/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.filestore.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.common.OperationMetadata;
import com.google.cloud.filestore.v1beta1.Backup;
import com.google.cloud.filestore.v1beta1.CloudFilestoreManagerClient;
import com.google.cloud.filestore.v1beta1.CreateBackupRequest;
import com.google.cloud.filestore.v1beta1.CreateInstanceRequest;
import com.google.cloud.filestore.v1beta1.CreateShareRequest;
import com.google.cloud.filestore.v1beta1.CreateSnapshotRequest;
import com.google.cloud.filestore.v1beta1.DeleteBackupRequest;
import com.google.cloud.filestore.v1beta1.DeleteInstanceRequest;
import com.google.cloud.filestore.v1beta1.DeleteShareRequest;
import com.google.cloud.filestore.v1beta1.DeleteSnapshotRequest;
import com.google.cloud.filestore.v1beta1.GetBackupRequest;
import com.google.cloud.filestore.v1beta1.GetInstanceRequest;
import com.google.cloud.filestore.v1beta1.GetShareRequest;
import com.google.cloud.filestore.v1beta1.GetSnapshotRequest;
import com.google.cloud.filestore.v1beta1.Instance;
import com.google.cloud.filestore.v1beta1.ListBackupsRequest;
import com.google.cloud.filestore.v1beta1.ListBackupsResponse;
import com.google.cloud.filestore.v1beta1.ListInstancesRequest;
import com.google.cloud.filestore.v1beta1.ListInstancesResponse;
import com.google.cloud.filestore.v1beta1.ListSharesRequest;
import com.google.cloud.filestore.v1beta1.ListSharesResponse;
import com.google.cloud.filestore.v1beta1.ListSnapshotsRequest;
import com.google.cloud.filestore.v1beta1.ListSnapshotsResponse;
import com.google.cloud.filestore.v1beta1.RestoreInstanceRequest;
import com.google.cloud.filestore.v1beta1.RevertInstanceRequest;
import com.google.cloud.filestore.v1beta1.Share;
import com.google.cloud.filestore.v1beta1.Snapshot;
import com.google.cloud.filestore.v1beta1.UpdateBackupRequest;
import com.google.cloud.filestore.v1beta1.UpdateInstanceRequest;
import com.google.cloud.filestore.v1beta1.UpdateShareRequest;
import com.google.cloud.filestore.v1beta1.UpdateSnapshotRequest;
import com.google.cloud.filestore.v1beta1.stub.CloudFilestoreManagerStub;
import com.google.cloud.filestore.v1beta1.stub.CloudFilestoreManagerStubSettings;
import com.google.cloud.filestore.v1beta1.stub.GrpcCloudFilestoreManagerCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcCloudFilestoreManagerStub
extends CloudFilestoreManagerStub {
    private static final MethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/ListInstances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInstancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInstancesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateInstanceRequest, Operation> createInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/CreateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateInstanceRequest, Operation> updateInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/UpdateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RestoreInstanceRequest, Operation> restoreInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/RestoreInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)RestoreInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RevertInstanceRequest, Operation> revertInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/RevertInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)RevertInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteInstanceRequest, Operation> deleteInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/DeleteInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/ListSnapshots").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSnapshotsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSnapshotsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSnapshotRequest, Snapshot> getSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/GetSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Snapshot.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateSnapshotRequest, Operation> createSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/CreateSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSnapshotRequest, Operation> deleteSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/DeleteSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSnapshotRequest, Operation> updateSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/UpdateSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListBackupsRequest, ListBackupsResponse> listBackupsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/ListBackups").setRequestMarshaller(ProtoUtils.marshaller((Message)ListBackupsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListBackupsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetBackupRequest, Backup> getBackupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/GetBackup").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBackupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Backup.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateBackupRequest, Operation> createBackupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/CreateBackup").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateBackupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteBackupRequest, Operation> deleteBackupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/DeleteBackup").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteBackupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateBackupRequest, Operation> updateBackupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/UpdateBackup").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateBackupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSharesRequest, ListSharesResponse> listSharesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/ListShares").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSharesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSharesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetShareRequest, Share> getShareMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/GetShare").setRequestMarshaller(ProtoUtils.marshaller((Message)GetShareRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Share.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateShareRequest, Operation> createShareMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/CreateShare").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateShareRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteShareRequest, Operation> deleteShareMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/DeleteShare").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteShareRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateShareRequest, Operation> updateShareMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.filestore.v1beta1.CloudFilestoreManager/UpdateShare").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateShareRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, CloudFilestoreManagerClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable;
    private final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable;
    private final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable;
    private final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable;
    private final UnaryCallable<RestoreInstanceRequest, Operation> restoreInstanceCallable;
    private final OperationCallable<RestoreInstanceRequest, Instance, OperationMetadata> restoreInstanceOperationCallable;
    private final UnaryCallable<RevertInstanceRequest, Operation> revertInstanceCallable;
    private final OperationCallable<RevertInstanceRequest, Instance, OperationMetadata> revertInstanceOperationCallable;
    private final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable;
    private final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable;
    private final UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable;
    private final UnaryCallable<ListSnapshotsRequest, CloudFilestoreManagerClient.ListSnapshotsPagedResponse> listSnapshotsPagedCallable;
    private final UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable;
    private final UnaryCallable<CreateSnapshotRequest, Operation> createSnapshotCallable;
    private final OperationCallable<CreateSnapshotRequest, Snapshot, OperationMetadata> createSnapshotOperationCallable;
    private final UnaryCallable<DeleteSnapshotRequest, Operation> deleteSnapshotCallable;
    private final OperationCallable<DeleteSnapshotRequest, Empty, OperationMetadata> deleteSnapshotOperationCallable;
    private final UnaryCallable<UpdateSnapshotRequest, Operation> updateSnapshotCallable;
    private final OperationCallable<UpdateSnapshotRequest, Snapshot, OperationMetadata> updateSnapshotOperationCallable;
    private final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable;
    private final UnaryCallable<ListBackupsRequest, CloudFilestoreManagerClient.ListBackupsPagedResponse> listBackupsPagedCallable;
    private final UnaryCallable<GetBackupRequest, Backup> getBackupCallable;
    private final UnaryCallable<CreateBackupRequest, Operation> createBackupCallable;
    private final OperationCallable<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationCallable;
    private final UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable;
    private final OperationCallable<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationCallable;
    private final UnaryCallable<UpdateBackupRequest, Operation> updateBackupCallable;
    private final OperationCallable<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationCallable;
    private final UnaryCallable<ListSharesRequest, ListSharesResponse> listSharesCallable;
    private final UnaryCallable<ListSharesRequest, CloudFilestoreManagerClient.ListSharesPagedResponse> listSharesPagedCallable;
    private final UnaryCallable<GetShareRequest, Share> getShareCallable;
    private final UnaryCallable<CreateShareRequest, Operation> createShareCallable;
    private final OperationCallable<CreateShareRequest, Share, OperationMetadata> createShareOperationCallable;
    private final UnaryCallable<DeleteShareRequest, Operation> deleteShareCallable;
    private final OperationCallable<DeleteShareRequest, Empty, OperationMetadata> deleteShareOperationCallable;
    private final UnaryCallable<UpdateShareRequest, Operation> updateShareCallable;
    private final OperationCallable<UpdateShareRequest, Share, OperationMetadata> updateShareOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCloudFilestoreManagerStub create(CloudFilestoreManagerStubSettings settings) throws IOException {
        return new GrpcCloudFilestoreManagerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCloudFilestoreManagerStub create(ClientContext clientContext) throws IOException {
        return new GrpcCloudFilestoreManagerStub(CloudFilestoreManagerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCloudFilestoreManagerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCloudFilestoreManagerStub(CloudFilestoreManagerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCloudFilestoreManagerStub(CloudFilestoreManagerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCloudFilestoreManagerCallableFactory());
    }

    protected GrpcCloudFilestoreManagerStub(CloudFilestoreManagerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listInstancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"instance.name", (Object)String.valueOf(request.getInstance().getName()));
            return params.build();
        }).build();
        GrpcCallSettings restoreInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(restoreInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings revertInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(revertInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listSnapshotsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSnapshotsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"snapshot.name", (Object)String.valueOf(request.getSnapshot().getName()));
            return params.build();
        }).build();
        GrpcCallSettings listBackupsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listBackupsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getBackupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBackupMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createBackupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createBackupMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteBackupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteBackupMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateBackupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateBackupMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"backup.name", (Object)String.valueOf(request.getBackup().getName()));
            return params.build();
        }).build();
        GrpcCallSettings listSharesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSharesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getShareTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getShareMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createShareTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createShareMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteShareTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteShareMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateShareTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateShareMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"share.name", (Object)String.valueOf(request.getShare().getName()));
            return params.build();
        }).build();
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.createInstanceCallable = callableFactory.createUnaryCallable(createInstanceTransportSettings, settings.createInstanceSettings(), clientContext);
        this.createInstanceOperationCallable = callableFactory.createOperationCallable(createInstanceTransportSettings, settings.createInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateInstanceCallable = callableFactory.createUnaryCallable(updateInstanceTransportSettings, settings.updateInstanceSettings(), clientContext);
        this.updateInstanceOperationCallable = callableFactory.createOperationCallable(updateInstanceTransportSettings, settings.updateInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.restoreInstanceCallable = callableFactory.createUnaryCallable(restoreInstanceTransportSettings, settings.restoreInstanceSettings(), clientContext);
        this.restoreInstanceOperationCallable = callableFactory.createOperationCallable(restoreInstanceTransportSettings, settings.restoreInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.revertInstanceCallable = callableFactory.createUnaryCallable(revertInstanceTransportSettings, settings.revertInstanceSettings(), clientContext);
        this.revertInstanceOperationCallable = callableFactory.createOperationCallable(revertInstanceTransportSettings, settings.revertInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteInstanceCallable = callableFactory.createUnaryCallable(deleteInstanceTransportSettings, settings.deleteInstanceSettings(), clientContext);
        this.deleteInstanceOperationCallable = callableFactory.createOperationCallable(deleteInstanceTransportSettings, settings.deleteInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listSnapshotsCallable = callableFactory.createUnaryCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.listSnapshotsPagedCallable = callableFactory.createPagedCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.getSnapshotCallable = callableFactory.createUnaryCallable(getSnapshotTransportSettings, settings.getSnapshotSettings(), clientContext);
        this.createSnapshotCallable = callableFactory.createUnaryCallable(createSnapshotTransportSettings, settings.createSnapshotSettings(), clientContext);
        this.createSnapshotOperationCallable = callableFactory.createOperationCallable(createSnapshotTransportSettings, settings.createSnapshotOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteSnapshotCallable = callableFactory.createUnaryCallable(deleteSnapshotTransportSettings, settings.deleteSnapshotSettings(), clientContext);
        this.deleteSnapshotOperationCallable = callableFactory.createOperationCallable(deleteSnapshotTransportSettings, settings.deleteSnapshotOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateSnapshotCallable = callableFactory.createUnaryCallable(updateSnapshotTransportSettings, settings.updateSnapshotSettings(), clientContext);
        this.updateSnapshotOperationCallable = callableFactory.createOperationCallable(updateSnapshotTransportSettings, settings.updateSnapshotOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listBackupsCallable = callableFactory.createUnaryCallable(listBackupsTransportSettings, settings.listBackupsSettings(), clientContext);
        this.listBackupsPagedCallable = callableFactory.createPagedCallable(listBackupsTransportSettings, settings.listBackupsSettings(), clientContext);
        this.getBackupCallable = callableFactory.createUnaryCallable(getBackupTransportSettings, settings.getBackupSettings(), clientContext);
        this.createBackupCallable = callableFactory.createUnaryCallable(createBackupTransportSettings, settings.createBackupSettings(), clientContext);
        this.createBackupOperationCallable = callableFactory.createOperationCallable(createBackupTransportSettings, settings.createBackupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteBackupCallable = callableFactory.createUnaryCallable(deleteBackupTransportSettings, settings.deleteBackupSettings(), clientContext);
        this.deleteBackupOperationCallable = callableFactory.createOperationCallable(deleteBackupTransportSettings, settings.deleteBackupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateBackupCallable = callableFactory.createUnaryCallable(updateBackupTransportSettings, settings.updateBackupSettings(), clientContext);
        this.updateBackupOperationCallable = callableFactory.createOperationCallable(updateBackupTransportSettings, settings.updateBackupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listSharesCallable = callableFactory.createUnaryCallable(listSharesTransportSettings, settings.listSharesSettings(), clientContext);
        this.listSharesPagedCallable = callableFactory.createPagedCallable(listSharesTransportSettings, settings.listSharesSettings(), clientContext);
        this.getShareCallable = callableFactory.createUnaryCallable(getShareTransportSettings, settings.getShareSettings(), clientContext);
        this.createShareCallable = callableFactory.createUnaryCallable(createShareTransportSettings, settings.createShareSettings(), clientContext);
        this.createShareOperationCallable = callableFactory.createOperationCallable(createShareTransportSettings, settings.createShareOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteShareCallable = callableFactory.createUnaryCallable(deleteShareTransportSettings, settings.deleteShareSettings(), clientContext);
        this.deleteShareOperationCallable = callableFactory.createOperationCallable(deleteShareTransportSettings, settings.deleteShareOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateShareCallable = callableFactory.createUnaryCallable(updateShareTransportSettings, settings.updateShareSettings(), clientContext);
        this.updateShareOperationCallable = callableFactory.createOperationCallable(updateShareTransportSettings, settings.updateShareOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, CloudFilestoreManagerClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.createInstanceCallable;
    }

    @Override
    public OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.createInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.updateInstanceCallable;
    }

    @Override
    public OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.updateInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<RestoreInstanceRequest, Operation> restoreInstanceCallable() {
        return this.restoreInstanceCallable;
    }

    @Override
    public OperationCallable<RestoreInstanceRequest, Instance, OperationMetadata> restoreInstanceOperationCallable() {
        return this.restoreInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<RevertInstanceRequest, Operation> revertInstanceCallable() {
        return this.revertInstanceCallable;
    }

    @Override
    public OperationCallable<RevertInstanceRequest, Instance, OperationMetadata> revertInstanceOperationCallable() {
        return this.revertInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.deleteInstanceCallable;
    }

    @Override
    public OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.deleteInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable() {
        return this.listSnapshotsCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotsRequest, CloudFilestoreManagerClient.ListSnapshotsPagedResponse> listSnapshotsPagedCallable() {
        return this.listSnapshotsPagedCallable;
    }

    @Override
    public UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable() {
        return this.getSnapshotCallable;
    }

    @Override
    public UnaryCallable<CreateSnapshotRequest, Operation> createSnapshotCallable() {
        return this.createSnapshotCallable;
    }

    @Override
    public OperationCallable<CreateSnapshotRequest, Snapshot, OperationMetadata> createSnapshotOperationCallable() {
        return this.createSnapshotOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteSnapshotRequest, Operation> deleteSnapshotCallable() {
        return this.deleteSnapshotCallable;
    }

    @Override
    public OperationCallable<DeleteSnapshotRequest, Empty, OperationMetadata> deleteSnapshotOperationCallable() {
        return this.deleteSnapshotOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateSnapshotRequest, Operation> updateSnapshotCallable() {
        return this.updateSnapshotCallable;
    }

    @Override
    public OperationCallable<UpdateSnapshotRequest, Snapshot, OperationMetadata> updateSnapshotOperationCallable() {
        return this.updateSnapshotOperationCallable;
    }

    @Override
    public UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.listBackupsCallable;
    }

    @Override
    public UnaryCallable<ListBackupsRequest, CloudFilestoreManagerClient.ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.listBackupsPagedCallable;
    }

    @Override
    public UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.getBackupCallable;
    }

    @Override
    public UnaryCallable<CreateBackupRequest, Operation> createBackupCallable() {
        return this.createBackupCallable;
    }

    @Override
    public OperationCallable<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationCallable() {
        return this.createBackupOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable() {
        return this.deleteBackupCallable;
    }

    @Override
    public OperationCallable<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationCallable() {
        return this.deleteBackupOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateBackupRequest, Operation> updateBackupCallable() {
        return this.updateBackupCallable;
    }

    @Override
    public OperationCallable<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationCallable() {
        return this.updateBackupOperationCallable;
    }

    @Override
    public UnaryCallable<ListSharesRequest, ListSharesResponse> listSharesCallable() {
        return this.listSharesCallable;
    }

    @Override
    public UnaryCallable<ListSharesRequest, CloudFilestoreManagerClient.ListSharesPagedResponse> listSharesPagedCallable() {
        return this.listSharesPagedCallable;
    }

    @Override
    public UnaryCallable<GetShareRequest, Share> getShareCallable() {
        return this.getShareCallable;
    }

    @Override
    public UnaryCallable<CreateShareRequest, Operation> createShareCallable() {
        return this.createShareCallable;
    }

    @Override
    public OperationCallable<CreateShareRequest, Share, OperationMetadata> createShareOperationCallable() {
        return this.createShareOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteShareRequest, Operation> deleteShareCallable() {
        return this.deleteShareCallable;
    }

    @Override
    public OperationCallable<DeleteShareRequest, Empty, OperationMetadata> deleteShareOperationCallable() {
        return this.deleteShareOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateShareRequest, Operation> updateShareCallable() {
        return this.updateShareCallable;
    }

    @Override
    public OperationCallable<UpdateShareRequest, Share, OperationMetadata> updateShareOperationCallable() {
        return this.updateShareOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

