/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreAdminClient;
import com.google.cloud.firestore.v1.stub.FirestoreAdminStub;
import com.google.cloud.firestore.v1.stub.GrpcFirestoreAdminStub;
import com.google.cloud.firestore.v1.stub.HttpJsonFirestoreAdminStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.firestore.admin.v1.CreateDatabaseMetadata;
import com.google.firestore.admin.v1.CreateDatabaseRequest;
import com.google.firestore.admin.v1.CreateIndexRequest;
import com.google.firestore.admin.v1.Database;
import com.google.firestore.admin.v1.DeleteIndexRequest;
import com.google.firestore.admin.v1.ExportDocumentsMetadata;
import com.google.firestore.admin.v1.ExportDocumentsRequest;
import com.google.firestore.admin.v1.ExportDocumentsResponse;
import com.google.firestore.admin.v1.Field;
import com.google.firestore.admin.v1.FieldOperationMetadata;
import com.google.firestore.admin.v1.GetDatabaseRequest;
import com.google.firestore.admin.v1.GetFieldRequest;
import com.google.firestore.admin.v1.GetIndexRequest;
import com.google.firestore.admin.v1.ImportDocumentsMetadata;
import com.google.firestore.admin.v1.ImportDocumentsRequest;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.admin.v1.IndexOperationMetadata;
import com.google.firestore.admin.v1.ListDatabasesRequest;
import com.google.firestore.admin.v1.ListDatabasesResponse;
import com.google.firestore.admin.v1.ListFieldsRequest;
import com.google.firestore.admin.v1.ListFieldsResponse;
import com.google.firestore.admin.v1.ListIndexesRequest;
import com.google.firestore.admin.v1.ListIndexesResponse;
import com.google.firestore.admin.v1.UpdateDatabaseMetadata;
import com.google.firestore.admin.v1.UpdateDatabaseRequest;
import com.google.firestore.admin.v1.UpdateFieldRequest;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class FirestoreAdminStubSettings
extends StubSettings<FirestoreAdminStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/datastore").build();
    private final UnaryCallSettings<CreateIndexRequest, Operation> createIndexSettings;
    private final OperationCallSettings<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationSettings;
    private final PagedCallSettings<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesSettings;
    private final UnaryCallSettings<GetIndexRequest, Index> getIndexSettings;
    private final UnaryCallSettings<DeleteIndexRequest, Empty> deleteIndexSettings;
    private final UnaryCallSettings<GetFieldRequest, Field> getFieldSettings;
    private final UnaryCallSettings<UpdateFieldRequest, Operation> updateFieldSettings;
    private final OperationCallSettings<UpdateFieldRequest, Field, FieldOperationMetadata> updateFieldOperationSettings;
    private final PagedCallSettings<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsSettings;
    private final UnaryCallSettings<ExportDocumentsRequest, Operation> exportDocumentsSettings;
    private final OperationCallSettings<ExportDocumentsRequest, ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsOperationSettings;
    private final UnaryCallSettings<ImportDocumentsRequest, Operation> importDocumentsSettings;
    private final OperationCallSettings<ImportDocumentsRequest, Empty, ImportDocumentsMetadata> importDocumentsOperationSettings;
    private final UnaryCallSettings<CreateDatabaseRequest, Operation> createDatabaseSettings;
    private final OperationCallSettings<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings;
    private final UnaryCallSettings<GetDatabaseRequest, Database> getDatabaseSettings;
    private final UnaryCallSettings<ListDatabasesRequest, ListDatabasesResponse> listDatabasesSettings;
    private final UnaryCallSettings<UpdateDatabaseRequest, Operation> updateDatabaseSettings;
    private final OperationCallSettings<UpdateDatabaseRequest, Database, UpdateDatabaseMetadata> updateDatabaseOperationSettings;
    private static final PagedListDescriptor<ListIndexesRequest, ListIndexesResponse, Index> LIST_INDEXES_PAGE_STR_DESC = new PagedListDescriptor<ListIndexesRequest, ListIndexesResponse, Index>(){

        public String emptyToken() {
            return "";
        }

        public ListIndexesRequest injectToken(ListIndexesRequest payload, String token) {
            return ListIndexesRequest.newBuilder((ListIndexesRequest)payload).setPageToken(token).build();
        }

        public ListIndexesRequest injectPageSize(ListIndexesRequest payload, int pageSize) {
            return ListIndexesRequest.newBuilder((ListIndexesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIndexesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIndexesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Index> extractResources(ListIndexesResponse payload) {
            return payload.getIndexesList() == null ? ImmutableList.of() : payload.getIndexesList();
        }
    };
    private static final PagedListDescriptor<ListFieldsRequest, ListFieldsResponse, Field> LIST_FIELDS_PAGE_STR_DESC = new PagedListDescriptor<ListFieldsRequest, ListFieldsResponse, Field>(){

        public String emptyToken() {
            return "";
        }

        public ListFieldsRequest injectToken(ListFieldsRequest payload, String token) {
            return ListFieldsRequest.newBuilder((ListFieldsRequest)payload).setPageToken(token).build();
        }

        public ListFieldsRequest injectPageSize(ListFieldsRequest payload, int pageSize) {
            return ListFieldsRequest.newBuilder((ListFieldsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFieldsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFieldsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Field> extractResources(ListFieldsResponse payload) {
            return payload.getFieldsList() == null ? ImmutableList.of() : payload.getFieldsList();
        }
    };
    private static final PagedListResponseFactory<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse> LIST_INDEXES_PAGE_STR_FACT = new PagedListResponseFactory<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse>(){

        public ApiFuture<FirestoreAdminClient.ListIndexesPagedResponse> getFuturePagedResponse(UnaryCallable<ListIndexesRequest, ListIndexesResponse> callable, ListIndexesRequest request, ApiCallContext context, ApiFuture<ListIndexesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INDEXES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FirestoreAdminClient.ListIndexesPagedResponse.createAsync((PageContext<ListIndexesRequest, ListIndexesResponse, Index>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse> LIST_FIELDS_PAGE_STR_FACT = new PagedListResponseFactory<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse>(){

        public ApiFuture<FirestoreAdminClient.ListFieldsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFieldsRequest, ListFieldsResponse> callable, ListFieldsRequest request, ApiCallContext context, ApiFuture<ListFieldsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FIELDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FirestoreAdminClient.ListFieldsPagedResponse.createAsync((PageContext<ListFieldsRequest, ListFieldsResponse, Field>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateIndexRequest, Operation> createIndexSettings() {
        return this.createIndexSettings;
    }

    public OperationCallSettings<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationSettings() {
        return this.createIndexOperationSettings;
    }

    public PagedCallSettings<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesSettings() {
        return this.listIndexesSettings;
    }

    public UnaryCallSettings<GetIndexRequest, Index> getIndexSettings() {
        return this.getIndexSettings;
    }

    public UnaryCallSettings<DeleteIndexRequest, Empty> deleteIndexSettings() {
        return this.deleteIndexSettings;
    }

    public UnaryCallSettings<GetFieldRequest, Field> getFieldSettings() {
        return this.getFieldSettings;
    }

    public UnaryCallSettings<UpdateFieldRequest, Operation> updateFieldSettings() {
        return this.updateFieldSettings;
    }

    public OperationCallSettings<UpdateFieldRequest, Field, FieldOperationMetadata> updateFieldOperationSettings() {
        return this.updateFieldOperationSettings;
    }

    public PagedCallSettings<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsSettings() {
        return this.listFieldsSettings;
    }

    public UnaryCallSettings<ExportDocumentsRequest, Operation> exportDocumentsSettings() {
        return this.exportDocumentsSettings;
    }

    public OperationCallSettings<ExportDocumentsRequest, ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsOperationSettings() {
        return this.exportDocumentsOperationSettings;
    }

    public UnaryCallSettings<ImportDocumentsRequest, Operation> importDocumentsSettings() {
        return this.importDocumentsSettings;
    }

    public OperationCallSettings<ImportDocumentsRequest, Empty, ImportDocumentsMetadata> importDocumentsOperationSettings() {
        return this.importDocumentsOperationSettings;
    }

    public UnaryCallSettings<CreateDatabaseRequest, Operation> createDatabaseSettings() {
        return this.createDatabaseSettings;
    }

    public OperationCallSettings<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings() {
        return this.createDatabaseOperationSettings;
    }

    public UnaryCallSettings<GetDatabaseRequest, Database> getDatabaseSettings() {
        return this.getDatabaseSettings;
    }

    public UnaryCallSettings<ListDatabasesRequest, ListDatabasesResponse> listDatabasesSettings() {
        return this.listDatabasesSettings;
    }

    public UnaryCallSettings<UpdateDatabaseRequest, Operation> updateDatabaseSettings() {
        return this.updateDatabaseSettings;
    }

    public OperationCallSettings<UpdateDatabaseRequest, Database, UpdateDatabaseMetadata> updateDatabaseOperationSettings() {
        return this.updateDatabaseOperationSettings;
    }

    public FirestoreAdminStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFirestoreAdminStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonFirestoreAdminStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "firestore.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "firestore.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FirestoreAdminStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FirestoreAdminStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FirestoreAdminStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return FirestoreAdminStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FirestoreAdminStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createIndexSettings = settingsBuilder.createIndexSettings().build();
        this.createIndexOperationSettings = settingsBuilder.createIndexOperationSettings().build();
        this.listIndexesSettings = settingsBuilder.listIndexesSettings().build();
        this.getIndexSettings = settingsBuilder.getIndexSettings().build();
        this.deleteIndexSettings = settingsBuilder.deleteIndexSettings().build();
        this.getFieldSettings = settingsBuilder.getFieldSettings().build();
        this.updateFieldSettings = settingsBuilder.updateFieldSettings().build();
        this.updateFieldOperationSettings = settingsBuilder.updateFieldOperationSettings().build();
        this.listFieldsSettings = settingsBuilder.listFieldsSettings().build();
        this.exportDocumentsSettings = settingsBuilder.exportDocumentsSettings().build();
        this.exportDocumentsOperationSettings = settingsBuilder.exportDocumentsOperationSettings().build();
        this.importDocumentsSettings = settingsBuilder.importDocumentsSettings().build();
        this.importDocumentsOperationSettings = settingsBuilder.importDocumentsOperationSettings().build();
        this.createDatabaseSettings = settingsBuilder.createDatabaseSettings().build();
        this.createDatabaseOperationSettings = settingsBuilder.createDatabaseOperationSettings().build();
        this.getDatabaseSettings = settingsBuilder.getDatabaseSettings().build();
        this.listDatabasesSettings = settingsBuilder.listDatabasesSettings().build();
        this.updateDatabaseSettings = settingsBuilder.updateDatabaseSettings().build();
        this.updateDatabaseOperationSettings = settingsBuilder.updateDatabaseOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FirestoreAdminStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateIndexRequest, Operation> createIndexSettings;
        private final OperationCallSettings.Builder<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationSettings;
        private final PagedCallSettings.Builder<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesSettings;
        private final UnaryCallSettings.Builder<GetIndexRequest, Index> getIndexSettings;
        private final UnaryCallSettings.Builder<DeleteIndexRequest, Empty> deleteIndexSettings;
        private final UnaryCallSettings.Builder<GetFieldRequest, Field> getFieldSettings;
        private final UnaryCallSettings.Builder<UpdateFieldRequest, Operation> updateFieldSettings;
        private final OperationCallSettings.Builder<UpdateFieldRequest, Field, FieldOperationMetadata> updateFieldOperationSettings;
        private final PagedCallSettings.Builder<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsSettings;
        private final UnaryCallSettings.Builder<ExportDocumentsRequest, Operation> exportDocumentsSettings;
        private final OperationCallSettings.Builder<ExportDocumentsRequest, ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsOperationSettings;
        private final UnaryCallSettings.Builder<ImportDocumentsRequest, Operation> importDocumentsSettings;
        private final OperationCallSettings.Builder<ImportDocumentsRequest, Empty, ImportDocumentsMetadata> importDocumentsOperationSettings;
        private final UnaryCallSettings.Builder<CreateDatabaseRequest, Operation> createDatabaseSettings;
        private final OperationCallSettings.Builder<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings;
        private final UnaryCallSettings.Builder<GetDatabaseRequest, Database> getDatabaseSettings;
        private final UnaryCallSettings.Builder<ListDatabasesRequest, ListDatabasesResponse> listDatabasesSettings;
        private final UnaryCallSettings.Builder<UpdateDatabaseRequest, Operation> updateDatabaseSettings;
        private final OperationCallSettings.Builder<UpdateDatabaseRequest, Database, UpdateDatabaseMetadata> updateDatabaseOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createIndexOperationSettings = OperationCallSettings.newBuilder();
            this.listIndexesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INDEXES_PAGE_STR_FACT);
            this.getIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFieldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFieldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFieldOperationSettings = OperationCallSettings.newBuilder();
            this.listFieldsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FIELDS_PAGE_STR_FACT);
            this.exportDocumentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportDocumentsOperationSettings = OperationCallSettings.newBuilder();
            this.importDocumentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importDocumentsOperationSettings = OperationCallSettings.newBuilder();
            this.createDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDatabaseOperationSettings = OperationCallSettings.newBuilder();
            this.getDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDatabasesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatabaseOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createIndexSettings, this.listIndexesSettings, this.getIndexSettings, this.deleteIndexSettings, this.getFieldSettings, this.updateFieldSettings, this.listFieldsSettings, this.exportDocumentsSettings, this.importDocumentsSettings, this.createDatabaseSettings, this.getDatabaseSettings, this.listDatabasesSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateDatabaseSettings});
            Builder.initDefaults(this);
        }

        protected Builder(FirestoreAdminStubSettings settings) {
            super((StubSettings)settings);
            this.createIndexSettings = settings.createIndexSettings.toBuilder();
            this.createIndexOperationSettings = settings.createIndexOperationSettings.toBuilder();
            this.listIndexesSettings = settings.listIndexesSettings.toBuilder();
            this.getIndexSettings = settings.getIndexSettings.toBuilder();
            this.deleteIndexSettings = settings.deleteIndexSettings.toBuilder();
            this.getFieldSettings = settings.getFieldSettings.toBuilder();
            this.updateFieldSettings = settings.updateFieldSettings.toBuilder();
            this.updateFieldOperationSettings = settings.updateFieldOperationSettings.toBuilder();
            this.listFieldsSettings = settings.listFieldsSettings.toBuilder();
            this.exportDocumentsSettings = settings.exportDocumentsSettings.toBuilder();
            this.exportDocumentsOperationSettings = settings.exportDocumentsOperationSettings.toBuilder();
            this.importDocumentsSettings = settings.importDocumentsSettings.toBuilder();
            this.importDocumentsOperationSettings = settings.importDocumentsOperationSettings.toBuilder();
            this.createDatabaseSettings = settings.createDatabaseSettings.toBuilder();
            this.createDatabaseOperationSettings = settings.createDatabaseOperationSettings.toBuilder();
            this.getDatabaseSettings = settings.getDatabaseSettings.toBuilder();
            this.listDatabasesSettings = settings.listDatabasesSettings.toBuilder();
            this.updateDatabaseSettings = settings.updateDatabaseSettings.toBuilder();
            this.updateDatabaseOperationSettings = settings.updateDatabaseOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createIndexSettings, this.listIndexesSettings, this.getIndexSettings, this.deleteIndexSettings, this.getFieldSettings, this.updateFieldSettings, this.listFieldsSettings, this.exportDocumentsSettings, this.importDocumentsSettings, this.createDatabaseSettings, this.getDatabaseSettings, this.listDatabasesSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateDatabaseSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FirestoreAdminStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FirestoreAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FirestoreAdminStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(FirestoreAdminStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(FirestoreAdminStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)FirestoreAdminStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)FirestoreAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FirestoreAdminStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(FirestoreAdminStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(FirestoreAdminStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listIndexesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getFieldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateFieldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listFieldsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.importDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDatabasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Index.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(IndexOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateFieldOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Field.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(FieldOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.exportDocumentsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportDocumentsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ExportDocumentsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importDocumentsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportDocumentsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Database.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateDatabaseMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Database.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateDatabaseMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateIndexRequest, Operation> createIndexSettings() {
            return this.createIndexSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationSettings() {
            return this.createIndexOperationSettings;
        }

        public PagedCallSettings.Builder<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesSettings() {
            return this.listIndexesSettings;
        }

        public UnaryCallSettings.Builder<GetIndexRequest, Index> getIndexSettings() {
            return this.getIndexSettings;
        }

        public UnaryCallSettings.Builder<DeleteIndexRequest, Empty> deleteIndexSettings() {
            return this.deleteIndexSettings;
        }

        public UnaryCallSettings.Builder<GetFieldRequest, Field> getFieldSettings() {
            return this.getFieldSettings;
        }

        public UnaryCallSettings.Builder<UpdateFieldRequest, Operation> updateFieldSettings() {
            return this.updateFieldSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateFieldRequest, Field, FieldOperationMetadata> updateFieldOperationSettings() {
            return this.updateFieldOperationSettings;
        }

        public PagedCallSettings.Builder<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsSettings() {
            return this.listFieldsSettings;
        }

        public UnaryCallSettings.Builder<ExportDocumentsRequest, Operation> exportDocumentsSettings() {
            return this.exportDocumentsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportDocumentsRequest, ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsOperationSettings() {
            return this.exportDocumentsOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportDocumentsRequest, Operation> importDocumentsSettings() {
            return this.importDocumentsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ImportDocumentsRequest, Empty, ImportDocumentsMetadata> importDocumentsOperationSettings() {
            return this.importDocumentsOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateDatabaseRequest, Operation> createDatabaseSettings() {
            return this.createDatabaseSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings() {
            return this.createDatabaseOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDatabaseRequest, Database> getDatabaseSettings() {
            return this.getDatabaseSettings;
        }

        public UnaryCallSettings.Builder<ListDatabasesRequest, ListDatabasesResponse> listDatabasesSettings() {
            return this.listDatabasesSettings;
        }

        public UnaryCallSettings.Builder<UpdateDatabaseRequest, Operation> updateDatabaseSettings() {
            return this.updateDatabaseSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDatabaseRequest, Database, UpdateDatabaseMetadata> updateDatabaseOperationSettings() {
            return this.updateDatabaseOperationSettings;
        }

        public FirestoreAdminStubSettings build() throws IOException {
            return new FirestoreAdminStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.INTERNAL, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

