/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1.CreateGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.DeleteGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.FetchDeploymentStateRequest;
import com.google.cloud.gaming.v1.FetchDeploymentStateResponse;
import com.google.cloud.gaming.v1.GameServerDeployment;
import com.google.cloud.gaming.v1.GameServerDeploymentRollout;
import com.google.cloud.gaming.v1.GameServerDeploymentsServiceClient;
import com.google.cloud.gaming.v1.GetGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.GetGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1.ListGameServerDeploymentsRequest;
import com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse;
import com.google.cloud.gaming.v1.OperationMetadata;
import com.google.cloud.gaming.v1.PreviewGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1.PreviewGameServerDeploymentRolloutResponse;
import com.google.cloud.gaming.v1.UpdateGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.UpdateGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1.stub.GameServerDeploymentsServiceStub;
import com.google.cloud.gaming.v1.stub.GrpcGameServerDeploymentsServiceStub;
import com.google.cloud.gaming.v1.stub.HttpJsonGameServerDeploymentsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class GameServerDeploymentsServiceStubSettings
extends StubSettings<GameServerDeploymentsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse> listGameServerDeploymentsSettings;
    private final UnaryCallSettings<GetGameServerDeploymentRequest, GameServerDeployment> getGameServerDeploymentSettings;
    private final UnaryCallSettings<CreateGameServerDeploymentRequest, Operation> createGameServerDeploymentSettings;
    private final OperationCallSettings<CreateGameServerDeploymentRequest, GameServerDeployment, OperationMetadata> createGameServerDeploymentOperationSettings;
    private final UnaryCallSettings<DeleteGameServerDeploymentRequest, Operation> deleteGameServerDeploymentSettings;
    private final OperationCallSettings<DeleteGameServerDeploymentRequest, Empty, OperationMetadata> deleteGameServerDeploymentOperationSettings;
    private final UnaryCallSettings<UpdateGameServerDeploymentRequest, Operation> updateGameServerDeploymentSettings;
    private final OperationCallSettings<UpdateGameServerDeploymentRequest, GameServerDeployment, OperationMetadata> updateGameServerDeploymentOperationSettings;
    private final UnaryCallSettings<GetGameServerDeploymentRolloutRequest, GameServerDeploymentRollout> getGameServerDeploymentRolloutSettings;
    private final UnaryCallSettings<UpdateGameServerDeploymentRolloutRequest, Operation> updateGameServerDeploymentRolloutSettings;
    private final OperationCallSettings<UpdateGameServerDeploymentRolloutRequest, GameServerDeployment, OperationMetadata> updateGameServerDeploymentRolloutOperationSettings;
    private final UnaryCallSettings<PreviewGameServerDeploymentRolloutRequest, PreviewGameServerDeploymentRolloutResponse> previewGameServerDeploymentRolloutSettings;
    private final UnaryCallSettings<FetchDeploymentStateRequest, FetchDeploymentStateResponse> fetchDeploymentStateSettings;
    private static final PagedListDescriptor<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment> LIST_GAME_SERVER_DEPLOYMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment>(){

        public String emptyToken() {
            return "";
        }

        public ListGameServerDeploymentsRequest injectToken(ListGameServerDeploymentsRequest payload, String token) {
            return ListGameServerDeploymentsRequest.newBuilder((ListGameServerDeploymentsRequest)payload).setPageToken(token).build();
        }

        public ListGameServerDeploymentsRequest injectPageSize(ListGameServerDeploymentsRequest payload, int pageSize) {
            return ListGameServerDeploymentsRequest.newBuilder((ListGameServerDeploymentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGameServerDeploymentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGameServerDeploymentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GameServerDeployment> extractResources(ListGameServerDeploymentsResponse payload) {
            return payload.getGameServerDeploymentsList() == null ? ImmutableList.of() : payload.getGameServerDeploymentsList();
        }
    };
    private static final PagedListResponseFactory<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse> LIST_GAME_SERVER_DEPLOYMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse>(){

        public ApiFuture<GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse> callable, ListGameServerDeploymentsRequest request, ApiCallContext context, ApiFuture<ListGameServerDeploymentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GAME_SERVER_DEPLOYMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse.createAsync((PageContext<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse> listGameServerDeploymentsSettings() {
        return this.listGameServerDeploymentsSettings;
    }

    public UnaryCallSettings<GetGameServerDeploymentRequest, GameServerDeployment> getGameServerDeploymentSettings() {
        return this.getGameServerDeploymentSettings;
    }

    public UnaryCallSettings<CreateGameServerDeploymentRequest, Operation> createGameServerDeploymentSettings() {
        return this.createGameServerDeploymentSettings;
    }

    public OperationCallSettings<CreateGameServerDeploymentRequest, GameServerDeployment, OperationMetadata> createGameServerDeploymentOperationSettings() {
        return this.createGameServerDeploymentOperationSettings;
    }

    public UnaryCallSettings<DeleteGameServerDeploymentRequest, Operation> deleteGameServerDeploymentSettings() {
        return this.deleteGameServerDeploymentSettings;
    }

    public OperationCallSettings<DeleteGameServerDeploymentRequest, Empty, OperationMetadata> deleteGameServerDeploymentOperationSettings() {
        return this.deleteGameServerDeploymentOperationSettings;
    }

    public UnaryCallSettings<UpdateGameServerDeploymentRequest, Operation> updateGameServerDeploymentSettings() {
        return this.updateGameServerDeploymentSettings;
    }

    public OperationCallSettings<UpdateGameServerDeploymentRequest, GameServerDeployment, OperationMetadata> updateGameServerDeploymentOperationSettings() {
        return this.updateGameServerDeploymentOperationSettings;
    }

    public UnaryCallSettings<GetGameServerDeploymentRolloutRequest, GameServerDeploymentRollout> getGameServerDeploymentRolloutSettings() {
        return this.getGameServerDeploymentRolloutSettings;
    }

    public UnaryCallSettings<UpdateGameServerDeploymentRolloutRequest, Operation> updateGameServerDeploymentRolloutSettings() {
        return this.updateGameServerDeploymentRolloutSettings;
    }

    public OperationCallSettings<UpdateGameServerDeploymentRolloutRequest, GameServerDeployment, OperationMetadata> updateGameServerDeploymentRolloutOperationSettings() {
        return this.updateGameServerDeploymentRolloutOperationSettings;
    }

    public UnaryCallSettings<PreviewGameServerDeploymentRolloutRequest, PreviewGameServerDeploymentRolloutResponse> previewGameServerDeploymentRolloutSettings() {
        return this.previewGameServerDeploymentRolloutSettings;
    }

    public UnaryCallSettings<FetchDeploymentStateRequest, FetchDeploymentStateResponse> fetchDeploymentStateSettings() {
        return this.fetchDeploymentStateSettings;
    }

    public GameServerDeploymentsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGameServerDeploymentsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGameServerDeploymentsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gameservices.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "gameservices.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GameServerDeploymentsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GameServerDeploymentsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GameServerDeploymentsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return GameServerDeploymentsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GameServerDeploymentsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listGameServerDeploymentsSettings = settingsBuilder.listGameServerDeploymentsSettings().build();
        this.getGameServerDeploymentSettings = settingsBuilder.getGameServerDeploymentSettings().build();
        this.createGameServerDeploymentSettings = settingsBuilder.createGameServerDeploymentSettings().build();
        this.createGameServerDeploymentOperationSettings = settingsBuilder.createGameServerDeploymentOperationSettings().build();
        this.deleteGameServerDeploymentSettings = settingsBuilder.deleteGameServerDeploymentSettings().build();
        this.deleteGameServerDeploymentOperationSettings = settingsBuilder.deleteGameServerDeploymentOperationSettings().build();
        this.updateGameServerDeploymentSettings = settingsBuilder.updateGameServerDeploymentSettings().build();
        this.updateGameServerDeploymentOperationSettings = settingsBuilder.updateGameServerDeploymentOperationSettings().build();
        this.getGameServerDeploymentRolloutSettings = settingsBuilder.getGameServerDeploymentRolloutSettings().build();
        this.updateGameServerDeploymentRolloutSettings = settingsBuilder.updateGameServerDeploymentRolloutSettings().build();
        this.updateGameServerDeploymentRolloutOperationSettings = settingsBuilder.updateGameServerDeploymentRolloutOperationSettings().build();
        this.previewGameServerDeploymentRolloutSettings = settingsBuilder.previewGameServerDeploymentRolloutSettings().build();
        this.fetchDeploymentStateSettings = settingsBuilder.fetchDeploymentStateSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GameServerDeploymentsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse> listGameServerDeploymentsSettings;
        private final UnaryCallSettings.Builder<GetGameServerDeploymentRequest, GameServerDeployment> getGameServerDeploymentSettings;
        private final UnaryCallSettings.Builder<CreateGameServerDeploymentRequest, Operation> createGameServerDeploymentSettings;
        private final OperationCallSettings.Builder<CreateGameServerDeploymentRequest, GameServerDeployment, OperationMetadata> createGameServerDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteGameServerDeploymentRequest, Operation> deleteGameServerDeploymentSettings;
        private final OperationCallSettings.Builder<DeleteGameServerDeploymentRequest, Empty, OperationMetadata> deleteGameServerDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<UpdateGameServerDeploymentRequest, Operation> updateGameServerDeploymentSettings;
        private final OperationCallSettings.Builder<UpdateGameServerDeploymentRequest, GameServerDeployment, OperationMetadata> updateGameServerDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<GetGameServerDeploymentRolloutRequest, GameServerDeploymentRollout> getGameServerDeploymentRolloutSettings;
        private final UnaryCallSettings.Builder<UpdateGameServerDeploymentRolloutRequest, Operation> updateGameServerDeploymentRolloutSettings;
        private final OperationCallSettings.Builder<UpdateGameServerDeploymentRolloutRequest, GameServerDeployment, OperationMetadata> updateGameServerDeploymentRolloutOperationSettings;
        private final UnaryCallSettings.Builder<PreviewGameServerDeploymentRolloutRequest, PreviewGameServerDeploymentRolloutResponse> previewGameServerDeploymentRolloutSettings;
        private final UnaryCallSettings.Builder<FetchDeploymentStateRequest, FetchDeploymentStateResponse> fetchDeploymentStateSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listGameServerDeploymentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GAME_SERVER_DEPLOYMENTS_PAGE_STR_FACT);
            this.getGameServerDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGameServerDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGameServerDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteGameServerDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGameServerDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.updateGameServerDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGameServerDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.getGameServerDeploymentRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGameServerDeploymentRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGameServerDeploymentRolloutOperationSettings = OperationCallSettings.newBuilder();
            this.previewGameServerDeploymentRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.fetchDeploymentStateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGameServerDeploymentsSettings, this.getGameServerDeploymentSettings, this.createGameServerDeploymentSettings, this.deleteGameServerDeploymentSettings, this.updateGameServerDeploymentSettings, this.getGameServerDeploymentRolloutSettings, this.updateGameServerDeploymentRolloutSettings, this.previewGameServerDeploymentRolloutSettings, this.fetchDeploymentStateSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GameServerDeploymentsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listGameServerDeploymentsSettings = settings.listGameServerDeploymentsSettings.toBuilder();
            this.getGameServerDeploymentSettings = settings.getGameServerDeploymentSettings.toBuilder();
            this.createGameServerDeploymentSettings = settings.createGameServerDeploymentSettings.toBuilder();
            this.createGameServerDeploymentOperationSettings = settings.createGameServerDeploymentOperationSettings.toBuilder();
            this.deleteGameServerDeploymentSettings = settings.deleteGameServerDeploymentSettings.toBuilder();
            this.deleteGameServerDeploymentOperationSettings = settings.deleteGameServerDeploymentOperationSettings.toBuilder();
            this.updateGameServerDeploymentSettings = settings.updateGameServerDeploymentSettings.toBuilder();
            this.updateGameServerDeploymentOperationSettings = settings.updateGameServerDeploymentOperationSettings.toBuilder();
            this.getGameServerDeploymentRolloutSettings = settings.getGameServerDeploymentRolloutSettings.toBuilder();
            this.updateGameServerDeploymentRolloutSettings = settings.updateGameServerDeploymentRolloutSettings.toBuilder();
            this.updateGameServerDeploymentRolloutOperationSettings = settings.updateGameServerDeploymentRolloutOperationSettings.toBuilder();
            this.previewGameServerDeploymentRolloutSettings = settings.previewGameServerDeploymentRolloutSettings.toBuilder();
            this.fetchDeploymentStateSettings = settings.fetchDeploymentStateSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGameServerDeploymentsSettings, this.getGameServerDeploymentSettings, this.createGameServerDeploymentSettings, this.deleteGameServerDeploymentSettings, this.updateGameServerDeploymentSettings, this.getGameServerDeploymentRolloutSettings, this.updateGameServerDeploymentRolloutSettings, this.previewGameServerDeploymentRolloutSettings, this.fetchDeploymentStateSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GameServerDeploymentsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GameServerDeploymentsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GameServerDeploymentsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GameServerDeploymentsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(GameServerDeploymentsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)GameServerDeploymentsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)GameServerDeploymentsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GameServerDeploymentsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GameServerDeploymentsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(GameServerDeploymentsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listGameServerDeploymentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getGameServerDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createGameServerDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteGameServerDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateGameServerDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getGameServerDeploymentRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateGameServerDeploymentRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.previewGameServerDeploymentRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchDeploymentStateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createGameServerDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GameServerDeployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteGameServerDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateGameServerDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GameServerDeployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateGameServerDeploymentRolloutOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GameServerDeployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse> listGameServerDeploymentsSettings() {
            return this.listGameServerDeploymentsSettings;
        }

        public UnaryCallSettings.Builder<GetGameServerDeploymentRequest, GameServerDeployment> getGameServerDeploymentSettings() {
            return this.getGameServerDeploymentSettings;
        }

        public UnaryCallSettings.Builder<CreateGameServerDeploymentRequest, Operation> createGameServerDeploymentSettings() {
            return this.createGameServerDeploymentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateGameServerDeploymentRequest, GameServerDeployment, OperationMetadata> createGameServerDeploymentOperationSettings() {
            return this.createGameServerDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteGameServerDeploymentRequest, Operation> deleteGameServerDeploymentSettings() {
            return this.deleteGameServerDeploymentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteGameServerDeploymentRequest, Empty, OperationMetadata> deleteGameServerDeploymentOperationSettings() {
            return this.deleteGameServerDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateGameServerDeploymentRequest, Operation> updateGameServerDeploymentSettings() {
            return this.updateGameServerDeploymentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateGameServerDeploymentRequest, GameServerDeployment, OperationMetadata> updateGameServerDeploymentOperationSettings() {
            return this.updateGameServerDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<GetGameServerDeploymentRolloutRequest, GameServerDeploymentRollout> getGameServerDeploymentRolloutSettings() {
            return this.getGameServerDeploymentRolloutSettings;
        }

        public UnaryCallSettings.Builder<UpdateGameServerDeploymentRolloutRequest, Operation> updateGameServerDeploymentRolloutSettings() {
            return this.updateGameServerDeploymentRolloutSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateGameServerDeploymentRolloutRequest, GameServerDeployment, OperationMetadata> updateGameServerDeploymentRolloutOperationSettings() {
            return this.updateGameServerDeploymentRolloutOperationSettings;
        }

        public UnaryCallSettings.Builder<PreviewGameServerDeploymentRolloutRequest, PreviewGameServerDeploymentRolloutResponse> previewGameServerDeploymentRolloutSettings() {
            return this.previewGameServerDeploymentRolloutSettings;
        }

        public UnaryCallSettings.Builder<FetchDeploymentStateRequest, FetchDeploymentStateResponse> fetchDeploymentStateSettings() {
            return this.fetchDeploymentStateSettings;
        }

        public GameServerDeploymentsServiceStubSettings build() throws IOException {
            return new GameServerDeploymentsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

