/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.networksecurity.v1.AuthorizationPolicy;
import com.google.cloud.networksecurity.v1.AuthorizationPolicyName;
import com.google.cloud.networksecurity.v1.ClientTlsPolicy;
import com.google.cloud.networksecurity.v1.ClientTlsPolicyName;
import com.google.cloud.networksecurity.v1.CreateAuthorizationPolicyRequest;
import com.google.cloud.networksecurity.v1.CreateClientTlsPolicyRequest;
import com.google.cloud.networksecurity.v1.CreateServerTlsPolicyRequest;
import com.google.cloud.networksecurity.v1.DeleteAuthorizationPolicyRequest;
import com.google.cloud.networksecurity.v1.DeleteClientTlsPolicyRequest;
import com.google.cloud.networksecurity.v1.DeleteServerTlsPolicyRequest;
import com.google.cloud.networksecurity.v1.GetAuthorizationPolicyRequest;
import com.google.cloud.networksecurity.v1.GetClientTlsPolicyRequest;
import com.google.cloud.networksecurity.v1.GetServerTlsPolicyRequest;
import com.google.cloud.networksecurity.v1.ListAuthorizationPoliciesRequest;
import com.google.cloud.networksecurity.v1.ListAuthorizationPoliciesResponse;
import com.google.cloud.networksecurity.v1.ListClientTlsPoliciesRequest;
import com.google.cloud.networksecurity.v1.ListClientTlsPoliciesResponse;
import com.google.cloud.networksecurity.v1.ListServerTlsPoliciesRequest;
import com.google.cloud.networksecurity.v1.ListServerTlsPoliciesResponse;
import com.google.cloud.networksecurity.v1.LocationName;
import com.google.cloud.networksecurity.v1.NetworkSecuritySettings;
import com.google.cloud.networksecurity.v1.OperationMetadata;
import com.google.cloud.networksecurity.v1.ServerTlsPolicy;
import com.google.cloud.networksecurity.v1.ServerTlsPolicyName;
import com.google.cloud.networksecurity.v1.UpdateAuthorizationPolicyRequest;
import com.google.cloud.networksecurity.v1.UpdateClientTlsPolicyRequest;
import com.google.cloud.networksecurity.v1.UpdateServerTlsPolicyRequest;
import com.google.cloud.networksecurity.v1.stub.NetworkSecurityStub;
import com.google.cloud.networksecurity.v1.stub.NetworkSecurityStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NetworkSecurityClient
implements BackgroundResource {
    private final NetworkSecuritySettings settings;
    private final NetworkSecurityStub stub;
    private final OperationsClient operationsClient;

    public static final NetworkSecurityClient create() throws IOException {
        return NetworkSecurityClient.create(NetworkSecuritySettings.newBuilder().build());
    }

    public static final NetworkSecurityClient create(NetworkSecuritySettings settings) throws IOException {
        return new NetworkSecurityClient(settings);
    }

    public static final NetworkSecurityClient create(NetworkSecurityStub stub) {
        return new NetworkSecurityClient(stub);
    }

    protected NetworkSecurityClient(NetworkSecuritySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkSecurityStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected NetworkSecurityClient(NetworkSecurityStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final NetworkSecuritySettings getSettings() {
        return this.settings;
    }

    public NetworkSecurityStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListAuthorizationPoliciesPagedResponse listAuthorizationPolicies(LocationName parent) {
        ListAuthorizationPoliciesRequest request = ListAuthorizationPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAuthorizationPolicies(request);
    }

    public final ListAuthorizationPoliciesPagedResponse listAuthorizationPolicies(String parent) {
        ListAuthorizationPoliciesRequest request = ListAuthorizationPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listAuthorizationPolicies(request);
    }

    public final ListAuthorizationPoliciesPagedResponse listAuthorizationPolicies(ListAuthorizationPoliciesRequest request) {
        return (ListAuthorizationPoliciesPagedResponse)((Object)this.listAuthorizationPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAuthorizationPoliciesRequest, ListAuthorizationPoliciesPagedResponse> listAuthorizationPoliciesPagedCallable() {
        return this.stub.listAuthorizationPoliciesPagedCallable();
    }

    public final UnaryCallable<ListAuthorizationPoliciesRequest, ListAuthorizationPoliciesResponse> listAuthorizationPoliciesCallable() {
        return this.stub.listAuthorizationPoliciesCallable();
    }

    public final AuthorizationPolicy getAuthorizationPolicy(AuthorizationPolicyName name) {
        GetAuthorizationPolicyRequest request = GetAuthorizationPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAuthorizationPolicy(request);
    }

    public final AuthorizationPolicy getAuthorizationPolicy(String name) {
        GetAuthorizationPolicyRequest request = GetAuthorizationPolicyRequest.newBuilder().setName(name).build();
        return this.getAuthorizationPolicy(request);
    }

    public final AuthorizationPolicy getAuthorizationPolicy(GetAuthorizationPolicyRequest request) {
        return (AuthorizationPolicy)this.getAuthorizationPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetAuthorizationPolicyRequest, AuthorizationPolicy> getAuthorizationPolicyCallable() {
        return this.stub.getAuthorizationPolicyCallable();
    }

    public final OperationFuture<AuthorizationPolicy, OperationMetadata> createAuthorizationPolicyAsync(LocationName parent, AuthorizationPolicy authorizationPolicy, String authorizationPolicyId) {
        CreateAuthorizationPolicyRequest request = CreateAuthorizationPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAuthorizationPolicy(authorizationPolicy).setAuthorizationPolicyId(authorizationPolicyId).build();
        return this.createAuthorizationPolicyAsync(request);
    }

    public final OperationFuture<AuthorizationPolicy, OperationMetadata> createAuthorizationPolicyAsync(String parent, AuthorizationPolicy authorizationPolicy, String authorizationPolicyId) {
        CreateAuthorizationPolicyRequest request = CreateAuthorizationPolicyRequest.newBuilder().setParent(parent).setAuthorizationPolicy(authorizationPolicy).setAuthorizationPolicyId(authorizationPolicyId).build();
        return this.createAuthorizationPolicyAsync(request);
    }

    public final OperationFuture<AuthorizationPolicy, OperationMetadata> createAuthorizationPolicyAsync(CreateAuthorizationPolicyRequest request) {
        return this.createAuthorizationPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAuthorizationPolicyRequest, AuthorizationPolicy, OperationMetadata> createAuthorizationPolicyOperationCallable() {
        return this.stub.createAuthorizationPolicyOperationCallable();
    }

    public final UnaryCallable<CreateAuthorizationPolicyRequest, Operation> createAuthorizationPolicyCallable() {
        return this.stub.createAuthorizationPolicyCallable();
    }

    public final OperationFuture<AuthorizationPolicy, OperationMetadata> updateAuthorizationPolicyAsync(AuthorizationPolicy authorizationPolicy, FieldMask updateMask) {
        UpdateAuthorizationPolicyRequest request = UpdateAuthorizationPolicyRequest.newBuilder().setAuthorizationPolicy(authorizationPolicy).setUpdateMask(updateMask).build();
        return this.updateAuthorizationPolicyAsync(request);
    }

    public final OperationFuture<AuthorizationPolicy, OperationMetadata> updateAuthorizationPolicyAsync(UpdateAuthorizationPolicyRequest request) {
        return this.updateAuthorizationPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAuthorizationPolicyRequest, AuthorizationPolicy, OperationMetadata> updateAuthorizationPolicyOperationCallable() {
        return this.stub.updateAuthorizationPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateAuthorizationPolicyRequest, Operation> updateAuthorizationPolicyCallable() {
        return this.stub.updateAuthorizationPolicyCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAuthorizationPolicyAsync(AuthorizationPolicyName name) {
        DeleteAuthorizationPolicyRequest request = DeleteAuthorizationPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAuthorizationPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAuthorizationPolicyAsync(String name) {
        DeleteAuthorizationPolicyRequest request = DeleteAuthorizationPolicyRequest.newBuilder().setName(name).build();
        return this.deleteAuthorizationPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAuthorizationPolicyAsync(DeleteAuthorizationPolicyRequest request) {
        return this.deleteAuthorizationPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAuthorizationPolicyRequest, Empty, OperationMetadata> deleteAuthorizationPolicyOperationCallable() {
        return this.stub.deleteAuthorizationPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteAuthorizationPolicyRequest, Operation> deleteAuthorizationPolicyCallable() {
        return this.stub.deleteAuthorizationPolicyCallable();
    }

    public final ListServerTlsPoliciesPagedResponse listServerTlsPolicies(LocationName parent) {
        ListServerTlsPoliciesRequest request = ListServerTlsPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServerTlsPolicies(request);
    }

    public final ListServerTlsPoliciesPagedResponse listServerTlsPolicies(String parent) {
        ListServerTlsPoliciesRequest request = ListServerTlsPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listServerTlsPolicies(request);
    }

    public final ListServerTlsPoliciesPagedResponse listServerTlsPolicies(ListServerTlsPoliciesRequest request) {
        return (ListServerTlsPoliciesPagedResponse)((Object)this.listServerTlsPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServerTlsPoliciesRequest, ListServerTlsPoliciesPagedResponse> listServerTlsPoliciesPagedCallable() {
        return this.stub.listServerTlsPoliciesPagedCallable();
    }

    public final UnaryCallable<ListServerTlsPoliciesRequest, ListServerTlsPoliciesResponse> listServerTlsPoliciesCallable() {
        return this.stub.listServerTlsPoliciesCallable();
    }

    public final ServerTlsPolicy getServerTlsPolicy(ServerTlsPolicyName name) {
        GetServerTlsPolicyRequest request = GetServerTlsPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServerTlsPolicy(request);
    }

    public final ServerTlsPolicy getServerTlsPolicy(String name) {
        GetServerTlsPolicyRequest request = GetServerTlsPolicyRequest.newBuilder().setName(name).build();
        return this.getServerTlsPolicy(request);
    }

    public final ServerTlsPolicy getServerTlsPolicy(GetServerTlsPolicyRequest request) {
        return (ServerTlsPolicy)this.getServerTlsPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetServerTlsPolicyRequest, ServerTlsPolicy> getServerTlsPolicyCallable() {
        return this.stub.getServerTlsPolicyCallable();
    }

    public final OperationFuture<ServerTlsPolicy, OperationMetadata> createServerTlsPolicyAsync(LocationName parent, ServerTlsPolicy serverTlsPolicy, String serverTlsPolicyId) {
        CreateServerTlsPolicyRequest request = CreateServerTlsPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setServerTlsPolicy(serverTlsPolicy).setServerTlsPolicyId(serverTlsPolicyId).build();
        return this.createServerTlsPolicyAsync(request);
    }

    public final OperationFuture<ServerTlsPolicy, OperationMetadata> createServerTlsPolicyAsync(String parent, ServerTlsPolicy serverTlsPolicy, String serverTlsPolicyId) {
        CreateServerTlsPolicyRequest request = CreateServerTlsPolicyRequest.newBuilder().setParent(parent).setServerTlsPolicy(serverTlsPolicy).setServerTlsPolicyId(serverTlsPolicyId).build();
        return this.createServerTlsPolicyAsync(request);
    }

    public final OperationFuture<ServerTlsPolicy, OperationMetadata> createServerTlsPolicyAsync(CreateServerTlsPolicyRequest request) {
        return this.createServerTlsPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServerTlsPolicyRequest, ServerTlsPolicy, OperationMetadata> createServerTlsPolicyOperationCallable() {
        return this.stub.createServerTlsPolicyOperationCallable();
    }

    public final UnaryCallable<CreateServerTlsPolicyRequest, Operation> createServerTlsPolicyCallable() {
        return this.stub.createServerTlsPolicyCallable();
    }

    public final OperationFuture<ServerTlsPolicy, OperationMetadata> updateServerTlsPolicyAsync(ServerTlsPolicy serverTlsPolicy, FieldMask updateMask) {
        UpdateServerTlsPolicyRequest request = UpdateServerTlsPolicyRequest.newBuilder().setServerTlsPolicy(serverTlsPolicy).setUpdateMask(updateMask).build();
        return this.updateServerTlsPolicyAsync(request);
    }

    public final OperationFuture<ServerTlsPolicy, OperationMetadata> updateServerTlsPolicyAsync(UpdateServerTlsPolicyRequest request) {
        return this.updateServerTlsPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateServerTlsPolicyRequest, ServerTlsPolicy, OperationMetadata> updateServerTlsPolicyOperationCallable() {
        return this.stub.updateServerTlsPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateServerTlsPolicyRequest, Operation> updateServerTlsPolicyCallable() {
        return this.stub.updateServerTlsPolicyCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServerTlsPolicyAsync(ServerTlsPolicyName name) {
        DeleteServerTlsPolicyRequest request = DeleteServerTlsPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServerTlsPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServerTlsPolicyAsync(String name) {
        DeleteServerTlsPolicyRequest request = DeleteServerTlsPolicyRequest.newBuilder().setName(name).build();
        return this.deleteServerTlsPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServerTlsPolicyAsync(DeleteServerTlsPolicyRequest request) {
        return this.deleteServerTlsPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServerTlsPolicyRequest, Empty, OperationMetadata> deleteServerTlsPolicyOperationCallable() {
        return this.stub.deleteServerTlsPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteServerTlsPolicyRequest, Operation> deleteServerTlsPolicyCallable() {
        return this.stub.deleteServerTlsPolicyCallable();
    }

    public final ListClientTlsPoliciesPagedResponse listClientTlsPolicies(LocationName parent) {
        ListClientTlsPoliciesRequest request = ListClientTlsPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listClientTlsPolicies(request);
    }

    public final ListClientTlsPoliciesPagedResponse listClientTlsPolicies(String parent) {
        ListClientTlsPoliciesRequest request = ListClientTlsPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listClientTlsPolicies(request);
    }

    public final ListClientTlsPoliciesPagedResponse listClientTlsPolicies(ListClientTlsPoliciesRequest request) {
        return (ListClientTlsPoliciesPagedResponse)((Object)this.listClientTlsPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListClientTlsPoliciesRequest, ListClientTlsPoliciesPagedResponse> listClientTlsPoliciesPagedCallable() {
        return this.stub.listClientTlsPoliciesPagedCallable();
    }

    public final UnaryCallable<ListClientTlsPoliciesRequest, ListClientTlsPoliciesResponse> listClientTlsPoliciesCallable() {
        return this.stub.listClientTlsPoliciesCallable();
    }

    public final ClientTlsPolicy getClientTlsPolicy(ClientTlsPolicyName name) {
        GetClientTlsPolicyRequest request = GetClientTlsPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getClientTlsPolicy(request);
    }

    public final ClientTlsPolicy getClientTlsPolicy(String name) {
        GetClientTlsPolicyRequest request = GetClientTlsPolicyRequest.newBuilder().setName(name).build();
        return this.getClientTlsPolicy(request);
    }

    public final ClientTlsPolicy getClientTlsPolicy(GetClientTlsPolicyRequest request) {
        return (ClientTlsPolicy)this.getClientTlsPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetClientTlsPolicyRequest, ClientTlsPolicy> getClientTlsPolicyCallable() {
        return this.stub.getClientTlsPolicyCallable();
    }

    public final OperationFuture<ClientTlsPolicy, OperationMetadata> createClientTlsPolicyAsync(LocationName parent, ClientTlsPolicy clientTlsPolicy, String clientTlsPolicyId) {
        CreateClientTlsPolicyRequest request = CreateClientTlsPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setClientTlsPolicy(clientTlsPolicy).setClientTlsPolicyId(clientTlsPolicyId).build();
        return this.createClientTlsPolicyAsync(request);
    }

    public final OperationFuture<ClientTlsPolicy, OperationMetadata> createClientTlsPolicyAsync(String parent, ClientTlsPolicy clientTlsPolicy, String clientTlsPolicyId) {
        CreateClientTlsPolicyRequest request = CreateClientTlsPolicyRequest.newBuilder().setParent(parent).setClientTlsPolicy(clientTlsPolicy).setClientTlsPolicyId(clientTlsPolicyId).build();
        return this.createClientTlsPolicyAsync(request);
    }

    public final OperationFuture<ClientTlsPolicy, OperationMetadata> createClientTlsPolicyAsync(CreateClientTlsPolicyRequest request) {
        return this.createClientTlsPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClientTlsPolicyRequest, ClientTlsPolicy, OperationMetadata> createClientTlsPolicyOperationCallable() {
        return this.stub.createClientTlsPolicyOperationCallable();
    }

    public final UnaryCallable<CreateClientTlsPolicyRequest, Operation> createClientTlsPolicyCallable() {
        return this.stub.createClientTlsPolicyCallable();
    }

    public final OperationFuture<ClientTlsPolicy, OperationMetadata> updateClientTlsPolicyAsync(ClientTlsPolicy clientTlsPolicy, FieldMask updateMask) {
        UpdateClientTlsPolicyRequest request = UpdateClientTlsPolicyRequest.newBuilder().setClientTlsPolicy(clientTlsPolicy).setUpdateMask(updateMask).build();
        return this.updateClientTlsPolicyAsync(request);
    }

    public final OperationFuture<ClientTlsPolicy, OperationMetadata> updateClientTlsPolicyAsync(UpdateClientTlsPolicyRequest request) {
        return this.updateClientTlsPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateClientTlsPolicyRequest, ClientTlsPolicy, OperationMetadata> updateClientTlsPolicyOperationCallable() {
        return this.stub.updateClientTlsPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateClientTlsPolicyRequest, Operation> updateClientTlsPolicyCallable() {
        return this.stub.updateClientTlsPolicyCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClientTlsPolicyAsync(ClientTlsPolicyName name) {
        DeleteClientTlsPolicyRequest request = DeleteClientTlsPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteClientTlsPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClientTlsPolicyAsync(String name) {
        DeleteClientTlsPolicyRequest request = DeleteClientTlsPolicyRequest.newBuilder().setName(name).build();
        return this.deleteClientTlsPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClientTlsPolicyAsync(DeleteClientTlsPolicyRequest request) {
        return this.deleteClientTlsPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteClientTlsPolicyRequest, Empty, OperationMetadata> deleteClientTlsPolicyOperationCallable() {
        return this.stub.deleteClientTlsPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteClientTlsPolicyRequest, Operation> deleteClientTlsPolicyCallable() {
        return this.stub.deleteClientTlsPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListClientTlsPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListClientTlsPoliciesRequest, ListClientTlsPoliciesResponse, ClientTlsPolicy, ListClientTlsPoliciesPage, ListClientTlsPoliciesFixedSizeCollection> {
        private ListClientTlsPoliciesFixedSizeCollection(List<ListClientTlsPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListClientTlsPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListClientTlsPoliciesFixedSizeCollection(null, 0);
        }

        protected ListClientTlsPoliciesFixedSizeCollection createCollection(List<ListClientTlsPoliciesPage> pages, int collectionSize) {
            return new ListClientTlsPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListClientTlsPoliciesPage
    extends AbstractPage<ListClientTlsPoliciesRequest, ListClientTlsPoliciesResponse, ClientTlsPolicy, ListClientTlsPoliciesPage> {
        private ListClientTlsPoliciesPage(PageContext<ListClientTlsPoliciesRequest, ListClientTlsPoliciesResponse, ClientTlsPolicy> context, ListClientTlsPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListClientTlsPoliciesPage createEmptyPage() {
            return new ListClientTlsPoliciesPage(null, null);
        }

        protected ListClientTlsPoliciesPage createPage(PageContext<ListClientTlsPoliciesRequest, ListClientTlsPoliciesResponse, ClientTlsPolicy> context, ListClientTlsPoliciesResponse response) {
            return new ListClientTlsPoliciesPage(context, response);
        }

        public ApiFuture<ListClientTlsPoliciesPage> createPageAsync(PageContext<ListClientTlsPoliciesRequest, ListClientTlsPoliciesResponse, ClientTlsPolicy> context, ApiFuture<ListClientTlsPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListClientTlsPoliciesPagedResponse
    extends AbstractPagedListResponse<ListClientTlsPoliciesRequest, ListClientTlsPoliciesResponse, ClientTlsPolicy, ListClientTlsPoliciesPage, ListClientTlsPoliciesFixedSizeCollection> {
        public static ApiFuture<ListClientTlsPoliciesPagedResponse> createAsync(PageContext<ListClientTlsPoliciesRequest, ListClientTlsPoliciesResponse, ClientTlsPolicy> context, ApiFuture<ListClientTlsPoliciesResponse> futureResponse) {
            ApiFuture<ListClientTlsPoliciesPage> futurePage = ListClientTlsPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListClientTlsPoliciesPagedResponse((ListClientTlsPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListClientTlsPoliciesPagedResponse(ListClientTlsPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListClientTlsPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServerTlsPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServerTlsPoliciesRequest, ListServerTlsPoliciesResponse, ServerTlsPolicy, ListServerTlsPoliciesPage, ListServerTlsPoliciesFixedSizeCollection> {
        private ListServerTlsPoliciesFixedSizeCollection(List<ListServerTlsPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServerTlsPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListServerTlsPoliciesFixedSizeCollection(null, 0);
        }

        protected ListServerTlsPoliciesFixedSizeCollection createCollection(List<ListServerTlsPoliciesPage> pages, int collectionSize) {
            return new ListServerTlsPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServerTlsPoliciesPage
    extends AbstractPage<ListServerTlsPoliciesRequest, ListServerTlsPoliciesResponse, ServerTlsPolicy, ListServerTlsPoliciesPage> {
        private ListServerTlsPoliciesPage(PageContext<ListServerTlsPoliciesRequest, ListServerTlsPoliciesResponse, ServerTlsPolicy> context, ListServerTlsPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListServerTlsPoliciesPage createEmptyPage() {
            return new ListServerTlsPoliciesPage(null, null);
        }

        protected ListServerTlsPoliciesPage createPage(PageContext<ListServerTlsPoliciesRequest, ListServerTlsPoliciesResponse, ServerTlsPolicy> context, ListServerTlsPoliciesResponse response) {
            return new ListServerTlsPoliciesPage(context, response);
        }

        public ApiFuture<ListServerTlsPoliciesPage> createPageAsync(PageContext<ListServerTlsPoliciesRequest, ListServerTlsPoliciesResponse, ServerTlsPolicy> context, ApiFuture<ListServerTlsPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServerTlsPoliciesPagedResponse
    extends AbstractPagedListResponse<ListServerTlsPoliciesRequest, ListServerTlsPoliciesResponse, ServerTlsPolicy, ListServerTlsPoliciesPage, ListServerTlsPoliciesFixedSizeCollection> {
        public static ApiFuture<ListServerTlsPoliciesPagedResponse> createAsync(PageContext<ListServerTlsPoliciesRequest, ListServerTlsPoliciesResponse, ServerTlsPolicy> context, ApiFuture<ListServerTlsPoliciesResponse> futureResponse) {
            ApiFuture<ListServerTlsPoliciesPage> futurePage = ListServerTlsPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServerTlsPoliciesPagedResponse((ListServerTlsPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServerTlsPoliciesPagedResponse(ListServerTlsPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServerTlsPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAuthorizationPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAuthorizationPoliciesRequest, ListAuthorizationPoliciesResponse, AuthorizationPolicy, ListAuthorizationPoliciesPage, ListAuthorizationPoliciesFixedSizeCollection> {
        private ListAuthorizationPoliciesFixedSizeCollection(List<ListAuthorizationPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAuthorizationPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListAuthorizationPoliciesFixedSizeCollection(null, 0);
        }

        protected ListAuthorizationPoliciesFixedSizeCollection createCollection(List<ListAuthorizationPoliciesPage> pages, int collectionSize) {
            return new ListAuthorizationPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAuthorizationPoliciesPage
    extends AbstractPage<ListAuthorizationPoliciesRequest, ListAuthorizationPoliciesResponse, AuthorizationPolicy, ListAuthorizationPoliciesPage> {
        private ListAuthorizationPoliciesPage(PageContext<ListAuthorizationPoliciesRequest, ListAuthorizationPoliciesResponse, AuthorizationPolicy> context, ListAuthorizationPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListAuthorizationPoliciesPage createEmptyPage() {
            return new ListAuthorizationPoliciesPage(null, null);
        }

        protected ListAuthorizationPoliciesPage createPage(PageContext<ListAuthorizationPoliciesRequest, ListAuthorizationPoliciesResponse, AuthorizationPolicy> context, ListAuthorizationPoliciesResponse response) {
            return new ListAuthorizationPoliciesPage(context, response);
        }

        public ApiFuture<ListAuthorizationPoliciesPage> createPageAsync(PageContext<ListAuthorizationPoliciesRequest, ListAuthorizationPoliciesResponse, AuthorizationPolicy> context, ApiFuture<ListAuthorizationPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAuthorizationPoliciesPagedResponse
    extends AbstractPagedListResponse<ListAuthorizationPoliciesRequest, ListAuthorizationPoliciesResponse, AuthorizationPolicy, ListAuthorizationPoliciesPage, ListAuthorizationPoliciesFixedSizeCollection> {
        public static ApiFuture<ListAuthorizationPoliciesPagedResponse> createAsync(PageContext<ListAuthorizationPoliciesRequest, ListAuthorizationPoliciesResponse, AuthorizationPolicy> context, ApiFuture<ListAuthorizationPoliciesResponse> futureResponse) {
            ApiFuture<ListAuthorizationPoliciesPage> futurePage = ListAuthorizationPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAuthorizationPoliciesPagedResponse((ListAuthorizationPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAuthorizationPoliciesPagedResponse(ListAuthorizationPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAuthorizationPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

