/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orgpolicy.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orgpolicy.v2.CreatePolicyRequest;
import com.google.cloud.orgpolicy.v2.DeletePolicyRequest;
import com.google.cloud.orgpolicy.v2.GetEffectivePolicyRequest;
import com.google.cloud.orgpolicy.v2.GetPolicyRequest;
import com.google.cloud.orgpolicy.v2.ListConstraintsRequest;
import com.google.cloud.orgpolicy.v2.ListConstraintsResponse;
import com.google.cloud.orgpolicy.v2.ListPoliciesRequest;
import com.google.cloud.orgpolicy.v2.ListPoliciesResponse;
import com.google.cloud.orgpolicy.v2.OrgPolicyClient;
import com.google.cloud.orgpolicy.v2.Policy;
import com.google.cloud.orgpolicy.v2.UpdatePolicyRequest;
import com.google.cloud.orgpolicy.v2.stub.GrpcOrgPolicyCallableFactory;
import com.google.cloud.orgpolicy.v2.stub.OrgPolicyStub;
import com.google.cloud.orgpolicy.v2.stub.OrgPolicyStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcOrgPolicyStub
extends OrgPolicyStub {
    private static final MethodDescriptor<ListConstraintsRequest, ListConstraintsResponse> listConstraintsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/ListConstraints").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConstraintsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConstraintsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListPoliciesRequest, ListPoliciesResponse> listPoliciesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/ListPolicies").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPoliciesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPoliciesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetPolicyRequest, Policy> getPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/GetPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetEffectivePolicyRequest, Policy> getEffectivePolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/GetEffectivePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEffectivePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<CreatePolicyRequest, Policy> createPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/CreatePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdatePolicyRequest, Policy> updatePolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/UpdatePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdatePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<DeletePolicyRequest, Empty> deletePolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/DeletePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<ListConstraintsRequest, ListConstraintsResponse> listConstraintsCallable;
    private final UnaryCallable<ListConstraintsRequest, OrgPolicyClient.ListConstraintsPagedResponse> listConstraintsPagedCallable;
    private final UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> listPoliciesCallable;
    private final UnaryCallable<ListPoliciesRequest, OrgPolicyClient.ListPoliciesPagedResponse> listPoliciesPagedCallable;
    private final UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable;
    private final UnaryCallable<GetEffectivePolicyRequest, Policy> getEffectivePolicyCallable;
    private final UnaryCallable<CreatePolicyRequest, Policy> createPolicyCallable;
    private final UnaryCallable<UpdatePolicyRequest, Policy> updatePolicyCallable;
    private final UnaryCallable<DeletePolicyRequest, Empty> deletePolicyCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcOrgPolicyStub create(OrgPolicyStubSettings settings) throws IOException {
        return new GrpcOrgPolicyStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcOrgPolicyStub create(ClientContext clientContext) throws IOException {
        return new GrpcOrgPolicyStub(OrgPolicyStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcOrgPolicyStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcOrgPolicyStub(OrgPolicyStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcOrgPolicyStub(OrgPolicyStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcOrgPolicyCallableFactory());
    }

    protected GrpcOrgPolicyStub(OrgPolicyStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listConstraintsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConstraintsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listPoliciesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPoliciesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getEffectivePolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEffectivePolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updatePolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updatePolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("policy.name", String.valueOf(request.getPolicy().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listConstraintsCallable = callableFactory.createUnaryCallable(listConstraintsTransportSettings, settings.listConstraintsSettings(), clientContext);
        this.listConstraintsPagedCallable = callableFactory.createPagedCallable(listConstraintsTransportSettings, settings.listConstraintsSettings(), clientContext);
        this.listPoliciesCallable = callableFactory.createUnaryCallable(listPoliciesTransportSettings, settings.listPoliciesSettings(), clientContext);
        this.listPoliciesPagedCallable = callableFactory.createPagedCallable(listPoliciesTransportSettings, settings.listPoliciesSettings(), clientContext);
        this.getPolicyCallable = callableFactory.createUnaryCallable(getPolicyTransportSettings, settings.getPolicySettings(), clientContext);
        this.getEffectivePolicyCallable = callableFactory.createUnaryCallable(getEffectivePolicyTransportSettings, settings.getEffectivePolicySettings(), clientContext);
        this.createPolicyCallable = callableFactory.createUnaryCallable(createPolicyTransportSettings, settings.createPolicySettings(), clientContext);
        this.updatePolicyCallable = callableFactory.createUnaryCallable(updatePolicyTransportSettings, settings.updatePolicySettings(), clientContext);
        this.deletePolicyCallable = callableFactory.createUnaryCallable(deletePolicyTransportSettings, settings.deletePolicySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListConstraintsRequest, ListConstraintsResponse> listConstraintsCallable() {
        return this.listConstraintsCallable;
    }

    @Override
    public UnaryCallable<ListConstraintsRequest, OrgPolicyClient.ListConstraintsPagedResponse> listConstraintsPagedCallable() {
        return this.listConstraintsPagedCallable;
    }

    @Override
    public UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> listPoliciesCallable() {
        return this.listPoliciesCallable;
    }

    @Override
    public UnaryCallable<ListPoliciesRequest, OrgPolicyClient.ListPoliciesPagedResponse> listPoliciesPagedCallable() {
        return this.listPoliciesPagedCallable;
    }

    @Override
    public UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable() {
        return this.getPolicyCallable;
    }

    @Override
    public UnaryCallable<GetEffectivePolicyRequest, Policy> getEffectivePolicyCallable() {
        return this.getEffectivePolicyCallable;
    }

    @Override
    public UnaryCallable<CreatePolicyRequest, Policy> createPolicyCallable() {
        return this.createPolicyCallable;
    }

    @Override
    public UnaryCallable<UpdatePolicyRequest, Policy> updatePolicyCallable() {
        return this.updatePolicyCallable;
    }

    @Override
    public UnaryCallable<DeletePolicyRequest, Empty> deletePolicyCallable() {
        return this.deletePolicyCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

