/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsub.v1.AckResponse;

final class StatusUtil {
    private StatusUtil() {
    }

    static AckResponse getFailedAckResponse(Throwable t) {
        AckResponse failedAckResponse;
        if (!(t instanceof ApiException)) {
            return AckResponse.OTHER;
        }
        ApiException apiException = (ApiException)t;
        switch (apiException.getStatusCode().getCode()) {
            case FAILED_PRECONDITION: {
                failedAckResponse = AckResponse.FAILED_PRECONDITION;
                break;
            }
            case PERMISSION_DENIED: {
                failedAckResponse = AckResponse.PERMISSION_DENIED;
                break;
            }
            default: {
                failedAckResponse = AckResponse.OTHER;
            }
        }
        return failedAckResponse;
    }

    static boolean isRetryable(Throwable error) {
        if (!(error instanceof ApiException)) {
            return true;
        }
        ApiException apiException = (ApiException)error;
        switch (apiException.getStatusCode().getCode()) {
            case DEADLINE_EXCEEDED: 
            case INTERNAL: 
            case CANCELLED: 
            case RESOURCE_EXHAUSTED: 
            case ABORTED: 
            case UNKNOWN: {
                return true;
            }
            case UNAVAILABLE: {
                return !apiException.getMessage().contains("Server shutdownNow invoked");
            }
        }
        return false;
    }
}

