/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.wire.PublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.StreamFactories;
import com.google.protobuf.ByteString;
import java.util.Optional;

final class AutoValue_SinglePartitionPublisherBuilder
extends SinglePartitionPublisherBuilder {
    private final TopicPath topic;
    private final Partition partition;
    private final StreamFactories.PublishStreamFactory streamFactory;
    private final BatchingSettings batchingSettings;
    private final Optional<ByteString> clientId;
    private final PublisherBuilder.Builder underlyingBuilder;

    private AutoValue_SinglePartitionPublisherBuilder(TopicPath topic, Partition partition, StreamFactories.PublishStreamFactory streamFactory, BatchingSettings batchingSettings, Optional<ByteString> clientId, PublisherBuilder.Builder underlyingBuilder) {
        this.topic = topic;
        this.partition = partition;
        this.streamFactory = streamFactory;
        this.batchingSettings = batchingSettings;
        this.clientId = clientId;
        this.underlyingBuilder = underlyingBuilder;
    }

    @Override
    TopicPath topic() {
        return this.topic;
    }

    @Override
    Partition partition() {
        return this.partition;
    }

    @Override
    StreamFactories.PublishStreamFactory streamFactory() {
        return this.streamFactory;
    }

    @Override
    BatchingSettings batchingSettings() {
        return this.batchingSettings;
    }

    @Override
    Optional<ByteString> clientId() {
        return this.clientId;
    }

    @Override
    PublisherBuilder.Builder underlyingBuilder() {
        return this.underlyingBuilder;
    }

    public String toString() {
        return "SinglePartitionPublisherBuilder{topic=" + this.topic + ", partition=" + this.partition + ", streamFactory=" + this.streamFactory + ", batchingSettings=" + this.batchingSettings + ", clientId=" + this.clientId + ", underlyingBuilder=" + this.underlyingBuilder + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SinglePartitionPublisherBuilder) {
            SinglePartitionPublisherBuilder that = (SinglePartitionPublisherBuilder)o;
            return this.topic.equals(that.topic()) && this.partition.equals(that.partition()) && this.streamFactory.equals(that.streamFactory()) && this.batchingSettings.equals(that.batchingSettings()) && this.clientId.equals(that.clientId()) && this.underlyingBuilder.equals(that.underlyingBuilder());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.streamFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchingSettings.hashCode();
        h$ *= 1000003;
        h$ ^= this.clientId.hashCode();
        h$ *= 1000003;
        return h$ ^= this.underlyingBuilder.hashCode();
    }

    static final class Builder
    extends SinglePartitionPublisherBuilder.Builder {
        private TopicPath topic;
        private Partition partition;
        private StreamFactories.PublishStreamFactory streamFactory;
        private BatchingSettings batchingSettings;
        private Optional<ByteString> clientId = Optional.empty();
        private PublisherBuilder.Builder underlyingBuilder;

        Builder() {
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setTopic(TopicPath topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setPartition(Partition partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setStreamFactory(StreamFactories.PublishStreamFactory streamFactory) {
            if (streamFactory == null) {
                throw new NullPointerException("Null streamFactory");
            }
            this.streamFactory = streamFactory;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setBatchingSettings(BatchingSettings batchingSettings) {
            if (batchingSettings == null) {
                throw new NullPointerException("Null batchingSettings");
            }
            this.batchingSettings = batchingSettings;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setClientId(ByteString clientId) {
            this.clientId = Optional.of(clientId);
            return this;
        }

        @Override
        SinglePartitionPublisherBuilder.Builder setUnderlyingBuilder(PublisherBuilder.Builder underlyingBuilder) {
            if (underlyingBuilder == null) {
                throw new NullPointerException("Null underlyingBuilder");
            }
            this.underlyingBuilder = underlyingBuilder;
            return this;
        }

        @Override
        SinglePartitionPublisherBuilder autoBuild() {
            if (this.topic == null || this.partition == null || this.streamFactory == null || this.batchingSettings == null || this.underlyingBuilder == null) {
                StringBuilder missing = new StringBuilder();
                if (this.topic == null) {
                    missing.append(" topic");
                }
                if (this.partition == null) {
                    missing.append(" partition");
                }
                if (this.streamFactory == null) {
                    missing.append(" streamFactory");
                }
                if (this.batchingSettings == null) {
                    missing.append(" batchingSettings");
                }
                if (this.underlyingBuilder == null) {
                    missing.append(" underlyingBuilder");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SinglePartitionPublisherBuilder(this.topic, this.partition, this.streamFactory, this.batchingSettings, this.clientId, this.underlyingBuilder);
        }
    }
}

