/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsublite.proto.CreateReservationRequest;
import com.google.cloud.pubsublite.proto.CreateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.CreateTopicRequest;
import com.google.cloud.pubsublite.proto.DeleteReservationRequest;
import com.google.cloud.pubsublite.proto.DeleteSubscriptionRequest;
import com.google.cloud.pubsublite.proto.DeleteTopicRequest;
import com.google.cloud.pubsublite.proto.GetReservationRequest;
import com.google.cloud.pubsublite.proto.GetSubscriptionRequest;
import com.google.cloud.pubsublite.proto.GetTopicPartitionsRequest;
import com.google.cloud.pubsublite.proto.GetTopicRequest;
import com.google.cloud.pubsublite.proto.ListReservationTopicsRequest;
import com.google.cloud.pubsublite.proto.ListReservationTopicsResponse;
import com.google.cloud.pubsublite.proto.ListReservationsRequest;
import com.google.cloud.pubsublite.proto.ListReservationsResponse;
import com.google.cloud.pubsublite.proto.ListSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicsRequest;
import com.google.cloud.pubsublite.proto.ListTopicsResponse;
import com.google.cloud.pubsublite.proto.OperationMetadata;
import com.google.cloud.pubsublite.proto.Reservation;
import com.google.cloud.pubsublite.proto.SeekSubscriptionRequest;
import com.google.cloud.pubsublite.proto.SeekSubscriptionResponse;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.cloud.pubsublite.proto.TopicPartitions;
import com.google.cloud.pubsublite.proto.UpdateReservationRequest;
import com.google.cloud.pubsublite.proto.UpdateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.UpdateTopicRequest;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.cloud.pubsublite.v1.stub.AdminServiceStub;
import com.google.cloud.pubsublite.v1.stub.AdminServiceStubSettings;
import com.google.cloud.pubsublite.v1.stub.GrpcAdminServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAdminServiceStub
extends AdminServiceStub {
    private static final MethodDescriptor<CreateTopicRequest, Topic> createTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/CreateTopic").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTopicRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Topic.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTopicRequest, Topic> getTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/GetTopic").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTopicRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Topic.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTopicPartitionsRequest, TopicPartitions> getTopicPartitionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/GetTopicPartitions").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTopicPartitionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TopicPartitions.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTopicsRequest, ListTopicsResponse> listTopicsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/ListTopics").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTopicsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTopicsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateTopicRequest, Topic> updateTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/UpdateTopic").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTopicRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Topic.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteTopicRequest, Empty> deleteTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/DeleteTopic").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTopicRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/ListTopicSubscriptions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTopicSubscriptionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTopicSubscriptionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateSubscriptionRequest, Subscription> createSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/CreateSubscription").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSubscriptionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Subscription.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSubscriptionRequest, Subscription> getSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/GetSubscription").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSubscriptionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Subscription.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/ListSubscriptions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSubscriptionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSubscriptionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSubscriptionRequest, Subscription> updateSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/UpdateSubscription").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSubscriptionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Subscription.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSubscriptionRequest, Empty> deleteSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/DeleteSubscription").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSubscriptionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<SeekSubscriptionRequest, Operation> seekSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/SeekSubscription").setRequestMarshaller(ProtoUtils.marshaller((Message)SeekSubscriptionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateReservationRequest, Reservation> createReservationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/CreateReservation").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateReservationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Reservation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetReservationRequest, Reservation> getReservationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/GetReservation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetReservationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Reservation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListReservationsRequest, ListReservationsResponse> listReservationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/ListReservations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListReservationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListReservationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateReservationRequest, Reservation> updateReservationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/UpdateReservation").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateReservationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Reservation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteReservationRequest, Empty> deleteReservationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/DeleteReservation").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteReservationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListReservationTopicsRequest, ListReservationTopicsResponse> listReservationTopicsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.pubsublite.v1.AdminService/ListReservationTopics").setRequestMarshaller(ProtoUtils.marshaller((Message)ListReservationTopicsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListReservationTopicsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateTopicRequest, Topic> createTopicCallable;
    private final UnaryCallable<GetTopicRequest, Topic> getTopicCallable;
    private final UnaryCallable<GetTopicPartitionsRequest, TopicPartitions> getTopicPartitionsCallable;
    private final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable;
    private final UnaryCallable<ListTopicsRequest, AdminServiceClient.ListTopicsPagedResponse> listTopicsPagedCallable;
    private final UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable;
    private final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable;
    private final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable;
    private final UnaryCallable<ListTopicSubscriptionsRequest, AdminServiceClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable;
    private final UnaryCallable<CreateSubscriptionRequest, Subscription> createSubscriptionCallable;
    private final UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable;
    private final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable;
    private final UnaryCallable<ListSubscriptionsRequest, AdminServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable;
    private final UnaryCallable<UpdateSubscriptionRequest, Subscription> updateSubscriptionCallable;
    private final UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable;
    private final UnaryCallable<SeekSubscriptionRequest, Operation> seekSubscriptionCallable;
    private final OperationCallable<SeekSubscriptionRequest, SeekSubscriptionResponse, OperationMetadata> seekSubscriptionOperationCallable;
    private final UnaryCallable<CreateReservationRequest, Reservation> createReservationCallable;
    private final UnaryCallable<GetReservationRequest, Reservation> getReservationCallable;
    private final UnaryCallable<ListReservationsRequest, ListReservationsResponse> listReservationsCallable;
    private final UnaryCallable<ListReservationsRequest, AdminServiceClient.ListReservationsPagedResponse> listReservationsPagedCallable;
    private final UnaryCallable<UpdateReservationRequest, Reservation> updateReservationCallable;
    private final UnaryCallable<DeleteReservationRequest, Empty> deleteReservationCallable;
    private final UnaryCallable<ListReservationTopicsRequest, ListReservationTopicsResponse> listReservationTopicsCallable;
    private final UnaryCallable<ListReservationTopicsRequest, AdminServiceClient.ListReservationTopicsPagedResponse> listReservationTopicsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAdminServiceStub create(AdminServiceStubSettings settings) throws IOException {
        return new GrpcAdminServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAdminServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAdminServiceStub(AdminServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAdminServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAdminServiceStub(AdminServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAdminServiceStub(AdminServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAdminServiceCallableFactory());
    }

    protected GrpcAdminServiceStub(AdminServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTopicMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTopicMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getTopicPartitionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTopicPartitionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listTopicsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTopicsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTopicMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic.name", String.valueOf(request.getTopic().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTopicMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listTopicSubscriptionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTopicSubscriptionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSubscriptionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSubscriptionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSubscriptionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSubscriptionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSubscriptionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("subscription.name", String.valueOf(request.getSubscription().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSubscriptionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings seekSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(seekSubscriptionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createReservationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createReservationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getReservationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getReservationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listReservationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listReservationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateReservationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateReservationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("reservation.name", String.valueOf(request.getReservation().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteReservationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteReservationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listReservationTopicsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listReservationTopicsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createTopicCallable = callableFactory.createUnaryCallable(createTopicTransportSettings, settings.createTopicSettings(), clientContext);
        this.getTopicCallable = callableFactory.createUnaryCallable(getTopicTransportSettings, settings.getTopicSettings(), clientContext);
        this.getTopicPartitionsCallable = callableFactory.createUnaryCallable(getTopicPartitionsTransportSettings, settings.getTopicPartitionsSettings(), clientContext);
        this.listTopicsCallable = callableFactory.createUnaryCallable(listTopicsTransportSettings, settings.listTopicsSettings(), clientContext);
        this.listTopicsPagedCallable = callableFactory.createPagedCallable(listTopicsTransportSettings, settings.listTopicsSettings(), clientContext);
        this.updateTopicCallable = callableFactory.createUnaryCallable(updateTopicTransportSettings, settings.updateTopicSettings(), clientContext);
        this.deleteTopicCallable = callableFactory.createUnaryCallable(deleteTopicTransportSettings, settings.deleteTopicSettings(), clientContext);
        this.listTopicSubscriptionsCallable = callableFactory.createUnaryCallable(listTopicSubscriptionsTransportSettings, settings.listTopicSubscriptionsSettings(), clientContext);
        this.listTopicSubscriptionsPagedCallable = callableFactory.createPagedCallable(listTopicSubscriptionsTransportSettings, settings.listTopicSubscriptionsSettings(), clientContext);
        this.createSubscriptionCallable = callableFactory.createUnaryCallable(createSubscriptionTransportSettings, settings.createSubscriptionSettings(), clientContext);
        this.getSubscriptionCallable = callableFactory.createUnaryCallable(getSubscriptionTransportSettings, settings.getSubscriptionSettings(), clientContext);
        this.listSubscriptionsCallable = callableFactory.createUnaryCallable(listSubscriptionsTransportSettings, settings.listSubscriptionsSettings(), clientContext);
        this.listSubscriptionsPagedCallable = callableFactory.createPagedCallable(listSubscriptionsTransportSettings, settings.listSubscriptionsSettings(), clientContext);
        this.updateSubscriptionCallable = callableFactory.createUnaryCallable(updateSubscriptionTransportSettings, settings.updateSubscriptionSettings(), clientContext);
        this.deleteSubscriptionCallable = callableFactory.createUnaryCallable(deleteSubscriptionTransportSettings, settings.deleteSubscriptionSettings(), clientContext);
        this.seekSubscriptionCallable = callableFactory.createUnaryCallable(seekSubscriptionTransportSettings, settings.seekSubscriptionSettings(), clientContext);
        this.seekSubscriptionOperationCallable = callableFactory.createOperationCallable(seekSubscriptionTransportSettings, settings.seekSubscriptionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createReservationCallable = callableFactory.createUnaryCallable(createReservationTransportSettings, settings.createReservationSettings(), clientContext);
        this.getReservationCallable = callableFactory.createUnaryCallable(getReservationTransportSettings, settings.getReservationSettings(), clientContext);
        this.listReservationsCallable = callableFactory.createUnaryCallable(listReservationsTransportSettings, settings.listReservationsSettings(), clientContext);
        this.listReservationsPagedCallable = callableFactory.createPagedCallable(listReservationsTransportSettings, settings.listReservationsSettings(), clientContext);
        this.updateReservationCallable = callableFactory.createUnaryCallable(updateReservationTransportSettings, settings.updateReservationSettings(), clientContext);
        this.deleteReservationCallable = callableFactory.createUnaryCallable(deleteReservationTransportSettings, settings.deleteReservationSettings(), clientContext);
        this.listReservationTopicsCallable = callableFactory.createUnaryCallable(listReservationTopicsTransportSettings, settings.listReservationTopicsSettings(), clientContext);
        this.listReservationTopicsPagedCallable = callableFactory.createPagedCallable(listReservationTopicsTransportSettings, settings.listReservationTopicsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateTopicRequest, Topic> createTopicCallable() {
        return this.createTopicCallable;
    }

    @Override
    public UnaryCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.getTopicCallable;
    }

    @Override
    public UnaryCallable<GetTopicPartitionsRequest, TopicPartitions> getTopicPartitionsCallable() {
        return this.getTopicPartitionsCallable;
    }

    @Override
    public UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.listTopicsCallable;
    }

    @Override
    public UnaryCallable<ListTopicsRequest, AdminServiceClient.ListTopicsPagedResponse> listTopicsPagedCallable() {
        return this.listTopicsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable() {
        return this.updateTopicCallable;
    }

    @Override
    public UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.deleteTopicCallable;
    }

    @Override
    public UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable() {
        return this.listTopicSubscriptionsCallable;
    }

    @Override
    public UnaryCallable<ListTopicSubscriptionsRequest, AdminServiceClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable() {
        return this.listTopicSubscriptionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateSubscriptionRequest, Subscription> createSubscriptionCallable() {
        return this.createSubscriptionCallable;
    }

    @Override
    public UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable() {
        return this.getSubscriptionCallable;
    }

    @Override
    public UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable() {
        return this.listSubscriptionsCallable;
    }

    @Override
    public UnaryCallable<ListSubscriptionsRequest, AdminServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable() {
        return this.listSubscriptionsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateSubscriptionRequest, Subscription> updateSubscriptionCallable() {
        return this.updateSubscriptionCallable;
    }

    @Override
    public UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable() {
        return this.deleteSubscriptionCallable;
    }

    @Override
    public UnaryCallable<SeekSubscriptionRequest, Operation> seekSubscriptionCallable() {
        return this.seekSubscriptionCallable;
    }

    @Override
    public OperationCallable<SeekSubscriptionRequest, SeekSubscriptionResponse, OperationMetadata> seekSubscriptionOperationCallable() {
        return this.seekSubscriptionOperationCallable;
    }

    @Override
    public UnaryCallable<CreateReservationRequest, Reservation> createReservationCallable() {
        return this.createReservationCallable;
    }

    @Override
    public UnaryCallable<GetReservationRequest, Reservation> getReservationCallable() {
        return this.getReservationCallable;
    }

    @Override
    public UnaryCallable<ListReservationsRequest, ListReservationsResponse> listReservationsCallable() {
        return this.listReservationsCallable;
    }

    @Override
    public UnaryCallable<ListReservationsRequest, AdminServiceClient.ListReservationsPagedResponse> listReservationsPagedCallable() {
        return this.listReservationsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateReservationRequest, Reservation> updateReservationCallable() {
        return this.updateReservationCallable;
    }

    @Override
    public UnaryCallable<DeleteReservationRequest, Empty> deleteReservationCallable() {
        return this.deleteReservationCallable;
    }

    @Override
    public UnaryCallable<ListReservationTopicsRequest, ListReservationTopicsResponse> listReservationTopicsCallable() {
        return this.listReservationTopicsCallable;
    }

    @Override
    public UnaryCallable<ListReservationTopicsRequest, AdminServiceClient.ListReservationTopicsPagedResponse> listReservationTopicsPagedCallable() {
        return this.listReservationTopicsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

