/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.proto.Subscription;
import java.util.concurrent.TimeUnit;

public final class PartitionLookupUtils {
    private PartitionLookupUtils() {
    }

    public static int numPartitions(TopicPath topic) throws ApiException {
        int n;
        block8: {
            AdminClient client = AdminClient.create(AdminClientSettings.newBuilder().setRegion(topic.location().extractRegion()).build());
            try {
                n = PartitionLookupUtils.numPartitions(topic, client);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExtractStatus.toCanonical((Throwable)e).underlying;
                }
            }
            client.close();
        }
        return n;
    }

    public static int numPartitions(TopicPath topic, AdminClient client) throws ApiException {
        ApiFuture<Long> partitionCountFuture = client.getTopicPartitionCount(topic);
        try {
            long numPartitions = (Long)partitionCountFuture.get(1L, TimeUnit.MINUTES);
            UncheckedApiPreconditions.checkState(numPartitions > 0L, "Config has 0 or less partitions configured. This config is invalid.");
            UncheckedApiPreconditions.checkState(numPartitions < Integer.MAX_VALUE, "Config has more than Integer.MAX_VALUE partitions configured. This config cannot be used with this client library.");
            return (int)numPartitions;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    public static int numPartitions(SubscriptionPath subscription) throws ApiException {
        int n;
        block8: {
            AdminClient client = AdminClient.create(AdminClientSettings.newBuilder().setRegion(subscription.location().extractRegion()).build());
            try {
                n = PartitionLookupUtils.numPartitions(subscription, client);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw ExtractStatus.toCanonical((Throwable)t).underlying;
                }
            }
            client.close();
        }
        return n;
    }

    public static int numPartitions(SubscriptionPath subscription, AdminClient client) throws ApiException {
        ApiFuture<Subscription> subscriptionFuture = client.getSubscription(subscription);
        try {
            return PartitionLookupUtils.numPartitions(TopicPath.parse(((Subscription)subscriptionFuture.get(1L, TimeUnit.MINUTES)).getTopic()), client);
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }
}

