/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.CreateServiceRequest;
import com.google.cloud.run.v2.DeleteServiceRequest;
import com.google.cloud.run.v2.GetServiceRequest;
import com.google.cloud.run.v2.ListServicesRequest;
import com.google.cloud.run.v2.ListServicesResponse;
import com.google.cloud.run.v2.LocationName;
import com.google.cloud.run.v2.Service;
import com.google.cloud.run.v2.ServiceName;
import com.google.cloud.run.v2.ServicesSettings;
import com.google.cloud.run.v2.UpdateServiceRequest;
import com.google.cloud.run.v2.stub.ServicesStub;
import com.google.cloud.run.v2.stub.ServicesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ServicesClient
implements BackgroundResource {
    private final ServicesSettings settings;
    private final ServicesStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ServicesClient create() throws IOException {
        return ServicesClient.create(ServicesSettings.newBuilder().build());
    }

    public static final ServicesClient create(ServicesSettings settings) throws IOException {
        return new ServicesClient(settings);
    }

    public static final ServicesClient create(ServicesStub stub) {
        return new ServicesClient(stub);
    }

    protected ServicesClient(ServicesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ServicesStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ServicesClient(ServicesStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ServicesSettings getSettings() {
        return this.settings;
    }

    public ServicesStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Service, Service> createServiceAsync(LocationName parent, Service service, String serviceId) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setService(service).setServiceId(serviceId).build();
        return this.createServiceAsync(request);
    }

    public final OperationFuture<Service, Service> createServiceAsync(String parent, Service service, String serviceId) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent).setService(service).setServiceId(serviceId).build();
        return this.createServiceAsync(request);
    }

    public final OperationFuture<Service, Service> createServiceAsync(CreateServiceRequest request) {
        return this.createServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceRequest, Service, Service> createServiceOperationCallable() {
        return this.stub.createServiceOperationCallable();
    }

    public final UnaryCallable<CreateServiceRequest, Operation> createServiceCallable() {
        return this.stub.createServiceCallable();
    }

    public final Service getService(ServiceName name) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getService(request);
    }

    public final Service getService(String name) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setName(name).build();
        return this.getService(request);
    }

    public final Service getService(GetServiceRequest request) {
        return (Service)this.getServiceCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.stub.getServiceCallable();
    }

    public final ListServicesPagedResponse listServices(LocationName parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(String parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(ListServicesRequest request) {
        return (ListServicesPagedResponse)((Object)this.listServicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServicesRequest, ListServicesPagedResponse> listServicesPagedCallable() {
        return this.stub.listServicesPagedCallable();
    }

    public final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.stub.listServicesCallable();
    }

    public final OperationFuture<Service, Service> updateServiceAsync(Service service) {
        UpdateServiceRequest request = UpdateServiceRequest.newBuilder().setService(service).build();
        return this.updateServiceAsync(request);
    }

    public final OperationFuture<Service, Service> updateServiceAsync(Service service, FieldMask updateMask) {
        UpdateServiceRequest request = UpdateServiceRequest.newBuilder().setService(service).setUpdateMask(updateMask).build();
        return this.updateServiceAsync(request);
    }

    public final OperationFuture<Service, Service> updateServiceAsync(UpdateServiceRequest request) {
        return this.updateServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateServiceRequest, Service, Service> updateServiceOperationCallable() {
        return this.stub.updateServiceOperationCallable();
    }

    public final UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable() {
        return this.stub.updateServiceCallable();
    }

    public final OperationFuture<Service, Service> deleteServiceAsync(ServiceName name) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServiceAsync(request);
    }

    public final OperationFuture<Service, Service> deleteServiceAsync(String name) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setName(name).build();
        return this.deleteServiceAsync(request);
    }

    public final OperationFuture<Service, Service> deleteServiceAsync(DeleteServiceRequest request) {
        return this.deleteServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceRequest, Service, Service> deleteServiceOperationCallable() {
        return this.stub.deleteServiceOperationCallable();
    }

    public final UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable() {
        return this.stub.deleteServiceCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        private ListServicesFixedSizeCollection(List<ListServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServicesFixedSizeCollection createEmptyCollection() {
            return new ListServicesFixedSizeCollection(null, 0);
        }

        protected ListServicesFixedSizeCollection createCollection(List<ListServicesPage> pages, int collectionSize) {
            return new ListServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServicesPage
    extends AbstractPage<ListServicesRequest, ListServicesResponse, Service, ListServicesPage> {
        private ListServicesPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            super(context, (Object)response);
        }

        private static ListServicesPage createEmptyPage() {
            return new ListServicesPage(null, null);
        }

        protected ListServicesPage createPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            return new ListServicesPage(context, response);
        }

        public ApiFuture<ListServicesPage> createPageAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServicesPagedResponse
    extends AbstractPagedListResponse<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        public static ApiFuture<ListServicesPagedResponse> createAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            ApiFuture<ListServicesPage> futurePage = ListServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServicesPagedResponse((ListServicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServicesPagedResponse(ListServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServicesFixedSizeCollection.createEmptyCollection());
        }
    }
}

