/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.CreateWorkerPoolRequest;
import com.google.cloud.run.v2.DeleteWorkerPoolRequest;
import com.google.cloud.run.v2.GetWorkerPoolRequest;
import com.google.cloud.run.v2.ListWorkerPoolsRequest;
import com.google.cloud.run.v2.ListWorkerPoolsResponse;
import com.google.cloud.run.v2.LocationName;
import com.google.cloud.run.v2.UpdateWorkerPoolRequest;
import com.google.cloud.run.v2.WorkerPool;
import com.google.cloud.run.v2.WorkerPoolName;
import com.google.cloud.run.v2.WorkerPoolsSettings;
import com.google.cloud.run.v2.stub.WorkerPoolsStub;
import com.google.cloud.run.v2.stub.WorkerPoolsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class WorkerPoolsClient
implements BackgroundResource {
    private final WorkerPoolsSettings settings;
    private final WorkerPoolsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final WorkerPoolsClient create() throws IOException {
        return WorkerPoolsClient.create(WorkerPoolsSettings.newBuilder().build());
    }

    public static final WorkerPoolsClient create(WorkerPoolsSettings settings) throws IOException {
        return new WorkerPoolsClient(settings);
    }

    public static final WorkerPoolsClient create(WorkerPoolsStub stub) {
        return new WorkerPoolsClient(stub);
    }

    protected WorkerPoolsClient(WorkerPoolsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((WorkerPoolsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected WorkerPoolsClient(WorkerPoolsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final WorkerPoolsSettings getSettings() {
        return this.settings;
    }

    public WorkerPoolsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<WorkerPool, WorkerPool> createWorkerPoolAsync(LocationName parent, WorkerPool workerPool, String workerPoolId) {
        CreateWorkerPoolRequest request = CreateWorkerPoolRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkerPool(workerPool).setWorkerPoolId(workerPoolId).build();
        return this.createWorkerPoolAsync(request);
    }

    public final OperationFuture<WorkerPool, WorkerPool> createWorkerPoolAsync(String parent, WorkerPool workerPool, String workerPoolId) {
        CreateWorkerPoolRequest request = CreateWorkerPoolRequest.newBuilder().setParent(parent).setWorkerPool(workerPool).setWorkerPoolId(workerPoolId).build();
        return this.createWorkerPoolAsync(request);
    }

    public final OperationFuture<WorkerPool, WorkerPool> createWorkerPoolAsync(CreateWorkerPoolRequest request) {
        return this.createWorkerPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateWorkerPoolRequest, WorkerPool, WorkerPool> createWorkerPoolOperationCallable() {
        return this.stub.createWorkerPoolOperationCallable();
    }

    public final UnaryCallable<CreateWorkerPoolRequest, Operation> createWorkerPoolCallable() {
        return this.stub.createWorkerPoolCallable();
    }

    public final WorkerPool getWorkerPool(WorkerPoolName name) {
        GetWorkerPoolRequest request = GetWorkerPoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkerPool(request);
    }

    public final WorkerPool getWorkerPool(String name) {
        GetWorkerPoolRequest request = GetWorkerPoolRequest.newBuilder().setName(name).build();
        return this.getWorkerPool(request);
    }

    public final WorkerPool getWorkerPool(GetWorkerPoolRequest request) {
        return (WorkerPool)this.getWorkerPoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkerPoolRequest, WorkerPool> getWorkerPoolCallable() {
        return this.stub.getWorkerPoolCallable();
    }

    public final ListWorkerPoolsPagedResponse listWorkerPools(LocationName parent) {
        ListWorkerPoolsRequest request = ListWorkerPoolsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkerPools(request);
    }

    public final ListWorkerPoolsPagedResponse listWorkerPools(String parent) {
        ListWorkerPoolsRequest request = ListWorkerPoolsRequest.newBuilder().setParent(parent).build();
        return this.listWorkerPools(request);
    }

    public final ListWorkerPoolsPagedResponse listWorkerPools(ListWorkerPoolsRequest request) {
        return (ListWorkerPoolsPagedResponse)((Object)this.listWorkerPoolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsPagedResponse> listWorkerPoolsPagedCallable() {
        return this.stub.listWorkerPoolsPagedCallable();
    }

    public final UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsCallable() {
        return this.stub.listWorkerPoolsCallable();
    }

    public final OperationFuture<WorkerPool, WorkerPool> updateWorkerPoolAsync(WorkerPool workerPool) {
        UpdateWorkerPoolRequest request = UpdateWorkerPoolRequest.newBuilder().setWorkerPool(workerPool).build();
        return this.updateWorkerPoolAsync(request);
    }

    public final OperationFuture<WorkerPool, WorkerPool> updateWorkerPoolAsync(WorkerPool workerPool, FieldMask updateMask) {
        UpdateWorkerPoolRequest request = UpdateWorkerPoolRequest.newBuilder().setWorkerPool(workerPool).setUpdateMask(updateMask).build();
        return this.updateWorkerPoolAsync(request);
    }

    public final OperationFuture<WorkerPool, WorkerPool> updateWorkerPoolAsync(UpdateWorkerPoolRequest request) {
        return this.updateWorkerPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateWorkerPoolRequest, WorkerPool, WorkerPool> updateWorkerPoolOperationCallable() {
        return this.stub.updateWorkerPoolOperationCallable();
    }

    public final UnaryCallable<UpdateWorkerPoolRequest, Operation> updateWorkerPoolCallable() {
        return this.stub.updateWorkerPoolCallable();
    }

    public final OperationFuture<WorkerPool, WorkerPool> deleteWorkerPoolAsync(WorkerPoolName name) {
        DeleteWorkerPoolRequest request = DeleteWorkerPoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteWorkerPoolAsync(request);
    }

    public final OperationFuture<WorkerPool, WorkerPool> deleteWorkerPoolAsync(String name) {
        DeleteWorkerPoolRequest request = DeleteWorkerPoolRequest.newBuilder().setName(name).build();
        return this.deleteWorkerPoolAsync(request);
    }

    public final OperationFuture<WorkerPool, WorkerPool> deleteWorkerPoolAsync(DeleteWorkerPoolRequest request) {
        return this.deleteWorkerPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteWorkerPoolRequest, WorkerPool, WorkerPool> deleteWorkerPoolOperationCallable() {
        return this.stub.deleteWorkerPoolOperationCallable();
    }

    public final UnaryCallable<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolCallable() {
        return this.stub.deleteWorkerPoolCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListWorkerPoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool, ListWorkerPoolsPage, ListWorkerPoolsFixedSizeCollection> {
        private ListWorkerPoolsFixedSizeCollection(List<ListWorkerPoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkerPoolsFixedSizeCollection createEmptyCollection() {
            return new ListWorkerPoolsFixedSizeCollection(null, 0);
        }

        protected ListWorkerPoolsFixedSizeCollection createCollection(List<ListWorkerPoolsPage> pages, int collectionSize) {
            return new ListWorkerPoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkerPoolsPage
    extends AbstractPage<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool, ListWorkerPoolsPage> {
        private ListWorkerPoolsPage(PageContext<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool> context, ListWorkerPoolsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkerPoolsPage createEmptyPage() {
            return new ListWorkerPoolsPage(null, null);
        }

        protected ListWorkerPoolsPage createPage(PageContext<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool> context, ListWorkerPoolsResponse response) {
            return new ListWorkerPoolsPage(context, response);
        }

        public ApiFuture<ListWorkerPoolsPage> createPageAsync(PageContext<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool> context, ApiFuture<ListWorkerPoolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkerPoolsPagedResponse
    extends AbstractPagedListResponse<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool, ListWorkerPoolsPage, ListWorkerPoolsFixedSizeCollection> {
        public static ApiFuture<ListWorkerPoolsPagedResponse> createAsync(PageContext<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool> context, ApiFuture<ListWorkerPoolsResponse> futureResponse) {
            ApiFuture<ListWorkerPoolsPage> futurePage = ListWorkerPoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkerPoolsPagedResponse((ListWorkerPoolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkerPoolsPagedResponse(ListWorkerPoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkerPoolsFixedSizeCollection.createEmptyCollection());
        }
    }
}

