/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.executor.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnavailableException;
import com.google.auth.Credentials;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.NoCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.executor.spanner.CloudExecutor;
import com.google.cloud.executor.spanner.CloudUtil;
import com.google.cloud.executor.spanner.WorkerProxy;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceConfigInfo;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ReplicaInfo;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.encryption.CustomerManagedEncryption;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.longrunning.Operation;
import com.google.protobuf.ByteString;
import com.google.protobuf.util.Timestamps;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.EncryptionConfig;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.executor.v1.AdminAction;
import com.google.spanner.executor.v1.AdminResult;
import com.google.spanner.executor.v1.BatchDmlAction;
import com.google.spanner.executor.v1.BatchPartition;
import com.google.spanner.executor.v1.CancelOperationAction;
import com.google.spanner.executor.v1.ChangeStreamRecord;
import com.google.spanner.executor.v1.ChildPartitionsRecord;
import com.google.spanner.executor.v1.CloseBatchTransactionAction;
import com.google.spanner.executor.v1.CloudBackupResponse;
import com.google.spanner.executor.v1.CloudDatabaseResponse;
import com.google.spanner.executor.v1.CloudInstanceConfigResponse;
import com.google.spanner.executor.v1.CloudInstanceResponse;
import com.google.spanner.executor.v1.Concurrency;
import com.google.spanner.executor.v1.CopyCloudBackupAction;
import com.google.spanner.executor.v1.CreateCloudBackupAction;
import com.google.spanner.executor.v1.CreateCloudDatabaseAction;
import com.google.spanner.executor.v1.CreateCloudInstanceAction;
import com.google.spanner.executor.v1.CreateUserInstanceConfigAction;
import com.google.spanner.executor.v1.DataChangeRecord;
import com.google.spanner.executor.v1.DeleteCloudBackupAction;
import com.google.spanner.executor.v1.DeleteCloudInstanceAction;
import com.google.spanner.executor.v1.DeleteUserInstanceConfigAction;
import com.google.spanner.executor.v1.DmlAction;
import com.google.spanner.executor.v1.DropCloudDatabaseAction;
import com.google.spanner.executor.v1.ExecuteChangeStreamQuery;
import com.google.spanner.executor.v1.ExecutePartitionAction;
import com.google.spanner.executor.v1.FinishTransactionAction;
import com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction;
import com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction;
import com.google.spanner.executor.v1.GetCloudBackupAction;
import com.google.spanner.executor.v1.GetCloudDatabaseAction;
import com.google.spanner.executor.v1.GetCloudInstanceAction;
import com.google.spanner.executor.v1.GetCloudInstanceConfigAction;
import com.google.spanner.executor.v1.GetOperationAction;
import com.google.spanner.executor.v1.HeartbeatRecord;
import com.google.spanner.executor.v1.ListCloudBackupOperationsAction;
import com.google.spanner.executor.v1.ListCloudBackupsAction;
import com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction;
import com.google.spanner.executor.v1.ListCloudDatabasesAction;
import com.google.spanner.executor.v1.ListCloudInstanceConfigsAction;
import com.google.spanner.executor.v1.ListCloudInstancesAction;
import com.google.spanner.executor.v1.MutationAction;
import com.google.spanner.executor.v1.OperationResponse;
import com.google.spanner.executor.v1.PartitionedUpdateAction;
import com.google.spanner.executor.v1.QueryAction;
import com.google.spanner.executor.v1.ReadAction;
import com.google.spanner.executor.v1.RestoreCloudDatabaseAction;
import com.google.spanner.executor.v1.SpannerAction;
import com.google.spanner.executor.v1.SpannerActionOutcome;
import com.google.spanner.executor.v1.SpannerAsyncActionRequest;
import com.google.spanner.executor.v1.SpannerAsyncActionResponse;
import com.google.spanner.executor.v1.StartBatchTransactionAction;
import com.google.spanner.executor.v1.StartTransactionAction;
import com.google.spanner.executor.v1.TransactionExecutionOptions;
import com.google.spanner.executor.v1.UpdateCloudBackupAction;
import com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction;
import com.google.spanner.executor.v1.UpdateCloudInstanceAction;
import com.google.spanner.executor.v1.Value;
import com.google.spanner.executor.v1.ValueList;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.TypeAnnotationCode;
import com.google.spanner.v1.TypeCode;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.threeten.bp.Duration;
import org.threeten.bp.LocalDate;

public class CloudClientExecutor
extends CloudExecutor {
    private static final Logger LOGGER = Logger.getLogger(CloudClientExecutor.class.getName());
    private static final String HOST_PREFIX = "https://localhost:";
    private Spanner client;
    private Spanner clientWithTimeout;
    private static final String TRANSACTION_ABANDONED = "Fake error to abandon transaction";
    private static final Executor txnThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("txn-pool-%d").build());
    private static final Executor actionThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("action-pool-%d").build());

    public CloudClientExecutor(boolean enableGrpcFaultInjector) {
        this.enableGrpcFaultInjector = enableGrpcFaultInjector;
    }

    private synchronized Spanner getClientWithTimeout(long timeoutSeconds) throws IOException {
        if (this.clientWithTimeout != null) {
            return this.clientWithTimeout;
        }
        this.clientWithTimeout = this.getClient(timeoutSeconds);
        return this.clientWithTimeout;
    }

    private synchronized Spanner getClient() throws IOException {
        if (this.client != null) {
            return this.client;
        }
        this.client = this.getClient(0L);
        return this.client;
    }

    private synchronized Spanner getClient(long timeoutSeconds) throws IOException {
        Object credentials = WorkerProxy.serviceKeyFile.isEmpty() ? NoCredentials.getInstance() : GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(FileUtils.readFileToByteArray((File)new File(WorkerProxy.serviceKeyFile))), (HttpTransportFactory)HTTP_TRANSPORT_FACTORY);
        TransportChannelProvider channelProvider = CloudUtil.newChannelProviderHelper(WorkerProxy.spannerPort);
        Duration rpcTimeout = Duration.ofHours((long)1L);
        if (timeoutSeconds > 0L) {
            rpcTimeout = Duration.ofSeconds((long)timeoutSeconds);
        }
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)1L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofSeconds((long)32L)).setInitialRpcTimeout(rpcTimeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(rpcTimeout).setTotalTimeout(rpcTimeout).build();
        SpannerOptions.Builder optionsBuilder = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("spanner-cloud-systest")).setHost(HOST_PREFIX + WorkerProxy.spannerPort).setCredentials((Credentials)credentials)).setChannelProvider(channelProvider);
        SpannerStubSettings.Builder stubSettingsBuilder = optionsBuilder.getSpannerStubSettingsBuilder();
        stubSettingsBuilder.executeSqlSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.executeStreamingSqlSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.readSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.streamingReadSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.commitSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.executeBatchDmlSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.partitionQuerySettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.partitionReadSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.rollbackSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.batchCreateSessionsSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.beginTransactionSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.createSessionSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.getSessionSettings().setRetrySettings(retrySettings);
        stubSettingsBuilder.deleteSessionSettings().setRetrySettings(retrySettings);
        return (Spanner)optionsBuilder.build().getService();
    }

    public Status startHandlingRequest(SpannerAsyncActionRequest req, ExecutionFlowContext executionContext) {
        CloudExecutor.OutcomeSender outcomeSender = new CloudExecutor.OutcomeSender(req.getActionId(), executionContext);
        if (!req.hasAction()) {
            return outcomeSender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Invalid request")));
        }
        SpannerAction action = req.getAction();
        String dbPath = executionContext.getDatabasePath(action.getDatabasePath());
        actionThreadPool.execute(() -> {
            Status status = this.executeAction(outcomeSender, action, dbPath, executionContext);
            if (!status.isOk()) {
                LOGGER.log(Level.WARNING, String.format("Failed to execute action with error: %s\n%s", status, action));
                executionContext.onError(status.getCause());
            }
        });
        return Status.OK;
    }

    private Status executeAction(CloudExecutor.OutcomeSender outcomeSender, SpannerAction action, String dbPath, ExecutionFlowContext executionContext) {
        try {
            if (action.hasAdmin()) {
                return this.executeAdminAction(action.getAdmin(), outcomeSender);
            }
            if (action.hasStart()) {
                if (dbPath == null) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Database path must be set for this action");
                }
                DatabaseClient dbClient = this.getClient().getDatabaseClient(DatabaseId.of((String)dbPath));
                return this.executeStartTxn(action.getStart(), dbClient, outcomeSender, executionContext);
            }
            if (action.hasFinish()) {
                return this.executeFinishTxn(action.getFinish(), outcomeSender, executionContext);
            }
            if (action.hasMutation()) {
                return this.executeMutation(action.getMutation(), outcomeSender, executionContext, false);
            }
            if (action.hasRead()) {
                return this.executeRead(action.getRead(), outcomeSender, executionContext);
            }
            if (action.hasQuery()) {
                return this.executeQuery(action.getQuery(), outcomeSender, executionContext);
            }
            if (action.hasDml()) {
                return this.executeCloudDmlUpdate(action.getDml(), outcomeSender, executionContext);
            }
            if (action.hasBatchDml()) {
                return this.executeCloudBatchDmlUpdates(action.getBatchDml(), outcomeSender, executionContext);
            }
            if (action.hasWrite()) {
                return this.executeMutation(action.getWrite().getMutation(), outcomeSender, executionContext, true);
            }
            if (action.hasStartBatchTxn()) {
                if (dbPath == null) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"database path must be set for this action");
                }
                BatchClient batchClient = this.getClient().getBatchClient(DatabaseId.of((String)dbPath));
                return this.executeStartBatchTxn(action.getStartBatchTxn(), batchClient, outcomeSender, executionContext);
            }
            if (action.hasGenerateDbPartitionsRead()) {
                return this.executeGenerateDbPartitionsRead(action.getGenerateDbPartitionsRead(), outcomeSender, executionContext);
            }
            if (action.hasGenerateDbPartitionsQuery()) {
                return this.executeGenerateDbPartitionsQuery(action.getGenerateDbPartitionsQuery(), outcomeSender, executionContext);
            }
            if (action.hasExecutePartition()) {
                return this.executeExecutePartition(action.getExecutePartition(), outcomeSender, executionContext);
            }
            if (action.hasPartitionedUpdate()) {
                if (dbPath == null) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Database path must be set for this action");
                }
                DatabaseClient dbClient = this.getClient().getDatabaseClient(DatabaseId.of((String)dbPath));
                return this.executePartitionedUpdate(action.getPartitionedUpdate(), dbClient, outcomeSender);
            }
            if (action.hasCloseBatchTxn()) {
                return this.executeCloseBatchTxn(action.getCloseBatchTxn(), outcomeSender, executionContext);
            }
            if (action.hasExecuteChangeStreamQuery()) {
                if (dbPath == null) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Database path must be set for this action");
                }
                return this.executeExecuteChangeStreamQuery(dbPath, action.getExecuteChangeStreamQuery(), outcomeSender);
            }
            return outcomeSender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNIMPLEMENTED, (String)("Not implemented yet: \n" + action))));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return outcomeSender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeAdminAction(AdminAction action, CloudExecutor.OutcomeSender outcomeSender) {
        try {
            if (action.hasCreateCloudInstance()) {
                return this.executeCreateCloudInstance(action.getCreateCloudInstance(), outcomeSender);
            }
            if (action.hasUpdateCloudInstance()) {
                return this.executeUpdateCloudInstance(action.getUpdateCloudInstance(), outcomeSender);
            }
            if (action.hasDeleteCloudInstance()) {
                return this.executeDeleteCloudInstance(action.getDeleteCloudInstance(), outcomeSender);
            }
            if (action.hasListCloudInstances()) {
                return this.executeListCloudInstances(action.getListCloudInstances(), outcomeSender);
            }
            if (action.hasListInstanceConfigs()) {
                return this.executeListCloudInstanceConfigs(action.getListInstanceConfigs(), outcomeSender);
            }
            if (action.hasGetCloudInstanceConfig()) {
                return this.executeGetCloudInstanceConfig(action.getGetCloudInstanceConfig(), outcomeSender);
            }
            if (action.hasGetCloudInstance()) {
                return this.executeGetCloudInstance(action.getGetCloudInstance(), outcomeSender);
            }
            if (action.hasCreateUserInstanceConfig()) {
                return this.executeCreateUserInstanceConfig(action.getCreateUserInstanceConfig(), outcomeSender);
            }
            if (action.hasDeleteUserInstanceConfig()) {
                return this.executeDeleteUserInstanceConfig(action.getDeleteUserInstanceConfig(), outcomeSender);
            }
            if (action.hasCreateCloudDatabase()) {
                return this.executeCreateCloudDatabase(action.getCreateCloudDatabase(), outcomeSender);
            }
            if (action.hasUpdateCloudDatabaseDdl()) {
                return this.executeUpdateCloudDatabaseDdl(action.getUpdateCloudDatabaseDdl(), outcomeSender);
            }
            if (action.hasDropCloudDatabase()) {
                return this.executeDropCloudDatabase(action.getDropCloudDatabase(), outcomeSender);
            }
            if (action.hasCreateCloudBackup()) {
                return this.executeCreateCloudBackup(action.getCreateCloudBackup(), outcomeSender);
            }
            if (action.hasCopyCloudBackup()) {
                return this.executeCopyCloudBackup(action.getCopyCloudBackup(), outcomeSender);
            }
            if (action.hasGetCloudBackup()) {
                return this.executeGetCloudBackup(action.getGetCloudBackup(), outcomeSender);
            }
            if (action.hasUpdateCloudBackup()) {
                return this.executeUpdateCloudBackup(action.getUpdateCloudBackup(), outcomeSender);
            }
            if (action.hasDeleteCloudBackup()) {
                return this.executeDeleteCloudBackup(action.getDeleteCloudBackup(), outcomeSender);
            }
            if (action.hasListCloudBackups()) {
                return this.executeListCloudBackups(action.getListCloudBackups(), outcomeSender);
            }
            if (action.hasListCloudBackupOperations()) {
                return this.executeListCloudBackupOperations(action.getListCloudBackupOperations(), outcomeSender);
            }
            if (action.hasListCloudDatabases()) {
                return this.executeListCloudDatabases(action.getListCloudDatabases(), outcomeSender);
            }
            if (action.hasListCloudDatabaseOperations()) {
                return this.executeListCloudDatabaseOperations(action.getListCloudDatabaseOperations(), outcomeSender);
            }
            if (action.hasRestoreCloudDatabase()) {
                return this.executeRestoreCloudDatabase(action.getRestoreCloudDatabase(), outcomeSender);
            }
            if (action.hasGetCloudDatabase()) {
                return this.executeGetCloudDatabase(action.getGetCloudDatabase(), outcomeSender);
            }
            if (action.hasGetOperation()) {
                return this.executeGetOperation(action.getGetOperation(), outcomeSender);
            }
            if (action.hasCancelOperation()) {
                return this.executeCancelOperation(action.getCancelOperation(), outcomeSender);
            }
            return outcomeSender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNIMPLEMENTED, (String)("Not implemented yet: \n" + action))));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return outcomeSender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeCreateCloudInstance(CreateCloudInstanceAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Creating instance: \n%s", action));
            InstanceAdminClient instanceAdminClient = this.getClient().getInstanceAdminClient();
            String instanceId = action.getInstanceId();
            InstanceId instance = InstanceId.of((String)action.getProjectId(), (String)instanceId);
            InstanceInfo.Builder builder = InstanceInfo.newBuilder((InstanceId)instance).setInstanceConfigId(InstanceConfigId.of((String)action.getProjectId(), (String)action.getInstanceConfigId())).setDisplayName(instanceId).putAllLabels(action.getLabelsMap());
            if (action.hasNodeCount()) {
                builder.setNodeCount(action.getNodeCount());
            }
            if (action.hasProcessingUnits()) {
                builder.setProcessingUnits(action.getProcessingUnits());
            }
            InstanceInfo request = builder.build();
            instanceAdminClient.createInstance(request).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)ex);
            if (e.getErrorCode() == ErrorCode.ALREADY_EXISTS) {
                return sender.finishWithOK();
            }
            return sender.finishWithError(this.toStatus(e));
        }
        catch (SpannerException se) {
            return sender.finishWithError(this.toStatus(se));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
        return sender.finishWithOK();
    }

    private Status executeUpdateCloudInstance(UpdateCloudInstanceAction action, CloudExecutor.OutcomeSender sender) {
        try {
            Map labels;
            LOGGER.log(Level.INFO, String.format("Updating instance: \n%s", action));
            InstanceAdminClient instanceAdminClient = this.getClient().getInstanceAdminClient();
            String instanceId = action.getInstanceId();
            InstanceId instance = InstanceId.of((String)action.getProjectId(), (String)instanceId);
            InstanceInfo.Builder builder = InstanceInfo.newBuilder((InstanceId)instance);
            ArrayList<InstanceInfo.InstanceField> fieldsToUpdate = new ArrayList<InstanceInfo.InstanceField>();
            if (action.hasDisplayName()) {
                fieldsToUpdate.add(InstanceInfo.InstanceField.DISPLAY_NAME);
                builder.setDisplayName(instanceId);
            }
            if (action.hasNodeCount()) {
                fieldsToUpdate.add(InstanceInfo.InstanceField.NODE_COUNT);
                builder.setNodeCount(action.getNodeCount());
            }
            if (action.hasProcessingUnits()) {
                fieldsToUpdate.add(InstanceInfo.InstanceField.PROCESSING_UNITS);
                builder.setProcessingUnits(action.getProcessingUnits());
            }
            if (!(labels = action.getLabelsMap()).isEmpty()) {
                fieldsToUpdate.add(InstanceInfo.InstanceField.LABELS);
                builder.putAllLabels(action.getLabelsMap());
            }
            InstanceInfo request = builder.build();
            instanceAdminClient.updateInstance(request, fieldsToUpdate.toArray(new InstanceInfo.InstanceField[0])).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)ex);
            return sender.finishWithError(this.toStatus(e));
        }
        catch (SpannerException se) {
            return sender.finishWithError(this.toStatus(se));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
        return sender.finishWithOK();
    }

    private Status executeDeleteCloudInstance(DeleteCloudInstanceAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Deleting instance: \n%s", action));
            InstanceAdminClient instanceAdminClient = this.getClient().getInstanceAdminClient();
            String instanceId = action.getInstanceId();
            InstanceId instance = InstanceId.of((String)action.getProjectId(), (String)instanceId);
            instanceAdminClient.deleteInstance(instance.getInstance());
        }
        catch (SpannerException se) {
            return sender.finishWithError(this.toStatus(se));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
        return sender.finishWithOK();
    }

    private Status executeListCloudInstances(ListCloudInstancesAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Listing instances:\n%s", action));
            ArrayList<Options.ListOption> options = new ArrayList<Options.ListOption>();
            if (action.hasPageSize()) {
                options.add(Options.pageSize((int)action.getPageSize()));
            }
            if (action.hasFilter()) {
                options.add(Options.filter((String)action.getFilter()));
            }
            if (action.hasPageToken()) {
                options.add(Options.pageToken((String)action.getPageToken()));
            }
            Page response = this.getClient().getInstanceAdminClient().listInstances(options.toArray(new Options.ListOption[0]));
            ArrayList<Instance> instanceList = new ArrayList<Instance>();
            for (com.google.cloud.spanner.Instance instance : response.iterateAll()) {
                instanceList.add(this.instanceToProto(instance));
            }
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setInstanceResponse(CloudInstanceResponse.newBuilder().addAllListedInstances(instanceList).setNextPageToken("").build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeListCloudInstanceConfigs(ListCloudInstanceConfigsAction action, CloudExecutor.OutcomeSender sender) {
        LOGGER.log(Level.INFO, String.format("Listing instance configs:\n%s", action));
        ArrayList<Options.ListOption> options = new ArrayList<Options.ListOption>();
        if (action.hasPageSize()) {
            options.add(Options.pageSize((int)action.getPageSize()));
        }
        if (action.hasPageToken()) {
            options.add(Options.pageToken((String)action.getPageToken()));
        }
        try {
            Page response = this.getClient().getInstanceAdminClient().listInstanceConfigs(options.toArray(new Options.ListOption[0]));
            ArrayList<InstanceConfig> instanceConfigList = new ArrayList<InstanceConfig>();
            for (com.google.cloud.spanner.InstanceConfig instanceConfig : response.iterateAll()) {
                instanceConfigList.add(this.instanceConfigToProto(instanceConfig));
            }
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setInstanceConfigResponse(CloudInstanceConfigResponse.newBuilder().addAllListedInstanceConfigs(instanceConfigList).setNextPageToken("").build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeGetCloudInstanceConfig(GetCloudInstanceConfigAction action, CloudExecutor.OutcomeSender sender) {
        LOGGER.log(Level.INFO, String.format("Getting instance config:\n%s", action));
        try {
            com.google.cloud.spanner.InstanceConfig instanceConfig = this.getClient().getInstanceAdminClient().getInstanceConfig(action.getInstanceConfigId());
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setInstanceConfigResponse(CloudInstanceConfigResponse.newBuilder().setInstanceConfig(this.instanceConfigToProto(instanceConfig)).build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeGetCloudInstance(GetCloudInstanceAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Retrieving instance:\n%s", action));
            com.google.cloud.spanner.Instance instance = this.getClient().getInstanceAdminClient().getInstance(action.getInstanceId());
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setInstanceResponse(CloudInstanceResponse.newBuilder().setInstance(this.instanceToProto(instance)).build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeCreateUserInstanceConfig(CreateUserInstanceConfigAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Creating user instance config:\n%s", action));
            com.google.cloud.spanner.InstanceConfig baseConfig = this.getClient().getInstanceAdminClient().getInstanceConfig(action.getBaseConfigId());
            InstanceConfigInfo instanceConfigInfo = com.google.cloud.spanner.InstanceConfig.newBuilder((InstanceConfigId)InstanceConfigId.of((String)action.getProjectId(), (String)action.getUserConfigId()), (InstanceConfigInfo)baseConfig).setDisplayName(action.getUserConfigId()).addReadOnlyReplicas(baseConfig.getOptionalReplicas()).build();
            this.getClient().getInstanceAdminClient().createInstanceConfig(instanceConfigInfo, new Options.CreateAdminApiOption[0]).get();
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
        return sender.finishWithOK();
    }

    private Status executeDeleteUserInstanceConfig(DeleteUserInstanceConfigAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Deleting user instance config:\n%s", action));
            this.getClient().getInstanceAdminClient().deleteInstanceConfig(action.getUserConfigId(), new Options.DeleteAdminApiOption[0]);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
        return sender.finishWithOK();
    }

    private Status executeCreateCloudCustomEncryptedDatabase(CreateCloudDatabaseAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Creating database: \n%s", action));
            com.google.cloud.spanner.Database dbInfo = this.getClient().getDatabaseAdminClient().newDatabaseBuilder(DatabaseId.of((String)action.getProjectId(), (String)action.getInstanceId(), (String)action.getDatabaseId())).setEncryptionConfig(CustomerManagedEncryption.fromProtoOrNull((EncryptionConfig)action.getEncryptionConfig())).build();
            this.getClient().getDatabaseAdminClient().createDatabase(dbInfo, (Iterable)action.getSdlStatementList());
        }
        catch (SpannerException se) {
            return sender.finishWithError(this.toStatus(se));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
        return sender.finishWithOK();
    }

    private Status executeCreateCloudDatabase(CreateCloudDatabaseAction action, CloudExecutor.OutcomeSender sender) {
        if (action.hasEncryptionConfig()) {
            return this.executeCreateCloudCustomEncryptedDatabase(action, sender);
        }
        try {
            LOGGER.log(Level.INFO, String.format("Creating database: \n%s", action));
            String instanceId = action.getInstanceId();
            String databaseId = action.getDatabaseId();
            this.getClient().getDatabaseAdminClient().createDatabase(instanceId, databaseId, (Iterable)action.getSdlStatementList()).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)ex);
            if (e.getErrorCode() == ErrorCode.ALREADY_EXISTS) {
                return sender.finishWithOK();
            }
            return sender.finishWithError(this.toStatus(e));
        }
        catch (SpannerException se) {
            return sender.finishWithError(this.toStatus(se));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
        return sender.finishWithOK();
    }

    private Status executeUpdateCloudDatabaseDdl(UpdateCloudDatabaseDdlAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Updating database: \n%s", action));
            DatabaseAdminClient dbAdminClient = this.getClient().getDatabaseAdminClient();
            String instanceId = action.getInstanceId();
            String databaseId = action.getDatabaseId();
            OperationFuture updateOp = dbAdminClient.updateDatabaseDdl(instanceId, databaseId, (Iterable)action.getSdlStatementList(), action.getOperationId());
            updateOp.get();
            UpdateDatabaseDdlMetadata metadata = (UpdateDatabaseDdlMetadata)updateOp.getMetadata().get();
            int tsCount = metadata.getCommitTimestampsCount();
            sender.setTimestamp(metadata.getCommitTimestamps(tsCount - 1));
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error executing DDL: " + String.join((CharSequence)"; ", (Iterable<? extends CharSequence>)action.getSdlStatementList()) + " " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
        return sender.finishWithOK();
    }

    private Status executeDropCloudDatabase(DropCloudDatabaseAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Dropping database: \n%s", action));
            DatabaseAdminClient dbAdminClient = this.getClient().getDatabaseAdminClient();
            String instanceId = action.getInstanceId();
            String databaseId = action.getDatabaseId();
            dbAdminClient.dropDatabase(instanceId, databaseId);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
        return sender.finishWithOK();
    }

    private Status executeCreateCloudBackup(CreateCloudBackupAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Creating backup: \n%s", action));
            Backup backupResult = (Backup)this.getClient().getDatabaseAdminClient().createBackup(action.getInstanceId(), action.getBackupId(), action.getDatabaseId(), Timestamp.fromProto((com.google.protobuf.Timestamp)action.getExpireTime())).get();
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setBackupResponse(CloudBackupResponse.newBuilder().setBackup(backupResult.getProto()).build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeCopyCloudBackup(CopyCloudBackupAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Copying backup: \n%s", action));
            Backup backupResult = (Backup)this.getClient().getDatabaseAdminClient().copyBackup(action.getInstanceId(), action.getBackupId(), action.getSourceBackup(), Timestamp.fromProto((com.google.protobuf.Timestamp)action.getExpireTime())).get();
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setBackupResponse(CloudBackupResponse.newBuilder().setBackup(backupResult.getProto()).build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeGetCloudBackup(GetCloudBackupAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Getting backup: \n%s", action));
            Backup backupResult = this.getClient().getDatabaseAdminClient().getBackup(action.getInstanceId(), action.getBackupId());
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setBackupResponse(CloudBackupResponse.newBuilder().setBackup(backupResult.getProto()).build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeUpdateCloudBackup(UpdateCloudBackupAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Updating backup: \n%s", action));
            Backup backupResult = this.getClient().getDatabaseAdminClient().updateBackup(action.getInstanceId(), action.getBackupId(), Timestamp.fromProto((com.google.protobuf.Timestamp)action.getExpireTime()));
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setBackupResponse(CloudBackupResponse.newBuilder().setBackup(backupResult.getProto()).build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeDeleteCloudBackup(DeleteCloudBackupAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, "Deleting backup: \n%s", action);
            this.getClient().getDatabaseAdminClient().deleteBackup(action.getInstanceId(), action.getBackupId());
            return sender.finishWithOK();
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeListCloudBackups(ListCloudBackupsAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Listing backup: \n%s", action));
            Page response = this.getClient().getDatabaseAdminClient().listBackups(action.getInstanceId(), new Options.ListOption[]{Options.pageSize((int)action.getPageSize()), Options.filter((String)action.getFilter()), Options.pageToken((String)action.getPageToken())});
            ArrayList<com.google.spanner.admin.database.v1.Backup> backupList = new ArrayList<com.google.spanner.admin.database.v1.Backup>();
            for (Backup backup : response.iterateAll()) {
                backupList.add(backup.getProto());
            }
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setBackupResponse(CloudBackupResponse.newBuilder().addAllListedBackups(backupList).setNextPageToken("").build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeListCloudBackupOperations(ListCloudBackupOperationsAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Listing backup operation: \n%s", action));
            Page response = this.getClient().getDatabaseAdminClient().listBackupOperations(action.getInstanceId(), new Options.ListOption[]{Options.pageSize((int)action.getPageSize()), Options.filter((String)action.getFilter()), Options.pageToken((String)action.getPageToken())});
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setBackupResponse(CloudBackupResponse.newBuilder().addAllListedBackupOperations(response.iterateAll()).setNextPageToken("").build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeListCloudDatabases(ListCloudDatabasesAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Listing database: \n%s", action));
            Page response = this.getClient().getDatabaseAdminClient().listDatabases(action.getInstanceId(), new Options.ListOption[]{Options.pageSize((int)action.getPageSize()), Options.pageToken((String)action.getPageToken())});
            ArrayList<Database> databaseList = new ArrayList<Database>();
            for (com.google.cloud.spanner.Database database : response.iterateAll()) {
                databaseList.add(database.getProto());
            }
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setDatabaseResponse(CloudDatabaseResponse.newBuilder().addAllListedDatabases(databaseList).setNextPageToken("").build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeListCloudDatabaseOperations(ListCloudDatabaseOperationsAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Listing database operation: \n%s", action));
            Page response = this.getClient().getDatabaseAdminClient().listDatabaseOperations(action.getInstanceId(), new Options.ListOption[]{Options.pageSize((int)action.getPageSize()), Options.filter((String)action.getFilter()), Options.pageToken((String)action.getPageToken())});
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setDatabaseResponse(CloudDatabaseResponse.newBuilder().addAllListedDatabaseOperations(response.iterateAll()).setNextPageToken("").build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeRestoreCloudDatabase(RestoreCloudDatabaseAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Restoring database: \n%s", action));
            com.google.cloud.spanner.Database db = (com.google.cloud.spanner.Database)this.getClient().getDatabaseAdminClient().restoreDatabase(action.getBackupInstanceId(), action.getBackupId(), action.getDatabaseInstanceId(), action.getDatabaseId()).get();
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setDatabaseResponse(CloudDatabaseResponse.newBuilder().setDatabase(db.getProto()).build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeGetCloudDatabase(GetCloudDatabaseAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Getting database: \n%s", action));
            com.google.cloud.spanner.Database databaseResult = this.getClient().getDatabaseAdminClient().getDatabase(action.getInstanceId(), action.getDatabaseId());
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setDatabaseResponse(CloudDatabaseResponse.newBuilder().setDatabase(databaseResult.getProto()).build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeGetOperation(GetOperationAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Getting operation: \n%s", action));
            String operationName = action.getOperation();
            Operation operationResult = this.getClient().getDatabaseAdminClient().getOperation(operationName);
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).setAdminResult(AdminResult.newBuilder().setOperationResponse(OperationResponse.newBuilder().setOperation(operationResult).build())).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeCancelOperation(CancelOperationAction action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Cancelling operation: \n%s", action));
            String operationName = action.getOperation();
            this.getClient().getDatabaseAdminClient().cancelOperation(operationName);
            return sender.finishWithOK();
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeStartBatchTxn(StartBatchTransactionAction action, BatchClient batchClient, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        LOGGER.log(Level.INFO, "Starting batch transaction");
        return executionContext.startBatchTxn(action, batchClient, sender);
    }

    private Status executeCloseBatchTxn(CloseBatchTransactionAction action, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        try {
            LOGGER.log(Level.INFO, "Closing batch transaction");
            if (action.getCleanup()) {
                executionContext.closeBatchTxn();
            }
            return sender.finishWithOK();
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
    }

    private Status executeGenerateDbPartitionsRead(GenerateDbPartitionsForReadAction action, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        try {
            BatchReadOnlyTransaction batchTxn = executionContext.getBatchTxn();
            CloudExecutor.Metadata metadata = new CloudExecutor.Metadata(action.getTableList());
            executionContext.setMetadata(metadata);
            ReadAction request = action.getRead();
            ArrayList<com.google.spanner.v1.Type> typeList = new ArrayList<com.google.spanner.v1.Type>();
            for (int i = 0; i < request.getColumnCount(); ++i) {
                typeList.add(executionContext.getColumnType(request.getTable(), request.getColumn(i)));
            }
            KeySet keySet = CloudClientExecutor.keySetProtoToCloudKeySet(request.getKeys(), typeList);
            PartitionOptions.Builder partitionOptionsBuilder = PartitionOptions.newBuilder();
            if (action.hasDesiredBytesPerPartition() && action.getDesiredBytesPerPartition() > 0L) {
                partitionOptionsBuilder.setPartitionSizeBytes(action.getDesiredBytesPerPartition());
            }
            if (action.hasMaxPartitionCount()) {
                partitionOptionsBuilder.setMaxPartitions(action.getMaxPartitionCount());
            }
            List parts = request.hasIndex() ? batchTxn.partitionReadUsingIndex(partitionOptionsBuilder.build(), request.getTable(), request.getIndex(), keySet, new ArrayList(request.getColumnList()), new Options.ReadOption[0]) : batchTxn.partitionRead(partitionOptionsBuilder.build(), request.getTable(), keySet, new ArrayList(request.getColumnList()), new Options.ReadOption[0]);
            ArrayList<BatchPartition> batchPartitions = new ArrayList<BatchPartition>();
            for (Partition part : parts) {
                batchPartitions.add(BatchPartition.newBuilder().setPartition(this.marshall(part)).setPartitionToken(part.getPartitionToken()).setTable(request.getTable()).setIndex(request.getIndex()).build());
            }
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).addAllDbPartition(batchPartitions).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            LOGGER.log(Level.WARNING, String.format("GenerateDbPartitionsRead failed for %s", action));
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeGenerateDbPartitionsQuery(GenerateDbPartitionsForQueryAction action, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        try {
            BatchReadOnlyTransaction batchTxn = executionContext.getBatchTxn();
            Statement.Builder stmt = Statement.newBuilder((String)action.getQuery().getSql());
            for (int i = 0; i < action.getQuery().getParamsCount(); ++i) {
                stmt.bind(action.getQuery().getParams(i).getName()).to(CloudClientExecutor.valueProtoToCloudValue(action.getQuery().getParams(i).getType(), action.getQuery().getParams(i).getValue()));
            }
            PartitionOptions partitionOptions = PartitionOptions.newBuilder().setPartitionSizeBytes(action.getDesiredBytesPerPartition()).build();
            List parts = batchTxn.partitionQuery(partitionOptions, stmt.build(), new Options.QueryOption[0]);
            ArrayList<BatchPartition> batchPartitions = new ArrayList<BatchPartition>();
            for (Partition part : parts) {
                batchPartitions.add(BatchPartition.newBuilder().setPartition(this.marshall(part)).setPartitionToken(part.getPartitionToken()).build());
            }
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).addAllDbPartition(batchPartitions).build();
            return sender.sendOutcome(outcome);
        }
        catch (SpannerException e) {
            LOGGER.log(Level.WARNING, String.format("GenerateDbPartitionsQuery failed for %s", action));
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeExecutePartition(ExecutePartitionAction action, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        try {
            BatchReadOnlyTransaction batchTxn = executionContext.getBatchTxn();
            ByteString partitionBinary = action.getPartition().getPartition();
            if (partitionBinary.size() == 0) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Invalid batchPartition " + action));
            }
            if (action.getPartition().hasTable()) {
                sender.initForBatchRead(action.getPartition().getTable(), action.getPartition().getIndex());
            } else {
                sender.initForQuery();
            }
            Partition partition = (Partition)this.unmarshall(partitionBinary);
            executionContext.startRead();
            ResultSet result = batchTxn.execute(partition);
            return this.processResults(result, 0, sender, executionContext);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executePartitionedUpdate(PartitionedUpdateAction action, DatabaseClient dbClient, CloudExecutor.OutcomeSender sender) {
        try {
            PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = action.getOptions();
            Long count = dbClient.executePartitionedUpdate(Statement.of((String)action.getUpdate().getSql()), new Options.UpdateOption[]{Options.tag((String)options.getTag()), Options.priority((Options.RpcPriority)Options.RpcPriority.fromProto((RequestOptions.Priority)options.getRpcPriority()))});
            SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudClientExecutor.toProto(Status.OK)).addDmlRowsModified(count.longValue()).build();
            sender.sendOutcome(outcome);
            return sender.finishWithOK();
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private ChildPartitionsRecord buildChildPartitionRecord(Struct childPartitionRecord) throws Exception {
        ChildPartitionsRecord.Builder childPartitionRecordBuilder = ChildPartitionsRecord.newBuilder();
        childPartitionRecordBuilder.setStartTime(Timestamps.parse((String)childPartitionRecord.getTimestamp(0).toString()));
        childPartitionRecordBuilder.setRecordSequence(childPartitionRecord.getString(1));
        for (Struct childPartition : childPartitionRecord.getStructList(2)) {
            ChildPartitionsRecord.ChildPartition.Builder childPartitionBuilder = ChildPartitionsRecord.ChildPartition.newBuilder();
            childPartitionBuilder.setToken(childPartition.getString(0));
            childPartitionBuilder.addAllParentPartitionTokens((Iterable)childPartition.getStringList(1));
            childPartitionRecordBuilder.addChildPartitions(childPartitionBuilder.build());
        }
        return childPartitionRecordBuilder.build();
    }

    private DataChangeRecord buildDataChangeRecord(Struct dataChangeRecord) throws Exception {
        DataChangeRecord.Builder dataChangeRecordBuilder = DataChangeRecord.newBuilder();
        dataChangeRecordBuilder.setCommitTime(Timestamps.parse((String)dataChangeRecord.getTimestamp(0).toString()));
        dataChangeRecordBuilder.setRecordSequence(dataChangeRecord.getString(1));
        dataChangeRecordBuilder.setTransactionId(dataChangeRecord.getString(2));
        dataChangeRecordBuilder.setIsLastRecord(dataChangeRecord.getBoolean(3));
        dataChangeRecordBuilder.setTable(dataChangeRecord.getString(4));
        for (Struct columnType : dataChangeRecord.getStructList(5)) {
            DataChangeRecord.ColumnType.Builder columnTypeBuilder = DataChangeRecord.ColumnType.newBuilder();
            columnTypeBuilder.setName(columnType.getString(0));
            columnTypeBuilder.setType(this.getJsonStringForStructColumn(columnType, 1));
            columnTypeBuilder.setIsPrimaryKey(columnType.getBoolean(2));
            columnTypeBuilder.setOrdinalPosition(columnType.getLong(3));
            dataChangeRecordBuilder.addColumnTypes(columnTypeBuilder.build());
        }
        for (Struct mod : dataChangeRecord.getStructList(6)) {
            DataChangeRecord.Mod.Builder modBuilder = DataChangeRecord.Mod.newBuilder();
            modBuilder.setKeys(this.getJsonStringForStructColumn(mod, 0));
            modBuilder.setNewValues(this.getJsonStringForStructColumn(mod, 1));
            modBuilder.setOldValues(this.getJsonStringForStructColumn(mod, 2));
            dataChangeRecordBuilder.addMods(modBuilder.build());
        }
        dataChangeRecordBuilder.setModType(dataChangeRecord.getString(7));
        dataChangeRecordBuilder.setValueCaptureType(dataChangeRecord.getString(8));
        dataChangeRecordBuilder.setTransactionTag(dataChangeRecord.getString(11));
        dataChangeRecordBuilder.setIsSystemTransaction(dataChangeRecord.getBoolean(12));
        return dataChangeRecordBuilder.build();
    }

    private String getJsonStringForStructColumn(Struct struct, int columnIndex) {
        Type columnType = struct.getColumnType(columnIndex);
        switch (columnType.getCode()) {
            case JSON: {
                return struct.getJson(columnIndex);
            }
            case STRING: {
                return struct.getString(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format("Cannot extract value from column with index = %d and column type = %s for struct: %s", columnIndex, columnType, struct));
    }

    private HeartbeatRecord buildHeartbeatRecord(Struct heartbeatRecord) throws Exception {
        HeartbeatRecord.Builder heartbeatRecordBuilder = HeartbeatRecord.newBuilder();
        heartbeatRecordBuilder.setHeartbeatTime(Timestamps.parse((String)heartbeatRecord.getTimestamp(0).toString()));
        return heartbeatRecordBuilder.build();
    }

    private Status executeExecuteChangeStreamQuery(String dbPath, ExecuteChangeStreamQuery action, CloudExecutor.OutcomeSender sender) {
        try {
            LOGGER.log(Level.INFO, String.format("Start executing change change stream query: \n%s", action));
            String changeStreamName = action.getName();
            String startTime = CloudClientExecutor.timestampToString(!action.hasPartitionToken(), Timestamps.toMicros((com.google.protobuf.Timestamp)action.getStartTime()));
            String endTime = "null";
            if (action.hasEndTime()) {
                endTime = CloudClientExecutor.timestampToString(!action.hasPartitionToken(), Timestamps.toMicros((com.google.protobuf.Timestamp)action.getEndTime()));
            }
            String heartbeat = "null";
            if (action.hasHeartbeatMilliseconds()) {
                heartbeat = Integer.toString(action.getHeartbeatMilliseconds());
            }
            String partitionToken = "null";
            if (action.hasPartitionToken()) {
                partitionToken = String.format("\"%s\"", action.getPartitionToken());
            }
            String tvfQuery = String.format("SELECT * FROM READ_%s(%s,%s,%s,%s);", changeStreamName, startTime, endTime, partitionToken, heartbeat);
            LOGGER.log(Level.INFO, String.format("Start executing change stream TVF: \n%s", tvfQuery));
            sender.initForChangeStreamQuery(action.getHeartbeatMilliseconds(), action.getName(), action.getPartitionToken());
            Spanner spannerClient = action.hasDeadlineSeconds() ? this.getClientWithTimeout(action.getDeadlineSeconds()) : this.getClient();
            DatabaseClient dbClient = spannerClient.getDatabaseClient(DatabaseId.of((String)dbPath));
            ResultSet resultSet = dbClient.singleUse().executeQuery(Statement.of((String)tvfQuery), new Options.QueryOption[0]);
            ChangeStreamRecord.Builder changeStreamRecordBuilder = ChangeStreamRecord.newBuilder();
            while (resultSet.next()) {
                Status appendStatus;
                Struct record = (Struct)resultSet.getStructList(0).get(0);
                for (Struct dataChangeRecord : record.getStructList("data_change_record")) {
                    if (dataChangeRecord.isNull(0)) continue;
                    DataChangeRecord builtDataChangeRecord = this.buildDataChangeRecord(dataChangeRecord);
                    changeStreamRecordBuilder.setDataChange(builtDataChangeRecord);
                }
                for (Struct heartbeatRecord : record.getStructList("heartbeat_record")) {
                    if (heartbeatRecord.isNull(0)) continue;
                    HeartbeatRecord builtHeartbeatRecord = this.buildHeartbeatRecord(heartbeatRecord);
                    changeStreamRecordBuilder.setHeartbeat(builtHeartbeatRecord);
                }
                for (Struct childPartitionRecord : record.getStructList("child_partitions_record")) {
                    if (childPartitionRecord.isNull(0)) continue;
                    ChildPartitionsRecord builtChildPartitionsRecord = this.buildChildPartitionRecord(childPartitionRecord);
                    changeStreamRecordBuilder.setChildPartition(builtChildPartitionsRecord);
                }
                if (sender.getIsPartitionedChangeStreamQuery()) {
                    long lastReceivedTimestamp = sender.getChangeStreamRecordReceivedTimestamp();
                    long currentChangeRecordReceivedTimestamp = System.currentTimeMillis();
                    long discrepancyMillis = currentChangeRecordReceivedTimestamp - lastReceivedTimestamp;
                    if (lastReceivedTimestamp > 0L && discrepancyMillis > sender.getChangeStreamHeartbeatMilliSeconds() * 10L && sender.getChangeStreamHeartbeatMilliSeconds() > 5000L) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INTERNAL, (String)("Does not pass the heartbeat interval check. The last record was received seconds" + discrepancyMillis / 1000L + " ago, which is more than ten times the heartbeat interval, which is " + sender.getChangeStreamHeartbeatMilliSeconds() / 1000L + " seconds. The change record received is: " + changeStreamRecordBuilder.build()));
                    }
                    sender.updateChangeStreamRecordReceivedTimestamp(currentChangeRecordReceivedTimestamp);
                }
                if ((appendStatus = sender.appendChangeStreamRecord(changeStreamRecordBuilder.build())).isOk()) continue;
                return appendStatus;
            }
            return sender.finishWithOK();
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
            if (e instanceof DeadlineExceededException) {
                return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)("Deadline exceeded error: " + e))));
            }
            if (e instanceof UnavailableException) {
                return this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNAVAILABLE, (String)e.getMessage()));
            }
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e))));
        }
    }

    private Status executeStartTxn(StartTransactionAction action, DatabaseClient dbClient, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        try {
            executionContext.updateTransactionSeed(action.getTransactionSeed());
            CloudExecutor.Metadata metadata = new CloudExecutor.Metadata(action.getTableList());
            if (action.hasConcurrency()) {
                LOGGER.log(Level.INFO, String.format("Starting read-only transaction %s\n", executionContext.getTransactionSeed()));
                executionContext.startReadOnlyTxn(dbClient, this.timestampBoundsFromConcurrency(action.getConcurrency()), metadata);
            } else {
                LOGGER.log(Level.INFO, "Starting read-write transaction %s\n", executionContext.getTransactionSeed());
                executionContext.startReadWriteTxn(dbClient, metadata, action.getExecutionOptions());
            }
            executionContext.setDatabaseClient(dbClient);
            executionContext.initReadState();
            return sender.finishWithOK();
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
        catch (Exception e) {
            return sender.finishWithError(this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
        }
    }

    private Status executeFinishTxn(FinishTransactionAction action, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        LOGGER.log(Level.INFO, String.format("Finishing transaction %s\n%s", executionContext.getTransactionSeed(), action));
        return executionContext.finish(action.getMode(), sender);
    }

    private Status executeMutation(MutationAction action, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext, boolean isWrite) {
        String prevTable = "";
        try {
            for (int i = 0; i < action.getModCount(); ++i) {
                int j;
                MutationAction.InsertArgs insertArgs;
                MutationAction.Mod mod = action.getMod(i);
                String table = mod.getTable();
                if (table.isEmpty()) {
                    table = prevTable;
                }
                if (table.isEmpty()) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Table name missing: " + action));
                }
                prevTable = table;
                LOGGER.log(Level.FINE, String.format("Executing mutation mod: \n%s", mod));
                ArrayList mutations = Lists.newArrayList();
                if (mod.hasInsert()) {
                    insertArgs = mod.getInsert();
                    for (j = 0; j < insertArgs.getValuesCount(); ++j) {
                        mutations.add(this.buildWrite((List<String>)insertArgs.getColumnList(), CloudClientExecutor.cloudValuesFromValueList(insertArgs.getValues(j), insertArgs.getTypeList()), Mutation.newInsertBuilder((String)table)));
                    }
                } else if (mod.hasUpdate()) {
                    MutationAction.UpdateArgs updateArgs = mod.getUpdate();
                    for (j = 0; j < updateArgs.getValuesCount(); ++j) {
                        mutations.add(this.buildWrite((List<String>)updateArgs.getColumnList(), CloudClientExecutor.cloudValuesFromValueList(updateArgs.getValues(j), updateArgs.getTypeList()), Mutation.newUpdateBuilder((String)table)));
                    }
                } else if (mod.hasInsertOrUpdate()) {
                    insertArgs = mod.getInsertOrUpdate();
                    for (j = 0; j < insertArgs.getValuesCount(); ++j) {
                        mutations.add(this.buildWrite((List<String>)insertArgs.getColumnList(), CloudClientExecutor.cloudValuesFromValueList(insertArgs.getValues(j), insertArgs.getTypeList()), Mutation.newInsertOrUpdateBuilder((String)table)));
                    }
                } else if (mod.hasReplace()) {
                    insertArgs = mod.getReplace();
                    for (j = 0; j < insertArgs.getValuesCount(); ++j) {
                        mutations.add(this.buildWrite((List<String>)insertArgs.getColumnList(), CloudClientExecutor.cloudValuesFromValueList(insertArgs.getValues(j), insertArgs.getTypeList()), Mutation.newReplaceBuilder((String)table)));
                    }
                } else if (mod.hasDeleteKeys()) {
                    KeySet keySet = CloudClientExecutor.keySetProtoToCloudKeySet(mod.getDeleteKeys(), executionContext.getKeyColumnTypes(table));
                    mutations.add(Mutation.delete((String)table, (KeySet)keySet));
                } else {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported mod: " + mod));
                }
                if (!isWrite) {
                    executionContext.bufferMutations(mutations);
                    continue;
                }
                executionContext.getDbClient().write((Iterable)mutations);
            }
            return sender.finishWithOK();
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
    }

    private Mutation buildWrite(List<String> columnList, List<com.google.cloud.spanner.Value> valueList, Mutation.WriteBuilder write) {
        Preconditions.checkState((columnList.size() == valueList.size() ? 1 : 0) != 0);
        for (int i = 0; i < columnList.size(); ++i) {
            write.set(columnList.get(i)).to(valueList.get(i));
        }
        return write.build();
    }

    private Status executeRead(ReadAction action, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        try {
            LOGGER.log(Level.INFO, String.format("Executing read %s\n%s\n", executionContext.getTransactionSeed(), action));
            ArrayList<com.google.spanner.v1.Type> typeList = new ArrayList();
            if (action.hasIndex()) {
                for (int i = 0; i < action.getColumnCount(); ++i) {
                    String col = action.getColumn(i);
                    typeList.add(executionContext.getColumnType(action.getTable(), col));
                }
            } else {
                typeList = executionContext.getKeyColumnTypes(action.getTable());
            }
            KeySet keySet = CloudClientExecutor.keySetProtoToCloudKeySet(action.getKeys(), typeList);
            ReadContext txn = executionContext.getTransactionForRead();
            sender.initForRead(action.getTable(), action.getIndex());
            executionContext.startRead();
            LOGGER.log(Level.INFO, String.format("Finish read building, ready to execute %s\n", executionContext.getTransactionSeed()));
            ResultSet result = action.hasIndex() ? txn.readUsingIndex(action.getTable(), action.getIndex(), keySet, (Iterable)action.getColumnList(), new Options.ReadOption[0]) : txn.read(action.getTable(), keySet, (Iterable)action.getColumnList(), new Options.ReadOption[0]);
            LOGGER.log(Level.INFO, String.format("Parsing read result %s\n", executionContext.getTransactionSeed()));
            return this.processResults(result, action.getLimit(), sender, executionContext);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
    }

    private Status executeQuery(QueryAction action, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        try {
            LOGGER.log(Level.INFO, String.format("Executing query %s\n%s\n", executionContext.getTransactionSeed(), action));
            ReadContext txn = executionContext.getTransactionForRead();
            sender.initForQuery();
            Statement.Builder stmt = Statement.newBuilder((String)action.getSql());
            for (int i = 0; i < action.getParamsCount(); ++i) {
                stmt.bind(action.getParams(i).getName()).to(CloudClientExecutor.valueProtoToCloudValue(action.getParams(i).getType(), action.getParams(i).getValue()));
            }
            executionContext.startRead();
            LOGGER.log(Level.INFO, String.format("Finish query building, ready to execute %s\n", executionContext.getTransactionSeed()));
            ResultSet result = txn.executeQuery(stmt.build(), new Options.QueryOption[]{Options.tag((String)"query-tag")});
            LOGGER.log(Level.INFO, String.format("Parsing query result %s\n", executionContext.getTransactionSeed()));
            return this.processResults(result, 0, sender, executionContext);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
    }

    private Status executeCloudDmlUpdate(DmlAction action, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        try {
            LOGGER.log(Level.INFO, String.format("Executing Dml update %s\n%s\n", executionContext.getTransactionSeed(), action));
            QueryAction update = action.getUpdate();
            Statement.Builder stmt = Statement.newBuilder((String)update.getSql());
            for (int i = 0; i < update.getParamsCount(); ++i) {
                stmt.bind(update.getParams(i).getName()).to(CloudClientExecutor.valueProtoToCloudValue(update.getParams(i).getType(), update.getParams(i).getValue()));
            }
            sender.initForQuery();
            ResultSet result = executionContext.getTransactionForWrite().executeQuery(stmt.build(), new Options.QueryOption[]{Options.tag((String)"dml-transaction-tag")});
            LOGGER.log(Level.INFO, String.format("Parsing Dml result %s\n", executionContext.getTransactionSeed()));
            return this.processResults(result, 0, sender, executionContext, true);
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
    }

    private Status executeCloudBatchDmlUpdates(BatchDmlAction action, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        try {
            ArrayList<Statement> queries = new ArrayList<Statement>();
            for (int i = 0; i < action.getUpdatesCount(); ++i) {
                LOGGER.log(Level.INFO, String.format("Executing BatchDml update [%d] %s\n%s\n", i + 1, executionContext.getTransactionSeed(), action));
                QueryAction update = action.getUpdates(i);
                Statement.Builder stmt = Statement.newBuilder((String)update.getSql());
                for (int j = 0; j < update.getParamsCount(); ++j) {
                    stmt.bind(update.getParams(j).getName()).to(CloudClientExecutor.valueProtoToCloudValue(update.getParams(j).getType(), update.getParams(j).getValue()));
                }
                queries.add(stmt.build());
            }
            long[] rowCounts = executionContext.executeBatchDml(queries);
            sender.initForQuery();
            for (long rowCount : rowCounts) {
                sender.appendRowsModifiedInDml(rowCount);
            }
            if (rowCounts.length != queries.size()) {
                sender.appendRowsModifiedInDml(0L);
            }
            return sender.finishWithOK();
        }
        catch (SpannerException e) {
            return sender.finishWithError(this.toStatus(e));
        }
    }

    private Status processResults(ResultSet results, int limit, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext) {
        return this.processResults(results, limit, sender, executionContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status processResults(ResultSet results, int limit, CloudExecutor.OutcomeSender sender, ExecutionFlowContext executionContext, boolean isDml) {
        Status status;
        block12: {
            Status appendStatus;
            ValueList row;
            try {
                int rowCount = 0;
                LOGGER.log(Level.INFO, String.format("Iterating result set: %s\n", executionContext.getTransactionSeed()));
                while (results.next()) {
                    row = this.buildRow((StructReader)results.getCurrentRowAsStruct(), sender);
                    appendStatus = sender.appendRow(row);
                    if (!appendStatus.isOk()) {
                        status = appendStatus;
                        break block12;
                    }
                    if (limit <= 0 || ++rowCount < limit) continue;
                    LOGGER.log(Level.INFO, "Stopping at row limit: " + limit);
                    break;
                }
                if (isDml) {
                    sender.appendRowsModifiedInDml(Objects.requireNonNull(results.getStats()).getRowCountExact());
                }
                LOGGER.log(Level.INFO, String.format("Successfully processed result: %s\n", executionContext.getTransactionSeed()));
                executionContext.finishRead(Status.OK);
                row = sender.finishWithOK();
            }
            catch (SpannerException e) {
                Status status2;
                block13: {
                    try {
                        status2 = this.toStatus(e);
                        LOGGER.log(Level.WARNING, String.format("Encountered exception: %s %s\n", status2.getDescription(), executionContext.getTransactionSeed()));
                        executionContext.finishRead(status2);
                        if (status2.getCode() != Status.ABORTED.getCode()) break block13;
                        appendStatus = sender.finishWithTransactionRestarted();
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.INFO, String.format("Closing result set %s\n", executionContext.getTransactionSeed()));
                        results.close();
                        throw throwable;
                    }
                    LOGGER.log(Level.INFO, String.format("Closing result set %s\n", executionContext.getTransactionSeed()));
                    results.close();
                    return appendStatus;
                }
                if (status2.getCode() == Status.UNAUTHENTICATED.getCode()) {
                    try {
                        LOGGER.log(Level.INFO, String.format("Found Unauthenticated error, client credentials:\n%s", ((SpannerOptions)this.getClient().getOptions()).getCredentials().toString()));
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, String.format("Failed to getClient %s", exception));
                    }
                }
                Status status3 = sender.finishWithError(status2);
                LOGGER.log(Level.INFO, String.format("Closing result set %s\n", executionContext.getTransactionSeed()));
                results.close();
                return status3;
            }
            LOGGER.log(Level.INFO, String.format("Closing result set %s\n", executionContext.getTransactionSeed()));
            results.close();
            return row;
        }
        LOGGER.log(Level.INFO, String.format("Closing result set %s\n", executionContext.getTransactionSeed()));
        results.close();
        return status;
    }

    private ValueList buildRow(StructReader result, CloudExecutor.OutcomeSender sender) throws SpannerException {
        ValueList.Builder rowBuilder = ValueList.newBuilder();
        StructType.Builder rowTypeBuilder = StructType.newBuilder();
        for (int i = 0; i < result.getColumnCount(); ++i) {
            Type columnType = result.getColumnType(i);
            rowTypeBuilder.addFields(StructType.Field.newBuilder().setName(((Type.StructField)result.getType().getStructFields().get(i)).getName()).setType(CloudClientExecutor.cloudTypeToTypeProto(columnType)).build());
            Value.Builder value = Value.newBuilder();
            if (result.isNull(i)) {
                value.setIsNull(true);
            } else {
                block0 : switch (columnType.getCode()) {
                    case BOOL: {
                        value.setBoolValue(result.getBoolean(i));
                        break;
                    }
                    case FLOAT64: {
                        value.setDoubleValue(result.getDouble(i));
                        break;
                    }
                    case INT64: {
                        value.setIntValue(result.getLong(i));
                        break;
                    }
                    case STRING: {
                        value.setStringValue(result.getString(i));
                        break;
                    }
                    case BYTES: {
                        value.setBytesValue(CloudClientExecutor.toByteString(result.getBytes(i)));
                        break;
                    }
                    case TIMESTAMP: {
                        value.setTimestampValue(this.timestampToProto(result.getTimestamp(i)));
                        break;
                    }
                    case DATE: {
                        value.setDateDaysValue(CloudClientExecutor.daysFromDate(result.getDate(i)));
                        break;
                    }
                    case NUMERIC: {
                        String ascii = result.getBigDecimal(i).toPlainString();
                        value.setStringValue(ascii);
                        break;
                    }
                    case JSON: {
                        value.setStringValue(result.getJson(i));
                        break;
                    }
                    case ARRAY: {
                        switch (result.getColumnType(i).getArrayElementType().getCode()) {
                            case BOOL: {
                                Value.Builder valueProto;
                                ValueList.Builder builder = ValueList.newBuilder();
                                List values = result.getBooleanList(i);
                                for (Boolean booleanValue : values) {
                                    valueProto = Value.newBuilder();
                                    if (booleanValue == null) {
                                        builder.addValue(valueProto.setIsNull(true).build());
                                        continue;
                                    }
                                    builder.addValue(valueProto.setBoolValue(booleanValue.booleanValue()).build());
                                }
                                value.setArrayValue(builder.build());
                                value.setArrayType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.BOOL).build());
                                break block0;
                            }
                            case FLOAT64: {
                                Value.Builder valueProto;
                                ValueList.Builder builder = ValueList.newBuilder();
                                List values = result.getDoubleList(i);
                                for (Double doubleValue : values) {
                                    valueProto = Value.newBuilder();
                                    if (doubleValue == null) {
                                        builder.addValue(valueProto.setIsNull(true).build());
                                        continue;
                                    }
                                    builder.addValue(valueProto.setDoubleValue(doubleValue.doubleValue()).build());
                                }
                                value.setArrayValue(builder.build());
                                value.setArrayType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.FLOAT64).build());
                                break block0;
                            }
                            case INT64: {
                                Value.Builder valueProto;
                                ValueList.Builder builder = ValueList.newBuilder();
                                List values = result.getLongList(i);
                                for (Long longValue : values) {
                                    valueProto = Value.newBuilder();
                                    if (longValue == null) {
                                        builder.addValue(valueProto.setIsNull(true).build());
                                        continue;
                                    }
                                    builder.addValue(valueProto.setIntValue(longValue.longValue()).build());
                                }
                                value.setArrayValue(builder.build());
                                value.setArrayType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.INT64).build());
                                break block0;
                            }
                            case STRING: {
                                Value.Builder valueProto;
                                ValueList.Builder builder = ValueList.newBuilder();
                                List values = result.getStringList(i);
                                for (String stringValue : values) {
                                    valueProto = Value.newBuilder();
                                    if (stringValue == null) {
                                        builder.addValue(valueProto.setIsNull(true).build());
                                        continue;
                                    }
                                    builder.addValue(valueProto.setStringValue(stringValue)).build();
                                }
                                value.setArrayValue(builder.build());
                                value.setArrayType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.STRING).build());
                                break block0;
                            }
                            case BYTES: {
                                Value.Builder valueProto;
                                ValueList.Builder builder = ValueList.newBuilder();
                                List values = result.getBytesList(i);
                                for (ByteArray byteArrayValue : values) {
                                    valueProto = Value.newBuilder();
                                    if (byteArrayValue == null) {
                                        builder.addValue(valueProto.setIsNull(true).build());
                                        continue;
                                    }
                                    builder.addValue(valueProto.setBytesValue(ByteString.copyFrom((byte[])byteArrayValue.toByteArray())).build());
                                }
                                value.setArrayValue(builder.build());
                                value.setArrayType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.BYTES).build());
                                break block0;
                            }
                            case DATE: {
                                Value.Builder valueProto;
                                ValueList.Builder builder = ValueList.newBuilder();
                                List values = result.getDateList(i);
                                for (Date dateValue : values) {
                                    valueProto = Value.newBuilder();
                                    if (dateValue == null) {
                                        builder.addValue(valueProto.setIsNull(true).build());
                                        continue;
                                    }
                                    builder.addValue(valueProto.setDateDaysValue(CloudClientExecutor.daysFromDate(dateValue)).build());
                                }
                                value.setArrayValue(builder.build());
                                value.setArrayType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.DATE).build());
                                break block0;
                            }
                            case TIMESTAMP: {
                                Value.Builder valueProto;
                                ValueList.Builder builder = ValueList.newBuilder();
                                List values = result.getTimestampList(i);
                                for (Timestamp timestampValue : values) {
                                    valueProto = Value.newBuilder();
                                    if (timestampValue == null) {
                                        builder.addValue(valueProto.setIsNull(true).build());
                                        continue;
                                    }
                                    builder.addValue(valueProto.setTimestampValue(this.timestampToProto(timestampValue)).build());
                                }
                                value.setArrayValue(builder.build());
                                value.setArrayType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.TIMESTAMP).build());
                                break block0;
                            }
                            case NUMERIC: {
                                Value.Builder valueProto;
                                ValueList.Builder builder = ValueList.newBuilder();
                                List values = result.getBigDecimalList(i);
                                for (BigDecimal bigDec : values) {
                                    valueProto = Value.newBuilder();
                                    if (bigDec == null) {
                                        builder.addValue(valueProto.setIsNull(true).build());
                                        continue;
                                    }
                                    builder.addValue(valueProto.setStringValue(bigDec.toPlainString()).build());
                                }
                                value.setArrayValue(builder.build());
                                value.setArrayType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.NUMERIC).build());
                                break block0;
                            }
                            case JSON: {
                                Value.Builder valueProto;
                                ValueList.Builder builder = ValueList.newBuilder();
                                List values = result.getJsonList(i);
                                for (String stringValue : values) {
                                    valueProto = Value.newBuilder();
                                    if (stringValue == null) {
                                        builder.addValue(valueProto.setIsNull(true).build());
                                        continue;
                                    }
                                    builder.addValue(valueProto.setStringValue(stringValue)).build();
                                }
                                value.setArrayValue(builder.build());
                                value.setArrayType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.JSON).build());
                                break block0;
                            }
                        }
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported row array type: " + result.getColumnType(i) + " for result type " + result.getType().toString()));
                    }
                    default: {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported row type: " + result.getColumnType(i) + " for result type " + result.getType().toString()));
                    }
                }
            }
            rowBuilder.addValue(value.build());
        }
        sender.setRowType(rowTypeBuilder.build());
        return rowBuilder.build();
    }

    private static List<com.google.cloud.spanner.Value> cloudValuesFromValueList(ValueList valueList, List<com.google.spanner.v1.Type> typeList) throws SpannerException {
        LOGGER.log(Level.INFO, String.format("Converting valueList: %s\n", valueList));
        Preconditions.checkState((valueList.getValueCount() == typeList.size() ? 1 : 0) != 0);
        ArrayList<com.google.cloud.spanner.Value> cloudValues = new ArrayList<com.google.cloud.spanner.Value>();
        for (int i = 0; i < valueList.getValueCount(); ++i) {
            com.google.cloud.spanner.Value value = CloudClientExecutor.valueProtoToCloudValue(typeList.get(i), valueList.getValue(i));
            cloudValues.add(value);
        }
        return cloudValues;
    }

    private static KeySet keySetProtoToCloudKeySet(com.google.spanner.executor.v1.KeySet keySetProto, List<com.google.spanner.v1.Type> typeList) throws SpannerException {
        int i;
        if (keySetProto.getAll()) {
            return KeySet.all();
        }
        KeySet.Builder cloudKeySetBuilder = KeySet.newBuilder();
        for (i = 0; i < keySetProto.getPointCount(); ++i) {
            cloudKeySetBuilder.addKey(CloudClientExecutor.keyProtoToCloudKey(keySetProto.getPoint(i), typeList));
        }
        for (i = 0; i < keySetProto.getRangeCount(); ++i) {
            cloudKeySetBuilder.addRange(CloudClientExecutor.keyRangeProtoToCloudKeyRange(keySetProto.getRange(i), typeList));
        }
        return cloudKeySetBuilder.build();
    }

    private static KeyRange keyRangeProtoToCloudKeyRange(com.google.spanner.executor.v1.KeyRange keyRangeProto, List<com.google.spanner.v1.Type> typeList) throws SpannerException {
        Key start = CloudClientExecutor.keyProtoToCloudKey(keyRangeProto.getStart(), typeList);
        Key end = CloudClientExecutor.keyProtoToCloudKey(keyRangeProto.getLimit(), typeList);
        if (!keyRangeProto.hasType()) {
            return KeyRange.closedOpen((Key)start, (Key)end);
        }
        switch (keyRangeProto.getType()) {
            case CLOSED_CLOSED: {
                return KeyRange.closedClosed((Key)start, (Key)end);
            }
            case CLOSED_OPEN: {
                return KeyRange.closedOpen((Key)start, (Key)end);
            }
            case OPEN_CLOSED: {
                return KeyRange.openClosed((Key)start, (Key)end);
            }
            case OPEN_OPEN: {
                return KeyRange.openOpen((Key)start, (Key)end);
            }
        }
        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Unrecognized key range type");
    }

    private static Key keyProtoToCloudKey(ValueList keyProto, List<com.google.spanner.v1.Type> typeList) throws SpannerException {
        Key.Builder cloudKey = Key.newBuilder();
        if (typeList.size() < keyProto.getValueCount()) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("There's more key parts in " + keyProto + " than column types in " + typeList));
        }
        block7: for (int i = 0; i < keyProto.getValueCount(); ++i) {
            com.google.spanner.v1.Type type = typeList.get(i);
            Value part = keyProto.getValue(i);
            if (part.hasIsNull()) {
                switch (type.getCode()) {
                    case BOOL: 
                    case INT64: 
                    case STRING: 
                    case BYTES: 
                    case FLOAT64: 
                    case DATE: 
                    case TIMESTAMP: 
                    case NUMERIC: 
                    case JSON: {
                        cloudKey.appendObject(null);
                        continue block7;
                    }
                    default: {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported null key part type: " + type.getCode().name()));
                    }
                }
            }
            if (part.hasIntValue()) {
                cloudKey.append(part.getIntValue());
                continue;
            }
            if (part.hasBoolValue()) {
                cloudKey.append(Boolean.valueOf(part.getBoolValue()));
                continue;
            }
            if (part.hasDoubleValue()) {
                cloudKey.append(part.getDoubleValue());
                continue;
            }
            if (part.hasBytesValue()) {
                switch (type.getCode()) {
                    case STRING: {
                        cloudKey.append(part.getBytesValue().toStringUtf8());
                        continue block7;
                    }
                    case BYTES: {
                        cloudKey.append(CloudClientExecutor.toByteArray(part.getBytesValue()));
                        continue block7;
                    }
                    default: {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported key part type: " + type.getCode().name()));
                    }
                }
            }
            if (part.hasStringValue()) {
                if (type.getCode() == TypeCode.NUMERIC) {
                    String ascii = part.getStringValue();
                    cloudKey.append(new BigDecimal(ascii));
                    continue;
                }
                cloudKey.append(part.getStringValue());
                continue;
            }
            if (part.hasTimestampValue()) {
                cloudKey.append(Timestamp.parseTimestamp((String)Timestamps.toString((com.google.protobuf.Timestamp)part.getTimestampValue())));
                continue;
            }
            if (part.hasDateDaysValue()) {
                cloudKey.append(CloudClientExecutor.dateFromDays(part.getDateDaysValue()));
                continue;
            }
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported key part: " + part));
        }
        return cloudKey.build();
    }

    private static com.google.cloud.spanner.Value valueProtoToCloudValue(com.google.spanner.v1.Type type, Value value) {
        if (value.hasIsCommitTimestamp() && value.getIsCommitTimestamp()) {
            return com.google.cloud.spanner.Value.timestamp((Timestamp)com.google.cloud.spanner.Value.COMMIT_TIMESTAMP);
        }
        switch (type.getCode()) {
            case INT64: {
                return com.google.cloud.spanner.Value.int64(value.hasIsNull() ? null : Long.valueOf(value.getIntValue()));
            }
            case FLOAT64: {
                return com.google.cloud.spanner.Value.float64(value.hasIsNull() ? null : Double.valueOf(value.getDoubleValue()));
            }
            case STRING: {
                return com.google.cloud.spanner.Value.string((String)(value.hasIsNull() ? null : value.getStringValue()));
            }
            case BYTES: {
                return com.google.cloud.spanner.Value.bytes(value.hasIsNull() ? null : ByteArray.copyFrom((byte[])value.getBytesValue().toByteArray()));
            }
            case BOOL: {
                return com.google.cloud.spanner.Value.bool(value.hasIsNull() ? null : Boolean.valueOf(value.getBoolValue()));
            }
            case TIMESTAMP: {
                if (value.hasIsNull()) {
                    return com.google.cloud.spanner.Value.timestamp(null);
                }
                if (!value.hasBytesValue()) {
                    return com.google.cloud.spanner.Value.timestamp((Timestamp)Timestamp.parseTimestamp((String)Timestamps.toString((com.google.protobuf.Timestamp)value.getTimestampValue())));
                }
                return com.google.cloud.spanner.Value.timestamp((Timestamp)com.google.cloud.spanner.Value.COMMIT_TIMESTAMP);
            }
            case DATE: {
                return com.google.cloud.spanner.Value.date(value.hasIsNull() ? null : CloudClientExecutor.dateFromDays(value.getDateDaysValue()));
            }
            case NUMERIC: {
                if (value.hasIsNull()) {
                    return com.google.cloud.spanner.Value.numeric(null);
                }
                String ascii = value.getStringValue();
                return com.google.cloud.spanner.Value.numeric((BigDecimal)new BigDecimal(ascii));
            }
            case JSON: {
                return com.google.cloud.spanner.Value.json((String)(value.hasIsNull() ? null : value.getStringValue()));
            }
            case STRUCT: {
                return com.google.cloud.spanner.Value.struct((Type)CloudClientExecutor.typeProtoToCloudType(type), value.hasIsNull() ? null : CloudClientExecutor.structProtoToCloudStruct(type, value.getStructValue()));
            }
            case ARRAY: {
                switch (type.getArrayElementType().getCode()) {
                    case INT64: {
                        if (value.hasIsNull()) {
                            return com.google.cloud.spanner.Value.int64Array((Iterable)null);
                        }
                        return com.google.cloud.spanner.Value.int64Array(CloudClientExecutor.unmarshallValueList(value.getArrayValue().getValueList().stream().map(Value::getIsNull).collect(Collectors.toList()), value.getArrayValue().getValueList().stream().map(Value::getIntValue).collect(Collectors.toList())));
                    }
                    case FLOAT64: {
                        if (value.hasIsNull()) {
                            return com.google.cloud.spanner.Value.float64Array((Iterable)null);
                        }
                        return com.google.cloud.spanner.Value.float64Array(CloudClientExecutor.unmarshallValueList(value.getArrayValue().getValueList().stream().map(Value::getIsNull).collect(Collectors.toList()), value.getArrayValue().getValueList().stream().map(Value::getDoubleValue).collect(Collectors.toList())));
                    }
                    case STRING: {
                        if (value.hasIsNull()) {
                            return com.google.cloud.spanner.Value.stringArray(null);
                        }
                        return com.google.cloud.spanner.Value.stringArray(CloudClientExecutor.unmarshallValueList(value.getArrayValue().getValueList().stream().map(Value::getIsNull).collect(Collectors.toList()), value.getArrayValue().getValueList().stream().map(Value::getStringValue).collect(Collectors.toList())));
                    }
                    case BYTES: {
                        if (value.hasIsNull()) {
                            return com.google.cloud.spanner.Value.bytesArray(null);
                        }
                        return com.google.cloud.spanner.Value.bytesArray(CloudClientExecutor.unmarshallValueList(value.getArrayValue().getValueList().stream().map(Value::getIsNull).collect(Collectors.toList()), value.getArrayValue().getValueList().stream().map(Value::getBytesValue).collect(Collectors.toList()), element -> ByteArray.copyFrom((byte[])element.toByteArray())));
                    }
                    case BOOL: {
                        if (value.hasIsNull()) {
                            return com.google.cloud.spanner.Value.boolArray((Iterable)null);
                        }
                        return com.google.cloud.spanner.Value.boolArray(CloudClientExecutor.unmarshallValueList(value.getArrayValue().getValueList().stream().map(Value::getIsNull).collect(Collectors.toList()), value.getArrayValue().getValueList().stream().map(Value::getBoolValue).collect(Collectors.toList())));
                    }
                    case TIMESTAMP: {
                        if (value.hasIsNull()) {
                            return com.google.cloud.spanner.Value.timestampArray(null);
                        }
                        return com.google.cloud.spanner.Value.timestampArray(CloudClientExecutor.unmarshallValueList(value.getArrayValue().getValueList().stream().map(Value::getIsNull).collect(Collectors.toList()), value.getArrayValue().getValueList().stream().map(Value::getTimestampValue).collect(Collectors.toList()), element -> Timestamp.parseTimestamp((String)Timestamps.toString((com.google.protobuf.Timestamp)element))));
                    }
                    case DATE: {
                        if (value.hasIsNull()) {
                            return com.google.cloud.spanner.Value.dateArray(null);
                        }
                        return com.google.cloud.spanner.Value.dateArray(CloudClientExecutor.unmarshallValueList(value.getArrayValue().getValueList().stream().map(Value::getIsNull).collect(Collectors.toList()), value.getArrayValue().getValueList().stream().map(Value::getDateDaysValue).collect(Collectors.toList()), CloudClientExecutor::dateFromDays));
                    }
                    case NUMERIC: {
                        if (value.hasIsNull()) {
                            return com.google.cloud.spanner.Value.numericArray(null);
                        }
                        List nullList = value.getArrayValue().getValueList().stream().map(Value::getIsNull).collect(Collectors.toList());
                        List valueList = value.getArrayValue().getValueList().stream().map(Value::getStringValue).collect(Collectors.toList());
                        ArrayList<BigDecimal> newValueList = new ArrayList<BigDecimal>(valueList.size());
                        for (int i = 0; i < valueList.size(); ++i) {
                            if (i < nullList.size() && ((Boolean)nullList.get(i)).booleanValue()) {
                                newValueList.add(null);
                                continue;
                            }
                            String ascii = (String)valueList.get(i);
                            newValueList.add(new BigDecimal(ascii));
                        }
                        return com.google.cloud.spanner.Value.numericArray(newValueList);
                    }
                    case STRUCT: {
                        Type elementType = CloudClientExecutor.typeProtoToCloudType(type.getArrayElementType());
                        if (value.hasIsNull()) {
                            return com.google.cloud.spanner.Value.structArray((Type)elementType, null);
                        }
                        return com.google.cloud.spanner.Value.structArray((Type)elementType, CloudClientExecutor.unmarshallValueList(value.getArrayValue().getValueList().stream().map(Value::getIsNull).collect(Collectors.toList()), value.getArrayValue().getValueList().stream().map(Value::getStructValue).collect(Collectors.toList()), element -> CloudClientExecutor.structProtoToCloudStruct(type.getArrayElementType(), element)));
                    }
                    case JSON: {
                        if (value.hasIsNull()) {
                            return com.google.cloud.spanner.Value.jsonArray(null);
                        }
                        return com.google.cloud.spanner.Value.jsonArray(CloudClientExecutor.unmarshallValueList(value.getArrayValue().getValueList().stream().map(Value::getIsNull).collect(Collectors.toList()), value.getArrayValue().getValueList().stream().map(Value::getStringValue).collect(Collectors.toList())));
                    }
                }
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported array element type while converting from value proto: " + type.getArrayElementType().getCode().name()));
            }
        }
        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported type while converting from value proto: " + type));
    }

    private com.google.protobuf.Timestamp timestampToProto(Timestamp t) throws SpannerException {
        try {
            return Timestamps.parse((String)t.toString());
        }
        catch (ParseException e) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Timestamp parse error", (Throwable)e);
        }
    }

    private static int daysFromDate(Date date) {
        return (int)LocalDate.of((int)date.getYear(), (int)date.getMonth(), (int)date.getDayOfMonth()).toEpochDay();
    }

    private static Date dateFromDays(int daysSinceEpoch) {
        LocalDate localDate = LocalDate.ofEpochDay((long)daysSinceEpoch);
        return Date.fromYearMonthDay((int)localDate.getYear(), (int)localDate.getMonthValue(), (int)localDate.getDayOfMonth());
    }

    @Nullable
    private static ByteString toByteString(@Nullable ByteArray byteArray) {
        if (byteArray == null) {
            return null;
        }
        return ByteString.copyFrom((byte[])byteArray.toByteArray());
    }

    @Nullable
    private static ByteArray toByteArray(@Nullable ByteString byteString) {
        if (byteString == null) {
            return null;
        }
        return ByteArray.copyFrom((byte[])byteString.toByteArray());
    }

    private static <S, T> List<T> unmarshallValueList(List<Boolean> isNullList, List<S> valueList, Function<S, T> converter) {
        ArrayList<Object> newValueList = new ArrayList<Object>(valueList.size());
        if (isNullList.isEmpty()) {
            for (S value : valueList) {
                newValueList.add(converter.apply(value));
            }
        } else {
            for (int i = 0; i < valueList.size(); ++i) {
                newValueList.add(isNullList.get(i) != false ? null : converter.apply(valueList.get(i)));
            }
        }
        return newValueList;
    }

    private static <S> List<S> unmarshallValueList(List<Boolean> isNullList, List<S> valueList) {
        return CloudClientExecutor.unmarshallValueList(isNullList, valueList, element -> element);
    }

    private static Struct structProtoToCloudStruct(com.google.spanner.v1.Type type, ValueList structValue) {
        List fieldValues = structValue.getValueList();
        List fieldTypes = type.getStructType().getFieldsList();
        if (fieldTypes.size() != fieldValues.size()) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Mismatch between number of expected fields and specified values for struct type");
        }
        Struct.Builder builder = Struct.newBuilder();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            builder.set(((StructType.Field)fieldTypes.get(i)).getName()).to(CloudClientExecutor.valueProtoToCloudValue(((StructType.Field)fieldTypes.get(i)).getType(), (Value)fieldValues.get(i)));
        }
        return builder.build();
    }

    private static Type typeProtoToCloudType(com.google.spanner.v1.Type typeProto) {
        switch (typeProto.getCode()) {
            case BOOL: {
                return Type.bool();
            }
            case INT64: {
                return Type.int64();
            }
            case STRING: {
                return Type.string();
            }
            case BYTES: {
                return Type.bytes();
            }
            case FLOAT64: {
                return Type.float64();
            }
            case DATE: {
                return Type.date();
            }
            case TIMESTAMP: {
                return Type.timestamp();
            }
            case NUMERIC: {
                if (typeProto.getTypeAnnotation().equals((Object)TypeAnnotationCode.PG_NUMERIC)) {
                    return Type.pgNumeric();
                }
                return Type.numeric();
            }
            case STRUCT: {
                List fields = typeProto.getStructType().getFieldsList();
                ArrayList<Type.StructField> cloudFields = new ArrayList<Type.StructField>();
                for (StructType.Field field : fields) {
                    Type fieldType = CloudClientExecutor.typeProtoToCloudType(field.getType());
                    cloudFields.add(Type.StructField.of((String)field.getName(), (Type)fieldType));
                }
                return Type.struct(cloudFields);
            }
            case ARRAY: {
                com.google.spanner.v1.Type elementType = typeProto.getArrayElementType();
                if (elementType.getCode() == TypeCode.ARRAY) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Unsupported array-of-array proto type");
                }
                Type cloudElementType = CloudClientExecutor.typeProtoToCloudType(elementType);
                return Type.array((Type)cloudElementType);
            }
            case JSON: {
                if (typeProto.getTypeAnnotation().equals((Object)TypeAnnotationCode.PG_JSONB)) {
                    return Type.pgJsonb();
                }
                return Type.json();
            }
        }
        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported proto type: " + typeProto));
    }

    private static com.google.spanner.v1.Type cloudTypeToTypeProto(@Nonnull Type cloudTypeProto) {
        switch (cloudTypeProto.getCode()) {
            case BOOL: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.BOOL).build();
            }
            case INT64: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.INT64).build();
            }
            case FLOAT64: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.FLOAT64).build();
            }
            case STRING: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.STRING).build();
            }
            case BYTES: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.BYTES).build();
            }
            case TIMESTAMP: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.TIMESTAMP).build();
            }
            case DATE: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.DATE).build();
            }
            case NUMERIC: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.NUMERIC).build();
            }
            case PG_NUMERIC: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.NUMERIC).setTypeAnnotation(TypeAnnotationCode.PG_NUMERIC).build();
            }
            case STRUCT: {
                StructType.Builder StructDescriptorBuilder = StructType.newBuilder();
                for (Type.StructField cloudField : cloudTypeProto.getStructFields()) {
                    StructDescriptorBuilder.addFields(StructType.Field.newBuilder().setName(cloudField.getName()).setType(CloudClientExecutor.cloudTypeToTypeProto(cloudField.getType())));
                }
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.STRUCT).setStructType(StructDescriptorBuilder.build()).build();
            }
            case ARRAY: {
                if (cloudTypeProto.getArrayElementType().getCode() == Type.Code.ARRAY) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Unsupported array-of-array cloud type");
                }
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(CloudClientExecutor.cloudTypeToTypeProto(cloudTypeProto.getArrayElementType())).build();
            }
            case JSON: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.JSON).build();
            }
            case PG_JSONB: {
                return com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.JSON).setTypeAnnotation(TypeAnnotationCode.PG_JSONB).build();
            }
        }
        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported cloud type: " + cloudTypeProto));
    }

    private <T extends Serializable> T unmarshall(ByteString input) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(input.newInput());
        return (T)((Serializable)objectInputStream.readObject());
    }

    private <T extends Serializable> ByteString marshall(T object) throws IOException {
        ByteString.Output output = ByteString.newOutput();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)output);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
        return output.toByteString();
    }

    private Timestamp timestampFromMicros(long micros) {
        long seconds = TimeUnit.MICROSECONDS.toSeconds(micros);
        int nanos = (int)(micros * 1000L - seconds * 1000000000L);
        return Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)nanos);
    }

    private TimestampBound timestampBoundsFromConcurrency(Concurrency concurrency) {
        if (concurrency.hasStalenessSeconds()) {
            return TimestampBound.ofExactStaleness((long)((long)(concurrency.getStalenessSeconds() * 1000000.0)), (TimeUnit)TimeUnit.MICROSECONDS);
        }
        if (concurrency.hasMinReadTimestampMicros()) {
            return TimestampBound.ofMinReadTimestamp((Timestamp)this.timestampFromMicros(concurrency.getMinReadTimestampMicros()));
        }
        if (concurrency.hasMaxStalenessSeconds()) {
            return TimestampBound.ofMaxStaleness((long)((long)(concurrency.getMaxStalenessSeconds() * 1000000.0)), (TimeUnit)TimeUnit.MICROSECONDS);
        }
        if (concurrency.hasExactTimestampMicros()) {
            return TimestampBound.ofReadTimestamp((Timestamp)this.timestampFromMicros(concurrency.getExactTimestampMicros()));
        }
        if (concurrency.hasStrong()) {
            return TimestampBound.strong();
        }
        if (concurrency.hasBatch()) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("batch mode should not be in snapshot transaction: " + concurrency));
        }
        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported concurrency mode: " + concurrency));
    }

    private Instance instanceToProto(com.google.cloud.spanner.Instance instance) {
        Instance.State state;
        Instance.Builder instanceBuilder = Instance.newBuilder();
        instanceBuilder.setConfig(instance.getInstanceConfigId().getInstanceConfig()).setName(instance.getId().getName()).setDisplayName(instance.getDisplayName()).setCreateTime(instance.getCreateTime().toProto()).setNodeCount(instance.getNodeCount()).setProcessingUnits(instance.getProcessingUnits()).setUpdateTime(instance.getUpdateTime().toProto()).putAllLabels(instance.getLabels());
        switch (instance.getState()) {
            case UNSPECIFIED: {
                state = Instance.State.STATE_UNSPECIFIED;
                break;
            }
            case CREATING: {
                state = Instance.State.CREATING;
                break;
            }
            case READY: {
                state = Instance.State.READY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state:" + instance.getState());
            }
        }
        instanceBuilder.setState(state);
        return instanceBuilder.build();
    }

    private InstanceConfig instanceConfigToProto(com.google.cloud.spanner.InstanceConfig instanceConfig) {
        InstanceConfig.Type type;
        InstanceConfig.State state;
        InstanceConfig.Builder instanceConfigBuilder = InstanceConfig.newBuilder();
        instanceConfigBuilder.setDisplayName(instanceConfig.getDisplayName()).setEtag(instanceConfig.getEtag()).setName(instanceConfig.getId().getName()).addAllLeaderOptions((Iterable)instanceConfig.getLeaderOptions()).addAllOptionalReplicas((Iterable)instanceConfig.getOptionalReplicas().stream().map(ReplicaInfo::getProto).collect(Collectors.toList())).addAllReplicas((Iterable)instanceConfig.getReplicas().stream().map(ReplicaInfo::getProto).collect(Collectors.toList())).putAllLabels(instanceConfig.getLabels()).setReconciling(instanceConfig.getReconciling());
        switch (instanceConfig.getState()) {
            case STATE_UNSPECIFIED: {
                state = InstanceConfig.State.STATE_UNSPECIFIED;
                break;
            }
            case CREATING: {
                state = InstanceConfig.State.CREATING;
                break;
            }
            case READY: {
                state = InstanceConfig.State.READY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state:" + instanceConfig.getState());
            }
        }
        instanceConfigBuilder.setState(state);
        switch (instanceConfig.getConfigType()) {
            case TYPE_UNSPECIFIED: {
                type = InstanceConfig.Type.TYPE_UNSPECIFIED;
                break;
            }
            case GOOGLE_MANAGED: {
                type = InstanceConfig.Type.GOOGLE_MANAGED;
                break;
            }
            case USER_MANAGED: {
                type = InstanceConfig.Type.USER_MANAGED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type:" + instanceConfig.getConfigType());
            }
        }
        instanceConfigBuilder.setConfigType(type);
        if (instanceConfig.getBaseConfig() != null) {
            instanceConfigBuilder.setBaseConfig(instanceConfig.getBaseConfig().getId().getName());
        }
        return instanceConfigBuilder.build();
    }

    class ExecutionFlowContext {
        private String prevDbPath;
        private ReadWriteTransaction rwTxn;
        private ReadOnlyTransaction roTxn;
        private BatchReadOnlyTransaction batchTxn;
        private DatabaseClient dbClient;
        private CloudExecutor.Metadata metadata;
        private int numPendingReads;
        private boolean readAborted;
        private String transactionSeed;
        StreamObserver<SpannerAsyncActionResponse> responseObserver;

        public ExecutionFlowContext(StreamObserver<SpannerAsyncActionResponse> responseObserver) {
            this.responseObserver = responseObserver;
        }

        public synchronized void onNext(SpannerAsyncActionResponse response) {
            this.responseObserver.onNext((Object)response);
        }

        public synchronized void onError(Throwable t) {
            this.responseObserver.onError(t);
        }

        public synchronized ReadContext getTransactionForRead() throws SpannerException {
            if (this.roTxn != null) {
                return this.roTxn;
            }
            if (this.rwTxn != null) {
                return this.rwTxn.getContext();
            }
            if (this.batchTxn != null) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Can't execute regular read in a batch transaction");
            }
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"No active transaction");
        }

        public synchronized TransactionContext getTransactionForWrite() throws SpannerException {
            if (this.rwTxn == null) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Not in a read-write transaction");
            }
            return this.rwTxn.getContext();
        }

        public synchronized BatchReadOnlyTransaction getBatchTxn() throws SpannerException {
            if (this.batchTxn == null) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Not in a batch transaction");
            }
            return this.batchTxn;
        }

        public synchronized void updateTransactionSeed(String transactionSeed) {
            if (!transactionSeed.isEmpty()) {
                this.transactionSeed = transactionSeed;
            }
        }

        public synchronized String getTransactionSeed() {
            return this.transactionSeed;
        }

        public DatabaseClient getDbClient() {
            return this.dbClient;
        }

        public synchronized void clear() {
            this.rwTxn = null;
            this.roTxn = null;
            this.metadata = null;
        }

        public synchronized void cleanup() {
            if (this.roTxn != null) {
                LOGGER.log(Level.INFO, "A read only transaction was active when stubby call closed");
                this.roTxn.close();
            }
            if (this.rwTxn != null) {
                LOGGER.log(Level.INFO, "A read write transaction was active when stubby call closed");
                try {
                    this.rwTxn.finish(FinishTransactionAction.Mode.ABANDON);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to abandon a read-write transaction: " + e.getMessage());
                }
            }
        }

        public synchronized String getDatabasePath(String dbPath) {
            if (dbPath == null || dbPath.isEmpty()) {
                return this.prevDbPath;
            }
            this.prevDbPath = dbPath;
            return dbPath;
        }

        public synchronized void setMetadata(CloudExecutor.Metadata metadata) {
            this.metadata = metadata;
        }

        public synchronized void startReadOnlyTxn(DatabaseClient dbClient, TimestampBound timestampBound, CloudExecutor.Metadata metadata) {
            if (this.rwTxn != null || this.roTxn != null || this.batchTxn != null) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Already in a transaction");
            }
            this.metadata = metadata;
            this.roTxn = timestampBound.getMode() == TimestampBound.Mode.MIN_READ_TIMESTAMP || timestampBound.getMode() == TimestampBound.Mode.MAX_STALENESS ? dbClient.singleUseReadOnlyTransaction(timestampBound) : dbClient.readOnlyTransaction(timestampBound);
        }

        public synchronized void startReadWriteTxn(DatabaseClient dbClient, CloudExecutor.Metadata metadata, TransactionExecutionOptions options) throws Exception {
            if (this.rwTxn != null || this.roTxn != null || this.batchTxn != null) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Already in a transaction");
            }
            LOGGER.log(Level.INFO, String.format("There's no active transaction, safe to create rwTxn: %s\n", this.getTransactionSeed()));
            this.metadata = metadata;
            this.rwTxn = new ReadWriteTransaction(dbClient, this.transactionSeed, options.getOptimistic());
            LOGGER.log(Level.INFO, String.format("Read-write transaction object created, try to start: %s\n", this.getTransactionSeed()));
            this.rwTxn.startRWTransaction();
        }

        public synchronized Status startBatchTxn(StartBatchTransactionAction action, BatchClient batchClient, CloudExecutor.OutcomeSender sender) {
            try {
                if (this.rwTxn != null || this.roTxn != null || this.batchTxn != null) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Already in a transaction");
                }
                if (action.hasBatchTxnTime()) {
                    TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)Timestamp.fromProto((com.google.protobuf.Timestamp)action.getBatchTxnTime()));
                    this.batchTxn = batchClient.batchReadOnlyTransaction(timestampBound);
                } else if (action.hasTid()) {
                    BatchTransactionId tId = (BatchTransactionId)CloudClientExecutor.this.unmarshall(action.getTid());
                    this.batchTxn = batchClient.batchReadOnlyTransaction(tId);
                } else {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Either timestamp or tid must be set");
                }
                SpannerActionOutcome outcome = SpannerActionOutcome.newBuilder().setStatus(CloudExecutor.toProto(Status.OK)).setBatchTxnId(CloudClientExecutor.this.marshall((Serializable)this.batchTxn.getBatchTransactionId())).build();
                this.initReadState();
                return sender.sendOutcome(outcome);
            }
            catch (SpannerException e) {
                return sender.finishWithError(CloudClientExecutor.this.toStatus(e));
            }
            catch (Exception e) {
                return sender.finishWithError(CloudClientExecutor.this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
            }
        }

        public synchronized void startRead() {
            ++this.numPendingReads;
        }

        public synchronized void finishRead(Status status) {
            if (status.getCode() == Status.ABORTED.getCode()) {
                this.readAborted = true;
            }
            --this.numPendingReads;
            if (this.readAborted && this.numPendingReads <= 0) {
                LOGGER.log(Level.FINE, "Transaction reset due to read/query abort");
                this.readAborted = false;
            }
        }

        public synchronized void initReadState() {
            this.readAborted = false;
            this.numPendingReads = 0;
        }

        public void setDatabaseClient(DatabaseClient client) {
            this.dbClient = client;
        }

        public List<com.google.spanner.v1.Type> getKeyColumnTypes(String tableName) throws SpannerException {
            Preconditions.checkNotNull((Object)this.metadata);
            return this.metadata.getKeyColumnTypes(tableName);
        }

        public com.google.spanner.v1.Type getColumnType(String tableName, String columnName) throws SpannerException {
            Preconditions.checkNotNull((Object)this.metadata);
            return this.metadata.getColumnType(tableName, columnName);
        }

        public synchronized void bufferMutations(List<Mutation> mutations) throws SpannerException {
            this.getTransactionForWrite().buffer(mutations);
        }

        public synchronized long[] executeBatchDml(@Nonnull List<Statement> stmts) throws SpannerException {
            for (int i = 0; i < stmts.size(); ++i) {
                LOGGER.log(Level.INFO, String.format("executeBatchDml [%d]: %s", i + 1, stmts.get(i).toString()));
            }
            return this.getTransactionForWrite().batchUpdate(stmts, new Options.UpdateOption[]{Options.tag((String)"batch-update-transaction-tag")});
        }

        public synchronized Status finish(FinishTransactionAction.Mode finishMode, CloudExecutor.OutcomeSender sender) {
            if (this.numPendingReads > 0) {
                return sender.finishWithError(CloudClientExecutor.this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.FAILED_PRECONDITION, (String)"Reads pending when trying to finish")));
            }
            SpannerActionOutcome.Builder outcomeBuilder = SpannerActionOutcome.newBuilder();
            outcomeBuilder.setStatus(CloudExecutor.toProto(Status.OK));
            if (this.roTxn != null || this.rwTxn != null) {
                try {
                    if (this.roTxn != null) {
                        Timestamp ts = this.roTxn.getReadTimestamp();
                        outcomeBuilder.setCommitTime(ts.toProto());
                        this.roTxn.close();
                        this.clear();
                    } else if (!this.rwTxn.finish(finishMode)) {
                        LOGGER.log(Level.FINE, "Transaction restarted");
                        outcomeBuilder.setTransactionRestarted(true);
                    } else {
                        LOGGER.log(Level.FINE, "Transaction finish successfully");
                        if (this.rwTxn.getTimestamp() != null) {
                            outcomeBuilder.setCommitTime(this.rwTxn.getTimestamp());
                        }
                        this.clear();
                    }
                }
                catch (SpannerException e) {
                    outcomeBuilder.setStatus(CloudExecutor.toProto(CloudClientExecutor.this.toStatus(e)));
                    this.clear();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Unexpected error: " + e.getMessage());
                    return sender.finishWithError(CloudClientExecutor.this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error: " + e.getMessage()))));
                }
                return sender.sendOutcome(outcomeBuilder.build());
            }
            if (this.batchTxn != null) {
                return CloudClientExecutor.this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Can't commit/abort a batch transaction"));
            }
            return CloudClientExecutor.this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"No currently active transaction"));
        }

        public synchronized void closeBatchTxn() throws SpannerException {
            if (this.batchTxn == null) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Not in a batch transaction");
            }
            this.batchTxn.close();
        }
    }

    private static class ReadWriteTransaction {
        private final DatabaseClient dbClient;
        private TransactionRunner runner;
        private TransactionContext txnContext;
        private com.google.protobuf.Timestamp timestamp;
        private FinishTransactionAction.Mode finishMode;
        private SpannerException error;
        private final String transactionSeed;
        private final boolean optimistic;
        private boolean runnerCompleted;

        public ReadWriteTransaction(DatabaseClient dbClient, String transactionSeed, boolean optimistic) {
            this.dbClient = dbClient;
            this.transactionSeed = transactionSeed;
            this.optimistic = optimistic;
            this.runnerCompleted = false;
        }

        private synchronized void setContext(TransactionContext transaction) {
            this.finishMode = null;
            this.txnContext = transaction;
            Preconditions.checkNotNull((Object)this.txnContext);
            LOGGER.log(Level.INFO, "Transaction callable created, setting context %s\n", this.transactionSeed);
            this.notifyAll();
        }

        private synchronized FinishTransactionAction.Mode waitForFinishAction() throws Exception {
            while (this.finishMode == null) {
                this.wait();
            }
            return this.finishMode;
        }

        private synchronized void waitForTransactionContext() throws Exception {
            while (this.txnContext == null && this.error == null) {
                this.wait();
            }
            if (this.error != null) {
                throw this.error;
            }
        }

        private synchronized void transactionSucceeded(com.google.protobuf.Timestamp timestamp) {
            this.timestamp = timestamp;
            this.runnerCompleted = true;
            this.notifyAll();
        }

        private synchronized void transactionFailed(SpannerException e) {
            if (e.getErrorCode() == ErrorCode.UNKNOWN && e.getMessage().contains(CloudClientExecutor.TRANSACTION_ABANDONED)) {
                LOGGER.log(Level.INFO, "Transaction abandoned");
            } else {
                this.error = e;
            }
            this.runnerCompleted = true;
            this.notifyAll();
        }

        public synchronized com.google.protobuf.Timestamp getTimestamp() {
            return this.timestamp;
        }

        public synchronized TransactionContext getContext() {
            Preconditions.checkState((this.txnContext != null ? 1 : 0) != 0);
            return this.txnContext;
        }

        public void startRWTransaction() throws Exception {
            TransactionRunner.TransactionCallable callable = transaction -> {
                this.setContext(transaction);
                LOGGER.log(Level.INFO, String.format("Transaction context set, executing and waiting for finish %s\n", this.transactionSeed));
                FinishTransactionAction.Mode mode = this.waitForFinishAction();
                if (mode == FinishTransactionAction.Mode.ABANDON) {
                    throw new Exception(CloudClientExecutor.TRANSACTION_ABANDONED);
                }
                return null;
            };
            Runnable runnable = () -> {
                try {
                    this.runner = this.optimistic ? this.dbClient.readWriteTransaction(new Options.TransactionOption[]{Options.optimisticLock()}) : this.dbClient.readWriteTransaction(new Options.TransactionOption[0]);
                    LOGGER.log(Level.INFO, String.format("Ready to run callable %s\n", this.transactionSeed));
                    this.runner.run(callable);
                    this.transactionSucceeded(this.runner.getCommitTimestamp().toProto());
                }
                catch (SpannerException e) {
                    LOGGER.log(Level.WARNING, String.format("Transaction runnable failed with exception %s\n", e.getMessage()), e);
                    this.transactionFailed(e);
                }
            };
            LOGGER.log(Level.INFO, String.format("Callable and Runnable created, ready to execute %s\n", this.transactionSeed));
            txnThreadPool.execute(runnable);
            this.waitForTransactionContext();
            LOGGER.log(Level.INFO, String.format("Transaction successfully created and running %s\n", this.transactionSeed));
        }

        public synchronized boolean finish(FinishTransactionAction.Mode finishMode) throws Exception {
            switch (finishMode) {
                case COMMIT: 
                case ABANDON: {
                    this.finishMode = finishMode;
                    Preconditions.checkNotNull((Object)finishMode);
                    this.txnContext = null;
                    LOGGER.log(Level.INFO, String.format("TxnContext cleared, sending finishMode to finish transaction %s\n", this.transactionSeed));
                    this.notifyAll();
                    while (this.txnContext == null && !this.runnerCompleted) {
                        this.wait();
                    }
                    LOGGER.log(Level.INFO, String.format("Transaction finished, getting back to caller %s\n", this.transactionSeed));
                    if (this.txnContext != null) {
                        return false;
                    }
                    if (this.error != null) {
                        if (this.error.getErrorCode() == ErrorCode.UNKNOWN && this.error.getMessage().contains("Transaction outcome unknown")) {
                            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)"Transaction outcome unknown.");
                        }
                        throw this.error;
                    }
                    return true;
                }
            }
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unsupported finish mode: " + finishMode));
        }
    }
}

