/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.executor.spanner;

import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.http.HttpTransportFactory;
import com.google.cloud.executor.spanner.CloudClientExecutor;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.base.Preconditions;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.google.rpc.Status;
import com.google.spanner.executor.v1.ChangeStreamRecord;
import com.google.spanner.executor.v1.ChildPartitionsRecord;
import com.google.spanner.executor.v1.ColumnMetadata;
import com.google.spanner.executor.v1.QueryResult;
import com.google.spanner.executor.v1.ReadResult;
import com.google.spanner.executor.v1.SpannerActionOutcome;
import com.google.spanner.executor.v1.SpannerAsyncActionResponse;
import com.google.spanner.executor.v1.TableMetadata;
import com.google.spanner.executor.v1.ValueList;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class CloudExecutor {
    private static final Logger LOGGER = Logger.getLogger(CloudExecutor.class.getName());
    protected static final Pattern DB_NAME = Pattern.compile("projects/([A-Za-z0-9-_]+)/instances/([A-Za-z0-9-_]+)/databases/([A-Za-z0-9-_]+)");
    protected static final String PROJECT_ID = "spanner-cloud-systest";
    protected static final HttpTransportFactory HTTP_TRANSPORT_FACTORY = NetHttpTransport::new;
    protected boolean enableGrpcFaultInjector;

    protected io.grpc.Status toStatus(SpannerException e) {
        switch (e.getErrorCode()) {
            case INVALID_ARGUMENT: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.INVALID_ARGUMENT.getCode()).withDescription(e.getMessage());
            }
            case PERMISSION_DENIED: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.PERMISSION_DENIED.getCode()).withDescription(e.getMessage());
            }
            case ABORTED: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.ABORTED.getCode()).withDescription(e.getMessage());
            }
            case ALREADY_EXISTS: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.ALREADY_EXISTS.getCode()).withDescription(e.getMessage());
            }
            case CANCELLED: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.CANCELLED.getCode()).withDescription(e.getMessage());
            }
            case INTERNAL: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.INTERNAL.getCode()).withDescription(e.getMessage() + e.getReason() == null ? "" : ": " + e.getReason());
            }
            case FAILED_PRECONDITION: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.FAILED_PRECONDITION.getCode()).withDescription(e.getMessage());
            }
            case NOT_FOUND: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.NOT_FOUND.getCode()).withDescription(e.getMessage());
            }
            case DEADLINE_EXCEEDED: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.DEADLINE_EXCEEDED.getCode()).withDescription(e.getMessage());
            }
            case RESOURCE_EXHAUSTED: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.RESOURCE_EXHAUSTED.getCode()).withDescription(e.getMessage());
            }
            case OUT_OF_RANGE: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.OUT_OF_RANGE.getCode()).withDescription(e.getMessage());
            }
            case UNAUTHENTICATED: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.UNAUTHENTICATED.getCode()).withDescription(e.getMessage());
            }
            case UNIMPLEMENTED: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.UNIMPLEMENTED.getCode()).withDescription(e.getMessage());
            }
            case UNAVAILABLE: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.UNAVAILABLE.getCode()).withDescription(e.getMessage());
            }
            case UNKNOWN: {
                return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.UNKNOWN.getCode()).withDescription(e.getMessage());
            }
        }
        return io.grpc.Status.fromCode((Status.Code)io.grpc.Status.UNKNOWN.getCode()).withDescription("Unsupported Spanner error code: " + e.getErrorCode());
    }

    protected static Status toProto(io.grpc.Status status) {
        return Status.newBuilder().setCode(status.getCode().value()).setMessage(status.getDescription() == null ? "" : status.getDescription()).build();
    }

    protected static String timestampToString(boolean useNanosPrecision, long timestampInMicros) {
        Timestamp timestamp = useNanosPrecision ? Timestamps.fromNanos((long)(timestampInMicros * 1000L + System.nanoTime() % 1000L)) : Timestamps.fromMicros((long)timestampInMicros);
        return String.format("\"%s\"", Timestamps.toString((Timestamp)timestamp));
    }

    public class OutcomeSender {
        private final int actionId;
        private final CloudClientExecutor.ExecutionFlowContext context;
        private Timestamp timestamp;
        private boolean hasReadResult;
        private boolean hasQueryResult;
        private boolean hasChangeStreamRecords;
        private String table;
        private String index;
        private Integer requestIndex;
        private StructType rowType;
        private SpannerActionOutcome.Builder partialOutcomeBuilder;
        private ReadResult.Builder readResultBuilder;
        private QueryResult.Builder queryResultBuilder;
        private int rowCount;
        private final List<Long> rowsModified = new ArrayList<Long>();
        private int changeStreamRecordCount;
        private final List<ChangeStreamRecord> changeStreamRecords = new ArrayList<ChangeStreamRecord>();
        private String partitionTokensString = "[";
        private String dataChangeRecordsString = "[";
        private String changeStreamForQuery = "";
        private String partitionTokenForQuery = "";
        private long changeStreamRecordReceivedTimestamp;
        private long changeStreamHeartbeatMilliseconds;
        private boolean isPartitionedChangeStreamQuery;
        private static final int MAX_ROWS_PER_BATCH = 100;
        private static final int MAX_CHANGE_STREAM_RECORDS_PER_BATCH = 2000;

        public OutcomeSender(int actionId, CloudClientExecutor.ExecutionFlowContext context) {
            this.actionId = actionId;
            this.context = context;
            this.index = null;
            this.rowType = null;
            this.requestIndex = null;
            this.timestamp = Timestamp.newBuilder().setSeconds(0L).setNanos(0).build();
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public void setRowType(StructType rowType) {
            this.rowType = rowType;
        }

        public void initForRead(String table, String index) {
            this.hasReadResult = true;
            this.table = table;
            if (!index.isEmpty()) {
                this.index = index;
            }
        }

        public void initForQuery() {
            this.hasQueryResult = true;
        }

        public void initForBatchRead(String table, String index) {
            this.initForRead(table, index);
            this.requestIndex = 0;
        }

        public void initForChangeStreamQuery(long changeStreamHeartbeatMilliseconds, String changeStreamName, String partitionToken) {
            this.hasChangeStreamRecords = true;
            this.changeStreamRecordReceivedTimestamp = 0L;
            this.changeStreamHeartbeatMilliseconds = changeStreamHeartbeatMilliseconds;
            this.changeStreamForQuery = changeStreamName;
            if (!partitionToken.isEmpty()) {
                this.isPartitionedChangeStreamQuery = true;
                this.partitionTokenForQuery = partitionToken;
            }
        }

        public void updateChangeStreamRecordReceivedTimestamp(long changeStreamRecordReceivedTimestamp) {
            this.changeStreamRecordReceivedTimestamp = changeStreamRecordReceivedTimestamp;
        }

        public void appendRowsModifiedInDml(Long rowsModified) {
            this.rowsModified.add(rowsModified);
        }

        public long getChangeStreamRecordReceivedTimestamp() {
            return this.changeStreamRecordReceivedTimestamp;
        }

        public long getChangeStreamHeartbeatMilliSeconds() {
            return this.changeStreamHeartbeatMilliseconds;
        }

        public boolean getIsPartitionedChangeStreamQuery() {
            return this.isPartitionedChangeStreamQuery;
        }

        public io.grpc.Status finishWithOK() {
            this.buildOutcome();
            this.partialOutcomeBuilder.setStatus(CloudExecutor.toProto(io.grpc.Status.OK));
            return this.flush();
        }

        public io.grpc.Status finishWithTransactionRestarted() {
            this.buildOutcome();
            this.partialOutcomeBuilder.setTransactionRestarted(true);
            this.partialOutcomeBuilder.setStatus(CloudExecutor.toProto(io.grpc.Status.OK));
            return this.flush();
        }

        public io.grpc.Status finishWithError(io.grpc.Status err) {
            this.buildOutcome();
            this.partialOutcomeBuilder.setStatus(CloudExecutor.toProto(err));
            return this.flush();
        }

        public io.grpc.Status appendRow(ValueList row) {
            if (!this.hasReadResult && !this.hasQueryResult) {
                return CloudExecutor.this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Either hasReadResult or hasQueryResult should be true"));
            }
            if (this.rowType == null) {
                return CloudExecutor.this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"RowType should be set first"));
            }
            this.buildOutcome();
            if (this.hasReadResult) {
                this.readResultBuilder.addRow(row);
                ++this.rowCount;
            } else if (this.hasQueryResult) {
                this.queryResultBuilder.addRow(row);
                ++this.rowCount;
            }
            if (this.rowCount >= 100) {
                return this.flush();
            }
            return io.grpc.Status.OK;
        }

        public io.grpc.Status appendChangeStreamRecord(ChangeStreamRecord record) {
            if (!this.hasChangeStreamRecords) {
                return CloudExecutor.this.toStatus(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"hasChangeStreamRecords should be true"));
            }
            if (record.hasDataChange()) {
                String appendedString = String.format("{%s, %s}, ", record.getDataChange().getTransactionId(), record.getDataChange().getRecordSequence());
                this.dataChangeRecordsString = this.dataChangeRecordsString + appendedString;
            } else if (record.hasChildPartition()) {
                for (ChildPartitionsRecord.ChildPartition childPartition : record.getChildPartition().getChildPartitionsList()) {
                    this.partitionTokensString = this.partitionTokensString.concat(childPartition.getToken() + ", ");
                }
            }
            this.buildOutcome();
            this.changeStreamRecords.add(record);
            ++this.changeStreamRecordCount;
            if (this.changeStreamRecordCount >= 2000) {
                return this.flush();
            }
            return io.grpc.Status.OK;
        }

        private void buildOutcome() {
            if (this.partialOutcomeBuilder != null) {
                return;
            }
            this.partialOutcomeBuilder = SpannerActionOutcome.newBuilder();
            this.partialOutcomeBuilder.setCommitTime(this.timestamp);
            if (this.hasReadResult) {
                this.readResultBuilder = ReadResult.newBuilder();
                this.readResultBuilder.setTable(this.table);
                if (this.index != null) {
                    this.readResultBuilder.setIndex(this.index);
                }
                if (this.rowType != null) {
                    this.readResultBuilder.setRowType(this.rowType);
                }
                if (this.requestIndex != null) {
                    this.readResultBuilder.setRequestIndex(this.requestIndex.intValue());
                }
            } else if (this.hasQueryResult) {
                this.queryResultBuilder = QueryResult.newBuilder();
                if (this.rowType != null) {
                    this.queryResultBuilder.setRowType(this.rowType);
                }
            }
        }

        private io.grpc.Status flush() {
            Preconditions.checkNotNull((Object)this.partialOutcomeBuilder);
            for (Long rowCount : this.rowsModified) {
                this.partialOutcomeBuilder.addDmlRowsModified(rowCount.longValue());
            }
            if (this.hasReadResult) {
                this.partialOutcomeBuilder.setReadResult(this.readResultBuilder.build());
            } else if (this.hasQueryResult) {
                this.partialOutcomeBuilder.setQueryResult(this.queryResultBuilder.build());
            } else if (this.hasChangeStreamRecords) {
                this.partialOutcomeBuilder.addAllChangeStreamRecords(this.changeStreamRecords);
                this.partitionTokensString = this.partitionTokensString + "]\n";
                this.dataChangeRecordsString = this.dataChangeRecordsString + "]\n";
                LOGGER.log(Level.INFO, String.format("OutcomeSender with action ID %s for change stream %s and partition token %s is sending data change records with the following transaction id/record sequence combinations: %s and partition tokens: %s", this.changeStreamForQuery, this.partitionTokenForQuery, this.actionId, this.dataChangeRecordsString, this.partitionTokensString));
                this.partitionTokensString = "";
                this.dataChangeRecordsString = "";
            }
            io.grpc.Status status = this.sendOutcome(this.partialOutcomeBuilder.build());
            this.partialOutcomeBuilder = null;
            this.readResultBuilder = null;
            this.queryResultBuilder = null;
            this.rowCount = 0;
            this.rowsModified.clear();
            this.changeStreamRecordCount = 0;
            this.changeStreamRecords.clear();
            return status;
        }

        public io.grpc.Status sendOutcome(SpannerActionOutcome outcome) {
            try {
                LOGGER.log(Level.INFO, String.format("Sending result %s actionId %s", outcome, this.actionId));
                SpannerAsyncActionResponse result = SpannerAsyncActionResponse.newBuilder().setActionId(this.actionId).setOutcome(outcome).build();
                this.context.onNext(result);
                LOGGER.log(Level.INFO, String.format("Sent result %s actionId %s", outcome, this.actionId));
            }
            catch (SpannerException e) {
                LOGGER.log(Level.SEVERE, "Failed to send outcome with error: " + e.getMessage(), e);
                return CloudExecutor.this.toStatus(e);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Failed to send outcome with error: " + t.getMessage(), t);
                return io.grpc.Status.fromThrowable((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unexpected error during rpc send: " + t)));
            }
            return io.grpc.Status.OK;
        }
    }

    public static class Metadata {
        private final Map<String, List<ColumnMetadata>> tableKeyColumnsInOrder = new HashMap<String, List<ColumnMetadata>>();
        private final Map<String, Map<String, ColumnMetadata>> tableColumnsByName = new HashMap<String, Map<String, ColumnMetadata>>();

        public Metadata(List<TableMetadata> metadata) {
            for (TableMetadata table : metadata) {
                String tableName = table.getName();
                this.tableKeyColumnsInOrder.put(tableName, table.getKeyColumnList());
                this.tableColumnsByName.put(tableName, new HashMap());
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    ColumnMetadata column = table.getColumn(j);
                    this.tableColumnsByName.get(tableName).put(column.getName(), column);
                }
            }
        }

        public List<Type> getKeyColumnTypes(String tableName) throws SpannerException {
            if (!this.tableKeyColumnsInOrder.containsKey(tableName)) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("There is no metadata for table: " + tableName));
            }
            ArrayList<Type> typeList = new ArrayList<Type>();
            List<ColumnMetadata> columns = this.tableKeyColumnsInOrder.get(tableName);
            for (ColumnMetadata column : columns) {
                typeList.add(column.getType());
            }
            return typeList;
        }

        public Type getColumnType(String tableName, String columnName) throws SpannerException {
            if (!this.tableColumnsByName.containsKey(tableName)) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("There is no metadata for table: " + tableName));
            }
            Map<String, ColumnMetadata> columnList = this.tableColumnsByName.get(tableName);
            if (!columnList.containsKey(columnName)) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Metadata for table " + tableName + " contains no column named " + columnName));
            }
            return columnList.get(columnName).getType();
        }
    }
}

