/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.nativeimage;

import com.google.api.gax.nativeimage.NativeImageUtils;
import org.graalvm.nativeimage.hosted.Feature;

final class SpannerFeature
implements Feature {
    private static final String SPANNER_CLASS = "com.google.spanner.v1.SpannerGrpc";
    private static final String SPANNER_TEST_CLASS = "com.google.cloud.spanner.GceTestEnvConfig";
    private static final String MOCK_CLASS = "com.google.cloud.spanner.MockDatabaseAdminServiceImpl";
    private static final String CLIENT_SIDE_IMPL_CLASS = "com.google.cloud.spanner.connection.ClientSideStatementImpl";
    private static final String CLIENT_SIDE_VALUE_CONVERTER = "com.google.cloud.spanner.connection.ClientSideStatementValueConverters";
    private static final String CONNECTION_IMPL = "com.google.cloud.spanner.connection.ConnectionImpl";
    private static final String CLIENT_SIDE_STATEMENTS = "com.google.cloud.spanner.connection.ClientSideStatements";
    private static final String CONNECTION_STATEMENT_EXECUTOR = "com.google.cloud.spanner.connection.ConnectionStatementExecutor";
    private static final String CLIENT_SIDE_STATEMENT_NO_PARAM_EXECUTOR = "com.google.cloud.spanner.connection.ClientSideStatementNoParamExecutor";
    private static final String CLIENT_SIDE_STATEMENT_SET_EXECUTOR = "com.google.cloud.spanner.connection.ClientSideStatementSetExecutor";
    private static final String CLIENT_SIDE_STATEMENT_PG_EXECUTOR = "com.google.cloud.spanner.connection.ClientSideStatementPgBeginExecutor";
    private static final String CLIENT_SIDE_STATEMENT_EXPLAIN_EXECUTOR = "com.google.cloud.spanner.connection.ClientSideStatementExplainExecutor";
    private static final String ABSTRACT_STATEMENT_PARSER = "com.google.cloud.spanner.connection.AbstractStatementParser";
    private static final String STATEMENT_PARSER = "com.google.cloud.spanner.connection.SpannerStatementParser";
    private static final String POSTGRESQL_STATEMENT_PARSER = "com.google.cloud.spanner.connection.PostgreSQLStatementParser";
    private static final String STATEMENT_RESULT = "com.google.cloud.spanner.connection.StatementResult$ResultType";

    SpannerFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class spannerClass;
        this.registerSpannerTestClasses(access);
        if (access.findClassByName(CLIENT_SIDE_IMPL_CLASS) != null) {
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, (String)CLIENT_SIDE_IMPL_CLASS);
        }
        if (access.findClassByName(CLIENT_SIDE_STATEMENT_NO_PARAM_EXECUTOR) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)CLIENT_SIDE_STATEMENT_NO_PARAM_EXECUTOR);
        }
        if (access.findClassByName(CLIENT_SIDE_STATEMENT_PG_EXECUTOR) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)CLIENT_SIDE_STATEMENT_PG_EXECUTOR);
        }
        if (access.findClassByName(CLIENT_SIDE_STATEMENT_EXPLAIN_EXECUTOR) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)CLIENT_SIDE_STATEMENT_EXPLAIN_EXECUTOR);
        }
        if (access.findClassByName(CLIENT_SIDE_STATEMENT_SET_EXECUTOR) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)CLIENT_SIDE_STATEMENT_SET_EXECUTOR);
        }
        if (access.findClassByName(CLIENT_SIDE_VALUE_CONVERTER) != null) {
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, (String)CLIENT_SIDE_VALUE_CONVERTER);
        }
        if (access.findClassByName(CLIENT_SIDE_STATEMENTS) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)CLIENT_SIDE_STATEMENTS);
        }
        if (access.findClassByName(CONNECTION_STATEMENT_EXECUTOR) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)CONNECTION_STATEMENT_EXECUTOR);
        }
        if (access.findClassByName(CONNECTION_IMPL) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)CONNECTION_IMPL);
        }
        if (access.findClassByName(ABSTRACT_STATEMENT_PARSER) != null) {
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, (String)ABSTRACT_STATEMENT_PARSER);
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"com.google.cloud.spanner.Dialect");
        }
        if (access.findClassByName(STATEMENT_PARSER) != null) {
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)STATEMENT_PARSER);
        }
        if (access.findClassByName(POSTGRESQL_STATEMENT_PARSER) != null) {
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)POSTGRESQL_STATEMENT_PARSER);
        }
        if (access.findClassByName(STATEMENT_RESULT) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)STATEMENT_RESULT);
        }
        if ((spannerClass = access.findClassByName(SPANNER_CLASS)) != null) {
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, (String)"com.google.spanner.admin.database.v1.Database");
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, (String)"com.google.spanner.admin.instance.v1.Instance");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"com.google.spanner.admin.database.v1.RestoreInfo");
        }
    }

    private void registerSpannerTestClasses(Feature.BeforeAnalysisAccess access) {
        Class mockClass;
        Class spannerTestClass = access.findClassByName(SPANNER_TEST_CLASS);
        if (spannerTestClass != null) {
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)SPANNER_TEST_CLASS);
        }
        if ((mockClass = access.findClassByName(MOCK_CLASS)) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"com.google.cloud.spanner.MockDatabaseAdminServiceImpl$MockBackup");
        }
    }
}

