/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ErrorHandler;
import com.google.cloud.spanner.IScope;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.RetryOnDifferentGrpcChannelException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TraceWrapper;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.protobuf.ByteString;
import com.google.spanner.v1.PartialResultSet;
import io.grpc.Context;
import io.grpc.Status;
import io.opentelemetry.api.common.Attributes;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@VisibleForTesting
abstract class ResumableStreamIterator
extends AbstractIterator<PartialResultSet>
implements AbstractResultSet.CloseableIterator<PartialResultSet> {
    private static final RetrySettings DEFAULT_STREAMING_RETRY_SETTINGS = SpannerStubSettings.newBuilder().executeStreamingSqlSettings().getRetrySettings();
    private final ErrorHandler errorHandler;
    private AsyncResultSet.StreamMessageListener streamMessageListener;
    private final RetrySettings streamingRetrySettings;
    private final Set<StatusCode.Code> retryableCodes;
    private static final Logger logger = Logger.getLogger(ResumableStreamIterator.class.getName());
    private BackOff backOff;
    private final LinkedList<PartialResultSet> buffer = new LinkedList();
    private final int maxBufferSize;
    private final ISpan span;
    private final TraceWrapper tracer;
    private AbstractResultSet.CloseableIterator<PartialResultSet> stream;
    private ByteString resumeToken;
    private boolean finished;
    private boolean safeToRetry = true;

    protected ResumableStreamIterator(int maxBufferSize, String streamName, ISpan parent, TraceWrapper tracer, ErrorHandler errorHandler, RetrySettings streamingRetrySettings, Set<StatusCode.Code> retryableCodes) {
        this(maxBufferSize, streamName, parent, tracer, Attributes.empty(), errorHandler, streamingRetrySettings, retryableCodes);
    }

    protected ResumableStreamIterator(int maxBufferSize, String streamName, ISpan parent, TraceWrapper tracer, Attributes attributes, ErrorHandler errorHandler, RetrySettings streamingRetrySettings, Set<StatusCode.Code> retryableCodes) {
        Preconditions.checkArgument((maxBufferSize >= 0 ? 1 : 0) != 0);
        this.maxBufferSize = maxBufferSize;
        this.tracer = tracer;
        this.span = tracer.spanBuilderWithExplicitParent(streamName, parent, attributes);
        this.errorHandler = errorHandler;
        this.streamingRetrySettings = (RetrySettings)Preconditions.checkNotNull((Object)streamingRetrySettings);
        this.retryableCodes = (Set)Preconditions.checkNotNull(retryableCodes);
    }

    private ExponentialBackOff newBackOff() {
        if (Objects.equals(this.streamingRetrySettings, DEFAULT_STREAMING_RETRY_SETTINGS)) {
            return new ExponentialBackOff.Builder().setMultiplier(this.streamingRetrySettings.getRetryDelayMultiplier()).setInitialIntervalMillis(Math.max(10, (int)this.streamingRetrySettings.getInitialRetryDelay().toMillis())).setMaxIntervalMillis(Math.max(1000, (int)this.streamingRetrySettings.getMaxRetryDelay().toMillis())).setMaxElapsedTimeMillis(Integer.MAX_VALUE).build();
        }
        return new ExponentialBackOff.Builder().setMultiplier(this.streamingRetrySettings.getRetryDelayMultiplier()).setInitialIntervalMillis(Math.max(1, (int)Math.min(this.streamingRetrySettings.getInitialRetryDelay().toMillis(), Integer.MAX_VALUE))).setMaxIntervalMillis(Math.max(1, (int)Math.min(this.streamingRetrySettings.getMaxRetryDelay().toMillis(), Integer.MAX_VALUE))).setMaxElapsedTimeMillis(Math.max(1, (int)Math.min(this.streamingRetrySettings.getTotalTimeout().toMillis(), Integer.MAX_VALUE))).build();
    }

    private void backoffSleep(Context context, BackOff backoff) throws SpannerException {
        this.backoffSleep(context, ResumableStreamIterator.nextBackOffMillis(backoff));
    }

    private static long nextBackOffMillis(BackOff backoff) throws SpannerException {
        try {
            return backoff.nextBackOffMillis();
        }
        catch (IOException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, e.getMessage(), e);
        }
    }

    private void backoffSleep(Context context, long backoffMillis) throws SpannerException {
        this.tracer.getCurrentSpan().addAnnotation("Backing off", "Delay", backoffMillis);
        CountDownLatch latch = new CountDownLatch(1);
        Context.CancellationListener listener = ignored -> latch.countDown();
        context.addListener(listener, (Executor)DirectExecutor.INSTANCE);
        try {
            if (backoffMillis == -1L) {
                backoffMillis = this.streamingRetrySettings.getMaxRetryDelay().toMillis();
            }
            if (latch.await(backoffMillis, TimeUnit.MILLISECONDS)) {
                throw SpannerExceptionFactory.newSpannerExceptionForCancellation(context, null);
            }
        }
        catch (InterruptedException interruptExcept) {
            throw SpannerExceptionFactory.newSpannerExceptionForCancellation(context, interruptExcept);
        }
        finally {
            context.removeListener(listener);
        }
    }

    abstract AbstractResultSet.CloseableIterator<PartialResultSet> startStream(@Nullable ByteString var1, AsyncResultSet.StreamMessageListener var2);

    boolean prepareIteratorForRetryOnDifferentGrpcChannel() {
        return false;
    }

    @Override
    public void close(@Nullable String message) {
        if (this.stream != null) {
            this.stream.close(message);
            this.span.end();
            this.stream = null;
        }
    }

    @Override
    public boolean isWithBeginTransaction() {
        return this.stream != null && this.stream.isWithBeginTransaction();
    }

    @Override
    @InternalApi
    public boolean initiateStreaming(AsyncResultSet.StreamMessageListener streamMessageListener) {
        this.streamMessageListener = streamMessageListener;
        this.startGrpcStreaming();
        return true;
    }

    protected PartialResultSet computeNext() {
        int numAttemptsOnOtherChannel = 0;
        Context context = Context.current();
        while (true) {
            this.startGrpcStreaming();
            if (!(this.buffer.isEmpty() || !this.finished && this.safeToRetry && this.buffer.getLast().getResumeToken().isEmpty())) {
                return this.buffer.pop();
            }
            try {
                if (this.stream.hasNext()) {
                    boolean hasResumeToken;
                    PartialResultSet next = (PartialResultSet)this.stream.next();
                    boolean bl = hasResumeToken = !next.getResumeToken().isEmpty();
                    if (hasResumeToken) {
                        this.resumeToken = next.getResumeToken();
                        this.safeToRetry = true;
                    }
                    if ((hasResumeToken || !this.safeToRetry) && this.buffer.isEmpty()) {
                        return next;
                    }
                    this.buffer.add(next);
                    if (this.buffer.size() <= this.maxBufferSize || !this.buffer.getLast().getResumeToken().isEmpty()) continue;
                    this.safeToRetry = false;
                    continue;
                }
                this.finished = true;
                if (!this.buffer.isEmpty()) continue;
                this.endOfData();
                return null;
            }
            catch (SpannerException spannerException) {
                Throwable translated;
                if (this.safeToRetry && this.isRetryable(spannerException)) {
                    this.span.addAnnotation("Stream broken. Safe to retry", (Throwable)((Object)spannerException));
                    logger.log(Level.FINE, "Retryable exception, will sleep and retry", (Throwable)((Object)spannerException));
                    while (!this.buffer.isEmpty() && this.buffer.getLast().getResumeToken().isEmpty()) {
                        this.buffer.removeLast();
                    }
                    assert (this.buffer.isEmpty() || this.buffer.getLast().getResumeToken().equals((Object)this.resumeToken));
                    this.stream = null;
                    IScope s = this.tracer.withSpan(this.span);
                    try {
                        long delay = spannerException.getRetryDelayInMillis();
                        if (delay != -1L) {
                            this.backoffSleep(context, delay);
                            continue;
                        }
                        if (this.backOff == null) {
                            this.backOff = this.newBackOff();
                        }
                        this.backoffSleep(context, this.backOff);
                        continue;
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                        continue;
                    }
                }
                if (this.resumeToken == null && this.buffer.isEmpty() && (translated = this.errorHandler.translateException((Throwable)((Object)spannerException))) instanceof RetryOnDifferentGrpcChannelException && ++numAttemptsOnOtherChannel < this.errorHandler.getMaxAttempts() && this.prepareIteratorForRetryOnDifferentGrpcChannel()) {
                    this.stream = null;
                    continue;
                }
                this.span.addAnnotation("Stream broken. Not safe to retry", (Throwable)((Object)spannerException));
                this.span.setStatus((Throwable)((Object)spannerException));
                throw spannerException;
            }
            catch (RuntimeException e) {
                this.span.addAnnotation("Stream broken. Not safe to retry", e);
                this.span.setStatus(e);
                throw e;
            }
            break;
        }
    }

    private void startGrpcStreaming() {
        if (this.stream == null) {
            this.span.addAnnotation("Starting/Resuming stream", "ResumeToken", this.resumeToken == null ? "null" : this.resumeToken.toStringUtf8());
            try (IScope scope = this.tracer.withSpan(this.span);){
                this.stream = (AbstractResultSet.CloseableIterator)Preconditions.checkNotNull(this.startStream(this.resumeToken, this.streamMessageListener));
                this.stream.requestPrefetchChunks();
            }
        }
    }

    boolean isRetryable(SpannerException spannerException) {
        return spannerException.isRetryable() || this.retryableCodes.contains(GrpcStatusCode.of((Status.Code)spannerException.getErrorCode().getGrpcStatusCode()).getCode());
    }

    private static enum DirectExecutor implements Executor
    {
        INSTANCE;


        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

