/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.google.api.core.BetaApi;

@BetaApi
public final class CompletedPart {
    @JacksonXmlProperty(localName="PartNumber")
    private final int partNumber;
    @JacksonXmlProperty(localName="ETag")
    private final String eTag;

    private CompletedPart(int partNumber, String eTag) {
        this.partNumber = partNumber;
        this.eTag = eTag;
    }

    @BetaApi
    public static Builder builder() {
        return new Builder();
    }

    @BetaApi
    public int partNumber() {
        return this.partNumber;
    }

    @BetaApi
    public String eTag() {
        return this.eTag;
    }

    @BetaApi
    public static class Builder {
        private int partNumber;
        private String etag;

        @BetaApi
        public Builder partNumber(int partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        @BetaApi
        public Builder eTag(String etag) {
            this.etag = etag;
            return this;
        }

        @BetaApi
        public CompletedPart build() {
            return new CompletedPart(this.partNumber, this.etag);
        }
    }
}

