/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.tpu.v2.AcceleratorType;
import com.google.cloud.tpu.v2.CreateNodeRequest;
import com.google.cloud.tpu.v2.DeleteNodeRequest;
import com.google.cloud.tpu.v2.GenerateServiceIdentityRequest;
import com.google.cloud.tpu.v2.GenerateServiceIdentityResponse;
import com.google.cloud.tpu.v2.GetAcceleratorTypeRequest;
import com.google.cloud.tpu.v2.GetGuestAttributesRequest;
import com.google.cloud.tpu.v2.GetGuestAttributesResponse;
import com.google.cloud.tpu.v2.GetNodeRequest;
import com.google.cloud.tpu.v2.GetRuntimeVersionRequest;
import com.google.cloud.tpu.v2.ListAcceleratorTypesRequest;
import com.google.cloud.tpu.v2.ListAcceleratorTypesResponse;
import com.google.cloud.tpu.v2.ListNodesRequest;
import com.google.cloud.tpu.v2.ListNodesResponse;
import com.google.cloud.tpu.v2.ListRuntimeVersionsRequest;
import com.google.cloud.tpu.v2.ListRuntimeVersionsResponse;
import com.google.cloud.tpu.v2.Node;
import com.google.cloud.tpu.v2.OperationMetadata;
import com.google.cloud.tpu.v2.RuntimeVersion;
import com.google.cloud.tpu.v2.StartNodeRequest;
import com.google.cloud.tpu.v2.StopNodeRequest;
import com.google.cloud.tpu.v2.TpuClient;
import com.google.cloud.tpu.v2.UpdateNodeRequest;
import com.google.cloud.tpu.v2.stub.GrpcTpuCallableFactory;
import com.google.cloud.tpu.v2.stub.TpuStub;
import com.google.cloud.tpu.v2.stub.TpuStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcTpuStub
extends TpuStub {
    private static final MethodDescriptor<ListNodesRequest, ListNodesResponse> listNodesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/ListNodes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListNodesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListNodesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetNodeRequest, Node> getNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/GetNode").setRequestMarshaller(ProtoUtils.marshaller((Message)GetNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Node.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateNodeRequest, Operation> createNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/CreateNode").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteNodeRequest, Operation> deleteNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/DeleteNode").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StopNodeRequest, Operation> stopNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/StopNode").setRequestMarshaller(ProtoUtils.marshaller((Message)StopNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StartNodeRequest, Operation> startNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/StartNode").setRequestMarshaller(ProtoUtils.marshaller((Message)StartNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateNodeRequest, Operation> updateNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/UpdateNode").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentityMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/GenerateServiceIdentity").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateServiceIdentityRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateServiceIdentityResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/ListAcceleratorTypes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAcceleratorTypesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAcceleratorTypesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/GetAcceleratorType").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAcceleratorTypeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AcceleratorType.getDefaultInstance())).build();
    private static final MethodDescriptor<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse> listRuntimeVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/ListRuntimeVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRuntimeVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRuntimeVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/GetRuntimeVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRuntimeVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RuntimeVersion.getDefaultInstance())).build();
    private static final MethodDescriptor<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v2.Tpu/GetGuestAttributes").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGuestAttributesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GetGuestAttributesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListNodesRequest, ListNodesResponse> listNodesCallable;
    private final UnaryCallable<ListNodesRequest, TpuClient.ListNodesPagedResponse> listNodesPagedCallable;
    private final UnaryCallable<GetNodeRequest, Node> getNodeCallable;
    private final UnaryCallable<CreateNodeRequest, Operation> createNodeCallable;
    private final OperationCallable<CreateNodeRequest, Node, OperationMetadata> createNodeOperationCallable;
    private final UnaryCallable<DeleteNodeRequest, Operation> deleteNodeCallable;
    private final OperationCallable<DeleteNodeRequest, Empty, OperationMetadata> deleteNodeOperationCallable;
    private final UnaryCallable<StopNodeRequest, Operation> stopNodeCallable;
    private final OperationCallable<StopNodeRequest, Node, OperationMetadata> stopNodeOperationCallable;
    private final UnaryCallable<StartNodeRequest, Operation> startNodeCallable;
    private final OperationCallable<StartNodeRequest, Node, OperationMetadata> startNodeOperationCallable;
    private final UnaryCallable<UpdateNodeRequest, Operation> updateNodeCallable;
    private final OperationCallable<UpdateNodeRequest, Node, OperationMetadata> updateNodeOperationCallable;
    private final UnaryCallable<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentityCallable;
    private final UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesCallable;
    private final UnaryCallable<ListAcceleratorTypesRequest, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesPagedCallable;
    private final UnaryCallable<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeCallable;
    private final UnaryCallable<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse> listRuntimeVersionsCallable;
    private final UnaryCallable<ListRuntimeVersionsRequest, TpuClient.ListRuntimeVersionsPagedResponse> listRuntimeVersionsPagedCallable;
    private final UnaryCallable<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionCallable;
    private final UnaryCallable<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, TpuClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTpuStub create(TpuStubSettings settings) throws IOException {
        return new GrpcTpuStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTpuStub create(ClientContext clientContext) throws IOException {
        return new GrpcTpuStub(TpuStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTpuStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTpuStub(TpuStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTpuStub(TpuStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTpuCallableFactory());
    }

    protected GrpcTpuStub(TpuStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listNodesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listNodesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getNodeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createNodeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteNodeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings stopNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(stopNodeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings startNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startNodeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateNodeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"node.name", (Object)String.valueOf(request.getNode().getName()));
            return params.build();
        }).build();
        GrpcCallSettings generateServiceIdentityTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateServiceIdentityMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listAcceleratorTypesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAcceleratorTypesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getAcceleratorTypeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAcceleratorTypeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listRuntimeVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRuntimeVersionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getRuntimeVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRuntimeVersionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getGuestAttributesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGuestAttributesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.listNodesCallable = callableFactory.createUnaryCallable(listNodesTransportSettings, settings.listNodesSettings(), clientContext);
        this.listNodesPagedCallable = callableFactory.createPagedCallable(listNodesTransportSettings, settings.listNodesSettings(), clientContext);
        this.getNodeCallable = callableFactory.createUnaryCallable(getNodeTransportSettings, settings.getNodeSettings(), clientContext);
        this.createNodeCallable = callableFactory.createUnaryCallable(createNodeTransportSettings, settings.createNodeSettings(), clientContext);
        this.createNodeOperationCallable = callableFactory.createOperationCallable(createNodeTransportSettings, settings.createNodeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteNodeCallable = callableFactory.createUnaryCallable(deleteNodeTransportSettings, settings.deleteNodeSettings(), clientContext);
        this.deleteNodeOperationCallable = callableFactory.createOperationCallable(deleteNodeTransportSettings, settings.deleteNodeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.stopNodeCallable = callableFactory.createUnaryCallable(stopNodeTransportSettings, settings.stopNodeSettings(), clientContext);
        this.stopNodeOperationCallable = callableFactory.createOperationCallable(stopNodeTransportSettings, settings.stopNodeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.startNodeCallable = callableFactory.createUnaryCallable(startNodeTransportSettings, settings.startNodeSettings(), clientContext);
        this.startNodeOperationCallable = callableFactory.createOperationCallable(startNodeTransportSettings, settings.startNodeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateNodeCallable = callableFactory.createUnaryCallable(updateNodeTransportSettings, settings.updateNodeSettings(), clientContext);
        this.updateNodeOperationCallable = callableFactory.createOperationCallable(updateNodeTransportSettings, settings.updateNodeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.generateServiceIdentityCallable = callableFactory.createUnaryCallable(generateServiceIdentityTransportSettings, settings.generateServiceIdentitySettings(), clientContext);
        this.listAcceleratorTypesCallable = callableFactory.createUnaryCallable(listAcceleratorTypesTransportSettings, settings.listAcceleratorTypesSettings(), clientContext);
        this.listAcceleratorTypesPagedCallable = callableFactory.createPagedCallable(listAcceleratorTypesTransportSettings, settings.listAcceleratorTypesSettings(), clientContext);
        this.getAcceleratorTypeCallable = callableFactory.createUnaryCallable(getAcceleratorTypeTransportSettings, settings.getAcceleratorTypeSettings(), clientContext);
        this.listRuntimeVersionsCallable = callableFactory.createUnaryCallable(listRuntimeVersionsTransportSettings, settings.listRuntimeVersionsSettings(), clientContext);
        this.listRuntimeVersionsPagedCallable = callableFactory.createPagedCallable(listRuntimeVersionsTransportSettings, settings.listRuntimeVersionsSettings(), clientContext);
        this.getRuntimeVersionCallable = callableFactory.createUnaryCallable(getRuntimeVersionTransportSettings, settings.getRuntimeVersionSettings(), clientContext);
        this.getGuestAttributesCallable = callableFactory.createUnaryCallable(getGuestAttributesTransportSettings, settings.getGuestAttributesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListNodesRequest, ListNodesResponse> listNodesCallable() {
        return this.listNodesCallable;
    }

    @Override
    public UnaryCallable<ListNodesRequest, TpuClient.ListNodesPagedResponse> listNodesPagedCallable() {
        return this.listNodesPagedCallable;
    }

    @Override
    public UnaryCallable<GetNodeRequest, Node> getNodeCallable() {
        return this.getNodeCallable;
    }

    @Override
    public UnaryCallable<CreateNodeRequest, Operation> createNodeCallable() {
        return this.createNodeCallable;
    }

    @Override
    public OperationCallable<CreateNodeRequest, Node, OperationMetadata> createNodeOperationCallable() {
        return this.createNodeOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteNodeRequest, Operation> deleteNodeCallable() {
        return this.deleteNodeCallable;
    }

    @Override
    public OperationCallable<DeleteNodeRequest, Empty, OperationMetadata> deleteNodeOperationCallable() {
        return this.deleteNodeOperationCallable;
    }

    @Override
    public UnaryCallable<StopNodeRequest, Operation> stopNodeCallable() {
        return this.stopNodeCallable;
    }

    @Override
    public OperationCallable<StopNodeRequest, Node, OperationMetadata> stopNodeOperationCallable() {
        return this.stopNodeOperationCallable;
    }

    @Override
    public UnaryCallable<StartNodeRequest, Operation> startNodeCallable() {
        return this.startNodeCallable;
    }

    @Override
    public OperationCallable<StartNodeRequest, Node, OperationMetadata> startNodeOperationCallable() {
        return this.startNodeOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateNodeRequest, Operation> updateNodeCallable() {
        return this.updateNodeCallable;
    }

    @Override
    public OperationCallable<UpdateNodeRequest, Node, OperationMetadata> updateNodeOperationCallable() {
        return this.updateNodeOperationCallable;
    }

    @Override
    public UnaryCallable<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentityCallable() {
        return this.generateServiceIdentityCallable;
    }

    @Override
    public UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesCallable() {
        return this.listAcceleratorTypesCallable;
    }

    @Override
    public UnaryCallable<ListAcceleratorTypesRequest, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesPagedCallable() {
        return this.listAcceleratorTypesPagedCallable;
    }

    @Override
    public UnaryCallable<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeCallable() {
        return this.getAcceleratorTypeCallable;
    }

    @Override
    public UnaryCallable<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse> listRuntimeVersionsCallable() {
        return this.listRuntimeVersionsCallable;
    }

    @Override
    public UnaryCallable<ListRuntimeVersionsRequest, TpuClient.ListRuntimeVersionsPagedResponse> listRuntimeVersionsPagedCallable() {
        return this.listRuntimeVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionCallable() {
        return this.getRuntimeVersionCallable;
    }

    @Override
    public UnaryCallable<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesCallable() {
        return this.getGuestAttributesCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, TpuClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

