/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.vision.v1.AnnotateImageRequest;
import com.google.cloud.vision.v1.BatchAnnotateImagesRequest;
import com.google.cloud.vision.v1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.ImageAnnotatorSettings;
import com.google.cloud.vision.v1.stub.ImageAnnotatorStub;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ImageAnnotatorClient
implements BackgroundResource {
    private final ImageAnnotatorSettings settings;
    private final ImageAnnotatorStub stub;

    public static final ImageAnnotatorClient create() throws IOException {
        return ImageAnnotatorClient.create(ImageAnnotatorSettings.newBuilder().build());
    }

    public static final ImageAnnotatorClient create(ImageAnnotatorSettings settings) throws IOException {
        return new ImageAnnotatorClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ImageAnnotatorClient create(ImageAnnotatorStub stub) {
        return new ImageAnnotatorClient(stub);
    }

    protected ImageAnnotatorClient(ImageAnnotatorSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ImageAnnotatorClient(ImageAnnotatorStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ImageAnnotatorSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ImageAnnotatorStub getStub() {
        return this.stub;
    }

    public final BatchAnnotateImagesResponse batchAnnotateImages(List<AnnotateImageRequest> requests) {
        BatchAnnotateImagesRequest request = BatchAnnotateImagesRequest.newBuilder().addAllRequests(requests).build();
        return this.batchAnnotateImages(request);
    }

    private final BatchAnnotateImagesResponse batchAnnotateImages(BatchAnnotateImagesRequest request) {
        return (BatchAnnotateImagesResponse)this.batchAnnotateImagesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesCallable() {
        return this.stub.batchAnnotateImagesCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

