/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p3beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.vision.v1p3beta1.AnnotateImageRequest;
import com.google.cloud.vision.v1p3beta1.AsyncAnnotateFileRequest;
import com.google.cloud.vision.v1p3beta1.AsyncBatchAnnotateFilesRequest;
import com.google.cloud.vision.v1p3beta1.AsyncBatchAnnotateFilesResponse;
import com.google.cloud.vision.v1p3beta1.BatchAnnotateImagesRequest;
import com.google.cloud.vision.v1p3beta1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1p3beta1.ImageAnnotatorSettings;
import com.google.cloud.vision.v1p3beta1.OperationMetadata;
import com.google.cloud.vision.v1p3beta1.stub.ImageAnnotatorStub;
import com.google.cloud.vision.v1p3beta1.stub.ImageAnnotatorStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ImageAnnotatorClient
implements BackgroundResource {
    private final ImageAnnotatorSettings settings;
    private final ImageAnnotatorStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ImageAnnotatorClient create() throws IOException {
        return ImageAnnotatorClient.create(ImageAnnotatorSettings.newBuilder().build());
    }

    public static final ImageAnnotatorClient create(ImageAnnotatorSettings settings) throws IOException {
        return new ImageAnnotatorClient(settings);
    }

    public static final ImageAnnotatorClient create(ImageAnnotatorStub stub) {
        return new ImageAnnotatorClient(stub);
    }

    protected ImageAnnotatorClient(ImageAnnotatorSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ImageAnnotatorStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ImageAnnotatorClient(ImageAnnotatorStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ImageAnnotatorSettings getSettings() {
        return this.settings;
    }

    public ImageAnnotatorStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final BatchAnnotateImagesResponse batchAnnotateImages(List<AnnotateImageRequest> requests) {
        BatchAnnotateImagesRequest request = BatchAnnotateImagesRequest.newBuilder().addAllRequests(requests).build();
        return this.batchAnnotateImages(request);
    }

    public final BatchAnnotateImagesResponse batchAnnotateImages(BatchAnnotateImagesRequest request) {
        return (BatchAnnotateImagesResponse)this.batchAnnotateImagesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesCallable() {
        return this.stub.batchAnnotateImagesCallable();
    }

    public final OperationFuture<AsyncBatchAnnotateFilesResponse, OperationMetadata> asyncBatchAnnotateFilesAsync(List<AsyncAnnotateFileRequest> requests) {
        AsyncBatchAnnotateFilesRequest request = AsyncBatchAnnotateFilesRequest.newBuilder().addAllRequests(requests).build();
        return this.asyncBatchAnnotateFilesAsync(request);
    }

    public final OperationFuture<AsyncBatchAnnotateFilesResponse, OperationMetadata> asyncBatchAnnotateFilesAsync(AsyncBatchAnnotateFilesRequest request) {
        return this.asyncBatchAnnotateFilesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AsyncBatchAnnotateFilesRequest, AsyncBatchAnnotateFilesResponse, OperationMetadata> asyncBatchAnnotateFilesOperationCallable() {
        return this.stub.asyncBatchAnnotateFilesOperationCallable();
    }

    public final UnaryCallable<AsyncBatchAnnotateFilesRequest, Operation> asyncBatchAnnotateFilesCallable() {
        return this.stub.asyncBatchAnnotateFilesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

