/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.cloud.grpc.GcpClientCall;
import com.google.cloud.grpc.GcpManagedChannelOptions;
import com.google.cloud.grpc.GcpMetricsConstants;
import com.google.cloud.grpc.proto.AffinityConfig;
import com.google.cloud.grpc.proto.ApiConfig;
import com.google.cloud.grpc.proto.MethodConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opencensus.common.ToLongFunction;
import io.opencensus.metrics.DerivedLongCumulative;
import io.opencensus.metrics.DerivedLongGauge;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.MetricOptions;
import io.opencensus.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class GcpManagedChannel
extends ManagedChannel {
    private static final Logger logger = Logger.getLogger(GcpManagedChannel.class.getName());
    static final AtomicInteger channelPoolIndex = new AtomicInteger();
    static final int DEFAULT_MAX_CHANNEL = 10;
    static final int DEFAULT_MAX_STREAM = 100;
    public static final Context.Key<Boolean> DISABLE_AFFINITY_CTX_KEY = Context.keyWithDefault((String)"DisableAffinity", (Object)false);
    public static final CallOptions.Key<Boolean> DISABLE_AFFINITY_KEY = CallOptions.Key.createWithDefault((String)"DisableAffinity", (Object)false);
    @GuardedBy(value="this")
    private Integer bindingIndex = -1;
    private final ManagedChannelBuilder<?> delegateChannelBuilder;
    private final GcpManagedChannelOptions options;
    private final boolean fallbackEnabled;
    private final boolean unresponsiveDetectionEnabled;
    private final int unresponsiveMs;
    private final int unresponsiveDropCount;
    private int maxSize = 10;
    private int minSize = 0;
    private int maxConcurrentStreamsLowWatermark = 100;
    @VisibleForTesting
    final Map<String, AffinityConfig> methodToAffinity = new HashMap<String, AffinityConfig>();
    @VisibleForTesting
    final Map<String, ChannelRef> affinityKeyToChannelRef = new ConcurrentHashMap<String, ChannelRef>();
    private final Map<Integer, Map<String, Integer>> fallbackMap = new ConcurrentHashMap<Integer, Map<String, Integer>>();
    @VisibleForTesting
    final List<ChannelRef> channelRefs = new CopyOnWriteArrayList<ChannelRef>();
    private final ExecutorService stateNotificationExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcp-mc-state-notifications-%d").build());
    @GuardedBy(value="this")
    private List<Runnable> stateChangeCallbacks = new LinkedList<Runnable>();
    private MetricRegistry metricRegistry;
    private final List<LabelKey> labelKeys = new ArrayList<LabelKey>();
    private final List<LabelKey> labelKeysWithResult = new ArrayList<LabelKey>(Collections.singletonList(LabelKey.create((String)GcpMetricsConstants.RESULT_LABEL, (String)GcpMetricsConstants.RESULT_DESC)));
    private final List<LabelValue> labelValues = new ArrayList<LabelValue>();
    private final List<LabelValue> labelValuesSuccess = new ArrayList<LabelValue>(Collections.singletonList(LabelValue.create((String)GcpMetricsConstants.RESULT_SUCCESS)));
    private final List<LabelValue> labelValuesError = new ArrayList<LabelValue>(Collections.singletonList(LabelValue.create((String)GcpMetricsConstants.RESULT_ERROR)));
    private String metricPrefix;
    private final String metricPoolIndex = String.format("pool-%d", channelPoolIndex.incrementAndGet());
    private final Map<String, Long> cumulativeMetricValues = new ConcurrentHashMap<String, Long>();
    private ScheduledExecutorService logMetricService;
    private final AtomicInteger readyChannels = new AtomicInteger();
    private int minReadyChannels = 0;
    private int maxReadyChannels = 0;
    private final AtomicLong numChannelConnect = new AtomicLong();
    private final AtomicLong numChannelDisconnect = new AtomicLong();
    private long minReadinessTime = 0L;
    private long maxReadinessTime = 0L;
    private final AtomicLong totalReadinessTime = new AtomicLong();
    private final AtomicLong readinessTimeOccurrences = new AtomicLong();
    private final AtomicInteger totalActiveStreams = new AtomicInteger();
    private int minActiveStreams = 0;
    private int maxActiveStreams = 0;
    private int minTotalActiveStreams = 0;
    private int maxTotalActiveStreams = 0;
    private long minOkCalls = 0L;
    private long maxOkCalls = 0L;
    private final AtomicLong totalOkCalls = new AtomicLong();
    private boolean minOkReported = false;
    private boolean maxOkReported = false;
    private long minErrCalls = 0L;
    private long maxErrCalls = 0L;
    private final AtomicLong totalErrCalls = new AtomicLong();
    private boolean minErrReported = false;
    private boolean maxErrReported = false;
    private final AtomicInteger minAffinity = new AtomicInteger();
    private final AtomicInteger maxAffinity = new AtomicInteger();
    private final AtomicInteger totalAffinityCount = new AtomicInteger();
    private final AtomicLong fallbacksSucceeded = new AtomicLong();
    private final AtomicLong fallbacksFailed = new AtomicLong();
    private final AtomicLong unresponsiveDetectionCount = new AtomicLong();
    private long minUnresponsiveMs = 0L;
    private long maxUnresponsiveMs = 0L;
    private long minUnresponsiveDrops = 0L;
    private long maxUnresponsiveDrops = 0L;

    public GcpManagedChannel(ManagedChannelBuilder<?> delegateChannelBuilder, ApiConfig apiConfig, GcpManagedChannelOptions options) {
        this.loadApiConfig(apiConfig);
        this.delegateChannelBuilder = delegateChannelBuilder;
        this.options = options;
        logger.finer(this.log("Created with api config: %s, and options: %s", apiConfig == null ? "null" : TextFormat.shortDebugString((MessageOrBuilder)apiConfig), options));
        this.initOptions();
        if (options.getResiliencyOptions() != null) {
            this.fallbackEnabled = options.getResiliencyOptions().isNotReadyFallbackEnabled();
            this.unresponsiveDetectionEnabled = options.getResiliencyOptions().isUnresponsiveDetectionEnabled();
            this.unresponsiveMs = options.getResiliencyOptions().getUnresponsiveDetectionMs();
            this.unresponsiveDropCount = options.getResiliencyOptions().getUnresponsiveDetectionDroppedCount();
        } else {
            this.fallbackEnabled = false;
            this.unresponsiveDetectionEnabled = false;
            this.unresponsiveMs = 0;
            this.unresponsiveDropCount = 0;
        }
        this.initMinChannels();
    }

    @Deprecated
    public GcpManagedChannel(ManagedChannelBuilder<?> delegateChannelBuilder, ApiConfig apiConfig, int poolSize, GcpManagedChannelOptions options) {
        this(delegateChannelBuilder, apiConfig, options);
        if (poolSize != 0) {
            logger.finer(this.log("Pool size adjusted to %d", poolSize));
            this.maxSize = poolSize;
        }
    }

    private Supplier<String> log(Supplier<String> messageSupplier) {
        return () -> String.format("%s: %s", this.metricPoolIndex, messageSupplier.get());
    }

    private String log(String message) {
        return String.format("%s: %s", this.metricPoolIndex, message);
    }

    private String log(String format, Object ... args) {
        return String.format("%s: %s", this.metricPoolIndex, String.format(format, args));
    }

    private synchronized void initMinChannels() {
        while (this.minSize - this.getNumberOfChannels() > 0) {
            this.createNewChannel();
        }
    }

    private void initOptions() {
        GcpManagedChannelOptions.GcpChannelPoolOptions poolOptions = this.options.getChannelPoolOptions();
        if (poolOptions != null) {
            this.maxSize = poolOptions.getMaxSize();
            this.minSize = poolOptions.getMinSize();
            this.maxConcurrentStreamsLowWatermark = poolOptions.getConcurrentStreamsLowWatermark();
        }
        this.initMetrics();
    }

    private synchronized void initLogMetrics() {
        if (this.logMetricService != null) {
            return;
        }
        this.logMetricService = Executors.newSingleThreadScheduledExecutor();
        this.logMetricService.scheduleAtFixedRate(this::logMetrics, 60L, 60L, TimeUnit.SECONDS);
    }

    private void logMetricsOptions() {
        if (this.options.getMetricsOptions() != null) {
            logger.fine(this.log("Metrics options: %s", this.options.getMetricsOptions()));
        }
    }

    private void logChannelsStats() {
        logger.fine(this.log("Active streams counts: [%s]", Joiner.on((String)", ").join((Iterator)this.channelRefs.stream().mapToInt(ChannelRef::getActiveStreamsCount).iterator())));
        logger.fine(this.log("Affinity counts: [%s]", Joiner.on((String)", ").join((Iterator)this.channelRefs.stream().mapToInt(ChannelRef::getAffinityCount).iterator())));
    }

    private void initMetrics() {
        GcpManagedChannelOptions.GcpMetricsOptions metricsOptions = this.options.getMetricsOptions();
        if (metricsOptions == null) {
            logger.info(this.log("Metrics options are empty. Metrics disabled."));
            this.initLogMetrics();
            return;
        }
        this.logMetricsOptions();
        if (metricsOptions.getMetricRegistry() == null) {
            logger.info(this.log("Metric registry is null. Metrics disabled."));
            this.initLogMetrics();
            return;
        }
        logger.info(this.log("Metrics enabled."));
        this.metricRegistry = metricsOptions.getMetricRegistry();
        this.labelKeys.addAll(metricsOptions.getLabelKeys());
        this.labelKeysWithResult.addAll(metricsOptions.getLabelKeys());
        this.labelValues.addAll(metricsOptions.getLabelValues());
        this.labelValuesSuccess.addAll(metricsOptions.getLabelValues());
        this.labelValuesError.addAll(metricsOptions.getLabelValues());
        LabelKey poolKey = LabelKey.create((String)GcpMetricsConstants.POOL_INDEX_LABEL, (String)GcpMetricsConstants.POOL_INDEX_DESC);
        this.labelKeys.add(poolKey);
        this.labelKeysWithResult.add(poolKey);
        LabelValue poolIndex = LabelValue.create((String)this.metricPoolIndex);
        this.labelValues.add(poolIndex);
        this.labelValuesSuccess.add(poolIndex);
        this.labelValuesError.add(poolIndex);
        this.metricPrefix = metricsOptions.getNamePrefix();
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_READY_CHANNELS, "The minimum number of channels simultaneously in the READY state.", "1", this, GcpManagedChannel::reportMinReadyChannels);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_READY_CHANNELS, "The maximum number of channels simultaneously in the READY state.", "1", this, GcpManagedChannel::reportMaxReadyChannels);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_CHANNELS, "The maximum number of channels in the pool.", "1", this, GcpManagedChannel::reportMaxChannels);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_ALLOWED_CHANNELS, "The maximum number of channels allowed in the pool. (The poll max size)", "1", this, GcpManagedChannel::reportMaxAllowedChannels);
        this.createDerivedLongCumulativeTimeSeries(GcpMetricsConstants.METRIC_NUM_CHANNEL_DISCONNECT, "The number of disconnections (occurrences when a channel deviates from the READY state)", "1", this, GcpManagedChannel::reportNumChannelDisconnect);
        this.createDerivedLongCumulativeTimeSeries(GcpMetricsConstants.METRIC_NUM_CHANNEL_CONNECT, "The number of times when a channel reached the READY state.", "1", this, GcpManagedChannel::reportNumChannelConnect);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_CHANNEL_READINESS_TIME, "The minimum time it took to transition a channel to the READY state.", "us", this, GcpManagedChannel::reportMinReadinessTime);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_AVG_CHANNEL_READINESS_TIME, "The average time it took to transition a channel to the READY state.", "us", this, GcpManagedChannel::reportAvgReadinessTime);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_CHANNEL_READINESS_TIME, "The maximum time it took to transition a channel to the READY state.", "us", this, GcpManagedChannel::reportMaxReadinessTime);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_ACTIVE_STREAMS, "The minimum number of active streams on any channel.", "1", this, GcpManagedChannel::reportMinActiveStreams);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_ACTIVE_STREAMS, "The maximum number of active streams on any channel.", "1", this, GcpManagedChannel::reportMaxActiveStreams);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_TOTAL_ACTIVE_STREAMS, "The minimum total number of active streams across all channels.", "1", this, GcpManagedChannel::reportMinTotalActiveStreams);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_TOTAL_ACTIVE_STREAMS, "The maximum total number of active streams across all channels.", "1", this, GcpManagedChannel::reportMaxTotalActiveStreams);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_AFFINITY, "The minimum number of affinity count on any channel.", "1", this, GcpManagedChannel::reportMinAffinity);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_AFFINITY, "The maximum number of affinity count on any channel.", "1", this, GcpManagedChannel::reportMaxAffinity);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_NUM_AFFINITY, "The total number of affinity count across all channels.", "1", this, GcpManagedChannel::reportNumAffinity);
        this.createDerivedLongGaugeTimeSeriesWithResult(GcpMetricsConstants.METRIC_MIN_CALLS, "The minimum number of completed calls on any channel.", "1", this, GcpManagedChannel::reportMinOkCalls, GcpManagedChannel::reportMinErrCalls);
        this.createDerivedLongGaugeTimeSeriesWithResult(GcpMetricsConstants.METRIC_MAX_CALLS, "The maximum number of completed calls on any channel.", "1", this, GcpManagedChannel::reportMaxOkCalls, GcpManagedChannel::reportMaxErrCalls);
        this.createDerivedLongCumulativeTimeSeriesWithResult(GcpMetricsConstants.METRIC_NUM_CALLS_COMPLETED, "The number of calls completed across all channels.", "1", this, GcpManagedChannel::reportTotalOkCalls, GcpManagedChannel::reportTotalErrCalls);
        this.createDerivedLongCumulativeTimeSeriesWithResult(GcpMetricsConstants.METRIC_NUM_FALLBACKS, "The number of calls that had fallback to another channel.", "1", this, GcpManagedChannel::reportSucceededFallbacks, GcpManagedChannel::reportFailedFallbacks);
        this.createDerivedLongCumulativeTimeSeries(GcpMetricsConstants.METRIC_NUM_UNRESPONSIVE_DETECTIONS, "The number of unresponsive connections detected.", "1", this, GcpManagedChannel::reportUnresponsiveDetectionCount);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_UNRESPONSIVE_DETECTION_TIME, "The minimum time it took to detect an unresponsive connection.", "ms", this, GcpManagedChannel::reportMinUnresponsiveMs);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_UNRESPONSIVE_DETECTION_TIME, "The maximum time it took to detect an unresponsive connection.", "ms", this, GcpManagedChannel::reportMaxUnresponsiveMs);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_UNRESPONSIVE_DROPPED_CALLS, "The minimum calls dropped before detection of an unresponsive connection.", "ms", this, GcpManagedChannel::reportMinUnresponsiveDrops);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_UNRESPONSIVE_DROPPED_CALLS, "The maximum calls dropped before detection of an unresponsive connection.", "ms", this, GcpManagedChannel::reportMaxUnresponsiveDrops);
    }

    private void logGauge(String key, long value) {
        logger.fine(this.log("stat: %s = %d", key, value));
    }

    private void logCumulative(String key, long value) {
        logger.fine(this.log(() -> {
            Long prevValue = this.cumulativeMetricValues.put(key, value);
            long logValue = prevValue == null ? value : value - prevValue;
            return String.format("stat: %s = %d", key, logValue);
        }));
    }

    @VisibleForTesting
    void logMetrics() {
        this.logMetricsOptions();
        this.logChannelsStats();
        this.reportMinReadyChannels();
        this.reportMaxReadyChannels();
        this.reportMaxChannels();
        this.reportMaxAllowedChannels();
        this.reportNumChannelDisconnect();
        this.reportNumChannelConnect();
        this.reportMinReadinessTime();
        this.reportAvgReadinessTime();
        this.reportMaxReadinessTime();
        this.reportMinActiveStreams();
        this.reportMaxActiveStreams();
        this.reportMinTotalActiveStreams();
        this.reportMaxTotalActiveStreams();
        this.reportMinAffinity();
        this.reportMaxAffinity();
        this.reportNumAffinity();
        this.reportMinOkCalls();
        this.reportMinErrCalls();
        this.reportMaxOkCalls();
        this.reportMaxErrCalls();
        this.reportTotalOkCalls();
        this.reportTotalErrCalls();
        this.reportSucceededFallbacks();
        this.reportFailedFallbacks();
        this.reportUnresponsiveDetectionCount();
        this.reportMinUnresponsiveMs();
        this.reportMaxUnresponsiveMs();
        this.reportMinUnresponsiveDrops();
        this.reportMaxUnresponsiveDrops();
    }

    private MetricOptions createMetricOptions(String description, List<LabelKey> labelKeys, String unit) {
        return MetricOptions.builder().setDescription(description).setLabelKeys(labelKeys).setUnit(unit).build();
    }

    private <T> void createDerivedLongGaugeTimeSeries(String name, String description, String unit, T obj, ToLongFunction<T> func) {
        DerivedLongGauge metric = this.metricRegistry.addDerivedLongGauge(this.metricPrefix + name, this.createMetricOptions(description, this.labelKeys, unit));
        metric.removeTimeSeries(this.labelValues);
        metric.createTimeSeries(this.labelValues, obj, func);
    }

    private <T> void createDerivedLongGaugeTimeSeriesWithResult(String name, String description, String unit, T obj, ToLongFunction<T> funcSucc, ToLongFunction<T> funcErr) {
        DerivedLongGauge metric = this.metricRegistry.addDerivedLongGauge(this.metricPrefix + name, this.createMetricOptions(description, this.labelKeysWithResult, unit));
        metric.removeTimeSeries(this.labelValuesSuccess);
        metric.createTimeSeries(this.labelValuesSuccess, obj, funcSucc);
        metric.removeTimeSeries(this.labelValuesError);
        metric.createTimeSeries(this.labelValuesError, obj, funcErr);
    }

    private <T> void createDerivedLongCumulativeTimeSeries(String name, String description, String unit, T obj, ToLongFunction<T> func) {
        DerivedLongCumulative metric = this.metricRegistry.addDerivedLongCumulative(this.metricPrefix + name, this.createMetricOptions(description, this.labelKeys, unit));
        metric.removeTimeSeries(this.labelValues);
        metric.createTimeSeries(this.labelValues, obj, func);
    }

    private <T> void createDerivedLongCumulativeTimeSeriesWithResult(String name, String description, String unit, T obj, ToLongFunction<T> funcSucc, ToLongFunction<T> funcErr) {
        DerivedLongCumulative metric = this.metricRegistry.addDerivedLongCumulative(this.metricPrefix + name, this.createMetricOptions(description, this.labelKeysWithResult, unit));
        metric.removeTimeSeries(this.labelValuesSuccess);
        metric.createTimeSeries(this.labelValuesSuccess, obj, funcSucc);
        metric.removeTimeSeries(this.labelValuesError);
        metric.createTimeSeries(this.labelValuesError, obj, funcErr);
    }

    private long reportMaxChannels() {
        int value = this.getNumberOfChannels();
        this.logGauge(GcpMetricsConstants.METRIC_MAX_CHANNELS, value);
        return value;
    }

    private long reportMaxAllowedChannels() {
        this.logGauge(GcpMetricsConstants.METRIC_MAX_ALLOWED_CHANNELS, this.maxSize);
        return this.maxSize;
    }

    private long reportMinReadyChannels() {
        int value = this.minReadyChannels;
        this.minReadyChannels = this.readyChannels.get();
        this.logGauge(GcpMetricsConstants.METRIC_MIN_READY_CHANNELS, value);
        return value;
    }

    private long reportMaxReadyChannels() {
        int value = this.maxReadyChannels;
        this.maxReadyChannels = this.readyChannels.get();
        this.logGauge(GcpMetricsConstants.METRIC_MAX_READY_CHANNELS, value);
        return value;
    }

    private long reportNumChannelConnect() {
        long value = this.numChannelConnect.get();
        this.logCumulative(GcpMetricsConstants.METRIC_NUM_CHANNEL_CONNECT, value);
        return value;
    }

    private long reportNumChannelDisconnect() {
        long value = this.numChannelDisconnect.get();
        this.logCumulative(GcpMetricsConstants.METRIC_NUM_CHANNEL_DISCONNECT, value);
        return value;
    }

    private long reportMinReadinessTime() {
        long value = this.minReadinessTime;
        this.minReadinessTime = 0L;
        this.logGauge(GcpMetricsConstants.METRIC_MIN_CHANNEL_READINESS_TIME, value);
        return value;
    }

    private long reportAvgReadinessTime() {
        long value = 0L;
        long total = this.totalReadinessTime.getAndSet(0L);
        long occ = this.readinessTimeOccurrences.getAndSet(0L);
        if (occ != 0L) {
            value = total / occ;
        }
        this.logGauge(GcpMetricsConstants.METRIC_AVG_CHANNEL_READINESS_TIME, value);
        return value;
    }

    private long reportMaxReadinessTime() {
        long value = this.maxReadinessTime;
        this.maxReadinessTime = 0L;
        this.logGauge(GcpMetricsConstants.METRIC_MAX_CHANNEL_READINESS_TIME, value);
        return value;
    }

    private int reportMinActiveStreams() {
        int value = this.minActiveStreams;
        this.minActiveStreams = this.channelRefs.stream().mapToInt(ChannelRef::getActiveStreamsCount).min().orElse(0);
        this.logGauge(GcpMetricsConstants.METRIC_MIN_ACTIVE_STREAMS, value);
        return value;
    }

    private int reportMaxActiveStreams() {
        int value = this.maxActiveStreams;
        this.maxActiveStreams = this.channelRefs.stream().mapToInt(ChannelRef::getActiveStreamsCount).max().orElse(0);
        this.logGauge(GcpMetricsConstants.METRIC_MAX_ACTIVE_STREAMS, value);
        return value;
    }

    private int reportMinTotalActiveStreams() {
        int value = this.minTotalActiveStreams;
        this.minTotalActiveStreams = this.totalActiveStreams.get();
        this.logGauge(GcpMetricsConstants.METRIC_MIN_TOTAL_ACTIVE_STREAMS, value);
        return value;
    }

    private int reportMaxTotalActiveStreams() {
        int value = this.maxTotalActiveStreams;
        this.maxTotalActiveStreams = this.totalActiveStreams.get();
        this.logGauge(GcpMetricsConstants.METRIC_MAX_TOTAL_ACTIVE_STREAMS, value);
        return value;
    }

    private int reportMinAffinity() {
        int value = this.minAffinity.getAndSet(this.channelRefs.stream().mapToInt(ChannelRef::getAffinityCount).min().orElse(0));
        this.logGauge(GcpMetricsConstants.METRIC_MIN_AFFINITY, value);
        return value;
    }

    private int reportMaxAffinity() {
        int value = this.maxAffinity.getAndSet(this.channelRefs.stream().mapToInt(ChannelRef::getAffinityCount).max().orElse(0));
        this.logGauge(GcpMetricsConstants.METRIC_MAX_AFFINITY, value);
        return value;
    }

    private int reportNumAffinity() {
        int value = this.totalAffinityCount.get();
        this.logGauge(GcpMetricsConstants.METRIC_NUM_AFFINITY, value);
        return value;
    }

    private synchronized long reportMinOkCalls() {
        this.minOkReported = true;
        this.calcMinMaxOkCalls();
        this.logGauge(GcpMetricsConstants.METRIC_MIN_CALLS + "_ok", this.minOkCalls);
        return this.minOkCalls;
    }

    private synchronized long reportMaxOkCalls() {
        this.maxOkReported = true;
        this.calcMinMaxOkCalls();
        this.logGauge(GcpMetricsConstants.METRIC_MAX_CALLS + "_ok", this.maxOkCalls);
        return this.maxOkCalls;
    }

    private long reportTotalOkCalls() {
        long value = this.totalOkCalls.get();
        this.logCumulative(GcpMetricsConstants.METRIC_NUM_CALLS_COMPLETED + "_ok", value);
        return value;
    }

    private LongSummaryStatistics calcStatsAndLog(String logLabel, ToLongFunction<ChannelRef> func) {
        StringBuilder str = new StringBuilder(logLabel + ": [");
        LongSummaryStatistics stats = this.channelRefs.stream().mapToLong(ch -> {
            long count = func.applyAsLong(ch);
            if (str.charAt(str.length() - 1) != '[') {
                str.append(", ");
            }
            str.append(count);
            return count;
        }).summaryStatistics();
        str.append("]");
        logger.fine(this.log(str.toString()));
        return stats;
    }

    private void calcMinMaxOkCalls() {
        if (this.minOkReported && this.maxOkReported) {
            this.minOkReported = false;
            this.maxOkReported = false;
            return;
        }
        LongSummaryStatistics stats = this.calcStatsAndLog("Ok calls", (ToLongFunction<ChannelRef>)((ToLongFunction)ChannelRef::getAndResetOkCalls));
        this.minOkCalls = stats.getMin();
        this.maxOkCalls = stats.getMax();
    }

    private synchronized long reportMinErrCalls() {
        this.minErrReported = true;
        this.calcMinMaxErrCalls();
        this.logGauge(GcpMetricsConstants.METRIC_MIN_CALLS + "_err", this.minErrCalls);
        return this.minErrCalls;
    }

    private synchronized long reportMaxErrCalls() {
        this.maxErrReported = true;
        this.calcMinMaxErrCalls();
        this.logGauge(GcpMetricsConstants.METRIC_MAX_CALLS + "_err", this.maxErrCalls);
        return this.maxErrCalls;
    }

    private long reportTotalErrCalls() {
        long value = this.totalErrCalls.get();
        this.logCumulative(GcpMetricsConstants.METRIC_NUM_CALLS_COMPLETED + "_err", value);
        return value;
    }

    private void calcMinMaxErrCalls() {
        if (this.minErrReported && this.maxErrReported) {
            this.minErrReported = false;
            this.maxErrReported = false;
            return;
        }
        LongSummaryStatistics stats = this.calcStatsAndLog("Failed calls", (ToLongFunction<ChannelRef>)((ToLongFunction)ChannelRef::getAndResetErrCalls));
        this.minErrCalls = stats.getMin();
        this.maxErrCalls = stats.getMax();
    }

    private long reportSucceededFallbacks() {
        long value = this.fallbacksSucceeded.get();
        this.logCumulative(GcpMetricsConstants.METRIC_NUM_FALLBACKS + "_ok", value);
        return value;
    }

    private long reportFailedFallbacks() {
        long value = this.fallbacksFailed.get();
        this.logCumulative(GcpMetricsConstants.METRIC_NUM_FALLBACKS + "_fail", value);
        return value;
    }

    private long reportUnresponsiveDetectionCount() {
        long value = this.unresponsiveDetectionCount.get();
        this.logCumulative(GcpMetricsConstants.METRIC_NUM_UNRESPONSIVE_DETECTIONS, value);
        return value;
    }

    private long reportMinUnresponsiveMs() {
        long value = this.minUnresponsiveMs;
        this.minUnresponsiveMs = 0L;
        this.logGauge(GcpMetricsConstants.METRIC_MIN_UNRESPONSIVE_DETECTION_TIME, value);
        return value;
    }

    private long reportMaxUnresponsiveMs() {
        long value = this.maxUnresponsiveMs;
        this.maxUnresponsiveMs = 0L;
        this.logGauge(GcpMetricsConstants.METRIC_MAX_UNRESPONSIVE_DETECTION_TIME, value);
        return value;
    }

    private long reportMinUnresponsiveDrops() {
        long value = this.minUnresponsiveDrops;
        this.minUnresponsiveDrops = 0L;
        this.logGauge(GcpMetricsConstants.METRIC_MIN_UNRESPONSIVE_DROPPED_CALLS, value);
        return value;
    }

    private long reportMaxUnresponsiveDrops() {
        long value = this.maxUnresponsiveDrops;
        this.maxUnresponsiveDrops = 0L;
        this.logGauge(GcpMetricsConstants.METRIC_MAX_UNRESPONSIVE_DROPPED_CALLS, value);
        return value;
    }

    private void incReadyChannels() {
        this.numChannelConnect.incrementAndGet();
        int newReady = this.readyChannels.incrementAndGet();
        if (this.maxReadyChannels < newReady) {
            this.maxReadyChannels = newReady;
        }
    }

    private void decReadyChannels() {
        this.numChannelDisconnect.incrementAndGet();
        int newReady = this.readyChannels.decrementAndGet();
        if (this.minReadyChannels > newReady) {
            this.minReadyChannels = newReady;
        }
    }

    private void saveReadinessTime(long readinessNanos) {
        long readinessTimeUs = readinessNanos / 1000L;
        if (this.minReadinessTime == 0L || readinessTimeUs < this.minReadinessTime) {
            this.minReadinessTime = readinessTimeUs;
        }
        if (readinessTimeUs > this.maxReadinessTime) {
            this.maxReadinessTime = readinessTimeUs;
        }
        this.totalReadinessTime.addAndGet(readinessTimeUs);
        this.readinessTimeOccurrences.incrementAndGet();
    }

    private void recordUnresponsiveDetection(long nanos, long dropCount) {
        this.unresponsiveDetectionCount.incrementAndGet();
        long ms = nanos / 1000000L;
        if (this.minUnresponsiveMs == 0L || this.minUnresponsiveMs > ms) {
            this.minUnresponsiveMs = ms;
        }
        if (this.maxUnresponsiveMs < ms) {
            this.maxUnresponsiveMs = ms;
        }
        if (this.minUnresponsiveDrops == 0L || this.minUnresponsiveDrops > dropCount) {
            this.minUnresponsiveDrops = dropCount;
        }
        if (this.maxUnresponsiveDrops < dropCount) {
            this.maxUnresponsiveDrops = dropCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWhenStateChanged(ConnectivityState source, Runnable callback) {
        if (this.getState(false).equals((Object)source)) {
            GcpManagedChannel gcpManagedChannel = this;
            synchronized (gcpManagedChannel) {
                this.stateChangeCallbacks.add(callback);
            }
            return;
        }
        try {
            this.stateNotificationExecutor.execute(callback);
        }
        catch (RejectedExecutionException e) {
            logger.fine(this.log("State notification change task rejected: %s", e.getMessage()));
        }
    }

    private synchronized void executeStateChangeCallbacks() {
        List<Runnable> callbacksToTrigger = this.stateChangeCallbacks;
        this.stateChangeCallbacks = new LinkedList<Runnable>();
        try {
            callbacksToTrigger.forEach(this.stateNotificationExecutor::execute);
        }
        catch (RejectedExecutionException e) {
            logger.fine(this.log("State notification change task rejected: %s", e.getMessage()));
        }
    }

    void processChannelStateChange(int channelId, ConnectivityState state) {
        this.executeStateChangeCallbacks();
        if (!this.fallbackEnabled) {
            return;
        }
        if (state == ConnectivityState.READY || state == ConnectivityState.IDLE) {
            this.fallbackMap.remove(channelId);
            return;
        }
        this.fallbackMap.putIfAbsent(channelId, new ConcurrentHashMap());
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getNumberOfChannels() {
        return this.channelRefs.size();
    }

    public int getStreamsLowWatermark() {
        return this.maxConcurrentStreamsLowWatermark;
    }

    public int getMinActiveStreams() {
        return this.channelRefs.stream().mapToInt(ChannelRef::getActiveStreamsCount).min().orElse(0);
    }

    public int getMaxActiveStreams() {
        return this.channelRefs.stream().mapToInt(ChannelRef::getActiveStreamsCount).max().orElse(0);
    }

    protected ChannelRef getChannelRefForBind() {
        ChannelRef channelRef;
        if (this.options.getChannelPoolOptions() != null && this.options.getChannelPoolOptions().isUseRoundRobinOnBind()) {
            channelRef = this.getChannelRefRoundRobin();
            logger.finest(this.log("Channel %d picked for bind operation using round-robin.", channelRef.getId()));
        } else {
            channelRef = this.getChannelRef(null);
            logger.finest(this.log("Channel %d picked for bind operation.", channelRef.getId()));
        }
        return channelRef;
    }

    protected synchronized ChannelRef getChannelRefRoundRobin() {
        if (this.channelRefs.size() < this.maxSize) {
            return this.createNewChannel();
        }
        Integer n = this.bindingIndex;
        Integer n2 = this.bindingIndex = Integer.valueOf(this.bindingIndex + 1);
        if (this.bindingIndex >= this.channelRefs.size()) {
            this.bindingIndex = 0;
        }
        return this.channelRefs.get(this.bindingIndex);
    }

    protected ChannelRef getChannelRef(@Nullable String key) {
        if (key == null || key.isEmpty()) {
            return this.pickLeastBusyChannel(false);
        }
        ChannelRef mappedChannel = this.affinityKeyToChannelRef.get(key);
        if (mappedChannel == null) {
            ChannelRef channelRef = this.pickLeastBusyChannel(false);
            this.bind(channelRef, Collections.singletonList(key));
            return channelRef;
        }
        if (!this.fallbackEnabled) {
            return mappedChannel;
        }
        Map<String, Integer> tempMap = this.fallbackMap.get(mappedChannel.getId());
        if (tempMap == null) {
            return mappedChannel;
        }
        Integer channelId = tempMap.get(key);
        if (channelId != null && !this.fallbackMap.containsKey(channelId)) {
            logger.finest(this.log("Using fallback channel: %d -> %d", mappedChannel.getId(), channelId));
            this.fallbacksSucceeded.incrementAndGet();
            return this.channelRefs.get(channelId);
        }
        ChannelRef channelRef = this.pickLeastBusyChannel(true);
        if (!this.fallbackMap.containsKey(channelRef.getId()) && channelRef.getActiveStreamsCount() < 100) {
            if (channelRef.getId() != mappedChannel.getId()) {
                logger.finest(this.log("Setting fallback channel: %d -> %d", mappedChannel.getId(), channelRef.getId()));
                this.fallbacksSucceeded.incrementAndGet();
                tempMap.put(key, channelRef.getId());
            }
            return channelRef;
        }
        logger.finest(this.log("Failed to find fallback for channel %d", mappedChannel.getId()));
        this.fallbacksFailed.incrementAndGet();
        if (channelId != null) {
            return this.channelRefs.get(channelId);
        }
        return mappedChannel;
    }

    private synchronized ChannelRef createNewChannel() {
        int size = this.channelRefs.size();
        ChannelRef channelRef = new ChannelRef(this.delegateChannelBuilder.build(), size);
        this.channelRefs.add(channelRef);
        logger.finer(this.log("Channel %d created.", channelRef.getId()));
        return channelRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ChannelRef createFirstChannel() {
        if (!this.channelRefs.isEmpty()) {
            return null;
        }
        GcpManagedChannel gcpManagedChannel = this;
        synchronized (gcpManagedChannel) {
            if (this.channelRefs.isEmpty()) {
                return this.createNewChannel();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ChannelRef tryCreateNewChannel() {
        if (this.channelRefs.size() >= this.maxSize) {
            return null;
        }
        GcpManagedChannel gcpManagedChannel = this;
        synchronized (gcpManagedChannel) {
            if (this.channelRefs.size() < this.maxSize) {
                return this.createNewChannel();
            }
        }
        return null;
    }

    private ChannelRef pickLeastBusyChannel(boolean forFallback) {
        ChannelRef newChannel;
        ChannelRef first = this.createFirstChannel();
        if (first != null) {
            return first;
        }
        ChannelRef channelCandidate = this.channelRefs.get(0);
        int minStreams = channelCandidate.getActiveStreamsCount();
        ChannelRef readyCandidate = null;
        int readyMinStreams = Integer.MAX_VALUE;
        for (ChannelRef channelRef : this.channelRefs) {
            int cnt = channelRef.getActiveStreamsCount();
            if (cnt < minStreams) {
                minStreams = cnt;
                channelCandidate = channelRef;
            }
            if (cnt >= readyMinStreams || this.fallbackMap.containsKey(channelRef.getId()) || channelRef.getActiveStreamsCount() >= 100) continue;
            readyMinStreams = cnt;
            readyCandidate = channelRef;
        }
        if (!this.fallbackEnabled) {
            if (this.channelRefs.size() < this.maxSize && minStreams >= this.maxConcurrentStreamsLowWatermark && (newChannel = this.tryCreateNewChannel()) != null) {
                return newChannel;
            }
            return channelCandidate;
        }
        if (this.channelRefs.size() < this.maxSize && readyMinStreams >= this.maxConcurrentStreamsLowWatermark && (newChannel = this.tryCreateNewChannel()) != null) {
            if (!forFallback && readyCandidate == null) {
                logger.finest(this.log("Fallback to newly created channel %d", newChannel.getId()));
                this.fallbacksSucceeded.incrementAndGet();
            }
            return newChannel;
        }
        if (readyCandidate != null) {
            if (!forFallback && readyCandidate.getId() != channelCandidate.getId()) {
                logger.finest(this.log("Picking fallback channel: %d -> %d", channelCandidate.getId(), readyCandidate.getId()));
                this.fallbacksSucceeded.incrementAndGet();
            }
            return readyCandidate;
        }
        if (!forFallback) {
            logger.finest(this.log("Failed to find fallback for channel %d", channelCandidate.getId()));
            this.fallbacksFailed.incrementAndGet();
        }
        return channelCandidate;
    }

    public String authority() {
        if (!this.channelRefs.isEmpty()) {
            return this.channelRefs.get(0).getChannel().authority();
        }
        ManagedChannel channel = this.delegateChannelBuilder.build();
        String authority = channel.authority();
        channel.shutdownNow();
        return authority;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        AffinityConfig affinity = this.methodToAffinity.get(methodDescriptor.getFullMethodName());
        if (affinity == null || ((Boolean)callOptions.getOption(DISABLE_AFFINITY_KEY)).booleanValue() || ((Boolean)DISABLE_AFFINITY_CTX_KEY.get(Context.current())).booleanValue()) {
            return new GcpClientCall.SimpleGcpClientCall<ReqT, RespT>(this.getChannelRef(null), methodDescriptor, callOptions);
        }
        return new GcpClientCall<ReqT, RespT>(this, methodDescriptor, callOptions, affinity);
    }

    public ManagedChannel shutdownNow() {
        logger.finer(this.log("Shutdown now started."));
        for (ChannelRef channelRef : this.channelRefs) {
            if (channelRef.getChannel().isTerminated()) continue;
            channelRef.getChannel().shutdownNow();
        }
        if (this.logMetricService != null && !this.logMetricService.isTerminated()) {
            this.logMetricService.shutdownNow();
        }
        if (!this.stateNotificationExecutor.isTerminated()) {
            this.stateNotificationExecutor.shutdownNow();
        }
        return this;
    }

    public ManagedChannel shutdown() {
        logger.finer(this.log("Shutdown started."));
        for (ChannelRef channelRef : this.channelRefs) {
            channelRef.getChannel().shutdown();
        }
        if (this.logMetricService != null) {
            this.logMetricService.shutdown();
        }
        this.stateNotificationExecutor.shutdown();
        return this;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        for (ChannelRef channelRef : this.channelRefs) {
            if (channelRef.getChannel().isTerminated()) continue;
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            channelRef.getChannel().awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        long awaitTimeNanos = endTimeNanos - System.nanoTime();
        if (this.logMetricService != null && awaitTimeNanos > 0L) {
            this.logMetricService.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        if ((awaitTimeNanos = endTimeNanos - System.nanoTime()) > 0L) {
            this.stateNotificationExecutor.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    public boolean isShutdown() {
        for (ChannelRef channelRef : this.channelRefs) {
            if (channelRef.getChannel().isShutdown()) continue;
            return false;
        }
        if (this.logMetricService != null) {
            return this.logMetricService.isShutdown();
        }
        return this.stateNotificationExecutor.isShutdown();
    }

    public boolean isTerminated() {
        for (ChannelRef channelRef : this.channelRefs) {
            if (channelRef.getChannel().isTerminated()) continue;
            return false;
        }
        if (this.logMetricService != null) {
            return this.logMetricService.isTerminated();
        }
        return this.stateNotificationExecutor.isTerminated();
    }

    public ConnectivityState getState(boolean requestConnection) {
        if (requestConnection && this.getNumberOfChannels() == 0) {
            this.createFirstChannel();
        }
        int ready = 0;
        int idle = 0;
        int connecting = 0;
        int transientFailure = 0;
        int shutdown = 0;
        for (ChannelRef channelRef : this.channelRefs) {
            ConnectivityState cur = channelRef.getChannel().getState(requestConnection);
            switch (cur) {
                case READY: {
                    ++ready;
                    break;
                }
                case SHUTDOWN: {
                    ++shutdown;
                    break;
                }
                case TRANSIENT_FAILURE: {
                    ++transientFailure;
                    break;
                }
                case CONNECTING: {
                    ++connecting;
                    break;
                }
                case IDLE: {
                    ++idle;
                }
            }
        }
        if (ready > 0) {
            return ConnectivityState.READY;
        }
        if (connecting > 0) {
            return ConnectivityState.CONNECTING;
        }
        if (transientFailure > 0) {
            return ConnectivityState.TRANSIENT_FAILURE;
        }
        if (idle > 0) {
            return ConnectivityState.IDLE;
        }
        if (shutdown > 0) {
            return ConnectivityState.SHUTDOWN;
        }
        return ConnectivityState.IDLE;
    }

    protected void bind(ChannelRef channelRef, List<String> affinityKeys) {
        if (channelRef == null || affinityKeys == null) {
            return;
        }
        logger.finest(this.log("Binding %d key(s) to channel %d: [%s]", affinityKeys.size(), channelRef.getId(), String.join((CharSequence)", ", affinityKeys)));
        for (String affinityKey : affinityKeys) {
            while (this.affinityKeyToChannelRef.putIfAbsent(affinityKey, channelRef) != null) {
                this.unbind(Collections.singletonList(affinityKey));
            }
            channelRef.affinityCountIncr();
        }
    }

    protected void unbind(List<String> affinityKeys) {
        if (affinityKeys == null) {
            return;
        }
        for (String affinityKey : affinityKeys) {
            ChannelRef channelRef = this.affinityKeyToChannelRef.remove(affinityKey);
            if (channelRef != null) {
                channelRef.affinityCountDecr();
                logger.finest(this.log("Unbinding key %s from channel %d.", affinityKey, channelRef.getId()));
                continue;
            }
            logger.finest(this.log("Unbinding key %s but it wasn't bound.", affinityKey));
        }
    }

    private void loadApiConfig(ApiConfig apiConfig) {
        int lowWatermark;
        if (apiConfig == null) {
            return;
        }
        if (apiConfig.getChannelPool().getMaxSize() > 0) {
            this.maxSize = apiConfig.getChannelPool().getMaxSize();
        }
        if ((lowWatermark = apiConfig.getChannelPool().getMaxConcurrentStreamsLowWatermark()) >= 0 && lowWatermark <= 100) {
            this.maxConcurrentStreamsLowWatermark = lowWatermark;
        }
        for (MethodConfig method : apiConfig.getMethodList()) {
            if (method.getAffinity().equals(AffinityConfig.getDefaultInstance())) continue;
            for (String methodName : method.getNameList()) {
                this.methodToAffinity.put(methodName, method.getAffinity());
            }
        }
    }

    @VisibleForTesting
    static List<String> getKeysFromMessage(MessageOrBuilder msg, String name) {
        int currentLength = name.indexOf(46);
        String currentName = name;
        if (currentLength != -1) {
            currentName = name.substring(0, currentLength);
        }
        ArrayList<String> keys = new ArrayList<String>();
        Map obs = msg.getAllFields();
        for (Map.Entry entry : obs.entrySet()) {
            List list;
            if (!((Descriptors.FieldDescriptor)entry.getKey()).getName().equals(currentName)) continue;
            if (currentLength == -1 && entry.getValue() instanceof String) {
                keys.add(entry.getValue().toString());
                continue;
            }
            if (currentLength != -1 && entry.getValue() instanceof MessageOrBuilder) {
                keys.addAll(GcpManagedChannel.getKeysFromMessage((MessageOrBuilder)entry.getValue(), name.substring(currentLength + 1)));
                continue;
            }
            if (currentLength == -1 || !(entry.getValue() instanceof List) || (list = (List)entry.getValue()).isEmpty() || !(list.get(0) instanceof MessageOrBuilder)) continue;
            for (Object item : list) {
                keys.addAll(GcpManagedChannel.getKeysFromMessage((MessageOrBuilder)item, name.substring(currentLength + 1)));
            }
        }
        return keys;
    }

    @Nullable
    protected <ReqT, RespT> List<String> checkKeys(Object message, boolean isReq, MethodDescriptor<ReqT, RespT> methodDescriptor) {
        if (!(message instanceof MessageOrBuilder)) {
            return null;
        }
        AffinityConfig affinity = this.methodToAffinity.get(methodDescriptor.getFullMethodName());
        if (affinity != null) {
            AffinityConfig.Command cmd = affinity.getCommand();
            String keyName = affinity.getAffinityKey();
            List<String> keys = GcpManagedChannel.getKeysFromMessage((MessageOrBuilder)message, keyName);
            if (isReq && (cmd == AffinityConfig.Command.UNBIND || cmd == AffinityConfig.Command.BOUND)) {
                if (keys.size() > 1) {
                    throw new IllegalStateException("Duplicate affinity key in the request message");
                }
                return keys;
            }
            if (!isReq && cmd == AffinityConfig.Command.BIND) {
                return keys;
            }
        }
        return null;
    }

    protected class ChannelRef {
        private final ManagedChannel delegate;
        private final int channelId;
        private final AtomicInteger affinityCount;
        private final AtomicInteger activeStreamsCount;
        private long lastResponseNanos = System.nanoTime();
        private final AtomicInteger deadlineExceededCount = new AtomicInteger();
        private final AtomicLong okCalls = new AtomicLong();
        private final AtomicLong errCalls = new AtomicLong();

        protected ChannelRef(ManagedChannel channel, int channelId) {
            this(channel, channelId, 0, 0);
        }

        protected ChannelRef(ManagedChannel channel, int channelId, int affinityCount, int activeStreamsCount) {
            this.delegate = channel;
            this.channelId = channelId;
            this.affinityCount = new AtomicInteger(affinityCount);
            this.activeStreamsCount = new AtomicInteger(activeStreamsCount);
            new ChannelStateMonitor(channel, channelId);
        }

        protected ManagedChannel getChannel() {
            return this.delegate;
        }

        protected int getId() {
            return this.channelId;
        }

        protected void affinityCountIncr() {
            int count = this.affinityCount.incrementAndGet();
            GcpManagedChannel.this.maxAffinity.getAndUpdate(currentMax -> Math.max(currentMax, count));
            GcpManagedChannel.this.totalAffinityCount.incrementAndGet();
        }

        protected void affinityCountDecr() {
            int count = this.affinityCount.decrementAndGet();
            GcpManagedChannel.this.minAffinity.getAndUpdate(currentMin -> Math.min(currentMin, count));
            GcpManagedChannel.this.totalAffinityCount.decrementAndGet();
        }

        protected void activeStreamsCountIncr() {
            int actStreams = this.activeStreamsCount.incrementAndGet();
            if (GcpManagedChannel.this.maxActiveStreams < actStreams) {
                GcpManagedChannel.this.maxActiveStreams = actStreams;
            }
            int totalActStreams = GcpManagedChannel.this.totalActiveStreams.incrementAndGet();
            if (GcpManagedChannel.this.maxTotalActiveStreams < totalActStreams) {
                GcpManagedChannel.this.maxTotalActiveStreams = totalActStreams;
            }
        }

        protected void activeStreamsCountDecr(long startNanos, Status status, boolean fromClientSide) {
            int actStreams = this.activeStreamsCount.decrementAndGet();
            if (GcpManagedChannel.this.minActiveStreams > actStreams) {
                GcpManagedChannel.this.minActiveStreams = actStreams;
            }
            int totalActStreams = GcpManagedChannel.this.totalActiveStreams.decrementAndGet();
            if (GcpManagedChannel.this.minTotalActiveStreams > totalActStreams) {
                GcpManagedChannel.this.minTotalActiveStreams = totalActStreams;
            }
            if (status.isOk()) {
                this.okCalls.incrementAndGet();
                GcpManagedChannel.this.totalOkCalls.incrementAndGet();
            } else {
                this.errCalls.incrementAndGet();
                GcpManagedChannel.this.totalErrCalls.incrementAndGet();
            }
            if (GcpManagedChannel.this.unresponsiveDetectionEnabled) {
                this.detectUnresponsiveConnection(startNanos, status, fromClientSide);
            }
        }

        protected void messageReceived() {
            this.lastResponseNanos = System.nanoTime();
            this.deadlineExceededCount.set(0);
        }

        protected int getAffinityCount() {
            return this.affinityCount.get();
        }

        protected int getActiveStreamsCount() {
            return this.activeStreamsCount.get();
        }

        protected long getAndResetOkCalls() {
            return this.okCalls.getAndSet(0L);
        }

        protected long getAndResetErrCalls() {
            return this.errCalls.getAndSet(0L);
        }

        private void detectUnresponsiveConnection(long startNanos, Status status, boolean fromClientSide) {
            if (status.getCode().equals((Object)Status.Code.DEADLINE_EXCEEDED)) {
                if (startNanos < this.lastResponseNanos) {
                    return;
                }
                if (this.deadlineExceededCount.incrementAndGet() >= GcpManagedChannel.this.unresponsiveDropCount && this.msSinceLastResponse() >= (long)GcpManagedChannel.this.unresponsiveMs) {
                    this.maybeReconnectUnresponsive();
                }
                return;
            }
            if (!fromClientSide) {
                this.lastResponseNanos = System.nanoTime();
                this.deadlineExceededCount.set(0);
            }
        }

        private long msSinceLastResponse() {
            return (System.nanoTime() - this.lastResponseNanos) / 1000000L;
        }

        private synchronized void maybeReconnectUnresponsive() {
            long msSinceLastResponse = this.msSinceLastResponse();
            if (this.deadlineExceededCount.get() >= GcpManagedChannel.this.unresponsiveDropCount && msSinceLastResponse >= (long)GcpManagedChannel.this.unresponsiveMs) {
                GcpManagedChannel.this.recordUnresponsiveDetection(System.nanoTime() - this.lastResponseNanos, this.deadlineExceededCount.get());
                logger.finer(GcpManagedChannel.this.log("Channel %d connection is unresponsive for %d ms and %d deadline exceeded calls. Forcing channel to idle state.", new Object[]{this.channelId, msSinceLastResponse, this.deadlineExceededCount.get()}));
                this.delegate.enterIdle();
                this.lastResponseNanos = System.nanoTime();
                this.deadlineExceededCount.set(0);
            }
        }
    }

    private class ChannelStateMonitor
    implements Runnable {
        private final int channelId;
        private final ManagedChannel channel;
        private ConnectivityState currentState;
        private long connectingStartNanos;

        private ChannelStateMonitor(ManagedChannel channel, int channelId) {
            this.channelId = channelId;
            this.channel = channel;
            this.run();
        }

        @Override
        public void run() {
            if (this.channel == null) {
                return;
            }
            boolean requestConnection = this.channelId < GcpManagedChannel.this.minSize;
            ConnectivityState newState = this.channel.getState(requestConnection);
            logger.finer(GcpManagedChannel.this.log("Channel %d state change detected: %s -> %s", new Object[]{this.channelId, this.currentState, newState}));
            if (newState == ConnectivityState.READY && this.currentState != ConnectivityState.READY) {
                GcpManagedChannel.this.incReadyChannels();
                GcpManagedChannel.this.saveReadinessTime(System.nanoTime() - this.connectingStartNanos);
            }
            if (newState != ConnectivityState.READY && this.currentState == ConnectivityState.READY) {
                GcpManagedChannel.this.decReadyChannels();
            }
            if (newState == ConnectivityState.CONNECTING && this.currentState != ConnectivityState.CONNECTING) {
                this.connectingStartNanos = System.nanoTime();
            }
            this.currentState = newState;
            GcpManagedChannel.this.processChannelStateChange(this.channelId, newState);
            if (newState != ConnectivityState.SHUTDOWN) {
                this.channel.notifyWhenStateChanged(newState, (Runnable)this);
            }
        }
    }
}

