/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowReaderIterator
implements Iterator<VectorSchemaRoot> {
    private static final Logger log = LoggerFactory.getLogger(ArrowReaderIterator.class);
    boolean closed = false;
    VectorSchemaRoot current = null;
    ArrowReader reader;

    public ArrowReaderIterator(ArrowReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        try {
            boolean res = this.reader.loadNextBatch();
            if (res) {
                this.current = this.reader.getVectorSchemaRoot();
            } else {
                this.ensureClosed();
            }
            return res;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load the next arrow batch", e);
        }
    }

    @Override
    public VectorSchemaRoot next() {
        VectorSchemaRoot res = this.current;
        this.current = null;
        return res;
    }

    private void ensureClosed() throws IOException {
        if (!this.closed) {
            this.reader.close();
            this.closed = true;
        }
    }
}

