/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import java.util.Optional;
import java.util.OptionalInt;

public class ReadSessionCreatorConfig {
    private final boolean viewsEnabled;
    private final Optional<String> materializationProject;
    private final Optional<String> materializationDataset;
    private final String viewEnabledParamName;
    private final int materializationExpirationTimeInMinutes;
    private final DataFormat readDataFormat;
    private final int maxReadRowsRetries;
    private final OptionalInt maxParallelism;
    private final OptionalInt preferredMinParallelism;
    private final int defaultParallelism;
    private final Optional<String> requestEncodedBase;
    private final Optional<String> bigQueryStorageGrpcEndpoint;
    private final Optional<String> bigQueryHttpEndpoint;
    private final int backgroundParsingThreads;
    private final boolean pushAllFilters;
    private final int prebufferResponses;
    private final int streamsPerPartition;
    private final ArrowSerializationOptions.CompressionCodec arrowCompressionCodec;
    private final Optional<String> traceId;
    private final boolean enableReadSessionCaching;

    ReadSessionCreatorConfig(boolean viewsEnabled, Optional<String> materializationProject, Optional<String> materializationDataset, int materializationExpirationTimeInMinutes, DataFormat readDataFormat, int maxReadRowsRetries, String viewEnabledParamName, OptionalInt maxParallelism, OptionalInt preferredMinParallelism, int defaultParallelism, Optional<String> requestEncodedBase, Optional<String> bigQueryStorageGrpcEndpoint, Optional<String> bigQueryHttpEndpoint, int backgroundParsingThreads, boolean pushAllFilters, int prebufferResponses, int streamsPerPartition, ArrowSerializationOptions.CompressionCodec arrowCompressionCodec, Optional<String> traceId, boolean enableReadSessionCaching) {
        this.viewsEnabled = viewsEnabled;
        this.materializationProject = materializationProject;
        this.materializationDataset = materializationDataset;
        this.viewEnabledParamName = viewEnabledParamName;
        this.materializationExpirationTimeInMinutes = materializationExpirationTimeInMinutes;
        this.readDataFormat = readDataFormat;
        this.maxReadRowsRetries = maxReadRowsRetries;
        this.maxParallelism = maxParallelism;
        this.preferredMinParallelism = preferredMinParallelism;
        this.defaultParallelism = defaultParallelism;
        this.requestEncodedBase = requestEncodedBase;
        this.bigQueryStorageGrpcEndpoint = bigQueryStorageGrpcEndpoint;
        this.bigQueryHttpEndpoint = bigQueryHttpEndpoint;
        this.backgroundParsingThreads = backgroundParsingThreads;
        this.pushAllFilters = pushAllFilters;
        this.prebufferResponses = prebufferResponses;
        this.streamsPerPartition = streamsPerPartition;
        this.arrowCompressionCodec = arrowCompressionCodec;
        this.traceId = traceId;
        this.enableReadSessionCaching = enableReadSessionCaching;
    }

    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    public Optional<String> getMaterializationProject() {
        return this.materializationProject;
    }

    public Optional<String> getMaterializationDataset() {
        return this.materializationDataset;
    }

    public String getViewEnabledParamName() {
        return this.viewEnabledParamName;
    }

    public int getMaterializationExpirationTimeInMinutes() {
        return this.materializationExpirationTimeInMinutes;
    }

    public DataFormat getReadDataFormat() {
        return this.readDataFormat;
    }

    public ArrowSerializationOptions.CompressionCodec getArrowCompressionCodec() {
        return this.arrowCompressionCodec;
    }

    public int getMaxReadRowsRetries() {
        return this.maxReadRowsRetries;
    }

    public OptionalInt getMaxParallelism() {
        return this.maxParallelism;
    }

    public int getDefaultParallelism() {
        return this.defaultParallelism;
    }

    public Optional<String> getRequestEncodedBase() {
        return this.requestEncodedBase;
    }

    public Optional<String> getBigQueryStorageGrpcEndpoint() {
        return this.bigQueryStorageGrpcEndpoint;
    }

    public Optional<String> getBigQueryHttpEndpoint() {
        return this.bigQueryHttpEndpoint;
    }

    public int backgroundParsingThreads() {
        return this.backgroundParsingThreads;
    }

    public boolean getPushAllFilters() {
        return this.pushAllFilters;
    }

    public ReadRowsHelper.Options toReadRowsHelperOptions() {
        return new ReadRowsHelper.Options(this.getMaxReadRowsRetries(), this.getBigQueryStorageGrpcEndpoint(), this.backgroundParsingThreads(), this.getPrebufferResponses());
    }

    public int streamsPerPartition() {
        return this.streamsPerPartition;
    }

    public int getPrebufferResponses() {
        return this.prebufferResponses;
    }

    public Optional<String> getTraceId() {
        return this.traceId;
    }

    public OptionalInt getPreferredMinParallelism() {
        return this.preferredMinParallelism;
    }

    public boolean isReadSessionCachingEnabled() {
        return this.enableReadSessionCaching;
    }
}

