/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.core.ApiFunction;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.cloud.bigquery.connector.common.BigQueryConfig;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.bigquery.connector.common.BigQueryCredentialsSupplier;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.common.base.Objects;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

public class BigQueryClientFactory
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(BigQueryClientFactory.class);
    private static final Map<BigQueryClientFactory, BigQueryReadClient> readClientMap = new HashMap<BigQueryClientFactory, BigQueryReadClient>();
    private static final Map<BigQueryClientFactory, BigQueryWriteClient> writeClientMap = new HashMap<BigQueryClientFactory, BigQueryWriteClient>();
    private final Credentials credentials;
    private final HeaderProvider headerProvider;
    private final BigQueryConfig bqConfig;
    private int cachedHashCode = 0;

    @Inject
    public BigQueryClientFactory(BigQueryCredentialsSupplier bigQueryCredentialsSupplier, HeaderProvider headerProvider, BigQueryConfig bqConfig) {
        this.credentials = bigQueryCredentialsSupplier.getCredentials();
        this.headerProvider = headerProvider;
        this.bqConfig = bqConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigQueryReadClient getBigQueryReadClient() {
        Map<BigQueryClientFactory, BigQueryReadClient> map = readClientMap;
        synchronized (map) {
            if (!readClientMap.containsKey(this)) {
                BigQueryReadClient bigQueryReadClient = this.createBigQueryReadClient(this.bqConfig.getBigQueryStorageGrpcEndpoint(), this.bqConfig.getChannelPoolSize(), this.bqConfig.getFlowControlWindowBytes());
                Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdownBigQueryReadClient(bigQueryReadClient)));
                readClientMap.put(this, bigQueryReadClient);
            }
        }
        return readClientMap.get(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigQueryWriteClient getBigQueryWriteClient() {
        Map<BigQueryClientFactory, BigQueryWriteClient> map = writeClientMap;
        synchronized (map) {
            if (!writeClientMap.containsKey(this)) {
                BigQueryWriteClient bigQueryWriteClient = this.createBigQueryWriteClient(this.bqConfig.getBigQueryStorageGrpcEndpoint());
                Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdownBigQueryWriteClient(bigQueryWriteClient)));
                writeClientMap.put(this, bigQueryWriteClient);
            }
        }
        return writeClientMap.get(this);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.credentials instanceof ExternalAccountCredentials ? Objects.hashCode((Object[])new Object[]{Arrays.hashCode(BigQueryUtil.getCredentialsByteArray(this.credentials)), this.headerProvider, this.bqConfig.getClientCreationHashCode()}) : Objects.hashCode((Object[])new Object[]{this.credentials, this.headerProvider, this.bqConfig.getClientCreationHashCode()});
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BigQueryClientFactory)) {
            return false;
        }
        BigQueryClientFactory that = (BigQueryClientFactory)o;
        if (Objects.equal((Object)this.headerProvider, (Object)that.headerProvider) && this.bqConfig.areClientCreationConfigsEqual(that.bqConfig)) {
            return BigQueryUtil.areCredentialsEqual(this.credentials, that.credentials);
        }
        return false;
    }

    private BigQueryReadClient createBigQueryReadClient(Optional<String> endpoint, int channelPoolSize, Optional<Integer> flowControlWindow) {
        try {
            InstantiatingGrpcChannelProvider.Builder transportBuilder = this.createTransportBuilder(endpoint);
            log.info("Channel pool size set to {}", (Object)channelPoolSize);
            transportBuilder.setChannelPoolSettings(ChannelPoolSettings.staticallySized((int)channelPoolSize));
            if (flowControlWindow.isPresent()) {
                ApiFunction channelConfigurator = channelBuilder -> {
                    if (channelBuilder instanceof NettyChannelBuilder) {
                        log.info("Flow control window for netty set to {} bytes", flowControlWindow.get());
                        return ((NettyChannelBuilder)channelBuilder).flowControlWindow(((Integer)flowControlWindow.get()).intValue());
                    }
                    log.info("Flow control window configured but underlying channel is not Netty");
                    return channelBuilder;
                };
                transportBuilder = transportBuilder.setChannelConfigurator(channelConfigurator);
            }
            BigQueryReadSettings.Builder clientSettings = (BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)transportBuilder.build())).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)this.credentials));
            this.bqConfig.getCreateReadSessionTimeoutInSeconds().ifPresent(timeoutInSeconds -> {
                UnaryCallSettings.Builder createReadSessionSettings = clientSettings.getStubSettingsBuilder().createReadSessionSettings();
                Duration timeout = Duration.ofSeconds((long)timeoutInSeconds);
                createReadSessionSettings.setRetrySettings(createReadSessionSettings.getRetrySettings().toBuilder().setInitialRpcTimeout(timeout).setMaxRpcTimeout(timeout).setTotalTimeout(timeout).build());
            });
            return BigQueryReadClient.create((BigQueryReadSettings)clientSettings.build());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error creating BigQueryStorageReadClient", e);
        }
    }

    private BigQueryWriteClient createBigQueryWriteClient(Optional<String> endpoint) {
        try {
            InstantiatingGrpcChannelProvider.Builder transportBuilder = this.createTransportBuilder(endpoint);
            BigQueryWriteSettings.Builder clientSettings = (BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)transportBuilder.build())).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)this.credentials));
            return BigQueryWriteClient.create((BigQueryWriteSettings)clientSettings.build());
        }
        catch (IOException e) {
            throw new BigQueryConnectorException("Error creating BigQueryWriteClient", e);
        }
    }

    private InstantiatingGrpcChannelProvider.Builder createTransportBuilder(Optional<String> endpoint) {
        InstantiatingGrpcChannelProvider.Builder transportBuilder = BigQueryReadSettings.defaultGrpcTransportProviderBuilder().setHeaderProvider(this.headerProvider);
        this.setProxyConfig(transportBuilder);
        endpoint.ifPresent(e -> {
            log.info("Overriding endpoint to: ", e);
            transportBuilder.setEndpoint(e);
        });
        return transportBuilder;
    }

    private void setProxyConfig(InstantiatingGrpcChannelProvider.Builder transportBuilder) {
        BigQueryProxyConfig proxyConfig = this.bqConfig.getBigQueryProxyConfig();
        if (proxyConfig.getProxyUri().isPresent()) {
            transportBuilder.setChannelConfigurator(BigQueryProxyTransporterBuilder.createGrpcChannelConfigurator(proxyConfig.getProxyUri(), proxyConfig.getProxyUsername(), proxyConfig.getProxyPassword()));
        }
    }

    private void shutdownBigQueryReadClient(BigQueryReadClient bigQueryReadClient) {
        if (bigQueryReadClient != null && !bigQueryReadClient.isShutdown()) {
            bigQueryReadClient.shutdown();
        }
    }

    private void shutdownBigQueryWriteClient(BigQueryWriteClient bigQueryWriteClient) {
        if (bigQueryWriteClient != null && !bigQueryWriteClient.isShutdown()) {
            bigQueryWriteClient.shutdown();
        }
    }
}

