/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroBinaryIterator
implements Iterator<InternalRow> {
    private static final Logger log = LoggerFactory.getLogger(AvroBinaryIterator.class);
    private final Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer;
    private long numberOfRowsParsed = 0L;
    GenericDatumReader reader;
    List<String> columnsInOrder;
    BinaryDecoder in;
    com.google.cloud.bigquery.Schema bqSchema;
    Optional<StructType> userProvidedSchema;
    private final SchemaConverters schemaConverters;

    public AvroBinaryIterator(com.google.cloud.bigquery.Schema bqSchema, List<String> columnsInOrder, Schema schema, ByteString rowsInBytes, Optional<StructType> userProvidedSchema, Optional<BigQueryStorageReadRowsTracer> bigQueryStorageReadRowsTracer, SchemaConvertersConfiguration schemaConvertersConfiguration) {
        this.reader = new GenericDatumReader(schema);
        this.bqSchema = bqSchema;
        this.columnsInOrder = columnsInOrder;
        this.in = new DecoderFactory().binaryDecoder(rowsInBytes.toByteArray(), null);
        this.userProvidedSchema = userProvidedSchema;
        this.bigQueryStorageReadRowsTracer = bigQueryStorageReadRowsTracer;
        this.schemaConverters = SchemaConverters.from(schemaConvertersConfiguration);
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.bigQueryStorageReadRowsTracer.isPresent() && this.in.isEnd()) {
                this.bigQueryStorageReadRowsTracer.get().rowsParseFinished(this.numberOfRowsParsed);
            }
            return !this.in.isEnd();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public InternalRow next() {
        try {
            ++this.numberOfRowsParsed;
            return this.schemaConverters.convertToInternalRow(this.bqSchema, this.columnsInOrder, (GenericRecord)this.reader.read(null, (Decoder)this.in), this.userProvidedSchema);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

