/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryConfigurationUtil;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.TypeConverter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.Metadata;
import scala.collection.immutable.Map;

public class SparkBigQueryUtil {
    private static final String SPARK_YARN_TAGS = "spark.yarn.tags";
    static final Properties BUILD_PROPERTIES = SparkBigQueryUtil.loadBuildProperties();
    static final String CONNECTOR_VERSION = BUILD_PROPERTIES.getProperty("connector.version");
    private static final ImmutableSet<TypeConverter> typeConverters;

    private static Properties loadBuildProperties() {
        try {
            Properties buildProperties = new Properties();
            buildProperties.load(SparkBigQueryUtil.class.getResourceAsStream("/spark-bigquery-connector.properties"));
            return buildProperties;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<String> optimizeLoadUriListForSpark(List<String> uris) {
        return BigQueryUtil.optimizeLoadUriList(uris, (String)".*/part-", (String)"-[-\\w\\.]+");
    }

    public static Path createGcsPath(SparkBigQueryConfig config, Configuration conf, String applicationId) {
        Path gcsPath;
        try {
            Preconditions.checkArgument((config.getTemporaryGcsBucket().isPresent() || config.getPersistentGcsBucket().isPresent() ? 1 : 0) != 0, (Object)"Either temporary or persistent GCS bucket must be set");
            if (config.getPersistentGcsBucket().isPresent() && config.getPersistentGcsPath().isPresent()) {
                gcsPath = new Path(String.format("gs://%s/%s", config.getPersistentGcsBucket().get(), config.getPersistentGcsPath().get()));
                FileSystem fs = gcsPath.getFileSystem(conf);
                if (fs.exists(gcsPath)) {
                    throw new IllegalArgumentException(String.format("Path %s already exists in %s bucket", config.getPersistentGcsPath().get(), config.getPersistentGcsBucket().get()));
                }
            } else {
                gcsPath = config.getTemporaryGcsBucket().isPresent() ? SparkBigQueryUtil.getUniqueGcsPath(config.getTemporaryGcsBucket().get(), applicationId, conf) : SparkBigQueryUtil.getUniqueGcsPath(config.getPersistentGcsBucket().get(), applicationId, conf);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return gcsPath;
    }

    private static Path getUniqueGcsPath(String gcsBucket, String applicationId, Configuration conf) throws IOException {
        boolean needNewPath = true;
        Path gcsPath = null;
        while (needNewPath) {
            gcsPath = new Path(String.format("gs://%s/.spark-bigquery-%s-%s", gcsBucket, applicationId, UUID.randomUUID()));
            FileSystem fs = gcsPath.getFileSystem(conf);
            needNewPath = fs.exists(gcsPath);
        }
        return gcsPath;
    }

    public static String getJobId(SQLConf sqlConf) {
        return SparkBigQueryUtil.getJobIdInternal(sqlConf.getConfString(SPARK_YARN_TAGS, "missing"), sqlConf.getConfString("spark.app.id", "generated-" + UUID.randomUUID()));
    }

    @VisibleForTesting
    static String getJobIdInternal(String yarnTags, String applicationId) {
        return Stream.of(yarnTags.split(",")).filter(tag -> tag.startsWith("dataproc_job_")).findFirst().orElseGet(() -> applicationId);
    }

    public static JobInfo.WriteDisposition saveModeToWriteDisposition(SaveMode saveMode) {
        if (saveMode == SaveMode.ErrorIfExists) {
            return JobInfo.WriteDisposition.WRITE_EMPTY;
        }
        if (saveMode == SaveMode.Append || saveMode == SaveMode.Ignore) {
            return JobInfo.WriteDisposition.WRITE_APPEND;
        }
        if (saveMode == SaveMode.Overwrite) {
            return JobInfo.WriteDisposition.WRITE_TRUNCATE;
        }
        throw new IllegalArgumentException("SaveMode " + saveMode + " is currently not supported.");
    }

    public static TableId parseSimpleTableId(SparkSession spark, java.util.Map<String, String> options) {
        ImmutableMap globalOptions = ImmutableMap.copyOf(SparkBigQueryUtil.scalaMapToJavaMap(spark.conf().getAll()));
        return BigQueryConfigurationUtil.parseSimpleTableId((ImmutableMap)globalOptions, options);
    }

    public static long sparkTimestampToBigQuery(Object sparkValue) {
        if (sparkValue instanceof Long) {
            return ((Number)sparkValue).longValue();
        }
        Timestamp timestamp = (Timestamp)sparkValue;
        long epochSecondsAsMicros = timestamp.getTime() / 1000L * 1000000L;
        int micros = timestamp.getNanos() / 1000;
        return epochSecondsAsMicros + (long)micros;
    }

    public static int sparkDateToBigQuery(Object sparkValue) {
        if (sparkValue instanceof Number) {
            return ((Number)sparkValue).intValue();
        }
        Date sparkDate = (Date)sparkValue;
        return (int)sparkDate.toLocalDate().toEpochDay();
    }

    public static String getTableNameFromOptions(java.util.Map<String, String> options) {
        Optional tableParam = BigQueryConfigurationUtil.getOptionFromMultipleParams(options, (Collection)ImmutableList.of((Object)"table", (Object)"path"), (Supplier)BigQueryConfigurationUtil.DEFAULT_FALLBACK).toJavaUtil();
        String tableParamStr = ((String)tableParam.get()).trim().replaceAll("\\s+", " ");
        TableId tableId = BigQueryUtil.parseTableId((String)tableParamStr);
        return BigQueryUtil.friendlyTableName((TableId)tableId);
    }

    public static <K, V> ImmutableMap<K, V> scalaMapToJavaMap(Map<K, V> map) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        map.foreach(entry -> result.put(entry._1(), entry._2()));
        return result.build();
    }

    public static boolean isDataFrameShowMethodInStackTrace() {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().equals("org.apache.spark.sql.Dataset") || !stackTraceElement.getMethodName().equals("showString")) continue;
            return true;
        }
        return false;
    }

    public static boolean isJson(Metadata metadata) {
        return metadata.contains("sqlType") && "JSON".equals(metadata.getString("sqlType"));
    }

    public static ImmutableList<Filter> extractPartitionAndClusteringFilters(TableInfo table, ImmutableList<Filter> filters) {
        ImmutableList partitionFields = BigQueryUtil.getPartitionFields((TableInfo)table);
        ImmutableList clusteringFields = BigQueryUtil.getClusteringFields((TableInfo)table);
        ImmutableList.Builder filterFields = ImmutableList.builder();
        filterFields.addAll((Iterable)partitionFields);
        filterFields.addAll((Iterable)clusteringFields);
        return (ImmutableList)filterFields.build().stream().flatMap(field -> SparkBigQueryUtil.filtersOnField(filters, field)).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    static Stream<Filter> filtersOnField(ImmutableList<Filter> filters, String field) {
        return filters.stream().filter(filter -> Stream.of(filter.references()).anyMatch(reference -> reference.equals(field)));
    }

    public static Stream<TypeConverter> getTypeConverterStream() {
        return typeConverters.stream();
    }

    @NotNull
    public static ImmutableMap<String, String> extractJobLabels(SparkConf sparkConf) {
        ImmutableMap.Builder labels = ImmutableMap.builder();
        ImmutableList tags = (ImmutableList)Stream.of(Optional.ofNullable(sparkConf.get(SPARK_YARN_TAGS, null))).filter(Optional::isPresent).flatMap(value -> Stream.of(((String)value.get()).split(","))).collect(ImmutableList.toImmutableList());
        tags.stream().filter(tag -> tag.startsWith("dataproc_job_")).findFirst().ifPresent(tag -> labels.put((Object)"dataproc_job_id", (Object)tag.substring(tag.lastIndexOf(95) + 1)));
        tags.stream().filter(tag -> tag.startsWith("dataproc_uuid_")).findFirst().ifPresent(tag -> labels.put((Object)"dataproc_job_uuid", (Object)tag.substring(tag.lastIndexOf(95) + 1)));
        return labels.build();
    }

    static {
        ServiceLoader<TypeConverter> serviceLoader = ServiceLoader.load(TypeConverter.class);
        typeConverters = ImmutableSet.copyOf(serviceLoader.iterator());
    }
}

