/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.direct;

import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryMetrics;
import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.connector.common.BigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.spark.bigquery.InternalRowIterator;
import com.google.cloud.spark.bigquery.ReadRowsResponseToInternalRowIteratorConverter;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.direct.BigQueryPartition;
import com.google.cloud.spark.bigquery.direct.ScalaIterator;
import com.google.cloud.spark.bigquery.metrics.SparkMetricsSource;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import scala.collection.Iterator;

class BigQueryRDDContext
implements Serializable {
    private static long serialVersionUID = -2219993393692435055L;
    private final Partition[] partitions;
    private final ReadSession readSession;
    private final String[] columnsInOrder;
    private final Schema bqSchema;
    private final SparkBigQueryConfig options;
    private final BigQueryClientFactory bigQueryClientFactory;
    private final BigQueryTracerFactory bigQueryTracerFactory;
    private List<String> streamNames;

    public BigQueryRDDContext(Partition[] parts, ReadSession readSession, Schema bqSchema, String[] columnsInOrder, SparkBigQueryConfig options, BigQueryClientFactory bigQueryClientFactory, BigQueryTracerFactory bigQueryTracerFactory) {
        this.partitions = parts;
        this.readSession = readSession;
        this.columnsInOrder = columnsInOrder;
        this.bigQueryClientFactory = bigQueryClientFactory;
        this.bigQueryTracerFactory = bigQueryTracerFactory;
        this.options = options;
        this.bqSchema = bqSchema;
        this.streamNames = BigQueryUtil.getStreamNames((ReadSession)readSession);
    }

    public Iterator<InternalRow> compute(Partition split, TaskContext context) {
        BigQueryPartition bigQueryPartition = (BigQueryPartition)split;
        SparkMetricsSource sparkMetricsSource = new SparkMetricsSource();
        SparkEnv.get().metricsSystem().registerSource((Source)sparkMetricsSource);
        BigQueryStorageReadRowsTracer tracer = this.bigQueryTracerFactory.newReadRowsTracer(Joiner.on((String)",").join(this.streamNames), (BigQueryMetrics)sparkMetricsSource);
        ReadRowsRequest.Builder request = ReadRowsRequest.newBuilder().setReadStream(bigQueryPartition.getStream());
        ReadRowsHelper readRowsHelper = new ReadRowsHelper(this.bigQueryClientFactory, request, this.options.toReadSessionCreatorConfig().toReadRowsHelperOptions(), Optional.of(tracer));
        java.util.Iterator readRowsResponseIterator = readRowsHelper.readRows();
        StructType schema = this.options.getSchema().orElse(SchemaConverters.from(SchemaConvertersConfiguration.from(this.options)).toSpark(this.bqSchema));
        ReadRowsResponseToInternalRowIteratorConverter converter = this.options.getReadDataFormat().equals((Object)DataFormat.AVRO) ? ReadRowsResponseToInternalRowIteratorConverter.avro(this.bqSchema, Arrays.asList(this.columnsInOrder), this.readSession.getAvroSchema().getSchema(), Optional.of(schema), Optional.of(tracer), SchemaConvertersConfiguration.from(this.options)) : ReadRowsResponseToInternalRowIteratorConverter.arrow(Arrays.asList(this.columnsInOrder), this.readSession.getArrowSchema().getSerializedSchema(), Optional.of(schema), Optional.of(tracer));
        return new InterruptibleIterator(context, new ScalaIterator<InternalRow>(new InternalRowIterator(readRowsResponseIterator, converter, readRowsHelper, tracer)));
    }

    public Partition[] getPartitions() {
        return this.partitions;
    }
}

