/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.spark2;

import com.google.cloud.spark.bigquery.DataFrameToRDDConverter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.types.StructType;
import scala.collection.Seq;
import scala.collection.mutable.WrappedArray;

public class Spark2DataFrameToRDDConverter
implements DataFrameToRDDConverter {
    public RDD<Row> convertToRDD(Dataset<Row> data) {
        StructType schema = data.schema();
        Seq attributeReferenceSeq = schema.toAttributes();
        AttributeReference[] attributeReferenceArray = new AttributeReference[attributeReferenceSeq.size()];
        attributeReferenceSeq.copyToArray((Object)attributeReferenceArray);
        Attribute[] attributes = (Attribute[])Stream.of(attributeReferenceArray).map(Attribute::toAttribute).toArray(Attribute[]::new);
        Seq attributeSeq = WrappedArray.make((Object)attributes).toSeq();
        ExpressionEncoder expressionEncoder = RowEncoder.apply((StructType)schema).resolveAndBind(attributeSeq, (Analyzer)SimpleAnalyzer$.MODULE$);
        RDD rowRdd = data.queryExecution().toRdd().toJavaRDD().mapPartitions((FlatMapFunction & Serializable)iter -> new EncodingIterator((Iterator<InternalRow>)iter, (ExpressionEncoder<Row>)expressionEncoder)).rdd();
        return rowRdd;
    }

    static class EncodingIterator
    implements Iterator<Row> {
        private Iterator<InternalRow> internalIterator;
        private ExpressionEncoder<Row> expressionEncoder;

        public EncodingIterator(Iterator<InternalRow> internalIterator, ExpressionEncoder<Row> expressionEncoder) {
            this.internalIterator = internalIterator;
            this.expressionEncoder = expressionEncoder;
        }

        @Override
        public boolean hasNext() {
            return this.internalIterator.hasNext();
        }

        @Override
        public Row next() {
            return (Row)this.expressionEncoder.fromRow(this.internalIterator.next());
        }
    }
}

