/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.pubsub.health;

import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.spring.autoconfigure.pubsub.GcpPubSubAutoConfiguration;
import com.google.cloud.spring.autoconfigure.pubsub.GcpPubSubProperties;
import com.google.cloud.spring.autoconfigure.pubsub.health.PubSubHealthIndicator;
import com.google.cloud.spring.autoconfigure.pubsub.health.PubSubSubscriptionHealthIndicator;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.pubsub.core.PubSubTemplate;
import com.google.cloud.spring.pubsub.core.health.HealthTrackerRegistry;
import com.google.cloud.spring.pubsub.core.health.HealthTrackerRegistryImpl;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@AutoConfiguration
@ConditionalOnClass(value={HealthIndicator.class, MetricServiceClient.class})
@ConditionalOnEnabledHealthIndicator(value="pubsub-subscriber")
@ConditionalOnProperty(value={"spring.cloud.gcp.pubsub.health.lagThreshold", "spring.cloud.gcp.pubsub.health.backlogThreshold"})
@AutoConfigureBefore(value={GcpPubSubAutoConfiguration.class})
@EnableConfigurationProperties(value={GcpPubSubProperties.class})
public class PubSubSubscriptionHealthIndicatorAutoConfiguration
extends CompositeHealthContributorConfiguration<PubSubHealthIndicator, PubSubTemplate> {
    private final GcpPubSubProperties gcpPubSubProperties;
    private final String projectId;

    public PubSubSubscriptionHealthIndicatorAutoConfiguration(GcpPubSubProperties gcpPubSubProperties, GcpProjectIdProvider projectIdProvider) {
        this.projectId = gcpPubSubProperties.getProjectId() != null ? gcpPubSubProperties.getProjectId() : projectIdProvider.getProjectId();
        this.gcpPubSubProperties = gcpPubSubProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MetricServiceClient metricServiceClient() throws IOException {
        return MetricServiceClient.create();
    }

    @Bean
    @ConditionalOnMissingBean(name={"pubSubHealthThreadPool"})
    public ThreadPoolTaskScheduler pubSubHealthThreadPool() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(this.gcpPubSubProperties.getHealth().getExecutorThreads());
        scheduler.setThreadNamePrefix("gcp-pubsub-health");
        scheduler.setDaemon(true);
        return scheduler;
    }

    @Bean
    @ConditionalOnMissingBean(name={"healthCheckExecutorProvider"})
    public ExecutorProvider healthCheckExecutorProvider(@Qualifier(value="pubSubHealthThreadPool") ThreadPoolTaskScheduler scheduler) {
        return FixedExecutorProvider.create((ScheduledExecutorService)scheduler.getScheduledExecutor());
    }

    @Bean
    @ConditionalOnMissingBean(name={"healthTrackerRegistry"})
    public HealthTrackerRegistry healthTrackerRegistry(MetricServiceClient metricServiceClient, @Qualifier(value="healthCheckExecutorProvider") ExecutorProvider executorProvider) {
        return new HealthTrackerRegistryImpl(this.projectId, metricServiceClient, this.gcpPubSubProperties.getHealth().getLagThreshold(), this.gcpPubSubProperties.getHealth().getBacklogThreshold(), this.gcpPubSubProperties.getHealth().getLookUpInterval(), executorProvider);
    }

    @Bean
    @ConditionalOnMissingBean(name={"pubSubSubscriptionHealthIndicator"})
    public PubSubSubscriptionHealthIndicator pubSubSubscriptionHealthIndicator(HealthTrackerRegistry healthTrackerRegistry) {
        return new PubSubSubscriptionHealthIndicator(healthTrackerRegistry);
    }
}

