/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubTracing;
import com.google.cloud.spring.pubsub.support.SubscriberFactory;
import com.google.pubsub.v1.PullRequest;

final class TracingSubscriberFactory
implements SubscriberFactory {
    private final PubSubTracing pubSubTracing;
    private final SubscriberFactory delegate;

    TracingSubscriberFactory(PubSubTracing pubSubTracing, SubscriberFactory delegate) {
        this.pubSubTracing = pubSubTracing;
        this.delegate = delegate;
    }

    public String getProjectId() {
        return this.delegate.getProjectId();
    }

    public Subscriber createSubscriber(String subscriptionName, MessageReceiver receiver) {
        return this.delegate.createSubscriber(subscriptionName, (MessageReceiver)this.pubSubTracing.messageReceiver(receiver, subscriptionName));
    }

    public PullRequest createPullRequest(String subscriptionName, Integer maxMessages, Boolean returnImmediately) {
        return this.delegate.createPullRequest(subscriptionName, maxMessages, returnImmediately);
    }

    public SubscriberStub createSubscriberStub(String subscriptionName) {
        return this.pubSubTracing.subscriberStub(this.delegate.createSubscriberStub(subscriptionName));
    }
}

