/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.sql;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.spring.core.GcpScope;
import com.google.cloud.sql.CredentialFactory;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlCredentialFactory
implements CredentialFactory {
    public static final String CREDENTIAL_LOCATION_PROPERTY_NAME = "GOOGLE_CLOUD_SQL_CREDS_LOCATION";
    public static final String CREDENTIAL_ENCODED_KEY_PROPERTY_NAME = "GOOGLE_CLOUD_SQL_ENCODED_KEY";
    private static final Log LOGGER = LogFactory.getLog(SqlCredentialFactory.class);

    public HttpRequestInitializer create() {
        return new HttpCredentialsAdapter((Credentials)this.getCredentials());
    }

    public GoogleCredentials getCredentials() {
        String credentialResourceLocation = System.getProperty(CREDENTIAL_LOCATION_PROPERTY_NAME);
        String encodedCredential = System.getProperty(CREDENTIAL_ENCODED_KEY_PROPERTY_NAME);
        if (credentialResourceLocation == null && encodedCredential == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"GOOGLE_CLOUD_SQL_CREDS_LOCATION and GOOGLE_CLOUD_SQL_ENCODED_KEY properties do not exist. Socket factory will use application default credentials.");
            }
            return null;
        }
        try {
            InputStream credentialsInputStream = encodedCredential != null ? new ByteArrayInputStream(Base64.getDecoder().decode(encodedCredential.getBytes())) : new FileInputStream(credentialResourceLocation);
            return GoogleCredentials.fromStream((InputStream)credentialsInputStream).createScoped(Collections.singleton(GcpScope.SQLADMIN.getUrl()));
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)"There was an error loading Cloud SQL credential.", (Throwable)ioe);
            return null;
        }
    }
}

