/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import brave.Span;
import brave.internal.Nullable;
import brave.messaging.ConsumerRequest;
import brave.propagation.Propagation;
import com.google.pubsub.v1.PubsubMessage;

final class PubSubConsumerRequest
extends ConsumerRequest {
    static final Propagation.RemoteGetter<PubSubConsumerRequest> GETTER = new Propagation.RemoteGetter<PubSubConsumerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.CONSUMER;
        }

        public String get(PubSubConsumerRequest request, String name) {
            return request.delegate.getAttributesOrDefault(name, null);
        }

        public String toString() {
            return "PubsubMessage.Builder::getAttribute";
        }
    };
    static final Propagation.RemoteSetter<PubSubConsumerRequest> SETTER = new Propagation.RemoteSetter<PubSubConsumerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.CONSUMER;
        }

        public void put(PubSubConsumerRequest request, String name, String value) {
            request.delegate.putAttributes(name, value);
        }

        public String toString() {
            return "PubsubMessage.Builder::putAttributes";
        }
    };
    final PubsubMessage.Builder delegate;
    final String subscription;

    PubSubConsumerRequest(PubsubMessage.Builder delegate, @Nullable String subscription) {
        if (delegate == null) {
            throw new NullPointerException("PubsubMessage.Builder delegate == null");
        }
        this.delegate = delegate;
        this.subscription = subscription;
    }

    public Span.Kind spanKind() {
        return Span.Kind.CONSUMER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "receive";
    }

    public String channelKind() {
        return "subscription";
    }

    public String channelName() {
        return this.subscription;
    }

    public String messageId() {
        return this.delegate.getMessageId();
    }
}

