/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.firestore.repository.support;

import com.google.cloud.spring.data.firestore.FirestoreTemplate;
import com.google.cloud.spring.data.firestore.mapping.FirestoreMappingContext;
import com.google.cloud.spring.data.firestore.repository.support.ReactiveFirestoreRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class FirestoreRepositoryFactoryBean<T extends Repository<S, I>, S, I>
extends RepositoryFactoryBeanSupport<T, S, I> {
    private FirestoreTemplate firestoreTemplate;
    private FirestoreMappingContext firestoreMappingContext;

    FirestoreRepositoryFactoryBean(Class<T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setFirestoreTemplate(FirestoreTemplate firestoreTemplate) {
        this.firestoreTemplate = firestoreTemplate;
    }

    public void setFirestoreMappingContext(FirestoreMappingContext mappingContext) {
        super.setMappingContext((MappingContext)mappingContext);
        this.firestoreMappingContext = mappingContext;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return new ReactiveFirestoreRepositoryFactory(this.firestoreTemplate, this.firestoreMappingContext);
    }
}

