/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core.mapping;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Type;
import com.google.cloud.spring.data.spanner.core.convert.ConversionUtils;
import com.google.cloud.spring.data.spanner.core.convert.SpannerEntityProcessor;
import com.google.cloud.spring.data.spanner.core.convert.SpannerEntityWriter;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerCompositeKeyProperty;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerDataException;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerMappingContext;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntity;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentProperty;
import com.google.cloud.spring.data.spanner.core.mapping.Table;
import com.google.cloud.spring.data.spanner.core.mapping.Where;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SpannerPersistentEntityImpl<T>
extends BasicPersistentEntity<T, SpannerPersistentProperty>
implements SpannerPersistentEntity<T> {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final Pattern TABLE_NAME_ILLEGAL_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");
    private final Class rawType;
    private final Set<String> columnNames = new HashSet<String>();
    private final Expression tableNameExpression;
    private final Table table;
    private final Map<Integer, SpannerPersistentProperty> primaryKeyParts = new HashMap<Integer, SpannerPersistentProperty>();
    private final SpannerMappingContext spannerMappingContext;
    private final SpannerEntityProcessor spannerEntityProcessor;
    private final StandardEvaluationContext context;
    private SpannerCompositeKeyProperty idProperty;
    private String tableName;
    private boolean hasEagerlyLoadedProperties = false;
    private final String where;
    private final Set<Class<?>> jsonProperties = new HashSet();

    public SpannerPersistentEntityImpl(TypeInformation<T> information, SpannerMappingContext spannerMappingContext, SpannerEntityProcessor spannerEntityProcessor) {
        super(information);
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A non-null SpannerMappingContext is required.");
        Assert.notNull((Object)spannerEntityProcessor, (String)"A non-null SpannerEntityProcessor is required.");
        this.spannerMappingContext = spannerMappingContext;
        this.spannerEntityProcessor = spannerEntityProcessor;
        this.rawType = information.getType();
        this.context = new StandardEvaluationContext();
        this.table = (Table)this.findAnnotation(Table.class);
        Where annotation = (Where)this.findAnnotation(Where.class);
        this.where = annotation != null ? annotation.value() : "";
        this.tableNameExpression = this.detectExpression();
    }

    protected boolean hasAnnotatedTableName() {
        return this.table != null && StringUtils.hasText((String)this.table.name());
    }

    @Nullable
    private Expression detectExpression() {
        if (!this.hasAnnotatedTableName()) {
            return null;
        }
        Expression expression = PARSER.parseExpression(this.table.name(), ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    public void addPersistentProperty(SpannerPersistentProperty property) {
        if (!property.isMapped()) {
            return;
        }
        this.addPersistentPropertyToPersistentEntity(property);
        if (property.isEmbedded()) {
            this.columnNames.addAll(this.spannerMappingContext.getPersistentEntityOrFail(property.getType()).columns());
        } else if (!property.isInterleaved()) {
            this.columnNames.add(property.getColumnName());
        } else if (property.isEagerInterleaved()) {
            this.hasEagerlyLoadedProperties = true;
        }
        if (property.getPrimaryKeyOrder() != null && property.getPrimaryKeyOrder().isPresent()) {
            int order = property.getPrimaryKeyOrder().getAsInt();
            this.primaryKeyParts.merge(order, property, (oldVal, newVal) -> {
                throw new SpannerDataException("Two properties were annotated with the same primary key order: " + property.getColumnName() + " and " + this.primaryKeyParts.get(order).getColumnName() + " in " + this.getType().getSimpleName() + ".");
            });
        }
        if (property.getAnnotatedColumnItemType() == Type.Code.JSON && property.isCollectionLike()) {
            this.jsonProperties.add(property.getColumnInnerType());
        } else if (property.getAnnotatedColumnItemType() == Type.Code.JSON) {
            this.jsonProperties.add(property.getType());
        }
    }

    private void addPersistentPropertyToPersistentEntity(SpannerPersistentProperty property) {
        super.addPersistentProperty((PersistentProperty)property);
    }

    @Override
    public SpannerCompositeKeyProperty getIdProperty() {
        return this.idProperty;
    }

    @Override
    public void doWithInterleavedProperties(PropertyHandler<SpannerPersistentProperty> handler) {
        this.doWithProperties(spannerPersistentProperty -> {
            if (spannerPersistentProperty.isInterleaved()) {
                handler.doWithPersistentProperty(spannerPersistentProperty);
            }
        });
    }

    @Override
    public void doWithColumnBackedProperties(PropertyHandler<SpannerPersistentProperty> handler) {
        this.doWithProperties(spannerPersistentProperty -> {
            if (!spannerPersistentProperty.isInterleaved()) {
                handler.doWithPersistentProperty(spannerPersistentProperty);
            }
        });
    }

    public boolean hasIdProperty() {
        return this.idProperty != null;
    }

    public void verify() {
        super.verify();
        this.verifyPrimaryKeysConsecutive();
        this.verifyInterleavedProperties();
        this.verifyEmbeddedColumnNameOverlap(new HashSet<String>(), this);
    }

    private void verifyInterleavedProperties() {
        this.doWithInterleavedProperties((PropertyHandler<SpannerPersistentProperty>)((PropertyHandler)spannerPersistentProperty -> {
            Class<?> childType = spannerPersistentProperty.getColumnInnerType();
            SpannerPersistentEntityImpl childEntity = (SpannerPersistentEntityImpl)this.spannerMappingContext.getPersistentEntityOrFail(childType);
            List<SpannerPersistentProperty> primaryKeyProperties = this.getFlattenedPrimaryKeyProperties();
            List<SpannerPersistentProperty> childKeyProperties = childEntity.getFlattenedPrimaryKeyProperties();
            if (primaryKeyProperties.size() >= childKeyProperties.size()) {
                throw new SpannerDataException("A child table (" + childEntity.getType().getSimpleName() + ") must contain the primary key columns of its parent (" + childEntity.getType().getSimpleName() + ") in the same order starting the first column with additional key columns after.");
            }
            for (int i = 0; i < primaryKeyProperties.size(); ++i) {
                SpannerPersistentProperty parentKey = primaryKeyProperties.get(i);
                SpannerPersistentProperty childKey = childKeyProperties.get(i);
                if (parentKey.getColumnName().equals(childKey.getColumnName()) && parentKey.getType().equals(childKey.getType())) continue;
                throw new SpannerDataException("The child primary key column (" + childEntity.getType().getSimpleName() + "." + childKey.getColumnName() + ") at position " + (i + 1) + " does not match that of its parent (" + this.getType().getSimpleName() + "." + parentKey.getColumnName() + ").");
            }
        }));
    }

    private void verifyEmbeddedColumnNameOverlap(Set<String> seen, SpannerPersistentEntity<?> spannerPersistentEntity) {
        spannerPersistentEntity.doWithColumnBackedProperties((PropertyHandler<SpannerPersistentProperty>)((PropertyHandler)spannerPersistentProperty -> {
            if (spannerPersistentProperty.isEmbedded()) {
                if (ConversionUtils.isIterableNonByteArrayType(spannerPersistentProperty.getType())) {
                    throw new SpannerDataException("Embedded properties cannot be collections: " + spannerPersistentProperty);
                }
                this.verifyEmbeddedColumnNameOverlap(seen, this.spannerMappingContext.getPersistentEntityOrFail(spannerPersistentProperty.getType()));
            } else {
                String columnName = spannerPersistentProperty.getColumnName();
                if (seen.contains(columnName)) {
                    throw new SpannerDataException("Two properties resolve to the same column name: " + columnName + " in " + this.getType().getSimpleName());
                }
                seen.add(columnName);
            }
        }));
    }

    private void verifyPrimaryKeysConsecutive() {
        for (int i = 1; i <= this.primaryKeyParts.size(); ++i) {
            SpannerPersistentProperty keyPart = this.primaryKeyParts.get(i);
            if (keyPart != null) continue;
            throw new SpannerDataException("The primary key columns were not given a consecutive order. There is no property annotated with order " + i + " in " + this.getType().getSimpleName() + ".");
        }
        this.idProperty = new SpannerCompositeKeyProperty(this, this.getPrimaryKeyProperties());
    }

    @Override
    public SpannerPersistentProperty[] getPrimaryKeyProperties() {
        SpannerPersistentProperty[] primaryKeyColumns = new SpannerPersistentProperty[this.primaryKeyParts.size()];
        for (int i = 1; i <= this.primaryKeyParts.size(); ++i) {
            primaryKeyColumns[i - 1] = this.primaryKeyParts.get(i);
        }
        return primaryKeyColumns;
    }

    @Override
    public List<SpannerPersistentProperty> getFlattenedPrimaryKeyProperties() {
        ArrayList<SpannerPersistentProperty> primaryKeyColumns = new ArrayList<SpannerPersistentProperty>();
        for (SpannerPersistentProperty property : this.getPrimaryKeyProperties()) {
            if (property.isEmbedded()) {
                primaryKeyColumns.addAll(this.spannerMappingContext.getPersistentEntityOrFail(property.getType()).getFlattenedPrimaryKeyProperties());
                continue;
            }
            primaryKeyColumns.add(property);
        }
        return primaryKeyColumns;
    }

    @Override
    public SpannerMappingContext getSpannerMappingContext() {
        return this.spannerMappingContext;
    }

    @Override
    public SpannerEntityWriter getSpannerEntityProcessor() {
        return this.spannerEntityProcessor;
    }

    @Override
    public String tableName() {
        if (this.tableName == null) {
            if (this.hasAnnotatedTableName()) {
                try {
                    this.tableName = this.validateTableName(this.tableNameExpression != null ? (String)this.tableNameExpression.getValue((EvaluationContext)this.context, String.class) : this.table.name());
                }
                catch (RuntimeException ex) {
                    throw new SpannerDataException("Error getting table name for " + this.getType().getSimpleName(), ex);
                }
            } else {
                this.tableName = StringUtils.uncapitalize((String)this.rawType.getSimpleName());
            }
        }
        return this.tableName;
    }

    @Override
    public boolean hasMultiFieldKey() {
        return this.getIdProperty() != null && !this.getIdProperty().getActualType().equals(Key.class);
    }

    private String validateTableName(String name) {
        if (TABLE_NAME_ILLEGAL_CHAR_PATTERN.matcher(name).find()) {
            throw new SpannerDataException("Only letters, numbers, and underscores are allowed in table names: " + name);
        }
        return name;
    }

    @Override
    public boolean hasEagerlyLoadedProperties() {
        return this.hasEagerlyLoadedProperties;
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    @Override
    public boolean hasWhere() {
        return !this.where.isEmpty();
    }

    @Override
    public Set<String> columns() {
        return Collections.unmodifiableSet(this.columnNames);
    }

    public boolean isJsonProperty(Class<?> type) {
        return this.jsonProperties.contains(type);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    @NonNull
    public <B> PersistentPropertyAccessor<B> getPropertyAccessor(@NonNull B object) {
        return new DelegatingPersistentPropertyAccessor(super.getPropertyAccessor(object));
    }

    @Override
    public String getPrimaryKeyColumnName() {
        SpannerPersistentProperty primaryKeyProperty = this.getPrimaryKeyProperties()[0];
        return primaryKeyProperty.isEmbedded() ? this.spannerMappingContext.getPersistentEntityOrFail(primaryKeyProperty.getType()).getPrimaryKeyColumnName() : primaryKeyProperty.getColumnName();
    }

    private class DelegatingPersistentPropertyAccessor<B>
    implements PersistentPropertyAccessor<B> {
        private final PersistentPropertyAccessor<B> delegate;

        DelegatingPersistentPropertyAccessor(PersistentPropertyAccessor<B> delegate) {
            this.delegate = delegate;
        }

        public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
            Iterator<Object> partsIterator;
            if (!property.isIdProperty()) {
                this.delegate.setProperty(property, value);
                return;
            }
            SpannerPersistentEntity owner = (SpannerPersistentEntity)property.getOwner();
            SpannerPersistentProperty[] primaryKeyProperties = owner.getPrimaryKeyProperties();
            if (value instanceof Key) {
                Key keyValue = (Key)value;
                if (keyValue.size() != primaryKeyProperties.length) {
                    throw new SpannerDataException("The number of key parts is not equal to the number of primary key properties");
                }
                partsIterator = keyValue.getParts().iterator();
            } else {
                if (primaryKeyProperties.length > 1) {
                    throw new SpannerDataException("The number of key parts is not equal to the number of primary key properties");
                }
                partsIterator = Collections.singleton(value).iterator();
            }
            for (SpannerPersistentProperty prop : primaryKeyProperties) {
                this.delegate.setProperty((PersistentProperty)prop, SpannerPersistentEntityImpl.this.spannerEntityProcessor.getReadConverter().convert(partsIterator.next(), prop.getType()));
            }
        }

        @Nullable
        public Object getProperty(PersistentProperty<?> property) {
            return property.isIdProperty() ? ((SpannerCompositeKeyProperty)property).getId(this.getBean()) : this.delegate.getProperty(property);
        }

        @NonNull
        public B getBean() {
            return (B)this.delegate.getBean();
        }
    }
}

