/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core.mapping;

import com.google.cloud.spanner.Type;
import com.google.cloud.spring.data.spanner.core.mapping.Column;
import com.google.cloud.spring.data.spanner.core.mapping.Embedded;
import com.google.cloud.spring.data.spanner.core.mapping.Interleaved;
import com.google.cloud.spring.data.spanner.core.mapping.NotMapped;
import com.google.cloud.spring.data.spanner.core.mapping.PrimaryKey;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerDataException;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentProperty;
import com.google.cloud.spring.data.spanner.core.mapping.Table;
import com.google.cloud.spring.data.spanner.core.mapping.Where;
import com.google.spanner.v1.TypeCode;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class SpannerPersistentPropertyImpl
extends AnnotationBasedPersistentProperty<SpannerPersistentProperty>
implements SpannerPersistentProperty {
    private final FieldNamingStrategy fieldNamingStrategy;

    SpannerPersistentPropertyImpl(Property property, PersistentEntity<?, SpannerPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        this.fieldNamingStrategy = fieldNamingStrategy != null ? fieldNamingStrategy : PropertyNameFieldNamingStrategy.INSTANCE;
    }

    @NonNull
    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypeInformation() {
        return StreamUtils.createStreamFromIterator(super.getPersistentEntityTypeInformation().iterator()).filter(typeInfo -> typeInfo.getType().isAnnotationPresent(Table.class)).toList();
    }

    @NonNull
    protected Association<SpannerPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public String getColumnName() {
        if (StringUtils.hasText((String)this.getAnnotatedColumnName())) {
            return this.getAnnotatedColumnName();
        }
        String fieldName = this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
        if (!StringUtils.hasText((String)fieldName)) {
            throw new MappingException(String.format("Invalid (null or empty) field name returned for property %s by %s!", this, this.fieldNamingStrategy.getClass()));
        }
        return fieldName;
    }

    @Override
    public Class<?> getColumnInnerType() {
        TypeInformation ti = this.getTypeInformation();
        List typeParams = ti.getTypeArguments();
        if (typeParams.size() != 1) {
            throw new SpannerDataException("in field '" + this.getColumnName() + "': Unsupported number of type parameters found: " + typeParams.size() + " Only collections of exactly 1 type parameter are supported.");
        }
        return ((TypeInformation)typeParams.get(0)).getType();
    }

    @Override
    public OptionalInt getPrimaryKeyOrder() {
        PrimaryKey annotation = (PrimaryKey)this.findAnnotation(PrimaryKey.class);
        if (annotation == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(annotation.keyOrder());
    }

    @Override
    public boolean isMapped() {
        return this.findAnnotation(NotMapped.class) == null;
    }

    @Override
    public boolean isEmbedded() {
        return this.findAnnotation(Embedded.class) != null;
    }

    @Override
    public boolean isInterleaved() {
        return this.findAnnotation(Interleaved.class) != null;
    }

    @Override
    public OptionalLong getMaxColumnLength() {
        Column annotation = (Column)this.findAnnotation(Column.class);
        if (annotation == null || annotation.spannerTypeMaxLength() < 0L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(annotation.spannerTypeMaxLength());
    }

    @Override
    public boolean isGenerateSchemaNotNull() {
        Column annotation = (Column)this.findAnnotation(Column.class);
        return annotation != null && !annotation.nullable();
    }

    @Override
    public boolean isCommitTimestamp() {
        Column annotation = (Column)this.findAnnotation(Column.class);
        return annotation != null && annotation.spannerCommitTimestamp();
    }

    @Override
    public String getWhere() {
        Where annotation = (Where)this.findAnnotation(Where.class);
        return annotation != null ? annotation.value() : "";
    }

    @Override
    public boolean hasWhere() {
        return !this.getWhere().isEmpty();
    }

    @Override
    public Type.Code getAnnotatedColumnItemType() {
        Column annotation = (Column)this.findAnnotation(Column.class);
        if (annotation == null || annotation.spannerType() == TypeCode.TYPE_CODE_UNSPECIFIED) {
            return null;
        }
        return Type.Code.valueOf((String)annotation.spannerType().name());
    }

    @Override
    public boolean isLazyInterleaved() {
        Interleaved annotation = (Interleaved)this.findAnnotation(Interleaved.class);
        return annotation != null && annotation.lazy();
    }

    @Override
    public boolean isEagerInterleaved() {
        Interleaved annotation = (Interleaved)this.findAnnotation(Interleaved.class);
        return annotation != null && !annotation.lazy();
    }

    public boolean isIdProperty() {
        return false;
    }

    private String getAnnotatedColumnName() {
        Column annotation = (Column)this.findAnnotation(Column.class);
        if (annotation != null && StringUtils.hasText((String)annotation.name())) {
            return annotation.name();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpannerPersistentPropertyImpl)) {
            return false;
        }
        SpannerPersistentPropertyImpl that = (SpannerPersistentPropertyImpl)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.fieldNamingStrategy.equals(that.fieldNamingStrategy);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fieldNamingStrategy);
    }
}

