/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.stream.binder.pubsub.config;

import com.google.cloud.spring.pubsub.PubSubAdmin;
import com.google.cloud.spring.pubsub.core.PubSubTemplate;
import com.google.cloud.spring.pubsub.core.health.HealthTrackerRegistry;
import com.google.cloud.spring.pubsub.integration.inbound.PubSubInboundChannelAdapter;
import com.google.cloud.spring.pubsub.integration.outbound.PubSubMessageHandler;
import com.google.cloud.spring.stream.binder.pubsub.PubSubMessageChannelBinder;
import com.google.cloud.spring.stream.binder.pubsub.aot.PubSubConsumerPropertiesRuntimeHints;
import com.google.cloud.spring.stream.binder.pubsub.properties.PubSubExtendedBindingProperties;
import com.google.cloud.spring.stream.binder.pubsub.provisioning.PubSubChannelProvisioner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.config.ConsumerEndpointCustomizer;
import org.springframework.cloud.stream.config.ProducerMessageHandlerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={Binder.class})
@ConditionalOnBean(value={PubSubAdmin.class, PubSubTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.pubsub.binder.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={PubSubExtendedBindingProperties.class})
@ImportRuntimeHints(value={PubSubConsumerPropertiesRuntimeHints.class})
public class PubSubBinderConfiguration {
    @Bean
    public PubSubChannelProvisioner pubSubChannelProvisioner(PubSubAdmin pubSubAdmin) {
        return new PubSubChannelProvisioner(pubSubAdmin);
    }

    @Bean
    public PubSubMessageChannelBinder pubSubBinder(PubSubChannelProvisioner pubSubChannelProvisioner, PubSubTemplate pubSubTemplate, PubSubExtendedBindingProperties pubSubExtendedBindingProperties, @Nullable ProducerMessageHandlerCustomizer<PubSubMessageHandler> producerCustomizer, @Nullable ConsumerEndpointCustomizer<PubSubInboundChannelAdapter> consumerCustomizer, @Nullable HealthTrackerRegistry healthTrackerRegistry) {
        PubSubMessageChannelBinder binder = new PubSubMessageChannelBinder(null, pubSubChannelProvisioner, pubSubTemplate, pubSubExtendedBindingProperties);
        binder.setProducerMessageHandlerCustomizer(producerCustomizer);
        binder.setConsumerEndpointCustomizer(consumerCustomizer);
        if (healthTrackerRegistry != null) {
            binder.setHealthTrackerRegistry(healthTrackerRegistry);
        }
        return binder;
    }
}

