/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.storage.integration;

import com.google.cloud.spring.storage.integration.GcsSession;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SharedSessionCapable;
import org.springframework.util.Assert;

public class GcsSessionFactory
implements SessionFactory<BlobInfo>,
SharedSessionCapable {
    private Storage gcs;

    public GcsSessionFactory(Storage gcs) {
        Assert.notNull((Object)gcs, (String)"The GCS client can't be null.");
        this.gcs = gcs;
    }

    public Session<BlobInfo> getSession() {
        return new GcsSession(this.gcs);
    }

    public boolean isSharedSession() {
        return true;
    }

    public void resetSharedSession() {
    }
}

