/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.vision;

import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.cloud.spring.storage.GoogleStorageLocation;
import com.google.cloud.spring.vision.DocumentOcrResultSet;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.vision.v1.AsyncAnnotateFileRequest;
import com.google.cloud.vision.v1.AsyncAnnotateFileResponse;
import com.google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse;
import com.google.cloud.vision.v1.Feature;
import com.google.cloud.vision.v1.GcsDestination;
import com.google.cloud.vision.v1.GcsSource;
import com.google.cloud.vision.v1.ImageAnnotatorClient;
import com.google.cloud.vision.v1.InputConfig;
import com.google.cloud.vision.v1.OperationMetadata;
import com.google.cloud.vision.v1.OutputConfig;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.StreamSupport;
import org.springframework.util.Assert;

public class DocumentOcrTemplate {
    private static final Feature DOCUMENT_OCR_FEATURE = Feature.newBuilder().setType(Feature.Type.DOCUMENT_TEXT_DETECTION).build();
    private final ImageAnnotatorClient imageAnnotatorClient;
    private final Storage storage;
    private final Executor executor;
    private final int jsonOutputBatchSize;

    public DocumentOcrTemplate(ImageAnnotatorClient imageAnnotatorClient, Storage storage, Executor executor, int jsonOutputBatchSize) {
        this.imageAnnotatorClient = imageAnnotatorClient;
        this.storage = storage;
        this.executor = executor;
        this.jsonOutputBatchSize = jsonOutputBatchSize;
    }

    public CompletableFuture<DocumentOcrResultSet> runOcrForDocument(GoogleStorageLocation document, GoogleStorageLocation outputFilePathPrefix) {
        Assert.isTrue((boolean)document.isFile(), (String)("Provided document location is not a valid file location: " + document));
        GcsSource gcsSource = GcsSource.newBuilder().setUri(document.uriString()).build();
        String contentType = this.extractContentType(document);
        InputConfig inputConfig = InputConfig.newBuilder().setMimeType(contentType).setGcsSource(gcsSource).build();
        GcsDestination gcsDestination = GcsDestination.newBuilder().setUri(outputFilePathPrefix.uriString()).build();
        OutputConfig outputConfig = OutputConfig.newBuilder().setGcsDestination(gcsDestination).setBatchSize(this.jsonOutputBatchSize).build();
        AsyncAnnotateFileRequest request = AsyncAnnotateFileRequest.newBuilder().addFeatures(DOCUMENT_OCR_FEATURE).setInputConfig(inputConfig).setOutputConfig(outputConfig).build();
        OperationFuture result = this.imageAnnotatorClient.asyncBatchAnnotateFilesAsync(Collections.singletonList(request));
        return this.extractOcrResultFuture((OperationFuture<AsyncBatchAnnotateFilesResponse, OperationMetadata>)result);
    }

    public DocumentOcrResultSet readOcrOutputFileSet(GoogleStorageLocation jsonOutputFilePathPrefix) {
        String nonNullPrefix = jsonOutputFilePathPrefix.getBlobName() == null ? "" : jsonOutputFilePathPrefix.getBlobName();
        Page blobsInFolder = this.storage.list(jsonOutputFilePathPrefix.getBucketName(), new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)nonNullPrefix)});
        List<Blob> blobPages = StreamSupport.stream(blobsInFolder.getValues().spliterator(), false).filter(blob -> blob.getContentType().equals("application/octet-stream")).toList();
        return new DocumentOcrResultSet(blobPages);
    }

    public DocumentOcrResultSet readOcrOutputFile(GoogleStorageLocation jsonFile) {
        if (!jsonFile.isFile()) {
            throw new IllegalArgumentException("Provided jsonOutputFile location is not a valid file location: " + jsonFile);
        }
        Blob jsonOutputBlob = this.storage.get(BlobId.of((String)jsonFile.getBucketName(), (String)jsonFile.getBlobName()));
        return new DocumentOcrResultSet(Collections.singletonList(jsonOutputBlob));
    }

    private CompletableFuture<DocumentOcrResultSet> extractOcrResultFuture(OperationFuture<AsyncBatchAnnotateFilesResponse, OperationMetadata> grpcFuture) {
        final CompletableFuture<DocumentOcrResultSet> result = new CompletableFuture<DocumentOcrResultSet>();
        ApiFutures.addCallback(grpcFuture, (ApiFutureCallback)new ApiFutureCallback<AsyncBatchAnnotateFilesResponse>(){

            public void onFailure(Throwable throwable) {
                result.completeExceptionally(throwable);
            }

            public void onSuccess(AsyncBatchAnnotateFilesResponse asyncBatchAnnotateFilesResponse) {
                String outputLocationUri = ((AsyncAnnotateFileResponse)asyncBatchAnnotateFilesResponse.getResponsesList().get(0)).getOutputConfig().getGcsDestination().getUri();
                GoogleStorageLocation outputFolderLocation = new GoogleStorageLocation(outputLocationUri);
                result.complete(DocumentOcrTemplate.this.readOcrOutputFileSet(outputFolderLocation));
            }
        }, (Executor)this.executor);
        return result;
    }

    private String extractContentType(GoogleStorageLocation document) {
        Blob documentBlob = this.storage.get(BlobId.of((String)document.getBucketName(), (String)document.getBlobName()));
        if (documentBlob == null) {
            throw new IllegalArgumentException("Provided document does not exist: " + document);
        }
        return documentBlob.getContentType();
    }
}

