/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MainClassFinder {
    public static Result find(List<Path> files, Consumer<LogEvent> logger) {
        ArrayList<String> mainClasses = new ArrayList<String>();
        for (Path file : files) {
            if (!Files.exists(file, new LinkOption[0])) {
                logger.accept(LogEvent.debug("MainClassFinder: " + file + " does not exist; ignoring"));
                continue;
            }
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                logger.accept(LogEvent.debug("MainClassFinder: " + file + " is not a regular file; skipping"));
                continue;
            }
            if (!file.toString().endsWith(".class")) {
                logger.accept(LogEvent.debug("MainClassFinder: " + file + " is not a class file; skipping"));
                continue;
            }
            MainClassVisitor mainClassVisitor = new MainClassVisitor();
            try {
                InputStream classFileInputStream = Files.newInputStream(file, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    ClassReader reader = new ClassReader(classFileInputStream);
                    reader.accept((ClassVisitor)mainClassVisitor, 0);
                    if (!mainClassVisitor.visitedMainClass) continue;
                    mainClasses.add(reader.getClassName().replace('/', '.'));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (classFileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            classFileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    classFileInputStream.close();
                }
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                logger.accept(LogEvent.warn("Invalid class file found: " + file));
            }
            catch (IOException ignored) {
                logger.accept(LogEvent.warn("Could not read file: " + file));
            }
        }
        if (mainClasses.size() == 1) {
            return Result.success((String)mainClasses.get(0));
        }
        if (mainClasses.size() == 0) {
            return Result.mainClassNotFound();
        }
        return Result.multipleMainClasses(mainClasses);
    }

    private static class MainClassVisitor
    extends ClassVisitor {
        private static final String MAIN_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String[].class)});
        private static final int OPTIONAL_ACCESS = 131216;
        private boolean visitedMainClass;

        private MainClassVisitor() {
            super(458752);
        }

        @Nullable
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if ((access & 0xFFFDFF6F) == 9 && name.equals("main") && descriptor.equals(MAIN_DESCRIPTOR)) {
                this.visitedMainClass = true;
            }
            return null;
        }
    }

    public static class Result {
        private final Type type;
        private final List<String> foundMainClasses;

        private static Result success(String foundMainClass) {
            return new Result(Type.MAIN_CLASS_FOUND, Collections.singletonList(foundMainClass));
        }

        private static Result mainClassNotFound() {
            return new Result(Type.MAIN_CLASS_NOT_FOUND, Collections.emptyList());
        }

        private static Result multipleMainClasses(List<String> foundMainClasses) {
            return new Result(Type.MULTIPLE_MAIN_CLASSES, foundMainClasses);
        }

        private Result(Type type, List<String> foundMainClasses) {
            this.foundMainClasses = foundMainClasses;
            this.type = type;
        }

        public String getFoundMainClass() {
            Preconditions.checkState((Type.MAIN_CLASS_FOUND == this.type ? 1 : 0) != 0);
            Preconditions.checkState((this.foundMainClasses.size() == 1 ? 1 : 0) != 0);
            return this.foundMainClasses.get(0);
        }

        public Type getType() {
            return this.type;
        }

        public List<String> getFoundMainClasses() {
            return this.foundMainClasses;
        }

        public static enum Type {
            MAIN_CLASS_FOUND,
            MAIN_CLASS_NOT_FOUND,
            MULTIPLE_MAIN_CLASSES;

        }
    }
}

