/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.DefaultHttpClient;

public class Connection
implements Closeable {
    private HttpRequestFactory requestFactory;
    @Nullable
    private HttpResponse httpResponse;
    private final GenericUrl url;

    public static Function<URL, Connection> getConnectionFactory() {
        ApacheHttpTransport transport = new ApacheHttpTransport();
        Connection.addProxyCredentials(transport);
        return url -> new Connection((URL)url, (HttpTransport)transport);
    }

    public static Function<URL, Connection> getInsecureConnectionFactory() throws GeneralSecurityException {
        ApacheHttpTransport transport = new ApacheHttpTransport.Builder().doNotValidateCertificate().build();
        Connection.addProxyCredentials(transport);
        return url -> new Connection((URL)url, (HttpTransport)transport);
    }

    @VisibleForTesting
    static void addProxyCredentials(ApacheHttpTransport transport) {
        Connection.addProxyCredentials(transport, "https");
        Connection.addProxyCredentials(transport, "http");
    }

    private static void addProxyCredentials(ApacheHttpTransport transport, String protocol) {
        Preconditions.checkArgument((protocol.equals("http") || protocol.equals("https") ? 1 : 0) != 0);
        String proxyHost = System.getProperty(protocol + ".proxyHost");
        String proxyUser = System.getProperty(protocol + ".proxyUser");
        String proxyPassword = System.getProperty(protocol + ".proxyPassword");
        if (proxyHost == null || proxyUser == null || proxyPassword == null) {
            return;
        }
        String defaultProxyPort = protocol.equals("http") ? "80" : "443";
        int proxyPort = Integer.parseInt(System.getProperty(protocol + ".proxyPort", defaultProxyPort));
        DefaultHttpClient httpClient = (DefaultHttpClient)transport.getHttpClient();
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
    }

    @VisibleForTesting
    Connection(URL url, HttpTransport transport) {
        this.url = new GenericUrl(url);
        this.requestFactory = transport.createRequestFactory();
    }

    @Override
    public void close() throws IOException {
        if (this.httpResponse == null) {
            return;
        }
        this.httpResponse.disconnect();
    }

    public Response get(Request request) throws IOException {
        return this.send("GET", request);
    }

    public Response post(Request request) throws IOException {
        return this.send("POST", request);
    }

    public Response put(Request request) throws IOException {
        return this.send("PUT", request);
    }

    public Response send(String httpMethod, Request request) throws IOException {
        Preconditions.checkState((this.httpResponse == null ? 1 : 0) != 0, (Object)"Connection can send only one request");
        HttpRequest httpRequest = this.requestFactory.buildRequest(httpMethod, this.url, request.getHttpContent()).setHeaders(request.getHeaders());
        if (request.getHttpTimeout() != null) {
            httpRequest.setConnectTimeout(request.getHttpTimeout().intValue());
            httpRequest.setReadTimeout(request.getHttpTimeout().intValue());
        }
        this.httpResponse = httpRequest.execute();
        return new Response(this.httpResponse);
    }
}

