/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.Port;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.configuration.DockerHealthCheck;
import com.google.cloud.tools.jib.image.DigestOnlyLayer;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.ReferenceLayer;
import com.google.cloud.tools.jib.image.ReferenceNoDiffIdLayer;
import com.google.cloud.tools.jib.image.json.BadContainerConfigurationFormatException;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class JsonToImageTranslator {
    private static final Pattern PORT_PATTERN = Pattern.compile("(?<portNum>\\d+)(?:/(?<protocol>tcp|udp))?");
    @VisibleForTesting
    static final Pattern ENVIRONMENT_PATTERN = Pattern.compile("(?<name>[^=]+)=(?<value>.*)");

    public static Image toImage(V21ManifestTemplate manifestTemplate) throws LayerPropertyNotFoundException, BadContainerConfigurationFormatException {
        Image.Builder imageBuilder = Image.builder(V21ManifestTemplate.class);
        for (DescriptorDigest digest : Lists.reverse(manifestTemplate.getLayerDigests())) {
            imageBuilder.addLayer(new DigestOnlyLayer(digest));
        }
        if (manifestTemplate.getContainerConfiguration().isPresent()) {
            JsonToImageTranslator.configureBuilderWithContainerConfiguration(imageBuilder, manifestTemplate.getContainerConfiguration().get());
        }
        return imageBuilder.build();
    }

    public static Image toImage(BuildableManifestTemplate manifestTemplate, ContainerConfigurationTemplate containerConfigurationTemplate) throws LayerCountMismatchException, LayerPropertyNotFoundException, BadContainerConfigurationFormatException {
        ArrayList<ReferenceNoDiffIdLayer> layers = new ArrayList<ReferenceNoDiffIdLayer>();
        for (BuildableManifestTemplate.ContentDescriptorTemplate layerObjectTemplate : manifestTemplate.getLayers()) {
            if (layerObjectTemplate.getDigest() == null) {
                throw new IllegalArgumentException("All layers in the manifest template must have digest set");
            }
            layers.add(new ReferenceNoDiffIdLayer(new BlobDescriptor(layerObjectTemplate.getSize(), layerObjectTemplate.getDigest())));
        }
        List<DescriptorDigest> diffIds = containerConfigurationTemplate.getDiffIds();
        if (layers.size() != diffIds.size()) {
            throw new LayerCountMismatchException("Mismatch between image manifest and container configuration");
        }
        Image.Builder imageBuilder = Image.builder(manifestTemplate.getClass());
        for (int layerIndex = 0; layerIndex < layers.size(); ++layerIndex) {
            ReferenceNoDiffIdLayer noDiffIdLayer = (ReferenceNoDiffIdLayer)layers.get(layerIndex);
            DescriptorDigest diffId = diffIds.get(layerIndex);
            imageBuilder.addLayer(new ReferenceLayer(noDiffIdLayer.getBlobDescriptor(), diffId));
        }
        JsonToImageTranslator.configureBuilderWithContainerConfiguration(imageBuilder, containerConfigurationTemplate);
        return imageBuilder.build();
    }

    private static void configureBuilderWithContainerConfiguration(Image.Builder imageBuilder, ContainerConfigurationTemplate containerConfigurationTemplate) throws BadContainerConfigurationFormatException {
        containerConfigurationTemplate.getHistory().forEach(imageBuilder::addHistory);
        if (containerConfigurationTemplate.getCreated() != null) {
            try {
                imageBuilder.setCreated(Instant.parse(containerConfigurationTemplate.getCreated()));
            }
            catch (DateTimeParseException ex) {
                throw new BadContainerConfigurationFormatException("Invalid image creation time: " + containerConfigurationTemplate.getCreated(), ex);
            }
        }
        if (containerConfigurationTemplate.getArchitecture() != null) {
            imageBuilder.setArchitecture(containerConfigurationTemplate.getArchitecture());
        }
        if (containerConfigurationTemplate.getOs() != null) {
            imageBuilder.setOs(containerConfigurationTemplate.getOs());
        }
        imageBuilder.setEntrypoint(containerConfigurationTemplate.getContainerEntrypoint());
        imageBuilder.setProgramArguments(containerConfigurationTemplate.getContainerCmd());
        List<String> baseHealthCheckCommand = containerConfigurationTemplate.getContainerHealthTest();
        if (baseHealthCheckCommand != null) {
            DockerHealthCheck.Builder builder = DockerHealthCheck.fromCommand(baseHealthCheckCommand);
            if (containerConfigurationTemplate.getContainerHealthInterval() != null) {
                builder.setInterval(Duration.ofNanos(containerConfigurationTemplate.getContainerHealthInterval()));
            }
            if (containerConfigurationTemplate.getContainerHealthTimeout() != null) {
                builder.setTimeout(Duration.ofNanos(containerConfigurationTemplate.getContainerHealthTimeout()));
            }
            if (containerConfigurationTemplate.getContainerHealthStartPeriod() != null) {
                builder.setStartPeriod(Duration.ofNanos(containerConfigurationTemplate.getContainerHealthStartPeriod()));
            }
            if (containerConfigurationTemplate.getContainerHealthRetries() != null) {
                builder.setRetries(containerConfigurationTemplate.getContainerHealthRetries());
            }
            imageBuilder.setHealthCheck(builder.build());
        }
        if (containerConfigurationTemplate.getContainerExposedPorts() != null) {
            imageBuilder.addExposedPorts((Set<Port>)JsonToImageTranslator.portMapToSet(containerConfigurationTemplate.getContainerExposedPorts()));
        }
        if (containerConfigurationTemplate.getContainerVolumes() != null) {
            imageBuilder.addVolumes((Set<AbsoluteUnixPath>)JsonToImageTranslator.volumeMapToSet(containerConfigurationTemplate.getContainerVolumes()));
        }
        if (containerConfigurationTemplate.getContainerEnvironment() != null) {
            for (String environmentVariable : containerConfigurationTemplate.getContainerEnvironment()) {
                Matcher matcher = ENVIRONMENT_PATTERN.matcher(environmentVariable);
                if (!matcher.matches()) {
                    throw new BadContainerConfigurationFormatException("Invalid environment variable definition: " + environmentVariable);
                }
                imageBuilder.addEnvironmentVariable(matcher.group("name"), matcher.group("value"));
            }
        }
        imageBuilder.addLabels(containerConfigurationTemplate.getContainerLabels());
        imageBuilder.setWorkingDirectory(containerConfigurationTemplate.getContainerWorkingDir());
        imageBuilder.setUser(containerConfigurationTemplate.getContainerUser());
    }

    @VisibleForTesting
    static ImmutableSet<Port> portMapToSet(@Nullable Map<String, Map<?, ?>> portMap) throws BadContainerConfigurationFormatException {
        if (portMap == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder ports = new ImmutableSet.Builder();
        for (Map.Entry<String, Map<?, ?>> entry : portMap.entrySet()) {
            String port = entry.getKey();
            Matcher matcher = PORT_PATTERN.matcher(port);
            if (!matcher.matches()) {
                throw new BadContainerConfigurationFormatException("Invalid port configuration: '" + port + "'.");
            }
            int portNumber = Integer.parseInt(matcher.group("portNum"));
            String protocol = matcher.group("protocol");
            ports.add((Object)Port.parseProtocol(portNumber, protocol));
        }
        return ports.build();
    }

    @VisibleForTesting
    static ImmutableSet<AbsoluteUnixPath> volumeMapToSet(@Nullable Map<String, Map<?, ?>> volumeMap) throws BadContainerConfigurationFormatException {
        if (volumeMap == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder volumeList = ImmutableSet.builder();
        for (String volume : volumeMap.keySet()) {
            try {
                volumeList.add((Object)AbsoluteUnixPath.get(volume));
            }
            catch (IllegalArgumentException exception) {
                throw new BadContainerConfigurationFormatException("Invalid volume path: " + volume);
            }
        }
        return volumeList.build();
    }

    private JsonToImageTranslator() {
    }
}

