/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.crypto.SettingsDecrypter;

public abstract class JibPluginConfiguration
extends AbstractMojo {
    @Nullable
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Nullable
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Nullable
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor descriptor;
    @Parameter
    private FromConfiguration from = new FromConfiguration();
    @Parameter
    private ToConfiguration to = new ToConfiguration();
    @Parameter
    private ContainerParameters container = new ContainerParameters();
    @Deprecated
    @Parameter
    private ExtraDirectoryParameters extraDirectory = new ExtraDirectoryParameters();
    @Parameter
    private ExtraDirectoriesParameters extraDirectories = new ExtraDirectoriesParameters();
    @Parameter
    private DockerClientParameters dockerClient = new DockerClientParameters();
    @Parameter(property="jib.allowInsecureRegistries")
    private boolean allowInsecureRegistries;
    @Parameter(property="jib.containerizingMode")
    private String containerizingMode = "exploded";
    @Parameter(property="jib.skip")
    private boolean skip;
    @Component
    protected SettingsDecrypter settingsDecrypter;

    MavenSession getSession() {
        return (MavenSession)Preconditions.checkNotNull((Object)this.session);
    }

    protected MavenProject getProject() {
        return (MavenProject)Preconditions.checkNotNull((Object)this.project);
    }

    protected void checkJibVersion() throws MojoExecutionException {
        Preconditions.checkNotNull((Object)this.descriptor);
        MojoCommon.checkJibVersion(this.descriptor);
    }

    @Nullable
    String getBaseImage() {
        String property = this.getProperty("jib.from.image");
        if (property != null) {
            return property;
        }
        return this.from.image;
    }

    @Nullable
    String getBaseImageCredentialHelperName() {
        String property = this.getProperty("jib.from.credHelper");
        if (property != null) {
            return property;
        }
        return this.from.credHelper;
    }

    AuthConfiguration getBaseImageAuth() {
        return this.from.auth;
    }

    @Nullable
    protected String getTargetImage() {
        String propertyAlternate = this.getProperty("image");
        if (propertyAlternate != null) {
            return propertyAlternate;
        }
        String property = this.getProperty("jib.to.image");
        if (property != null) {
            return property;
        }
        return this.to.image;
    }

    Set<String> getTargetImageAdditionalTags() {
        List tags;
        String property = this.getProperty("jib.to.tags");
        List list = tags = property != null ? ConfigurationPropertyValidator.parseListProperty(property) : this.to.tags;
        if (tags.stream().anyMatch(Strings::isNullOrEmpty)) {
            String source = property != null ? "jib.to.tags" : "<to><tags>";
            throw new IllegalArgumentException(source + " has empty tag");
        }
        return new HashSet<String>(tags);
    }

    @Nullable
    String getTargetImageCredentialHelperName() {
        String property = this.getProperty("jib.to.credHelper");
        if (property != null) {
            return property;
        }
        return this.to.credHelper;
    }

    AuthConfiguration getTargetImageAuth() {
        return this.to.auth;
    }

    @Deprecated
    boolean getUseCurrentTimestamp() {
        String property = this.getProperty("jib.container.useCurrentTimestamp");
        if (property != null) {
            return Boolean.parseBoolean(property);
        }
        return this.container.useCurrentTimestamp;
    }

    @Nullable
    List<String> getEntrypoint() {
        String property = this.getProperty("jib.container.entrypoint");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.entrypoint;
    }

    List<String> getJvmFlags() {
        String property = this.getProperty("jib.container.jvmFlags");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.jvmFlags;
    }

    Map<String, String> getEnvironment() {
        String property = this.getProperty("jib.container.environment");
        if (property != null) {
            return ConfigurationPropertyValidator.parseMapProperty(property);
        }
        return this.container.environment;
    }

    List<String> getExtraClasspath() {
        String property = this.getProperty("jib.container.extraClasspath");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.extraClasspath;
    }

    @Nullable
    String getMainClass() {
        String property = this.getProperty("jib.container.mainClass");
        if (property != null) {
            return property;
        }
        return this.container.mainClass;
    }

    @Nullable
    String getUser() {
        String property = this.getProperty("jib.container.user");
        if (property != null) {
            return property;
        }
        return this.container.user;
    }

    @Nullable
    String getWorkingDirectory() {
        String property = this.getProperty("jib.container.workingDirectory");
        if (property != null) {
            return property;
        }
        return this.container.workingDirectory;
    }

    @Nullable
    List<String> getArgs() {
        String property = this.getProperty("jib.container.args");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.args;
    }

    List<String> getExposedPorts() {
        String property = this.getProperty("jib.container.ports");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.ports;
    }

    List<String> getVolumes() {
        String property = this.getProperty("jib.container.volumes");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.volumes;
    }

    Map<String, String> getLabels() {
        String property = this.getProperty("jib.container.labels");
        if (property != null) {
            return ConfigurationPropertyValidator.parseMapProperty(property);
        }
        return this.container.labels;
    }

    String getAppRoot() {
        String property = this.getProperty("jib.container.appRoot");
        if (property != null) {
            return property;
        }
        return this.container.appRoot;
    }

    String getFormat() {
        String property = this.getProperty("jib.container.format");
        if (property != null) {
            return property;
        }
        return this.container.format;
    }

    String getFilesModificationTime() {
        String property = this.getProperty("jib.container.filesModificationTime");
        if (property != null) {
            return property;
        }
        return this.container.filesModificationTime;
    }

    String getCreationTime() {
        String property = this.getProperty("jib.container.creationTime");
        if (property != null) {
            return property;
        }
        return this.container.creationTime;
    }

    List<Path> getExtraDirectories() {
        String property;
        String deprecatedProperty = this.getProperty("jib.extraDirectory.path");
        String newProperty = this.getProperty("jib.extraDirectories.paths");
        List<File> deprecatedPaths = this.extraDirectory.getPaths();
        List<File> newPaths = this.extraDirectories.getPaths();
        if (deprecatedProperty != null) {
            this.getLog().warn((CharSequence)"The property 'jib.extraDirectory.path' is deprecated; use 'jib.extraDirectories.paths' instead");
        }
        if (!deprecatedPaths.isEmpty()) {
            this.getLog().warn((CharSequence)"<extraDirectory> is deprecated; use <extraDirectories> with <paths><path>");
        }
        if (deprecatedProperty != null && newProperty != null) {
            throw new IllegalArgumentException("You cannot configure both 'jib.extraDirectory.path' and 'jib.extraDirectories.paths'");
        }
        if (!deprecatedPaths.isEmpty() && !newPaths.isEmpty()) {
            throw new IllegalArgumentException("You cannot configure both <extraDirectory> and <extraDirectories>");
        }
        String string = property = newProperty != null ? newProperty : deprecatedProperty;
        if (property != null) {
            List<String> paths = ConfigurationPropertyValidator.parseListProperty(property);
            return paths.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        }
        List<File> paths = !newPaths.isEmpty() ? newPaths : deprecatedPaths;
        return paths.stream().map(File::toPath).collect(Collectors.toList());
    }

    List<PermissionConfiguration> getExtraDirectoryPermissions() {
        String property;
        String deprecatedProperty = this.getProperty("jib.extraDirectory.permissions");
        String newProperty = this.getProperty("jib.extraDirectories.permissions");
        List deprecatedPermissions = this.extraDirectory.permissions;
        List newPermissions = this.extraDirectories.permissions;
        if (deprecatedProperty != null) {
            this.getLog().warn((CharSequence)"The property 'jib.extraDirectory.permissions' is deprecated; use 'jib.extraDirectories.permissions' instead");
        }
        if (deprecatedProperty != null && newProperty != null) {
            throw new IllegalArgumentException("You cannot configure both 'jib.extraDirectory.permissions' and 'jib.extraDirectories.permissions'");
        }
        if (!deprecatedPermissions.isEmpty() && !newPermissions.isEmpty()) {
            throw new IllegalArgumentException("You cannot configure both <extraDirectory> and <extraDirectories>");
        }
        String string = property = newProperty != null ? newProperty : deprecatedProperty;
        if (property != null) {
            return ConfigurationPropertyValidator.parseMapProperty(property).entrySet().stream().map(entry -> new PermissionConfiguration((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        }
        return !this.extraDirectories.getPaths().isEmpty() ? this.extraDirectories.permissions : this.extraDirectory.permissions;
    }

    @Nullable
    Path getDockerClientExecutable() {
        String property = this.getProperty("jib.dockerClient.executable");
        if (property != null) {
            return Paths.get(property, new String[0]);
        }
        return this.dockerClient.executable == null ? null : this.dockerClient.executable.toPath();
    }

    Map<String, String> getDockerClientEnvironment() {
        String property = this.getProperty("jib.dockerClient.environment");
        if (property != null) {
            return ConfigurationPropertyValidator.parseMapProperty(property);
        }
        return this.dockerClient.environment;
    }

    boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    public String getContainerizingMode() {
        String property = this.getProperty("jib.containerizingMode");
        return property != null ? property : this.containerizingMode;
    }

    boolean isSkipped() {
        return this.skip;
    }

    boolean isContainerizable() {
        String moduleSpecification = this.getProperty("jib.containerize");
        if (this.project == null || Strings.isNullOrEmpty((String)moduleSpecification)) {
            return true;
        }
        if (moduleSpecification.equals(this.project.getGroupId() + ":" + this.project.getArtifactId()) || moduleSpecification.equals(":" + this.project.getArtifactId())) {
            return true;
        }
        if (moduleSpecification.contains(":")) {
            return false;
        }
        try {
            Path projectBase = this.project.getBasedir().toPath();
            return projectBase.endsWith(moduleSpecification);
        }
        catch (InvalidPathException ex) {
            return false;
        }
    }

    SettingsDecrypter getSettingsDecrypter() {
        return this.settingsDecrypter;
    }

    @VisibleForTesting
    void setProject(MavenProject project) {
        this.project = project;
    }

    @VisibleForTesting
    void setSession(MavenSession session) {
        this.session = session;
    }

    @Nullable
    String getProperty(String propertyName) {
        return MavenProjectProperties.getProperty(propertyName, this.project, this.session);
    }

    public static class DockerClientParameters {
        @Nullable
        @Parameter
        private File executable;
        @Parameter
        private Map<String, String> environment = Collections.emptyMap();
    }

    @Deprecated
    public static class ExtraDirectoryParameters {
        @Deprecated
        @Nullable
        @Parameter
        private File path;
        @Deprecated
        @Parameter
        private List<PermissionConfiguration> permissions = Collections.emptyList();

        @Deprecated
        public void set(File path) {
            this.path = path;
        }

        @Deprecated
        public List<File> getPaths() {
            return this.path == null ? Collections.emptyList() : Collections.singletonList(this.path);
        }
    }

    public static class ExtraDirectoriesParameters {
        @Parameter
        private List<File> paths = Collections.emptyList();
        @Parameter
        private List<PermissionConfiguration> permissions = Collections.emptyList();

        public List<File> getPaths() {
            return this.paths;
        }
    }

    public static class ContainerParameters {
        @Parameter
        private boolean useCurrentTimestamp = false;
        @Nullable
        @Parameter
        private List<String> entrypoint;
        @Parameter
        private List<String> jvmFlags = Collections.emptyList();
        @Parameter
        private Map<String, String> environment = Collections.emptyMap();
        @Parameter
        private List<String> extraClasspath = Collections.emptyList();
        @Nullable
        @Parameter
        private String mainClass;
        @Nullable
        @Parameter
        private List<String> args;
        @Parameter
        private String format = "Docker";
        @Parameter
        private List<String> ports = Collections.emptyList();
        @Parameter
        private List<String> volumes = Collections.emptyList();
        @Parameter
        private Map<String, String> labels = Collections.emptyMap();
        @Parameter
        private String appRoot = "";
        @Nullable
        @Parameter
        private String user;
        @Nullable
        @Parameter
        private String workingDirectory;
        @Parameter
        private String filesModificationTime = "EPOCH_PLUS_SECOND";
        @Parameter
        private String creationTime = "EPOCH";
    }

    public static class ToConfiguration {
        @Nullable
        @Parameter
        private String image;
        @Parameter
        private List<String> tags = Collections.emptyList();
        @Nullable
        @Parameter
        private String credHelper;
        @Parameter
        private ToAuthConfiguration auth = new ToAuthConfiguration();

        public void set(String image) {
            this.image = image;
        }
    }

    public static class FromConfiguration {
        @Nullable
        @Parameter
        private String image;
        @Nullable
        @Parameter
        private String credHelper;
        @Parameter
        private FromAuthConfiguration auth = new FromAuthConfiguration();
    }

    public static class PermissionConfiguration {
        @Nullable
        @Parameter
        private String file;
        @Nullable
        @Parameter
        private String mode;

        public PermissionConfiguration() {
        }

        @VisibleForTesting
        PermissionConfiguration(String file, String mode) {
            this.file = file;
            this.mode = mode;
        }

        Optional<String> getFile() {
            return Optional.ofNullable(this.file);
        }

        Optional<String> getMode() {
            return Optional.ofNullable(this.mode);
        }
    }

    public static class ToAuthConfiguration
    extends AuthConfiguration {
        public ToAuthConfiguration() {
            super("to");
        }
    }

    public static class FromAuthConfiguration
    extends AuthConfiguration {
        public FromAuthConfiguration() {
            super("from");
        }
    }

    private static class AuthConfiguration
    implements AuthProperty {
        @Nullable
        @Parameter
        private String username;
        @Nullable
        @Parameter
        private String password;
        private final String source;

        private AuthConfiguration(String source) {
            this.source = source;
        }

        @Override
        @Nullable
        public String getUsername() {
            return this.username;
        }

        @Override
        @Nullable
        public String getPassword() {
            return this.password;
        }

        @Override
        public String getAuthDescriptor() {
            return "<" + this.source + "><auth>";
        }

        @Override
        public String getUsernameDescriptor() {
            return this.getAuthDescriptor() + "<username>";
        }

        @Override
        public String getPasswordDescriptor() {
            return this.getAuthDescriptor() + "<password>";
        }
    }
}

