/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.GenericUrl;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.common.net.MediaType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;

class BlobPusher {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final DescriptorDigest blobDigest;
    private final Blob blob;
    @Nullable
    private final String sourceRepository;

    BlobPusher(RegistryEndpointRequestProperties registryEndpointRequestProperties, DescriptorDigest blobDigest, Blob blob, @Nullable String sourceRepository) {
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.blobDigest = blobDigest;
        this.blob = blob;
        this.sourceRepository = sourceRepository;
    }

    RegistryEndpointProvider<Optional<URL>> initializer() {
        return new Initializer();
    }

    RegistryEndpointProvider<URL> writer(URL location, Consumer<Long> writtenByteCountListener) {
        return new Writer(location, writtenByteCountListener);
    }

    RegistryEndpointProvider<Void> committer(URL location) {
        return new Committer(location);
    }

    private RegistryErrorException buildRegistryErrorException(String reason) {
        RegistryErrorExceptionBuilder registryErrorExceptionBuilder = new RegistryErrorExceptionBuilder(this.getActionDescription());
        registryErrorExceptionBuilder.addReason(reason);
        return registryErrorExceptionBuilder.build();
    }

    private String getActionDescription() {
        return "push BLOB for " + this.registryEndpointRequestProperties.getServerUrl() + "/" + this.registryEndpointRequestProperties.getImageName() + " with digest " + this.blobDigest;
    }

    private URL getRedirectLocation(Response response) throws RegistryErrorException {
        List<String> locationHeaders = response.getHeader("Location");
        if (locationHeaders.size() != 1) {
            throw this.buildRegistryErrorException("Expected 1 'Location' header, but found " + locationHeaders.size());
        }
        String locationHeader = locationHeaders.get(0);
        return response.getRequestUrl().toURL(locationHeader);
    }

    private class Committer
    implements RegistryEndpointProvider<Void> {
        private final URL location;

        @Override
        @Nullable
        public BlobHttpContent getContent() {
            return null;
        }

        @Override
        public List<String> getAccept() {
            return Collections.emptyList();
        }

        @Override
        public Void handleResponse(Response response) {
            return null;
        }

        @Override
        public URL getApiRoute(String apiRouteBase) {
            return new GenericUrl(this.location).set("digest", (Object)BlobPusher.this.blobDigest).toURL();
        }

        @Override
        public String getHttpMethod() {
            return "PUT";
        }

        @Override
        public String getActionDescription() {
            return BlobPusher.this.getActionDescription();
        }

        private Committer(URL location) {
            this.location = location;
        }
    }

    private class Writer
    implements RegistryEndpointProvider<URL> {
        private final URL location;
        private final Consumer<Long> writtenByteCountListener;

        @Override
        @Nullable
        public BlobHttpContent getContent() {
            return new BlobHttpContent(BlobPusher.this.blob, MediaType.OCTET_STREAM.toString(), this.writtenByteCountListener);
        }

        @Override
        public List<String> getAccept() {
            return Collections.emptyList();
        }

        @Override
        public URL handleResponse(Response response) throws RegistryException {
            return BlobPusher.this.getRedirectLocation(response);
        }

        @Override
        public URL getApiRoute(String apiRouteBase) {
            return this.location;
        }

        @Override
        public String getHttpMethod() {
            return "PATCH";
        }

        @Override
        public String getActionDescription() {
            return BlobPusher.this.getActionDescription();
        }

        private Writer(URL location, Consumer<Long> writtenByteCountListener) {
            this.location = location;
            this.writtenByteCountListener = writtenByteCountListener;
        }
    }

    private class Initializer
    implements RegistryEndpointProvider<Optional<URL>> {
        private Initializer() {
        }

        @Override
        @Nullable
        public BlobHttpContent getContent() {
            return null;
        }

        @Override
        public List<String> getAccept() {
            return Collections.emptyList();
        }

        @Override
        public Optional<URL> handleResponse(Response response) throws RegistryErrorException {
            switch (response.getStatusCode()) {
                case 201: {
                    return Optional.empty();
                }
                case 202: {
                    return Optional.of(BlobPusher.this.getRedirectLocation(response));
                }
            }
            throw BlobPusher.this.buildRegistryErrorException("Received unrecognized status code " + response.getStatusCode());
        }

        @Override
        public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
            StringBuilder url = new StringBuilder(apiRouteBase).append(BlobPusher.this.registryEndpointRequestProperties.getImageName()).append("/blobs/uploads/");
            if (BlobPusher.this.sourceRepository != null) {
                url.append("?mount=").append(BlobPusher.this.blobDigest).append("&from=").append(BlobPusher.this.sourceRepository);
            }
            return new URL(url.toString());
        }

        @Override
        public String getHttpMethod() {
            return "POST";
        }

        @Override
        public String getActionDescription() {
            return BlobPusher.this.getActionDescription();
        }
    }
}

