/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.tools.jib.api.LayerEntry;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class SkaffoldSyncMapTemplate
implements JsonTemplate {
    private final List<FileTemplate> generated = new ArrayList<FileTemplate>();
    private final List<FileTemplate> direct = new ArrayList<FileTemplate>();

    @VisibleForTesting
    public static SkaffoldSyncMapTemplate from(String jsonString) throws IOException {
        return (SkaffoldSyncMapTemplate)new ObjectMapper().readValue(jsonString, SkaffoldSyncMapTemplate.class);
    }

    public void addGenerated(LayerEntry layerEntry) {
        this.generated.add(new FileTemplate(layerEntry.getSourceFile().toAbsolutePath().toString(), layerEntry.getExtractionPath().toString()));
    }

    public void addDirect(LayerEntry layerEntry) {
        this.direct.add(new FileTemplate(layerEntry.getSourceFile().toAbsolutePath().toString(), layerEntry.getExtractionPath().toString()));
    }

    public String getJsonString() throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            new ObjectMapper().writeValue((OutputStream)outputStream, (Object)this);
            String string = ((Object)outputStream).toString();
            return string;
        }
    }

    @VisibleForTesting
    public List<FileTemplate> getGenerated() {
        return ImmutableList.copyOf(this.generated);
    }

    @VisibleForTesting
    public List<FileTemplate> getDirect() {
        return ImmutableList.copyOf(this.direct);
    }

    public static class FileTemplate
    implements JsonTemplate {
        private final String src;
        private final String dest;

        @JsonCreator
        public FileTemplate(@JsonProperty(value="src", required=true) String src, @JsonProperty(value="dest", required=true) String dest) {
            this.src = src;
            this.dest = dest;
        }

        @VisibleForTesting
        public String getSrc() {
            return this.src;
        }

        @VisibleForTesting
        public String getDest() {
            return this.dest;
        }
    }
}

