/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MavenRawConfiguration
implements RawConfiguration {
    private final JibPluginConfiguration jibPluginConfiguration;

    public MavenRawConfiguration(JibPluginConfiguration jibPluginConfiguration) {
        this.jibPluginConfiguration = jibPluginConfiguration;
    }

    @Override
    public Optional<String> getFromImage() {
        return Optional.ofNullable(this.jibPluginConfiguration.getBaseImage());
    }

    @Override
    public AuthProperty getFromAuth() {
        return this.jibPluginConfiguration.getBaseImageAuth();
    }

    @Override
    public Optional<String> getFromCredHelper() {
        return Optional.ofNullable(this.jibPluginConfiguration.getBaseImageCredentialHelperName());
    }

    @Override
    public Optional<String> getToImage() {
        return Optional.ofNullable(this.jibPluginConfiguration.getTargetImage());
    }

    @Override
    public AuthProperty getToAuth() {
        return this.jibPluginConfiguration.getTargetImageAuth();
    }

    @Override
    public Optional<String> getToCredHelper() {
        return Optional.ofNullable(this.jibPluginConfiguration.getTargetImageCredentialHelperName());
    }

    @Override
    public Set<String> getToTags() {
        return this.jibPluginConfiguration.getTargetImageAdditionalTags();
    }

    @Override
    public Optional<List<String>> getEntrypoint() {
        return Optional.ofNullable(this.jibPluginConfiguration.getEntrypoint());
    }

    @Override
    public Optional<List<String>> getProgramArguments() {
        return Optional.ofNullable(this.jibPluginConfiguration.getArgs());
    }

    @Override
    public List<String> getExtraClasspath() {
        return this.jibPluginConfiguration.getExtraClasspath();
    }

    @Override
    public Optional<String> getMainClass() {
        return Optional.ofNullable(this.jibPluginConfiguration.getMainClass());
    }

    @Override
    public List<String> getJvmFlags() {
        return this.jibPluginConfiguration.getJvmFlags();
    }

    @Override
    public String getAppRoot() {
        return this.jibPluginConfiguration.getAppRoot();
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.jibPluginConfiguration.getEnvironment();
    }

    @Override
    public Map<String, String> getLabels() {
        return this.jibPluginConfiguration.getLabels();
    }

    @Override
    public List<String> getVolumes() {
        return this.jibPluginConfiguration.getVolumes();
    }

    @Override
    public List<String> getPorts() {
        return this.jibPluginConfiguration.getExposedPorts();
    }

    @Override
    public Optional<String> getUser() {
        return Optional.ofNullable(this.jibPluginConfiguration.getUser());
    }

    @Override
    public Optional<String> getWorkingDirectory() {
        return Optional.ofNullable(this.jibPluginConfiguration.getWorkingDirectory());
    }

    @Override
    public boolean getAllowInsecureRegistries() {
        return this.jibPluginConfiguration.getAllowInsecureRegistries();
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.valueOf((String)this.jibPluginConfiguration.getFormat());
    }

    @Override
    public Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.jibPluginConfiguration.getProperty(propertyName));
    }

    @Override
    public String getFilesModificationTime() {
        return this.jibPluginConfiguration.getFilesModificationTime();
    }

    @Override
    public String getCreationTime() {
        return this.jibPluginConfiguration.getCreationTime();
    }

    @Override
    public Map<Path, AbsoluteUnixPath> getExtraDirectories() {
        LinkedHashMap<Path, AbsoluteUnixPath> directoryMap = new LinkedHashMap<Path, AbsoluteUnixPath>();
        for (JibPluginConfiguration.ExtraDirectoryParameters extraDirectory : MojoCommon.getExtraDirectories(this.jibPluginConfiguration)) {
            directoryMap.put(extraDirectory.getFrom(), AbsoluteUnixPath.get((String)extraDirectory.getInto()));
        }
        return directoryMap;
    }

    @Override
    public Map<String, FilePermissions> getExtraDirectoryPermissions() {
        return MojoCommon.convertPermissionsList(this.jibPluginConfiguration.getExtraDirectoryPermissions());
    }

    @Override
    public Optional<Path> getDockerExecutable() {
        return Optional.ofNullable(this.jibPluginConfiguration.getDockerClientExecutable());
    }

    @Override
    public Map<String, String> getDockerEnvironment() {
        return this.jibPluginConfiguration.getDockerClientEnvironment();
    }

    @Override
    public String getContainerizingMode() {
        return this.jibPluginConfiguration.getContainerizingMode();
    }

    @Override
    public Path getTarOutputPath() {
        return this.jibPluginConfiguration.getTarOutputPath();
    }

    @Override
    public Path getDigestOutputPath() {
        return this.jibPluginConfiguration.getDigestOutputPath();
    }

    @Override
    public Path getImageIdOutputPath() {
        return this.jibPluginConfiguration.getImageIdOutputPath();
    }

    @Override
    public Path getImageJsonOutputPath() {
        return this.jibPluginConfiguration.getImageJsonOutputPath();
    }

    @Override
    public List<? extends RawConfiguration.ExtensionConfiguration> getPluginExtensions() {
        return this.jibPluginConfiguration.getPluginExtensions();
    }
}

