/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common.logging;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.SingleThreadedExecutor;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.function.Consumer;

class PlainConsoleLogger
implements ConsoleLogger {
    private final ImmutableMap<LogEvent.Level, Consumer<String>> messageConsumers;
    private final SingleThreadedExecutor singleThreadedExecutor;

    PlainConsoleLogger(ImmutableMap<LogEvent.Level, Consumer<String>> messageConsumers, SingleThreadedExecutor singleThreadedExecutor) {
        this.messageConsumers = messageConsumers;
        this.singleThreadedExecutor = singleThreadedExecutor;
    }

    @Override
    public void log(LogEvent.Level logLevel, String message) {
        if (!this.messageConsumers.containsKey((Object)logLevel)) {
            return;
        }
        Consumer messageConsumer = (Consumer)this.messageConsumers.get((Object)logLevel);
        String plainMessage = message.replaceAll("\u001b\\[[0-9;]{1,5}m", "");
        this.singleThreadedExecutor.execute(() -> messageConsumer.accept(plainMessage));
    }

    @Override
    public void setFooter(List<String> footerLines) {
    }
}

