/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;

public class ImageMetadataOutput
implements JsonTemplate {
    private final String image;
    private final String imageId;
    private final String imageDigest;
    private final List<String> tags;
    private final Boolean imagePushed;

    @JsonCreator
    ImageMetadataOutput(@JsonProperty(value="image", required=true) String image, @JsonProperty(value="imageId", required=true) String imageId, @JsonProperty(value="imageDigest", required=true) String imageDigest, @JsonProperty(value="tags", required=true) List<String> tags, @JsonProperty(value="imagePushed", required=true) Boolean imagePushed) {
        this.image = image;
        this.imageId = imageId;
        this.imageDigest = imageDigest;
        this.tags = tags;
        this.imagePushed = imagePushed;
    }

    @VisibleForTesting
    static ImageMetadataOutput fromJson(String json) throws IOException {
        return JsonTemplateMapper.readJson(json, ImageMetadataOutput.class);
    }

    public static ImageMetadataOutput fromJibContainer(JibContainer jibContainer) {
        String image = jibContainer.getTargetImage().toString();
        String imageId = jibContainer.getImageId().toString();
        String imageDigest = jibContainer.getDigest().toString();
        Boolean imagePushed = jibContainer.isImagePushed();
        ImmutableList tags = ImmutableList.sortedCopyOf(jibContainer.getTags());
        return new ImageMetadataOutput(image, imageId, imageDigest, (List<String>)tags, imagePushed);
    }

    public String getImage() {
        return this.image;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getImageDigest() {
        return this.imageDigest;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Boolean isImagePushed() {
        return this.imagePushed;
    }

    public String toJson() throws IOException {
        return JsonTemplateMapper.toUtf8String(this);
    }
}

