/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.core;

import com.google.cloud.trace.core.TraceOptions;
import com.google.cloud.trace.core.TraceOptionsFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RateLimitingTraceOptionsFactory
implements TraceOptionsFactory {
    private final RateLimiter rateLimiter;
    private final boolean stackTraceEnabled;

    public RateLimitingTraceOptionsFactory(double samplingRate, boolean stackTraceEnabled) {
        this(RateLimiter.create((double)samplingRate), stackTraceEnabled);
    }

    @VisibleForTesting
    RateLimitingTraceOptionsFactory(RateLimiter rateLimiter, boolean stackTraceEnabled) {
        this.rateLimiter = (RateLimiter)Preconditions.checkNotNull((Object)rateLimiter);
        this.stackTraceEnabled = stackTraceEnabled;
    }

    @Override
    public TraceOptions create() {
        boolean traceEnabled = this.rateLimiter.tryAcquire();
        return new TraceOptions().overrideTraceEnabled(traceEnabled).overrideStackTraceEnabled(this.stackTraceEnabled);
    }

    @Override
    public TraceOptions create(TraceOptions traceOptions) {
        Preconditions.checkNotNull((Object)traceOptions);
        return traceOptions;
    }
}

