/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.core;

import com.google.cloud.trace.core.SpanId;
import com.google.cloud.trace.core.TraceId;
import com.google.cloud.trace.core.TraceOptions;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class SpanContext {
    private final TraceId traceId;
    private final SpanId spanId;
    private final TraceOptions traceOptions;

    public SpanContext(TraceId traceId, SpanId spanId, TraceOptions traceOptions) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.traceOptions = traceOptions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpanContext)) {
            return false;
        }
        SpanContext that = (SpanContext)obj;
        return Objects.equals(this.traceId, that.traceId) && Objects.equals(this.spanId, that.spanId) && Objects.equals(this.traceOptions, that.traceOptions);
    }

    public int hashCode() {
        return Objects.hash(this.traceId, this.spanId, this.traceOptions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("traceId", (Object)this.traceId).add("spanId", (Object)this.spanId).add("traceOptions", (Object)this.traceOptions).toString();
    }

    public TraceId getTraceId() {
        return this.traceId;
    }

    public SpanId getSpanId() {
        return this.spanId;
    }

    public TraceOptions getTraceOptions() {
        return this.traceOptions;
    }

    public SpanContext overrideOptions(TraceOptions overrideOptions) {
        return new SpanContext(this.traceId, this.spanId, overrideOptions);
    }
}

