/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.core;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLongs;
import java.util.Objects;

public class SpanId {
    private static final SpanId invalid = new SpanId(0L);
    private final long spanId;

    public static SpanId invalid() {
        return invalid;
    }

    public SpanId(long spanId) {
        this.spanId = spanId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpanId)) {
            return false;
        }
        SpanId that = (SpanId)obj;
        return this.spanId == that.spanId;
    }

    public int hashCode() {
        return Objects.hashCode(this.spanId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("spanId", (Object)this.getApiString()).toString();
    }

    public boolean isValid() {
        return this.spanId != 0L;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public String getApiString() {
        return UnsignedLongs.toString((long)this.spanId);
    }
}

