/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.core;

import com.google.cloud.trace.core.StackFrame;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class StackTrace {
    private final ImmutableList<StackFrame> stackFrames;

    public static Builder builder() {
        return new Builder();
    }

    private StackTrace(ImmutableList<StackFrame> stackFrames) {
        this.stackFrames = stackFrames;
    }

    public List<StackFrame> getStackFrames() {
        return this.stackFrames;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stackFrames", this.stackFrames).toString();
    }

    public static class Builder {
        private final ArrayList<StackFrame> stackFrames = new ArrayList();

        private Builder() {
        }

        public Builder add(String className, String methodName, String fileName, Integer lineNumber, Integer columnNumber) {
            this.stackFrames.add(new StackFrame(className, methodName, fileName, lineNumber, columnNumber));
            return this;
        }

        public StackTrace build() {
            return new StackTrace(ImmutableList.copyOf(this.stackFrames));
        }
    }
}

